/*
 * Decompiled with CFR 0.152.
 */
package com.fs.graphics.particle;

import com.fs.graphics.anim.BaseAnimation;

public abstract class BaseParticleEmitter
extends BaseAnimation {
    private float lastEmitTime;
    private float nextEmitTime;
    private float elapsed;
    private float avgPerFrame = 0.016666668f;
    private float framesPerEmit = 1.0f;
    private float framesSinceEmit = 0.0f;

    @Override
    public void started() {
        super.started();
        this.emit(0.0f);
        this.framesSinceEmit = 0.0f;
        this.lastEmitTime = 0.0f;
        this.nextEmitTime = this.lastEmitTime + this.getInterval();
    }

    @Override
    public void advance(float f) {
        this.avgPerFrame = this.avgPerFrame * 0.9f + f * 0.1f;
        this.framesPerEmit = (int)(this.getInterval() / this.avgPerFrame);
        this.elapsed += f;
        if (this.framesSinceEmit >= this.framesPerEmit) {
            this.emit(this.framesPerEmit * this.avgPerFrame);
            this.framesSinceEmit = 0.0f;
            this.lastEmitTime = this.elapsed;
            this.nextEmitTime = this.lastEmitTime + this.getInterval();
        }
        this.framesSinceEmit += 1.0f;
        this.everyFrame(f);
    }

    public abstract float getInterval();

    public abstract void everyFrame(float var1);

    public abstract void emit(float var1);
}

