/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.MusicPlayerPluginWithVolumeControl;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialMissionIntel;
import com.fs.starfarer.api.util.Misc;
import java.util.HashMap;
import java.util.Map;

public class MusicPlayerPluginImpl
implements MusicPlayerPluginWithVolumeControl {
    public static String KEEP_PLAYING_LOCATION_MUSIC_DURING_ENCOUNTER_MEM_KEY = "$playLocationMusicDuringEnc";
    public static String COMBAT_MUSIC_SET_MEM_KEY = "$combatMusicSetId";
    public static String COMBAT_MUSIC_SET_FACTION_KEY = "music_combat_set";
    public static String MUSIC_SET_MEM_KEY = "$musicSetId";
    public static String MUSIC_SET_MEM_KEY_MISSION = "$musicSetIdForMission";
    public static String MUSIC_ENCOUNTER_MYSTERIOUS_AGGRO = "music_encounter_mysterious";
    public static String MUSIC_ENCOUNTER_MYSTERIOUS_NON_AGGRESSIVE = "music_encounter_mysterious_non_aggressive";
    public static String MUSIC_ENCOUNTER_NEUTRAL = "music_encounter_neutral";
    public static String MUSIC_GALATIA_ACADEMY = "music_galatia_academy";
    public static Object CAMPAIGN_SYSTEM = new Object();
    public static Object CAMPAIGN_HYPERSPACE = new Object();
    public static Object NO_MUSIC = new Object();
    public static Object COMBAT = new Object();
    public static Object TITLE = new Object();
    public static Object MARKET = new Object();
    public static Object ENCOUNTER = new Object();
    public static Object PLANET_SURVEY = new Object();
    public static Object CUSTOM = new Object();
    public static Map<String, String> stringTokens = new HashMap<String, String>();
    public static String SYSTEM_MUSIC_PREFIX = "core_sys_music_";

    public static Object getToken(String str) {
        if (!stringTokens.containsKey(str)) {
            stringTokens.put(str, str);
        }
        return stringTokens.get(str);
    }

    @Override
    public Object getStateTokenForCampaignLocation() {
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        if (playerFleet.getContainingLocation() instanceof StarSystemAPI) {
            StarSystemAPI system = (StarSystemAPI)playerFleet.getContainingLocation();
            String musicSetId = system.getMemoryWithoutUpdate().getString(MUSIC_SET_MEM_KEY_MISSION);
            if (musicSetId != null) {
                return MusicPlayerPluginImpl.getToken(String.valueOf(SYSTEM_MUSIC_PREFIX) + musicSetId);
            }
            musicSetId = system.getMemoryWithoutUpdate().getString(MUSIC_SET_MEM_KEY);
            if (musicSetId != null) {
                return MusicPlayerPluginImpl.getToken(String.valueOf(SYSTEM_MUSIC_PREFIX) + musicSetId);
            }
            return CAMPAIGN_SYSTEM;
        }
        return CAMPAIGN_HYPERSPACE;
    }

    @Override
    public String getMusicSetIdForCombat(CombatEngineAPI engine) {
        if (engine.getContext() != null && engine.getContext().getOtherFleet() != null) {
            CampaignFleetAPI other = engine.getContext().getOtherFleet();
            MemoryAPI mem = other.getMemoryWithoutUpdate();
            if (mem.contains(COMBAT_MUSIC_SET_MEM_KEY)) {
                return mem.getString(COMBAT_MUSIC_SET_MEM_KEY);
            }
            String factionSet = other.getFaction().getMusicMap().get(COMBAT_MUSIC_SET_FACTION_KEY);
            if (factionSet != null) {
                return factionSet;
            }
        }
        return "music_combat";
    }

    @Override
    public String getMusicSetIdForTitle() {
        return "music_title";
    }

    @Override
    public float getMusicSetVolumeForCampaignStateToken(Object token, Object param) {
        if (token == CAMPAIGN_HYPERSPACE) {
            float vol;
            CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
            float depth = 0.0f;
            if (pf != null) {
                depth = Misc.getAbyssalDepth(pf.getLocationInHyperspace());
            }
            if ((vol = 1.0f - depth) > 1.0f) {
                vol = 1.0f;
            }
            if (vol < 0.0f) {
                vol = 0.0f;
            }
            return vol;
        }
        return 1.0f;
    }

    @Override
    public String getMusicSetIdForCampaignStateToken(Object token, Object param) {
        if (token == MARKET) {
            return this.getMarketMusicSetId(param);
        }
        if (token == ENCOUNTER) {
            return this.getEncounterMusicSetId(param);
        }
        if (token == CAMPAIGN_SYSTEM || token instanceof String && ((String)token).startsWith(SYSTEM_MUSIC_PREFIX)) {
            return this.getStarSystemMusicSetId();
        }
        if (token == CAMPAIGN_HYPERSPACE) {
            return this.getHyperspaceMusicSetId();
        }
        if (token == PLANET_SURVEY) {
            return this.getPlanetSurveyMusicSetId(param);
        }
        if (token == NO_MUSIC) {
            return null;
        }
        return null;
    }

    protected String getPlanetSurveyMusicSetId(Object param) {
        SectorEntityToken token = null;
        if (param instanceof SectorEntityToken) {
            token = (SectorEntityToken)param;
        } else if (param instanceof MarketAPI) {
            token = ((MarketAPI)param).getPlanetEntity();
        }
        if (token != null) {
            String musicSetId = token.getMemoryWithoutUpdate().getString(MUSIC_SET_MEM_KEY_MISSION);
            if (musicSetId != null) {
                return musicSetId;
            }
            musicSetId = token.getMemoryWithoutUpdate().getString(MUSIC_SET_MEM_KEY);
            if (musicSetId != null) {
                return musicSetId;
            }
        }
        return "music_survey_and_scavenge";
    }

    protected String getHyperspaceMusicSetId() {
        return "music_campaign_hyperspace";
    }

    protected String getStarSystemMusicSetId() {
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        if (playerFleet.getContainingLocation() instanceof StarSystemAPI) {
            StarSystemAPI system = (StarSystemAPI)playerFleet.getContainingLocation();
            String musicSetId = system.getMemoryWithoutUpdate().getString(MUSIC_SET_MEM_KEY_MISSION);
            if (musicSetId != null) {
                return musicSetId;
            }
            musicSetId = system.getMemoryWithoutUpdate().getString(MUSIC_SET_MEM_KEY);
            if (musicSetId != null) {
                return musicSetId;
            }
            if (system.hasTag("system_abyssal")) {
                return "music_campaign_abyssal";
            }
            if (system.hasTag("theme_core") || !Misc.getMarketsInLocation(system, "player").isEmpty()) {
                return "music_campaign";
            }
        }
        return "music_campaign_non_core";
    }

    protected String getEncounterMusicSetId(Object param) {
        if (param instanceof SectorEntityToken) {
            SectorEntityToken token = (SectorEntityToken)param;
            String musicSetId = token.getMemoryWithoutUpdate().getString(MUSIC_SET_MEM_KEY_MISSION);
            if (musicSetId != null) {
                return musicSetId;
            }
            musicSetId = token.getMemoryWithoutUpdate().getString(MUSIC_SET_MEM_KEY);
            if (musicSetId != null) {
                return musicSetId;
            }
            if ("abyssal_light".equals(token.getCustomEntityType())) {
                return MUSIC_ENCOUNTER_NEUTRAL;
            }
            if ("coronal_tap".equals(token.getCustomEntityType())) {
                return MUSIC_ENCOUNTER_MYSTERIOUS_AGGRO;
            }
            if ("wreck".equals(token.getCustomEntityType())) {
                return MUSIC_ENCOUNTER_NEUTRAL;
            }
            if ("derelict_gatehauler".equals(token.getCustomEntityType())) {
                return MUSIC_ENCOUNTER_MYSTERIOUS_NON_AGGRESSIVE;
            }
            if ("debris_field_shared".equals(token.getCustomEntityType())) {
                return "music_survey_and_scavenge";
            }
            if (token.hasTag("gate")) {
                return MUSIC_ENCOUNTER_NEUTRAL;
            }
            if (token.hasTag("objective")) {
                return MUSIC_ENCOUNTER_NEUTRAL;
            }
            if (token.hasTag("salvageable")) {
                if (token.getMemoryWithoutUpdate() != null && token.getMemoryWithoutUpdate().getBoolean("$hasDefenders")) {
                    if (token.getMemoryWithoutUpdate().getBoolean("$limboMiningStation")) {
                        return MUSIC_ENCOUNTER_MYSTERIOUS_AGGRO;
                    }
                    if (token.getMemoryWithoutUpdate().getBoolean("$limboWormholeCache")) {
                        return MUSIC_ENCOUNTER_MYSTERIOUS_AGGRO;
                    }
                    return MUSIC_ENCOUNTER_NEUTRAL;
                }
                return "music_survey_and_scavenge";
            }
            if (token.hasTag("salvage_music")) {
                return "music_survey_and_scavenge";
            }
            if (token.getFaction() != null) {
                FactionAPI faction = token.getFaction();
                String type = null;
                boolean hostile = false;
                boolean knowsWhoPlayerIs = false;
                if (token instanceof CampaignFleetAPI) {
                    CampaignFleetAPI fleet = (CampaignFleetAPI)token;
                    if (fleet.getAI() instanceof ModularFleetAIAPI) {
                        hostile = ((ModularFleetAIAPI)fleet.getAI()).isHostileTo(Global.getSector().getPlayerFleet());
                    }
                    knowsWhoPlayerIs = fleet.knowsWhoPlayerIs();
                }
                if ((type = faction.isAtWorst("player", RepLevel.FAVORABLE) && knowsWhoPlayerIs && !hostile ? "encounter_friendly" : (faction.isAtBest("player", RepLevel.SUSPICIOUS) && knowsWhoPlayerIs || hostile ? "encounter_hostile" : "encounter_neutral")) != null && (musicSetId = faction.getMusicMap().get(type)) != null) {
                    return musicSetId;
                }
                musicSetId = null;
                musicSetId = faction.isAtWorst("player", RepLevel.FAVORABLE) ? "music_default_encounter_friendly" : (faction.isAtBest("player", RepLevel.SUSPICIOUS) ? "music_default_encounter_hostile" : "music_default_encounter_neutral");
                return musicSetId;
            }
        }
        return null;
    }

    protected String getMarketMusicSetId(Object param) {
        if (param instanceof MarketAPI) {
            MarketAPI market = (MarketAPI)param;
            String musicSetId = market.getMemoryWithoutUpdate().getString(MUSIC_SET_MEM_KEY_MISSION);
            if (musicSetId != null) {
                return musicSetId;
            }
            musicSetId = market.getMemoryWithoutUpdate().getString(MUSIC_SET_MEM_KEY);
            if (musicSetId != null) {
                return musicSetId;
            }
            if (market.getPrimaryEntity() != null && market.getPrimaryEntity().getMemoryWithoutUpdate().getBoolean("$abandonedStation")) {
                return this.getPlanetSurveyMusicSetId(param);
            }
            if (market.getPrimaryEntity() != null && market.getPrimaryEntity().getId().equals("station_galatia_academy")) {
                if (TutorialMissionIntel.isTutorialInProgress()) {
                    return MUSIC_ENCOUNTER_MYSTERIOUS_AGGRO;
                }
                return MUSIC_GALATIA_ACADEMY;
            }
            FactionAPI faction = market.getFaction();
            if (faction != null) {
                String type = null;
                type = faction.isAtWorst("player", RepLevel.FAVORABLE) ? "market_friendly" : (faction.isAtBest("player", RepLevel.SUSPICIOUS) ? "market_hostile" : "market_neutral");
                if (type != null && (musicSetId = faction.getMusicMap().get(type)) != null) {
                    return musicSetId;
                }
                musicSetId = null;
                musicSetId = faction.isAtWorst("player", RepLevel.FAVORABLE) ? "music_default_market_friendly" : (faction.isAtBest("player", RepLevel.SUSPICIOUS) ? "music_default_market_hostile" : "music_default_market_neutral");
                return musicSetId;
            }
        }
        return null;
    }
}

