/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HTAbyssalLightFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HyperspaceTopographyEventIntel;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceTerrainPlugin;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class AbyssalLightBonus
implements EveryFrameScript {
    public static float BURN_BONUS_MULT = 1.0f;
    public static float BURN_BONUS_FLAT = 5.0f;
    public static float LIGHT_YEARS_PER_UNIT_OF_BURN_BONUS = 3.0f;
    public static float SENSOR_BONUS_FLAT = 1000.0f;
    public static float LIGHT_YEARS_PER_UNIT_OF_SENSOR_BONUS = 3.0f;
    protected CampaignFleetAPI fleet;
    protected float burnBonus = 0.0f;
    protected float sensorBonus = 0.0f;
    protected int framesSpentPending = 0;
    protected float pendingBurnBonus = 0.0f;
    protected float pendingSensorBonus = 0.0f;
    protected int pendingTopographyPoints = 0;
    protected int pendingLightsCount = 0;
    protected Vector2f prevLoc = null;

    public static AbyssalLightBonus get(CampaignFleetAPI fleet) {
        for (EveryFrameScript s : fleet.getScripts()) {
            if (!(s instanceof AbyssalLightBonus)) continue;
            return (AbyssalLightBonus)s;
        }
        AbyssalLightBonus script = new AbyssalLightBonus(fleet);
        fleet.addScript(script);
        return script;
    }

    public AbyssalLightBonus(CampaignFleetAPI fleet) {
        this.fleet = fleet;
        this.prevLoc = new Vector2f((ReadableVector2f)fleet.getLocation());
    }

    @Override
    public void advance(float amount) {
        String ly;
        float depth;
        if (this.fleet.isPlayerFleet()) {
            this.checkPendingAndSendMessages();
        }
        if ((depth = Misc.getAbyssalDepth(this.fleet)) < 1.0f) {
            this.burnBonus = 0.0f;
            this.sensorBonus = 0.0f;
            return;
        }
        Vector2f loc = this.fleet.getLocation();
        float distLY = Misc.getDistanceLY(loc, this.prevLoc);
        this.prevLoc.set((ReadableVector2f)this.fleet.getLocation());
        this.burnBonus -= distLY / LIGHT_YEARS_PER_UNIT_OF_BURN_BONUS;
        this.sensorBonus -= distLY / LIGHT_YEARS_PER_UNIT_OF_BURN_BONUS;
        if (this.burnBonus < 0.0f) {
            this.burnBonus = 0.0f;
        }
        if (this.sensorBonus < 0.0f) {
            this.sensorBonus = 0.0f;
        }
        if (this.burnBonus > 0.0f) {
            if (BURN_BONUS_MULT != 1.0f) {
                float burnMult = BURN_BONUS_MULT;
                if (this.burnBonus < 1.0f && (burnMult = 1.0f + (burnMult - 1.0f) * this.burnBonus) < 1.1f) {
                    burnMult = 1.1f;
                }
                ly = Misc.getRoundedValueOneAfterDecimalIfNotWhole(this.getBurnBonusLYRemaining(this.burnBonus));
                this.fleet.getStats().addTemporaryModMult(0.1f, "abyssalLight_1", "Abyssal light (for " + ly + " more light-years)", burnMult, this.fleet.getStats().getFleetwideMaxBurnMod());
            }
            if (BURN_BONUS_FLAT > 0.0f) {
                float burnFlat = BURN_BONUS_FLAT / HyperspaceTerrainPlugin.ABYSS_BURN_MULT;
                if (this.burnBonus < 1.0f / LIGHT_YEARS_PER_UNIT_OF_BURN_BONUS) {
                    burnFlat *= this.burnBonus * LIGHT_YEARS_PER_UNIT_OF_BURN_BONUS;
                }
                if ((burnFlat = (float)Math.round(burnFlat)) < 1.0f) {
                    burnFlat = 1.0f;
                }
                ly = Misc.getRoundedValueOneAfterDecimalIfNotWhole(this.getBurnBonusLYRemaining(this.burnBonus));
                this.fleet.getStats().addTemporaryModFlat(0.1f, "abyssalLight_2", "Abyssal light (for " + ly + " more light-years)", burnFlat, this.fleet.getStats().getFleetwideMaxBurnMod());
            }
        }
        if (this.sensorBonus > 0.0f && SENSOR_BONUS_FLAT > 0.0f) {
            float sensorFlat = SENSOR_BONUS_FLAT / HyperspaceTerrainPlugin.ABYSS_SENSOR_RANGE_MULT;
            if (this.sensorBonus < 1.0f / LIGHT_YEARS_PER_UNIT_OF_SENSOR_BONUS) {
                sensorFlat *= this.sensorBonus * LIGHT_YEARS_PER_UNIT_OF_SENSOR_BONUS;
            }
            if ((sensorFlat = (float)Math.round(sensorFlat)) < 1.0f) {
                sensorFlat = 1.0f;
            }
            ly = Misc.getRoundedValueOneAfterDecimalIfNotWhole(this.getSensorBonusLYRemaining(this.sensorBonus));
            this.fleet.getStats().addTemporaryModFlat(0.1f, "abyssalLight_3", "Abyssal light (for " + ly + " more light-years)", sensorFlat, this.fleet.getStats().getSensorRangeMod());
        }
    }

    public float getBurnBonusLYRemaining(float bonus) {
        return bonus * LIGHT_YEARS_PER_UNIT_OF_BURN_BONUS;
    }

    public float getSensorBonusLYRemaining(float bonus) {
        return bonus * LIGHT_YEARS_PER_UNIT_OF_SENSOR_BONUS;
    }

    public void addBurnBonus(float bonus) {
        if (this.fleet.isPlayerFleet()) {
            this.pendingBurnBonus += bonus;
            this.framesSpentPending = 0;
        } else {
            this.burnBonus += bonus;
        }
    }

    public void addSensorBonus(float bonus) {
        if (this.fleet.isPlayerFleet()) {
            this.pendingSensorBonus += bonus;
            this.framesSpentPending = 0;
        } else {
            this.sensorBonus += bonus;
        }
    }

    public void addTopographyPoints(int points) {
        this.pendingTopographyPoints += points;
        ++this.pendingLightsCount;
        this.framesSpentPending = 0;
    }

    public void checkPendingAndSendMessages() {
        ++this.framesSpentPending;
        if (this.framesSpentPending > 1) {
            String ly;
            MessageIntel msg;
            this.framesSpentPending = 0;
            if (this.pendingTopographyPoints > 0) {
                HyperspaceTopographyEventIntel.addFactorCreateIfNecessary(new HTAbyssalLightFactor(this.pendingTopographyPoints, this.pendingLightsCount > 1), null);
                this.pendingTopographyPoints = 0;
                this.pendingLightsCount = 0;
            }
            if (this.pendingBurnBonus > 0.0f) {
                msg = new MessageIntel();
                ly = Misc.getRoundedValueOneAfterDecimalIfNotWhole(this.getSensorBonusLYRemaining(this.pendingBurnBonus));
                msg.addLine("Increased burn level for %s light-years", Misc.getTextColor(), new String[]{"+" + ly}, Misc.getHighlightColor());
                msg.setSound(Sounds.NONE);
                Global.getSector().getCampaignUI().addMessage(msg, CommMessageAPI.MessageClickAction.NOTHING);
                this.burnBonus += this.pendingBurnBonus;
                this.pendingBurnBonus = 0.0f;
            }
            if (this.pendingSensorBonus > 0.0f) {
                msg = new MessageIntel();
                ly = Misc.getRoundedValueOneAfterDecimalIfNotWhole(this.getSensorBonusLYRemaining(this.pendingSensorBonus));
                msg.addLine("Increased sensor range for %s light-years", Misc.getTextColor(), new String[]{"+" + ly}, Misc.getHighlightColor());
                msg.setSound(Sounds.NONE);
                Global.getSector().getCampaignUI().addMessage(msg, CommMessageAPI.MessageClickAction.NOTHING);
                this.sensorBonus += this.pendingSensorBonus;
                this.pendingSensorBonus = 0.0f;
            }
        }
    }

    public float getBurnBonus() {
        return this.burnBonus;
    }

    public void setBurnBonus(float burnBonus) {
        this.burnBonus = burnBonus;
    }

    public float getSensorBonus() {
        return this.sensorBonus;
    }

    public void setSensorBonus(float sensorBonus) {
        this.sensorBonus = sensorBonus;
    }

    @Override
    public boolean isDone() {
        return this.burnBonus <= 0.0f && this.sensorBonus <= 0.0f && this.pendingBurnBonus <= 0.0f && this.pendingSensorBonus <= 0.0f && this.pendingTopographyPoints <= 0;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }
}

