/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.abilities.BaseDurationAbility;
import com.fs.starfarer.api.loading.CampaignPingSpec;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class InterdictionPulseAbility
extends BaseDurationAbility {
    public static final float MAX_EFFECT = 1.0f;
    public static final float BASE_RANGE = 500.0f;
    public static final float BASE_SECONDS = 6.0f;
    public static final float STRENGTH_PER_SECOND = 200.0f;
    public static final float DETECTABILITY_PERCENT = 100.0f;
    protected Boolean primed = null;
    protected Float elapsed = null;
    protected Integer numFired = null;

    public static float getRange(CampaignFleetAPI fleet) {
        return 500.0f + fleet.getSensorRangeMod().computeEffective(fleet.getSensorStrength()) / 2.0f;
    }

    @Override
    protected String getActivationText() {
        return "Interdiction pulse";
    }

    @Override
    protected void activateImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        Global.getSector().addPing((SectorEntityToken)fleet, "interdict");
        float range = InterdictionPulseAbility.getRange(fleet);
        for (CampaignFleetAPI other : fleet.getContainingLocation().getFleets()) {
            float dist;
            if (other == fleet || (dist = Misc.getDistance(fleet.getLocation(), other.getLocation())) > range + 500.0f) continue;
            other.addScript(new IPReactionScript(fleet, other, this.getActivationDays()));
        }
        this.primed = true;
    }

    protected void showRangePing(float amount) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        SectorEntityToken.VisibilityLevel vis = fleet.getVisibilityLevelToPlayerFleet();
        if (vis == SectorEntityToken.VisibilityLevel.NONE || vis == SectorEntityToken.VisibilityLevel.SENSOR_CONTACT) {
            return;
        }
        boolean fire = false;
        if (this.elapsed == null) {
            this.elapsed = Float.valueOf(0.0f);
            this.numFired = 0;
            fire = true;
        }
        this.elapsed = Float.valueOf(this.elapsed.floatValue() + amount);
        if (this.elapsed.floatValue() > 0.5f && this.numFired < 4) {
            this.elapsed = Float.valueOf(this.elapsed.floatValue() - 0.5f);
            fire = true;
        }
        if (fire) {
            this.numFired = this.numFired + 1;
            float range = InterdictionPulseAbility.getRange(fleet);
            CampaignPingSpec custom = new CampaignPingSpec();
            custom.setUseFactionColor(true);
            custom.setWidth(7.0f);
            custom.setMinRange(range - 100.0f);
            custom.setRange(200.0f);
            custom.setDuration(2.0f);
            custom.setAlphaMult(0.25f);
            custom.setInFraction(0.2f);
            custom.setNum(1);
            Global.getSector().addPing((SectorEntityToken)fleet, custom);
        }
    }

    @Override
    protected void applyEffect(float amount, float level) {
        boolean playedHit;
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        fleet.getStats().getDetectedRangeMod().modifyPercent(this.getModId(), 100.0f * level, "Interdiction pulse");
        if (level > 0.0f && level < 1.0f && amount > 0.0f) {
            this.showRangePing(amount);
            fleet.goSlowOneFrame();
            return;
        }
        float range = InterdictionPulseAbility.getRange(fleet);
        boolean bl = playedHit = !this.entity.isInCurrentLocation() || !this.entity.isVisibleToPlayerFleet();
        if (level == 1.0f && this.primed != null) {
            if (this.entity.isInCurrentLocation()) {
                Global.getSector().getMemoryWithoutUpdate().set("$interdictionPulseJustUsed", true, 0.1f);
            }
            fleet.getMemoryWithoutUpdate().set("$justDidInterdictionPulse", true, 0.1f);
            CampaignPingSpec custom = new CampaignPingSpec();
            custom.setUseFactionColor(true);
            custom.setWidth(15.0f);
            custom.setRange(range * 1.3f);
            custom.setDuration(0.5f);
            custom.setAlphaMult(1.0f);
            custom.setInFraction(0.1f);
            custom.setNum(1);
            Global.getSector().addPing((SectorEntityToken)fleet, custom);
            for (CampaignFleetAPI other : fleet.getContainingLocation().getFleets()) {
                SectorEntityToken.VisibilityLevel vis;
                float dist;
                if (other == fleet || other.getFaction() == fleet.getFaction() || other.isInHyperspaceTransition() || (dist = Misc.getDistance(fleet.getLocation(), other.getLocation())) > range) continue;
                float interdictSeconds = InterdictionPulseAbility.getInterdictSeconds(fleet, other);
                if (interdictSeconds > 0.0f && interdictSeconds < 1.0f) {
                    interdictSeconds = 1.0f;
                }
                if ((vis = other.getVisibilityLevelToPlayerFleet()) == SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS || vis == SectorEntityToken.VisibilityLevel.COMPOSITION_DETAILS || vis == SectorEntityToken.VisibilityLevel.SENSOR_CONTACT && fleet.isPlayerFleet()) {
                    if (interdictSeconds <= 0.0f) {
                        other.addFloatingText("Interdict avoided!", fleet.getFaction().getBaseUIColor(), 1.0f, true);
                        continue;
                    }
                    other.addFloatingText("Interdict! (" + Math.round(interdictSeconds) + "s)", fleet.getFaction().getBaseUIColor(), 1.0f, true);
                }
                float interdictDays = interdictSeconds / Global.getSector().getClock().getSecondsPerDay();
                for (AbilityPlugin ability : other.getAbilities().values()) {
                    if (!ability.getSpec().hasTag("burn+") && !ability.getSpec().hasTag("disabled_by_interdict") && !ability.getId().equals("interdiction_pulse")) continue;
                    float origCooldown = ability.getCooldownLeft();
                    float extra = 0.0f;
                    if (ability.isActiveOrInProgress()) {
                        extra += ability.getSpec().getDeactivationCooldown() * ability.getProgressFraction();
                        ability.deactivate();
                    }
                    if (!ability.getSpec().hasTag("burn+")) continue;
                    float cooldown = interdictDays;
                    cooldown += origCooldown;
                    float max = Math.max(ability.getSpec().getDeactivationCooldown(), 2.0f);
                    if ((cooldown += extra) > max) {
                        cooldown = max;
                    }
                    ability.setCooldownLeft(cooldown);
                }
                if (fleet.isPlayerFleet() && other.knowsWhoPlayerIs() && fleet.getFaction() != other.getFaction()) {
                    Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.INTERDICTED, null, null, false), other.getFaction().getId());
                }
                if (playedHit) continue;
                Global.getSoundPlayer().playSound("world_interdict_hit", 1.0f, 1.0f, other.getLocation(), other.getVelocity());
            }
            this.primed = null;
            this.elapsed = null;
            this.numFired = null;
        }
    }

    public static float getInterdictSeconds(CampaignFleetAPI fleet, CampaignFleetAPI other) {
        float defense;
        float offense = fleet.getSensorRangeMod().computeEffective(fleet.getSensorStrength());
        float diff = offense - (defense = other.getSensorRangeMod().computeEffective(other.getSensorStrength()));
        float extra = diff / 200.0f;
        float total = 6.0f + extra;
        if (total < 0.0f) {
            total = 0.0f;
        }
        return total;
    }

    @Override
    protected void deactivateImpl() {
        this.cleanupImpl();
    }

    @Override
    protected void cleanupImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        fleet.getStats().getDetectedRangeMod().unmodify(this.getModId());
        this.primed = null;
    }

    @Override
    public boolean isUsable() {
        return super.isUsable() && this.getFleet() != null;
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        Color fuel = Global.getSettings().getColor("progressBarFuelColor");
        Color bad = Misc.getNegativeHighlightColor();
        if (!Global.CODEX_TOOLTIP_MODE) {
            LabelAPI labelAPI = tooltip.addTitle("Interdiction Pulse");
        } else {
            tooltip.addSpacer(-10.0f);
        }
        float pad = 10.0f;
        int range = (int)InterdictionPulseAbility.getRange(fleet);
        tooltip.addPara("Slows* the fleet and uses its active sensor network to charge and release a powerful energy pulse that can disrupt the drive fields of nearby fleets.", pad);
        Color c = Misc.getTooltipTitleAndLightHighlightColor();
        Color hc = highlight;
        if (Global.CODEX_TOOLTIP_MODE) {
            hc = Misc.getBasePlayerColor();
        }
        tooltip.addPara("The disruption interrupts any movement-related abilities (such as %s or %s) and prevents their use for some time afterwards. Also interrupts charging interdiction pulses.", pad, hc, "Sustained Burn", "Emergency Burn");
        tooltip.addPara("The disruption lasts for %s seconds, modified by %s second for every %s points of difference in the fleets' sensor strengths.", pad, highlight, "6", "1", "200");
        tooltip.addPara("Base range of %s* units, increased by half your fleet's sensor strength, for a total of %s units. While the pulse is charging, the range at which the fleet can be detected will gradually increase by up to %s.", pad, highlight, "500", "" + range, "100%");
        tooltip.addPara("A successful interdict is considered a hostile act, though not on the same level as open warfare.", pad);
        tooltip.addPara("*2000 units = 1 map grid cell", gray, pad);
        tooltip.addPara("*A fleet is considered slow-moving at a burn level of half that of its slowest ship.", gray, pad);
        this.addIncompatibleToTooltip(tooltip, expanded);
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    @Override
    public void fleetLeftBattle(BattleAPI battle, boolean engagedInHostilities) {
        if (engagedInHostilities) {
            this.deactivate();
        }
    }

    @Override
    public void fleetOpenedMarket(MarketAPI market) {
        this.deactivate();
    }

    public static class IPReactionScript
    implements EveryFrameScript {
        float delay;
        boolean done;
        CampaignFleetAPI other;
        CampaignFleetAPI fleet;
        float activationDays;

        public IPReactionScript(CampaignFleetAPI fleet, CampaignFleetAPI other, float activationDays) {
            this.fleet = fleet;
            this.other = other;
            this.activationDays = activationDays;
            this.delay = 0.3f + 0.3f * (float)Math.random();
        }

        @Override
        public void advance(float amount) {
            if (this.done) {
                return;
            }
            this.delay -= amount;
            if (this.delay > 0.0f) {
                return;
            }
            SectorEntityToken.VisibilityLevel level = this.fleet.getVisibilityLevelTo(this.other);
            if (level == SectorEntityToken.VisibilityLevel.NONE || level == SectorEntityToken.VisibilityLevel.SENSOR_CONTACT) {
                this.done = true;
                return;
            }
            if (!(this.other.getAI() instanceof ModularFleetAIAPI)) {
                this.done = true;
                return;
            }
            ModularFleetAIAPI ai = (ModularFleetAIAPI)this.other.getAI();
            float dist = Misc.getDistance(this.fleet.getLocation(), this.other.getLocation());
            float speed = Math.max(1.0f, this.other.getTravelSpeed());
            float eta = dist / speed;
            float rushTime = this.activationDays * Global.getSector().getClock().getSecondsPerDay();
            rushTime += 0.5f + 0.5f * (float)Math.random();
            MemoryAPI mem = this.other.getMemoryWithoutUpdate();
            CampaignFleetAPI pursueTarget = mem.getFleet("$ai_pursuitTarget");
            if (eta < rushTime && pursueTarget == this.fleet) {
                this.done = true;
                return;
            }
            float range = InterdictionPulseAbility.getRange(this.fleet);
            float getAwayTime = 1.0f + (range - dist) / speed;
            AbilityPlugin sb = this.other.getAbility("sensor_burst");
            if (getAwayTime > rushTime && sb != null && sb.isUsable() && (float)Math.random() > 0.67f) {
                sb.activate();
                this.done = true;
                return;
            }
            float avoidRange = InterdictionPulseAbility.getRange(this.other) + 100.0f;
            ai.getNavModule().avoidLocation(this.fleet.getContainingLocation(), this.fleet.getLocation(), avoidRange, avoidRange + 50.0f, this.activationDays + 0.01f);
            ai.getNavModule().avoidLocation(this.fleet.getContainingLocation(), Misc.getPointAtRadius(this.fleet.getLocation(), avoidRange * 0.5f), avoidRange, avoidRange * 1.5f + 50.0f, this.activationDays + 0.05f);
            this.done = true;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public boolean runWhilePaused() {
            return false;
        }
    }
}

