/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen;

import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class ConstellationGen {
    public static SpringSystem createSpringSystem(List<StarSystemAPI> systems, Random random) {
        SpringSystem springs = new SpringSystem();
        if (systems.isEmpty()) {
            return springs;
        }
        Vector2f loc = new Vector2f(0.0f, 0.0f);
        boolean first = true;
        for (StarSystemAPI system : systems) {
            float radius = system.getMaxRadiusInHyperspace();
            if (radius < 500.0f) {
                radius = 500.0f;
            }
            float mass = radius;
            SpringNode node = springs.addNode(system, radius, mass, loc.x + random.nextFloat(), loc.y + random.nextFloat());
            if (!first) continue;
            node.moveable = false;
            first = false;
        }
        ArrayList<SpringNode> copy = new ArrayList<SpringNode>(springs.nodes);
        SpringNode curr = (SpringNode)copy.get((int)((double)copy.size() * random.nextDouble()));
        copy.remove(curr);
        float pullK = 1000.0f;
        float pushK = 500.0f;
        block1: while (!copy.isEmpty()) {
            int numBranches = random.nextInt(3) + 1;
            int i = 0;
            while (i < numBranches) {
                if (copy.isEmpty()) continue block1;
                SpringNode other = (SpringNode)copy.get((int)((double)copy.size() * random.nextDouble()));
                copy.remove(other);
                float d = curr.radius + other.radius + 2000.0f + random.nextFloat() * 0.0f;
                springs.addConnection(curr, other, pullK, d, true, true);
                if (i == numBranches - 1) {
                    curr = other;
                }
                ++i;
            }
        }
        for (SpringNode n1 : springs.nodes) {
            for (SpringNode n2 : springs.nodes) {
                if (n1 == n2) continue;
                float d = n1.radius + n2.radius + 5000.0f;
                springs.addConnection(n1, n2, pushK, d, true, false);
            }
        }
        for (SpringNode node : springs.nodes) {
            StarSystemAPI system = (StarSystemAPI)node.custom;
            system.getLocation().set((ReadableVector2f)node.loc);
        }
        return springs;
    }

    public static SpringSystem doConstellationLayout(List<StarSystemAPI> systems, Random random, Vector2f centerPoint) {
        SpringSystem springs = ConstellationGen.createSpringSystem(systems, random);
        int i = 0;
        while (i < 1000) {
            springs.advance(0.25f);
            if (springs.isDone()) break;
            ++i;
        }
        if (!springs.isDone()) {
            springs = ConstellationGen.createSpringSystem(systems, random);
            i = 0;
            while (i < 1000) {
                springs.advance(0.25f);
                if (springs.isDone()) break;
                ++i;
            }
        }
        float minX = Float.MAX_VALUE;
        float maxX = -3.4028235E38f;
        float minY = Float.MAX_VALUE;
        float maxY = -3.4028235E38f;
        for (SpringNode node : springs.nodes) {
            float x = node.loc.x;
            float y = node.loc.y;
            if (x < minX) {
                minX = x;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (!(y > maxY)) continue;
            maxY = y;
        }
        float midX = minX + (maxX - minX) * 0.5f;
        float midY = minY + (maxY - minY) * 0.5f;
        for (SpringNode node : springs.nodes) {
            node.loc.x = (int)(node.loc.x - midX + centerPoint.x);
            node.loc.y = (int)(node.loc.y - midY + centerPoint.y);
        }
        for (SpringNode node : springs.nodes) {
            StarSystemAPI system = (StarSystemAPI)node.custom;
            system.getLocation().set((ReadableVector2f)node.loc);
        }
        return springs;
    }

    public static class SpringConnection {
        public float k;
        public float d;
        public boolean push = true;
        public boolean pull = true;
        public SpringNode from;
        public SpringNode to;
    }

    public static class SpringNode {
        public Object custom;
        public float radius;
        public Vector2f loc = new Vector2f();
        public Vector2f vel = new Vector2f();
        public Vector2f force = new Vector2f();
        public float mass;
        public boolean moveable = true;
        public List<SpringConnection> connections = new ArrayList<SpringConnection>();
    }

    public static class SpringSystem {
        public List<SpringNode> nodes = new ArrayList<SpringNode>();
        public List<SpringConnection> connections = new ArrayList<SpringConnection>();
        public int iter = 0;

        public SpringNode addNode(Object custom, float radius, float mass, float x, float y) {
            SpringNode node = new SpringNode();
            node.custom = custom;
            node.radius = radius;
            node.mass = mass;
            node.loc.x = x;
            node.loc.y = y;
            this.nodes.add(node);
            return node;
        }

        public boolean connExists(SpringNode from, SpringNode to) {
            for (SpringConnection conn : this.connections) {
                if (conn.from == from && conn.to == to) {
                    return true;
                }
                if (conn.from != to || conn.to != from) continue;
                return true;
            }
            return false;
        }

        public void addConnection(SpringNode from, SpringNode to, float k, float d, boolean push, boolean pull) {
            if (from == to) {
                return;
            }
            if (this.connExists(from, to)) {
                return;
            }
            SpringConnection conn = new SpringConnection();
            conn.from = from;
            conn.to = to;
            conn.k = k;
            conn.d = d;
            conn.push = push;
            conn.pull = pull;
            from.connections.add(conn);
            to.connections.add(conn);
            this.connections.add(conn);
        }

        public void advance(float amount) {
            if (amount <= 0.0f) {
                return;
            }
            ++this.iter;
            for (SpringNode node : this.nodes) {
                node.force.set(0.0f, 0.0f);
            }
            for (SpringConnection conn : this.connections) {
                float dist = Misc.getDistance(conn.from.loc, conn.to.loc);
                if (!conn.push && dist < conn.d || !conn.pull && dist > conn.d) continue;
                float diff = conn.d - dist;
                Vector2f dir = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(conn.from.loc, conn.to.loc));
                float force = conn.k * diff;
                conn.to.force.x += dir.x * force;
                conn.to.force.y += dir.y * force;
                conn.from.force.x -= dir.x * force;
                conn.from.force.y -= dir.y * force;
            }
            float cof = 500.0f;
            for (SpringNode node : this.nodes) {
                float max;
                float friction = node.vel.length() * cof;
                if (friction > (max = node.vel.length() * node.mass / amount)) {
                    friction = max;
                }
                if (!(friction > 0.0f)) continue;
                Vector2f dir = new Vector2f((ReadableVector2f)node.vel);
                dir.negate();
                dir.normalise();
                dir.scale(friction);
                node.force.x += dir.x;
                node.force.y += dir.y;
            }
            for (SpringNode node : this.nodes) {
                if (!node.moveable) continue;
                float ax = node.force.x / node.mass;
                float ay = node.force.y / node.mass;
                node.vel.x += ax * amount;
                node.vel.y += ay * amount;
                node.loc.x += node.vel.x * amount;
                node.loc.y += node.vel.y * amount;
            }
        }

        public boolean isDone() {
            for (SpringNode n1 : this.nodes) {
                for (SpringNode n2 : this.nodes) {
                    float dist;
                    if (n1 == n2 || !((dist = Misc.getDistance(n1.loc, n2.loc)) < n1.radius + n2.radius)) continue;
                    return false;
                }
            }
            for (SpringConnection conn : this.connections) {
                float dist;
                if (!conn.pull || !((dist = Misc.getDistance(conn.from.loc, conn.to.loc)) > conn.d + 1000.0f)) continue;
                return false;
            }
            return true;
        }
    }

    public static class StarNode {
        public StarSystemAPI system;
        public Vector2f location;

        public StarNode(StarSystemAPI system, Vector2f location) {
            this.system = system;
            this.location = location;
        }
    }
}

