/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen;

import com.fs.starfarer.api.impl.campaign.procgen.DropGroupRow;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class SalvageEntityGenDataSpec {
    private String id;
    private String nameOverride;
    private float salvageRating;
    private float detectionRange;
    private float xpDiscover;
    private float xpSalvage;
    private float radiusOverride = -1.0f;
    private DiscoverabilityType type;
    private float probDefenders;
    private float defQuality;
    private float minStr;
    private float maxStr;
    private float maxDefenderSize;
    private float minDefenderSize;
    private float probStation;
    private String stationRole;
    private String defFaction;
    private List<DropData> dropValue = new ArrayList<DropData>();
    private List<DropData> dropRandom = new ArrayList<DropData>();
    private Set<String> tags = new HashSet<String>();

    public SalvageEntityGenDataSpec(JSONObject row) throws JSONException {
        String tags;
        DropData data;
        String value;
        String key;
        String[] pair;
        String part;
        int n;
        int n2;
        String[] stringArray;
        String[] parts;
        this.id = row.getString("id");
        this.stationRole = row.getString("stationRole");
        this.nameOverride = row.optString("name");
        if (this.nameOverride != null && this.nameOverride.isEmpty()) {
            this.nameOverride = null;
        }
        this.salvageRating = (float)row.optDouble("rating", 0.0);
        this.detectionRange = (float)row.optDouble("detection_range", 0.0);
        float baseXP = 200.0f + 1.0f * (this.salvageRating * 20.0f);
        baseXP = Misc.getRounded(baseXP);
        this.xpDiscover = (float)row.optDouble("xpDiscover", (double)baseXP);
        this.xpSalvage = (float)row.optDouble("xpSalvage", (double)(baseXP * 3.0f));
        this.radiusOverride = (float)row.optDouble("radius", -1.0);
        this.defQuality = (float)row.optDouble("defQuality", 1.0);
        this.probDefenders = (float)row.optDouble("probDefenders", 0.0);
        this.minStr = (float)row.optDouble("minStr", 0.0);
        this.maxStr = (float)row.optDouble("maxStr", 0.0);
        this.maxDefenderSize = (float)row.optDouble("maxSize", 4.0);
        this.minDefenderSize = (float)row.optDouble("minSize", 0.0);
        this.defFaction = row.optString("defFaction", null);
        if (this.defFaction != null && this.defFaction.isEmpty()) {
            this.defFaction = null;
        }
        this.probStation = (float)row.optDouble("probStation", 0.0);
        this.type = Misc.mapToEnum(row, "type", DiscoverabilityType.class, DiscoverabilityType.DISCOVERABLE);
        if (row.has("drop_value") && !row.getString("drop_value").isEmpty()) {
            stringArray = parts = row.getString("drop_value").split(",");
            n2 = parts.length;
            n = 0;
            while (n < n2) {
                part = stringArray[n];
                part = part.trim();
                pair = part.split(":");
                key = pair[0].trim();
                value = pair[1].trim();
                data = new DropData();
                data.group = key;
                data.value = Integer.valueOf(value);
                data.chances = -1;
                this.dropValue.add(data);
                ++n;
            }
        }
        if (row.has("drop_random") && !row.getString("drop_random").isEmpty()) {
            stringArray = parts = row.getString("drop_random").split(",");
            n2 = parts.length;
            n = 0;
            while (n < n2) {
                part = stringArray[n];
                part = part.trim();
                pair = part.split(":");
                key = pair[0].trim();
                value = pair[1].trim();
                data = new DropData();
                data.group = key;
                if (value.contains("x")) {
                    String[] chancesXValue = value.split("x");
                    if (chancesXValue[0].trim().contains("-")) {
                        data.chances = Integer.valueOf(chancesXValue[0].trim().split("-")[0]);
                        data.maxChances = Integer.valueOf(chancesXValue[0].trim().split("-")[1]);
                    } else {
                        data.chances = Integer.valueOf(chancesXValue[0].trim());
                    }
                    data.value = Integer.valueOf(chancesXValue[1].trim());
                } else {
                    data.value = -1;
                    if (value.contains("-")) {
                        data.chances = Integer.valueOf(value.trim().split("-")[0]);
                        data.maxChances = Integer.valueOf(value.trim().split("-")[1]);
                    } else {
                        float c = Float.valueOf(value).floatValue();
                        data.chances = (int)Math.max(c, 1.0f);
                        if (c < 1.0f) {
                            data.valueMult = c;
                        }
                    }
                }
                this.dropRandom.add(data);
                ++n;
            }
        }
        if ((tags = row.optString("tags", null)) != null) {
            String[] split;
            String[] stringArray2 = split = tags.split(",");
            int n3 = split.length;
            n2 = 0;
            while (n2 < n3) {
                String tag = stringArray2[n2];
                if (!(tag = tag.trim()).isEmpty()) {
                    this.addTag(tag);
                }
                ++n2;
            }
        }
    }

    public String getDefFaction() {
        return this.defFaction;
    }

    public void setDefFaction(String defFaction) {
        this.defFaction = defFaction;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    public float getRadiusOverride() {
        return this.radiusOverride;
    }

    public void setRadiusOverride(float radiusOverride) {
        this.radiusOverride = radiusOverride;
    }

    public String getNameOverride() {
        return this.nameOverride;
    }

    public void setNameOverride(String nameOverride) {
        this.nameOverride = nameOverride;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public float getSalvageRating() {
        return this.salvageRating;
    }

    public void setSalvageRating(float salvageRating) {
        this.salvageRating = salvageRating;
    }

    public float getDetectionRange() {
        return this.detectionRange;
    }

    public void setDetectionRange(float detectionRange) {
        this.detectionRange = detectionRange;
    }

    public float getXpDiscover() {
        return this.xpDiscover;
    }

    public void setXpDiscover(float xpDiscover) {
        this.xpDiscover = xpDiscover;
    }

    public float getXpSalvage() {
        return this.xpSalvage;
    }

    public void setXpSalvage(float xpSalvage) {
        this.xpSalvage = xpSalvage;
    }

    public List<DropData> getDropValue() {
        return this.dropValue;
    }

    public List<DropData> getDropRandom() {
        return this.dropRandom;
    }

    public DiscoverabilityType getType() {
        return this.type;
    }

    public void setType(DiscoverabilityType type) {
        this.type = type;
    }

    public float getProbDefenders() {
        return this.probDefenders;
    }

    public void setProbDefenders(float probDefenders) {
        this.probDefenders = probDefenders;
    }

    public float getMinStr() {
        return this.minStr;
    }

    public void setMinStr(float minStr) {
        this.minStr = minStr;
    }

    public float getMaxStr() {
        return this.maxStr;
    }

    public void setMaxStr(float maxStr) {
        this.maxStr = maxStr;
    }

    public float getMaxDefenderSize() {
        return this.maxDefenderSize;
    }

    public void setMaxDefenderSize(float maxSize) {
        this.maxDefenderSize = maxSize;
    }

    public float getMinDefenderSize() {
        return this.minDefenderSize;
    }

    public void setMinDefenderSize(float minDefenderSize) {
        this.minDefenderSize = minDefenderSize;
    }

    public float getDefQuality() {
        return this.defQuality;
    }

    public void setDefQuality(float defQuality) {
        this.defQuality = defQuality;
    }

    public float getProbStation() {
        return this.probStation;
    }

    public void setProbStation(float probStation) {
        this.probStation = probStation;
    }

    public String getStationRole() {
        return this.stationRole;
    }

    public void setStationRole(String stationRole) {
        this.stationRole = stationRole;
    }

    public static enum DiscoverabilityType {
        DISCOVERABLE,
        NOT_DISCOVERABLE,
        ALWAYS_VISIBLE;

    }

    public static class DropData
    implements Cloneable {
        public transient String group;
        public transient int chances = -1;
        public transient int maxChances = -1;
        public transient int value = -1;
        public transient float valueMult = 1.0f;
        private WeightedRandomPicker<DropGroupRow> custom = null;
        private String j = null;

        Object readResolve() {
            if (this.j != null) {
                try {
                    JSONObject json = new JSONObject(this.j);
                    if (json.has("g")) {
                        this.group = json.getString("g");
                    }
                    this.chances = json.has("c") ? json.getInt("c") : -1;
                    this.maxChances = json.has("mC") ? json.getInt("mC") : -1;
                    this.value = json.has("v") ? json.getInt("v") : -1;
                    this.valueMult = json.has("vM") ? (float)json.getDouble("vM") : 1.0f;
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
            return this;
        }

        Object writeReplace() {
            try {
                JSONObject json = new JSONObject();
                if (this.group != null) {
                    json.put("g", (Object)this.group);
                }
                if (this.chances > 0) {
                    json.put("c", this.chances);
                }
                if (this.maxChances > 0) {
                    json.put("mC", this.maxChances);
                }
                if (this.value > 0) {
                    json.put("v", this.value);
                }
                if (this.valueMult != 1.0f) {
                    json.put("vM", (double)this.valueMult);
                }
                this.j = json.toString();
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public void addWeapon(String id, float weight) {
            this.addCustom("wpn_" + id, weight);
        }

        public void addHullMod(String id, float weight) {
            this.addCustom("item_modspec:" + id, weight);
        }

        public void addFighterChip(String id, float weight) {
            this.addCustom("ftr_" + id, weight);
        }

        public void addNothing(float weight) {
            this.addCustom("nothing", weight);
        }

        public void addCommodity(String id, float weight) {
            this.addCustom(id, weight);
        }

        public void addSpecialItem(String data, float weight) {
            this.addCustom("item_" + data, weight);
        }

        public void addCustom(String data, float weight) {
            this.initCustom();
            int i = 0;
            while (i < this.custom.getItems().size()) {
                DropGroupRow row = this.custom.getItems().get(i);
                if (row.getCommodity() != null && row.getCommodity().equals(data)) {
                    float w = this.custom.getWeight(i);
                    this.custom.setWeight(i, w += weight);
                    return;
                }
                ++i;
            }
            DropGroupRow row = new DropGroupRow(data, "custom", weight);
            this.custom.add(row, weight);
        }

        public void addRandomWeapons(int tier, float weight) {
            this.addCustom("wpn_", tier, weight, null);
        }

        public void addRandomWeapons(int tier, float weight, String ... tags) {
            this.addCustom("wpn_", tier, weight, tags);
        }

        public void addRandomHullmods(int tier, float weight) {
            this.addCustom("item_modspec:", tier, weight, null);
        }

        public void addRandomHullmods(int tier, float weight, String ... tags) {
            this.addCustom("item_modspec:", tier, weight, tags);
        }

        public void addRandomFighters(int tier, float weight) {
            this.addCustom("ftr_", tier, weight, null);
        }

        public void addRandomFighters(int tier, float weight, String ... tags) {
            this.addCustom("ftr_", tier, weight, tags);
        }

        private void addCustom(String prefix, int tier, float weight, String ... tags) {
            this.initCustom();
            String data = prefix;
            data = String.valueOf(data) + "{";
            if (tier >= 0) {
                data = String.valueOf(data) + "tier:" + tier + ",";
            }
            if (tags != null && tags.length > 0) {
                data = String.valueOf(data) + "tags:[";
                String[] stringArray = tags;
                int n = tags.length;
                int n2 = 0;
                while (n2 < n) {
                    String tag = stringArray[n2];
                    data = String.valueOf(data) + tag + ",";
                    ++n2;
                }
                data = String.valueOf(data) + "]";
            }
            data = String.valueOf(data) + "}";
            DropGroupRow row = new DropGroupRow(data, "custom", weight);
            this.custom.add(row, weight);
        }

        public void initCustom() {
            if (this.custom == null) {
                this.custom = new WeightedRandomPicker();
            }
        }

        public void clearCustom() {
            this.custom = null;
        }

        public WeightedRandomPicker<DropGroupRow> getCustom() {
            return this.custom;
        }

        public DropData clone() {
            try {
                DropData copy = (DropData)super.clone();
                if (this.custom != null) {
                    copy.custom = new WeightedRandomPicker();
                    int i = 0;
                    while (i < this.custom.getItems().size()) {
                        copy.custom.add(this.custom.getItems().get(i), this.custom.getWeight(i));
                        ++i;
                    }
                }
                return copy;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

