/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen.themes;

import com.fs.starfarer.api.campaign.AICoreOfficerPlugin;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.BaseGenericPlugin;
import com.fs.starfarer.api.impl.campaign.DModManager;
import com.fs.starfarer.api.impl.campaign.fleets.DefaultFleetInflater;
import com.fs.starfarer.api.impl.campaign.fleets.DefaultFleetInflaterParams;
import com.fs.starfarer.api.impl.campaign.procgen.themes.MiscellaneousThemeGenerator;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageGenFromSeed;
import com.fs.starfarer.api.loading.VariantSource;
import com.fs.starfarer.api.util.Misc;
import java.util.Random;

public class PKDefenderPluginImpl
extends BaseGenericPlugin
implements SalvageGenFromSeed.SalvageDefenderModificationPlugin {
    @Override
    public float getStrength(SalvageGenFromSeed.SDMParams p, float strength, Random random, boolean withOverride) {
        return strength;
    }

    @Override
    public float getMinSize(SalvageGenFromSeed.SDMParams p, float minSize, Random random, boolean withOverride) {
        return minSize;
    }

    @Override
    public float getMaxSize(SalvageGenFromSeed.SDMParams p, float maxSize, Random random, boolean withOverride) {
        return maxSize;
    }

    @Override
    public float getProbability(SalvageGenFromSeed.SDMParams p, float probability, Random random, boolean withOverride) {
        return probability;
    }

    @Override
    public void reportDefeated(SalvageGenFromSeed.SDMParams p, SectorEntityToken entity, CampaignFleetAPI fleet) {
    }

    @Override
    public void modifyFleet(SalvageGenFromSeed.SDMParams p, CampaignFleetAPI fleet, Random random, boolean withOverride) {
        Misc.addDefeatTrigger(fleet, "PK14thDefeated");
        fleet.setNoFactionInName(true);
        fleet.setName("Remnants of Task Force Safeguard");
        AICoreOfficerPlugin plugin = Misc.getAICoreOfficerPlugin("alpha_core");
        fleet.getFleetData().clear();
        fleet.getFleetData().setShipNameRandom(random);
        FleetMemberAPI member = fleet.getFleetData().addFleetMember("legion_xiv_Automated");
        member.setId("xivtf_" + random.nextLong());
        PersonAPI person = plugin.createPerson("alpha_core", fleet.getFaction().getId(), random);
        person.getStats().setSkipRefresh(true);
        person.getStats().setSkillLevel("carrier_group", 1.0f);
        person.getStats().setSkillLevel("fighter_uplink", 1.0f);
        person.getStats().setSkipRefresh(false);
        member.setCaptain(person);
        ShipVariantAPI v = member.getVariant().clone();
        v.setSource(VariantSource.REFIT);
        v.addTag("no_autofit");
        v.addTag("no_auto_penalty");
        member.setVariant(v, false, true);
        fleet.setCommander(person);
        PKDefenderPluginImpl.addAutomated(fleet, "onslaught_xiv_Elite", null, "alpha_core", random);
        PKDefenderPluginImpl.addAutomated(fleet, "dominator_XIV_Elite", null, "beta_core", random);
        PKDefenderPluginImpl.addAutomated(fleet, "eagle_xiv_Elite", null, "beta_core", random);
        PKDefenderPluginImpl.addAutomated(fleet, "falcon_xiv_Elite", null, "beta_core", random);
        PKDefenderPluginImpl.addAutomated(fleet, "falcon_xiv_Escort", null, "beta_core", random);
        PKDefenderPluginImpl.addAutomated(fleet, "enforcer_XIV_Elite", null, "gamma_core", random);
        PKDefenderPluginImpl.addAutomated(fleet, "enforcer_XIV_Elite", null, "gamma_core", random);
        PKDefenderPluginImpl.addAutomated(fleet, "enforcer_XIV_Elite", null, "gamma_core", random);
        for (FleetMemberAPI curr : fleet.getFleetData().getMembersListCopy()) {
            PKDefenderPluginImpl.makeAICoreSkillsGoodForLowTech(curr, true);
            curr.getRepairTracker().setCR(curr.getRepairTracker().getMaxCR());
        }
        for (FleetMemberAPI curr : fleet.getFleetData().getMembersListCopy()) {
            v = curr.getVariant().clone();
            v.setSource(VariantSource.REFIT);
            curr.setVariant(v, false, false);
        }
        if (fleet.getInflater() instanceof DefaultFleetInflater) {
            DefaultFleetInflater dfi = (DefaultFleetInflater)fleet.getInflater();
            DefaultFleetInflaterParams dfip = (DefaultFleetInflaterParams)dfi.getParams();
            dfip.allWeapons = true;
            dfip.averageSMods = 3;
            dfip.quality = 0.4f;
            DModManager.assumeAllShipsAreAutomated = true;
            fleet.inflateIfNeeded();
            fleet.setInflater(null);
            DModManager.assumeAllShipsAreAutomated = false;
        }
        for (FleetMemberAPI curr : fleet.getFleetData().getMembersListCopy()) {
            curr.getVariant().addPermaMod("automated");
            curr.getVariant().setVariantDisplayName("Automated");
            curr.getVariant().addTag("no_auto_penalty");
            curr.getVariant().addTag("unrestorable");
            curr.getVariant().addTag("retain_smods_on_recovery");
            if (!curr.isCapital()) continue;
            curr.getVariant().addTag("always_recoverable");
        }
    }

    public static void addAutomated(CampaignFleetAPI fleet, String variantId, String shipName, String aiCore, Random random) {
        AICoreOfficerPlugin plugin = Misc.getAICoreOfficerPlugin("alpha_core");
        FleetMemberAPI member = fleet.getFleetData().addFleetMember(variantId);
        member.setId("xivtf_" + random.nextLong());
        if (shipName != null) {
            member.setShipName(shipName);
        }
        if (aiCore != null) {
            PersonAPI person = plugin.createPerson(aiCore, fleet.getFaction().getId(), random);
            member.setCaptain(person);
        }
    }

    public static void makeAICoreSkillsGoodForLowTech(FleetMemberAPI member, boolean integrate) {
        if (member.getCaptain() == null || !member.getCaptain().isAICore()) {
            return;
        }
        PersonAPI person = member.getCaptain();
        person.getStats().setSkipRefresh(true);
        String aiCoreId = person.getAICoreId();
        if (integrate) {
            person.getStats().setLevel(person.getStats().getLevel() + 1);
            person.getStats().setSkillLevel("ballistic_mastery", 2.0f);
        }
        boolean alpha = "alpha_core".equals(aiCoreId);
        boolean beta = "beta_core".equals(aiCoreId);
        boolean gamma = "gamma_core".equals(aiCoreId);
        if (member.isCapital() || member.isCruiser()) {
            person.getStats().setSkillLevel("combat_endurance", 0.0f);
            person.getStats().setSkillLevel("missile_specialization", 2.0f);
        }
        person.getStats().setSkipRefresh(false);
    }

    @Override
    public int getHandlingPriority(Object params) {
        if (!(params instanceof SalvageGenFromSeed.SDMParams)) {
            return 0;
        }
        SalvageGenFromSeed.SDMParams p = (SalvageGenFromSeed.SDMParams)params;
        if (p.entity != null && p.entity.getMemoryWithoutUpdate().contains(MiscellaneousThemeGenerator.PK_CACHE_KEY)) {
            return 2;
        }
        return -1;
    }

    @Override
    public float getQuality(SalvageGenFromSeed.SDMParams p, float quality, Random random, boolean withOverride) {
        return quality;
    }
}

