/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.MarketConditionSpecAPI;
import com.fs.starfarer.api.impl.campaign.intel.misc.SurveyDataForPlanetIntel;
import com.fs.starfarer.api.impl.campaign.procgen.themes.DerelictThemeGenerator;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageSpecialInteraction;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BreadcrumbSpecial;
import com.fs.starfarer.api.plugins.SurveyPlugin;
import com.fs.starfarer.api.util.Misc;
import java.util.List;

public class SurveyDataSpecial
extends BaseSalvageSpecial {
    public static float MAX_RANGE = 30000.0f;
    private SurveyDataSpecialData data;

    @Override
    public void init(InteractionDialogAPI dialog, Object specialData) {
        List<StarSystemAPI> systems;
        PlanetAPI planet;
        super.init(dialog, specialData);
        this.data = (SurveyDataSpecialData)specialData;
        if (this.data.type == SurveyDataSpecialType.PLANET_SURVEY_DATA && this.data.entityId == null && (planet = DerelictThemeGenerator.findInterestingPlanet(systems = Misc.getSystemsInRange(this.entity, null, true, MAX_RANGE), null, false, this.data.includeRuins, this.random)) != null) {
            this.data.entityId = planet.getId();
        }
        if (this.data.entityId != null) {
            SectorEntityToken entity = Global.getSector().getEntityById(this.data.entityId);
            StarSystemAPI system = Global.getSector().getStarSystem(this.data.entityId);
            if (entity == null && system == null) {
                this.data.entityId = null;
                this.data.type = SurveyDataSpecialType.SCRAMBLED;
            }
        } else {
            this.data.type = SurveyDataSpecialType.SCRAMBLED;
        }
        switch (this.data.type) {
            case SCRAMBLED: {
                this.initNothing();
                break;
            }
            case PLANET_SURVEY_DATA: {
                this.initPlanetSurveyData();
            }
        }
    }

    @Override
    public void initNothing() {
        this.addText("The $shortName's memory banks have been scrubbed clean by hard radiation, and the systems are largely inert and non-functional.");
        this.setDone(true);
    }

    protected void initPlanetSurveyData() {
        MarketConditionSpecAPI spec;
        String conditionId;
        if (this.data.entityId == null) {
            this.initNothing();
            return;
        }
        PlanetAPI planet = (PlanetAPI)Global.getSector().getEntityById(this.data.entityId);
        if (planet.getMarket() != null && planet.getMarket().getSurveyLevel() == MarketAPI.SurveyLevel.FULL) {
            this.initNothing();
            return;
        }
        String name = planet.getName();
        String world = String.valueOf(planet.getSpec().getAOrAn()) + " " + planet.getTypeNameWithWorld().toLowerCase();
        String loc = BreadcrumbSpecial.getLocatedString(planet, true);
        loc = loc.replaceFirst("located ", "");
        String text1 = "The $shortName's memory banks are partially accessible, and contain full survey data for " + name + ", " + world + " located " + loc + ".";
        String text1ForIntel = "While exploring $aOrAn $nameInText, your crews found partially accessible memory banks that contain full survey data for " + name + ", " + world + " located " + loc + ".";
        boolean debris = "debris_field_shared".equals(this.entity.getCustomEntityType());
        if (debris) {
            text1 = "Your salvage crews find a functional memory bank in the debris. It contains full survey data for " + name + ", " + world + " located " + loc + ".";
        }
        if ((conditionId = DerelictThemeGenerator.getInterestingCondition(planet, this.data.includeRuins)) != null && (spec = Global.getSettings().getMarketConditionSpec(conditionId)) != null) {
            text1 = String.valueOf(text1) + " The world is notable for ";
            text1ForIntel = String.valueOf(text1ForIntel) + " The world is notable for ";
            if (conditionId.equals("habitable")) {
                text1 = String.valueOf(text1) + "being habitable.";
                text1ForIntel = String.valueOf(text1ForIntel) + "being habitable.";
            } else {
                text1 = String.valueOf(text1) + "having " + spec.getName().toLowerCase() + ".";
                text1ForIntel = String.valueOf(text1ForIntel) + "having " + spec.getName().toLowerCase() + ".";
            }
        }
        this.addText(text1);
        Misc.setFullySurveyed(planet.getMarket(), null, false);
        Misc.addSurveyDataFor(planet, this.text);
        SurveyPlugin plugin = (SurveyPlugin)Global.getSettings().getNewPluginInstance("surveyPlugin");
        plugin.init(Global.getSector().getPlayerFleet(), planet);
        long xp = plugin.getXP();
        if (xp > 0L) {
            Global.getSector().getPlayerPerson().getStats().addXP(xp, this.text);
        }
        new SurveyDataForPlanetIntel(planet, this.getString(text1ForIntel), this.text);
        this.setDone(true);
    }

    @Override
    public void optionSelected(String optionText, Object optionData) {
        super.optionSelected(optionText, optionData);
    }

    public static class SurveyDataSpecialData
    implements SalvageSpecialInteraction.SalvageSpecialData {
        public SurveyDataSpecialType type = null;
        public String entityId = null;
        @Deprecated
        public String secondaryId = null;
        public boolean includeRuins = true;

        public SurveyDataSpecialData(SurveyDataSpecialType type) {
            this.type = type;
        }

        @Override
        public SalvageSpecialInteraction.SalvageSpecialPlugin createSpecialPlugin() {
            return new SurveyDataSpecial();
        }
    }

    public static enum SurveyDataSpecialType {
        SCRAMBLED,
        PLANET_SURVEY_DATA,
        PLANET_INTERESTING_PROPERTY,
        SYSTEM_PRELIMINARY_SURVEY,
        AUTO_PICK,
        AUTO_PICK_NOT_SYSTEM;

    }
}

