/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.characters.FleetTotalItem;
import com.fs.starfarer.api.characters.FleetTotalSource;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;

public class CrewTraining {
    public static float PEAK_SECONDS = 30.0f;
    public static float CR_PERCENT = 15.0f;

    public static class Level1
    extends BaseSkillEffectDescription
    implements ShipSkillEffect,
    FleetTotalSource {
        @Override
        public FleetTotalItem getFleetTotalItem() {
            return this.getCombatOPTotal();
        }

        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (!Level1.isCivilian(stats)) {
                float crBonus = this.computeAndCacheThresholdBonus(stats, "ct_cr", CR_PERCENT, BaseSkillEffectDescription.ThresholdBonusType.OP);
                stats.getMaxCombatReadiness().modifyFlat(id, crBonus * 0.01f, "Crew Training skill");
            }
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxCombatReadiness().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return null;
        }

        @Override
        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            FleetDataAPI data = Level1.getFleetData(null);
            float crBonus = this.computeAndCacheThresholdBonus(data, stats, "ct_cr", CR_PERCENT, BaseSkillEffectDescription.ThresholdBonusType.OP);
            info.addPara("+%s maximum combat readiness for combat ships (maximum: %s)", 0.0f, this.hc, this.hc, (int)crBonus + "%", (int)CR_PERCENT + "%");
            this.addOPThresholdInfo(info, data, stats, OP_THRESHOLD);
        }
    }

    public static class Level2
    extends BaseSkillEffectDescription
    implements ShipSkillEffect,
    FleetTotalSource {
        @Override
        public FleetTotalItem getFleetTotalItem() {
            return this.getCombatOPTotal();
        }

        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (!Level2.isCivilian(stats)) {
                float peakTimeBonus = this.computeAndCacheThresholdBonus(stats, "ct_peak", PEAK_SECONDS, BaseSkillEffectDescription.ThresholdBonusType.OP);
                stats.getPeakCRDuration().modifyFlat(id, peakTimeBonus);
            }
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getPeakCRDuration().unmodifyFlat(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return null;
        }

        @Override
        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            FleetDataAPI data = Level2.getFleetData(null);
            float peakTimeBonus = this.computeAndCacheThresholdBonus(data, stats, "ct_peak", PEAK_SECONDS, BaseSkillEffectDescription.ThresholdBonusType.OP);
            info.addPara("+%s seconds peak operating time for combat ships (maximum: %s)", 0.0f, this.hc, this.hc, "" + (int)peakTimeBonus, "" + (int)PEAK_SECONDS);
            this.addOPThresholdInfo(info, data, stats, OP_THRESHOLD);
        }
    }
}

