/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.fleet.FleetMemberViewAPI;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceTerrainPlugin;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class HyperStormBoost
implements EveryFrameScript {
    public static float MAX_BURN = Global.getSettings().getFloat("maxStormStrikeBurn");
    public static float STORM_SPEED_BURST = Global.getSettings().getSpeedPerBurnLevel() * 50.0f;
    public static float DURATION_SECONDS = 1.0f;
    protected CampaignFleetAPI fleet;
    protected float elapsed;
    protected float angle;
    protected HyperspaceTerrainPlugin.CellStateTracker cell;

    public HyperStormBoost(HyperspaceTerrainPlugin.CellStateTracker cell, CampaignFleetAPI fleet) {
        this.cell = cell;
        this.fleet = fleet;
        DURATION_SECONDS = 1.25f;
        STORM_SPEED_BURST = Global.getSettings().getSpeedPerBurnLevel() * 75.0f;
        if (Misc.getHyperspaceTerrain().getPlugin() instanceof HyperspaceTerrainPlugin) {
            float bestAngleAt;
            float mult;
            HyperspaceTerrainPlugin hyper = (HyperspaceTerrainPlugin)Misc.getHyperspaceTerrain().getPlugin();
            float x = hyper.getEntity().getLocation().x;
            float y = hyper.getEntity().getLocation().y;
            float size = hyper.getTileSize();
            float w = (float)hyper.getTiles().length * size;
            float h = (float)hyper.getTiles()[0].length * size;
            float tx = (x -= w / 2.0f) + (float)cell.i * size + size / 2.0f;
            float ty = (y -= h / 2.0f) + (float)cell.j * size + size / 2.0f;
            this.angle = Misc.getAngleInDegrees(new Vector2f(tx, ty), fleet.getLocation());
            Vector2f v = fleet.getVelocity();
            float angle2 = Misc.getAngleInDegrees(v);
            float speed = v.length();
            if (speed < 10.0f) {
                angle2 = fleet.getFacing();
            }
            if ((mult = 0.5f + 0.4f * speed / (bestAngleAt = Global.getSettings().getBaseTravelSpeed() + Global.getSettings().getSpeedPerBurnLevel() * 20.0f)) < 0.5f) {
                mult = 0.5f;
            }
            if (mult > 0.9f) {
                mult = 0.9f;
            }
            this.angle += Misc.getClosestTurnDirection(this.angle, angle2) * Misc.getAngleDiff(this.angle, angle2) * mult;
        }
    }

    @Override
    public void advance(float amount) {
        this.elapsed += amount;
        Vector2f boost = Misc.getUnitVectorAtDegreeAngle(this.angle);
        float mult = 1.0f;
        mult = 1.0f - this.elapsed / DURATION_SECONDS;
        if ((mult = (float)((double)mult * Math.pow(Math.min(1.0f, this.elapsed / 0.25f), 2.0))) < 0.0f) {
            mult = 0.0f;
        }
        if (mult > 1.0f) {
            mult = 1.0f;
        }
        boost.scale(STORM_SPEED_BURST * amount * mult);
        Vector2f v = this.fleet.getVelocity();
        if (this.fleet.getCurrBurnLevel() < MAX_BURN) {
            this.fleet.setVelocity(v.x + boost.x, v.y + boost.y);
        }
        float angleHeading = Misc.getAngleInDegrees(v);
        if (v.length() < 10.0f) {
            angleHeading = this.fleet.getFacing();
        }
        if ((boost = Misc.getUnitVectorAtDegreeAngle(angleHeading)).length() >= 1.0f) {
            float durIn = 1.0f;
            float durOut = 3.0f;
            float intensity = 1.0f;
            float sizeNormal = 5.0f + 20.0f * intensity;
            String modId = "boost " + this.cell.i + this.cell.j * 100;
            Color glowColor = new Color(100, 100, 255, 75);
            for (FleetMemberViewAPI view : this.fleet.getViews()) {
                view.getWindEffectDirX().shift(modId, boost.x * sizeNormal, durIn, durOut, 1.0f);
                view.getWindEffectDirY().shift(modId, boost.y * sizeNormal, durIn, durOut, 1.0f);
                view.getWindEffectColor().shift(modId, glowColor, durIn, durOut, intensity);
            }
        }
    }

    @Override
    public boolean isDone() {
        return this.elapsed >= DURATION_SECONDS || !this.fleet.isInHyperspace();
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }
}

