/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.dweller.DwellerCombatStrategyForBothSidesPlugin;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShipCreator;
import com.fs.starfarer.api.impl.combat.dweller.ShroudedEjectaShipCreator;
import com.fs.starfarer.api.impl.combat.dweller.ShroudedEyeShipCreator;
import com.fs.starfarer.api.impl.combat.dweller.ShroudedMaelstromShipCreator;
import com.fs.starfarer.api.impl.combat.dweller.ShroudedMawShipCreator;
import com.fs.starfarer.api.impl.combat.dweller.ShroudedTendrilShipCreator;
import com.fs.starfarer.api.impl.combat.dweller.ShroudedVortexShipCreator;
import java.util.LinkedHashMap;
import java.util.Map;

public class DwellerHullmod
extends BaseHullMod {
    public static Map<String, DwellerShipCreator> SHIP_CREATORS = new LinkedHashMap<String, DwellerShipCreator>();
    public static String INITED_DWELLER_STUFF;

    static {
        SHIP_CREATORS.put("shrouded_tendril", new ShroudedTendrilShipCreator());
        SHIP_CREATORS.put("shrouded_eye", new ShroudedEyeShipCreator());
        SHIP_CREATORS.put("shrouded_vortex", new ShroudedVortexShipCreator());
        SHIP_CREATORS.put("shrouded_maw", new ShroudedMawShipCreator());
        SHIP_CREATORS.put("shrouded_maelstrom", new ShroudedMaelstromShipCreator());
        SHIP_CREATORS.put("shrouded_ejecta", new ShroudedEjectaShipCreator());
        INITED_DWELLER_STUFF = "inited_dweller_stuff";
    }

    protected DwellerShipCreator getShipCreator(String hullId) {
        return SHIP_CREATORS.get(hullId);
    }

    protected boolean addStrategyAI() {
        return true;
    }

    @Override
    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        if (stats == null || stats.getVariant() == null) {
            return;
        }
        String hullId = stats.getVariant().getHullSpec().getBaseHullId();
        DwellerShipCreator creator = this.getShipCreator(hullId);
        if (creator != null) {
            creator.initBeforeShipCreation(hullSize, stats, id);
        }
    }

    @Override
    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
        if (ship == null || ship.getHullSpec() == null) {
            return;
        }
        String hullId = ship.getHullSpec().getBaseHullId();
        DwellerShipCreator creator = this.getShipCreator(hullId);
        if (creator != null) {
            creator.initAfterShipCreation(ship, id);
        }
    }

    @Override
    public void applyEffectsAfterShipAddedToCombatEngine(ShipAPI ship, String id) {
        CombatEngineAPI engine;
        if (ship == null || ship.getHullSpec() == null) {
            return;
        }
        String hullId = ship.getHullSpec().getBaseHullId();
        DwellerShipCreator creator = this.getShipCreator(hullId);
        if (creator != null) {
            creator.initAfterShipAddedToCombatEngine(ship, id);
        }
        if (this.addStrategyAI() && !(engine = Global.getCombatEngine()).hasPluginOfClass(DwellerCombatStrategyForBothSidesPlugin.class)) {
            engine.addPlugin(new DwellerCombatStrategyForBothSidesPlugin());
        }
    }

    @Override
    public void advanceInCombat(ShipAPI ship, float amount) {
        if (amount <= 0.0f || ship == null) {
            return;
        }
        if (ship.hasTag(INITED_DWELLER_STUFF)) {
            return;
        }
        ship.addTag(INITED_DWELLER_STUFF);
        if (ship == null || ship.getHullSpec() == null) {
            return;
        }
        String hullId = ship.getHullSpec().getBaseHullId();
        DwellerShipCreator creator = this.getShipCreator(hullId);
        if (creator != null) {
            creator.initInCombat(ship);
        }
    }
}

