/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.threat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.OnHitEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.ApplyDamageResultAPI;
import com.fs.starfarer.api.combat.listeners.DamageDealtModifier;
import com.fs.starfarer.api.impl.combat.DisintegratorEffect;
import com.fs.starfarer.api.impl.combat.threat.BaseFragmentMissileEffect;
import com.fs.starfarer.api.impl.combat.threat.RoilingSwarmEffect;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class DevouringSwarmMissileEffect
extends BaseFragmentMissileEffect
implements OnHitEffectPlugin {
    public static String DISMANTLING_SWARM = "dismantling_swarm";
    public static int NUM_TICKS = 11;

    @Override
    public void onFire(DamagingProjectileAPI projectile, WeaponAPI weapon, CombatEngineAPI engine) {
        super.onFire(projectile, weapon, engine);
        if (weapon.getShip() != null && !weapon.getShip().hasListenerOfClass(DismantlingFragmentBaseDamageNegator.class)) {
            weapon.getShip().addListener(new DismantlingFragmentBaseDamageNegator());
        }
    }

    @Override
    protected void configureMissileSwarmParams(RoilingSwarmEffect.RoilingSwarmParams params) {
        params.tags.add(DISMANTLING_SWARM);
        params.flashFringeColor = new Color(130, 165, 50, 50);
        params.flashCoreColor = new Color(130, 165, 50, 127);
        params.flashCoreRadiusMult = 0.0f;
        params.renderFlashOnSameLayer = true;
        params.flashRadius = 40.0f;
        params.preFlashDelay = 0.5f * (float)Math.random();
        params.flashFrequency = 40.0f;
        params.flashProbability = 1.0f;
    }

    @Override
    protected int getNumOtherMembersToTransfer() {
        return 5;
    }

    @Override
    protected int getNumOtherMembersToAdd() {
        return 0;
    }

    @Override
    protected int getEMPResistance() {
        return 1;
    }

    @Override
    protected boolean explodeOnFizzling() {
        return false;
    }

    @Override
    protected BaseFragmentMissileEffect.FragmentBehaviorOnImpact getOtherFragmentBehaviorOnImpact() {
        return BaseFragmentMissileEffect.FragmentBehaviorOnImpact.STOP_AND_FADE;
    }

    @Override
    protected void reportFragmentHit(MissileAPI missile, RoilingSwarmEffect.SwarmMember p, RoilingSwarmEffect swarm, CombatEntityAPI target) {
        CombatEngineAPI engine = Global.getCombatEngine();
        Color color = swarm.params.flashFringeColor;
        color = Misc.setAlpha(color, 255);
        float size = swarm.params.flashRadius * 2.0f;
        engine.addHitParticle(p.loc, new Vector2f(), size, 0.5f, color);
        engine.addHitParticle(p.loc, new Vector2f(), size * 0.25f, 1.0f, Color.white);
    }

    @Override
    public void onHit(final DamagingProjectileAPI projectile, CombatEntityAPI target, Vector2f point, boolean shieldHit, ApplyDamageResultAPI damageResult, CombatEngineAPI engine) {
        if (shieldHit) {
            return;
        }
        if (projectile.getDamageAmount() <= 0.0f) {
            return;
        }
        if (!(target instanceof ShipAPI)) {
            return;
        }
        final ShipAPI source = projectile.getSource();
        final RoilingSwarmEffect sourceSwarm = RoilingSwarmEffect.getSwarmFor(source);
        Vector2f offset = Vector2f.sub((Vector2f)point, (Vector2f)target.getLocation(), (Vector2f)new Vector2f());
        offset = Misc.rotateAroundOrigin(offset, -target.getFacing());
        DisintegratorEffect effect = new DisintegratorEffect(projectile, (ShipAPI)target, offset){

            @Override
            protected float getTotalDamage() {
                return projectile.getDamageAmount();
            }

            @Override
            protected int getNumTicks() {
                return NUM_TICKS;
            }

            @Override
            protected boolean canDamageHull() {
                return true;
            }

            @Override
            protected int getNumParticlesPerTick() {
                return 5;
            }

            @Override
            protected String getSoundLoopId() {
                return "devouring_swarm_loop";
            }

            @Override
            protected void addParticle() {
                DisintegratorEffect.ParticleData p = new DisintegratorEffect.ParticleData(25.0f, 3.0f + (float)Math.random() * 2.0f, 1.0f);
                p.color = new Color(125, 100, 200, 25);
                this.particles.add(p);
                p.offset = Misc.getPointWithinRadius(p.offset, 10.0f);
            }

            @Override
            protected void damageDealt(Vector2f loc, float hullDamage, float armorDamage) {
                if (sourceSwarm == null || source == null || !source.isAlive()) {
                    return;
                }
                if (source.isFighter()) {
                    return;
                }
                if ((float)Math.random() < 0.25f) {
                    return;
                }
                if (hullDamage > 0.0f || armorDamage > 0.0f) {
                    RoilingSwarmEffect.SwarmMember p = sourceSwarm.addMember();
                    p.loc.set((ReadableVector2f)loc);
                    p.fader.setDurationIn(0.3f);
                }
            }
        };
        CombatEntityAPI e = engine.addLayeredRenderingPlugin(effect);
        e.getLocation().set((ReadableVector2f)projectile.getLocation());
        if (projectile instanceof MissileAPI) {
            MissileAPI missile = (MissileAPI)projectile;
            missile.setDidDamage(true);
            Global.getSoundPlayer().playSound("devouring_swarm_hit_ship", 1.0f, 1.0f, point, missile.getVelocity());
        }
    }

    @Override
    protected boolean withEMPArc() {
        return super.withEMPArc();
    }

    @Override
    protected Color getEMPFringeColor() {
        Color c = this.weapon.getSpec().getGlowColor();
        c = Misc.scaleColorOnly(c, 0.5f);
        return c;
    }

    @Override
    protected Color getEMPCoreColor() {
        Color c = Color.white;
        c = Misc.scaleColorOnly(c, 0.5f);
        return c;
    }

    public static class DismantlingFragmentBaseDamageNegator
    implements DamageDealtModifier {
        @Override
        public String modifyDamageDealt(Object param, CombatEntityAPI target, DamageAPI damage, Vector2f point, boolean shieldHit) {
            MissileAPI missile;
            RoilingSwarmEffect swarm;
            if (shieldHit) {
                return null;
            }
            if (param instanceof MissileAPI && (swarm = RoilingSwarmEffect.getSwarmFor(missile = (MissileAPI)param)) != null && swarm.params.tags.contains(DISMANTLING_SWARM)) {
                damage.getModifier().modifyMult(DISMANTLING_SWARM, 0.0f);
                return DISMANTLING_SWARM;
            }
            return null;
        }
    }
}

