/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.threat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseCombatLayeredRenderingPlugin;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.ListMap;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class RoilingSwarmEffect
extends BaseCombatLayeredRenderingPlugin {
    public static String KEY_SHIP_MAP = "RoilingSwarmEffect_shipMap_key";
    public static String KEY_FLOCKING_MAP = "RoilingSwarmEffect_flockingMap_key";
    public static String KEY_EXCHANGE_MAP = "RoilingSwarmEffect_exchangeMap_key";
    protected RoilingSwarmParams params;
    protected List<SwarmMember> members = new ArrayList<SwarmMember>();
    protected CombatEntityAPI attachedTo;
    protected float elapsed = 0.0f;
    protected IntervalUtil flashChecker;
    protected IntervalUtil respawnChecker;
    protected IntervalUtil transferChecker;
    protected boolean spawnedInitial = false;
    protected boolean despawning = false;
    protected boolean forceDespawn = false;
    protected float sinceExchange = 0.0f;
    protected float maxDistFromCenterToFragment = 0.0f;
    public Object custom1;
    public Object custom2;
    public Object custom3;
    protected EnumSet<CombatEngineLayers> layers = EnumSet.of(CombatEngineLayers.FIGHTERS_LAYER, CombatEngineLayers.ABOVE_PARTICLES_LOWER);

    public static RoilingSwarmEffect getSwarmFor(CombatEntityAPI entity) {
        if (entity == null) {
            return null;
        }
        return RoilingSwarmEffect.getShipMap().get(entity);
    }

    public static LinkedHashMap<CombatEntityAPI, RoilingSwarmEffect> getShipMap() {
        LinkedHashMap map = (LinkedHashMap)Global.getCombatEngine().getCustomData().get(KEY_SHIP_MAP);
        if (map == null) {
            map = new LinkedHashMap();
            Global.getCombatEngine().getCustomData().put(KEY_SHIP_MAP, map);
        }
        return map;
    }

    public static ListMap<RoilingSwarmEffect> getFlockingMap() {
        return RoilingSwarmEffect.getStringToSwarmMap(KEY_FLOCKING_MAP);
    }

    public static ListMap<RoilingSwarmEffect> getExchangeMap() {
        return RoilingSwarmEffect.getStringToSwarmMap(KEY_EXCHANGE_MAP);
    }

    public static ListMap<RoilingSwarmEffect> getStringToSwarmMap(String key) {
        ListMap map = (ListMap)Global.getCombatEngine().getCustomData().get(key);
        if (map == null) {
            map = new ListMap();
            Global.getCombatEngine().getCustomData().put(key, map);
        }
        return map;
    }

    public RoilingSwarmEffect(CombatEntityAPI attachedTo) {
        this(attachedTo, new RoilingSwarmParams());
    }

    public RoilingSwarmEffect(CombatEntityAPI attachedTo, RoilingSwarmParams params) {
        CombatEntityAPI e = Global.getCombatEngine().addLayeredRenderingPlugin(this);
        e.getLocation().set((ReadableVector2f)attachedTo.getLocation());
        this.attachedTo = attachedTo;
        this.params = params;
        this.flashChecker = new IntervalUtil(0.5f, 1.5f);
        this.respawnChecker = new IntervalUtil(0.5f, 1.5f);
        this.transferChecker = new IntervalUtil(0.2f, 1.8f);
        RoilingSwarmEffect.getShipMap().put(attachedTo, this);
        if (params.flockingClass != null) {
            RoilingSwarmEffect.getFlockingMap().add(params.flockingClass, this);
        }
        if (params.memberExchangeClass != null) {
            RoilingSwarmEffect.getExchangeMap().add(params.memberExchangeClass, this);
        }
    }

    @Override
    public void init(CombatEntityAPI entity) {
        super.init(entity);
    }

    @Override
    public float getRenderRadius() {
        float extra = 0.0f;
        if (this.sinceExchange < 3.0f) {
            extra = 500.0f - this.sinceExchange * 100.0f;
        }
        extra = Math.max(extra, this.maxDistFromCenterToFragment);
        return this.params.visibleRange + extra;
    }

    @Override
    public EnumSet<CombatEngineLayers> getActiveLayers() {
        return this.layers;
    }

    public SwarmMember addMember() {
        SwarmMember sm = new SwarmMember(this.attachedTo.getLocation(), this.params, this.attachedTo);
        this.addMember(sm);
        return sm;
    }

    public void addMember(SwarmMember sm) {
        this.members.add(sm);
    }

    public void removeMember(SwarmMember sm) {
        this.members.remove(sm);
    }

    public void addMembers(int num) {
        int i = 0;
        while (i < num) {
            this.addMember();
            ++i;
        }
    }

    public void transferMembersTo(RoilingSwarmEffect other, float fraction) {
        int num = (int)((float)this.members.size() * fraction);
        this.transferMembersTo(other, num);
    }

    public void transferMembersTo(RoilingSwarmEffect other, int num) {
        this.transferMembersTo(other, num, null, 0.0f);
    }

    public void transferMembersTo(RoilingSwarmEffect other, int num, Vector2f point, float maxRangeFromPoint) {
        if (num <= 0) {
            return;
        }
        WeightedRandomPicker<SwarmMember> picker = this.getPicker(true, true);
        if (point != null) {
            picker = this.getPicker(true, true, point, maxRangeFromPoint);
        }
        int i = 0;
        while (i < num) {
            SwarmMember pick = picker.pickAndRemove();
            if (pick == null) break;
            this.removeMember(pick);
            other.addMember(pick);
            pick.rollOffset(other.params, other.attachedTo);
            ++i;
        }
    }

    public void despawnMembers(int num) {
        this.despawnMembers(num, true);
    }

    public void despawnMembers(int num, boolean allowFirst) {
        WeightedRandomPicker<SwarmMember> picker = this.getPicker(false, false);
        if (!allowFirst && !this.members.isEmpty()) {
            picker.remove(this.members.get(0));
        }
        int i = 0;
        while (i < num) {
            SwarmMember pick = picker.pickAndRemove();
            if (pick == null) break;
            pick.fader.fadeOut();
            ++i;
        }
    }

    public SwarmMember pick(float pickDuration) {
        SwarmMember pick = this.getPicker(true, true).pick();
        if (pick != null) {
            pick.setRecentlyPicked(pickDuration);
        }
        return pick;
    }

    public WeightedRandomPicker<SwarmMember> getPicker(boolean preferNonFlashing, boolean preferNonPicked, Vector2f towards) {
        WeightedRandomPicker<SwarmMember> picker = new WeightedRandomPicker<SwarmMember>();
        float angle = Misc.getAngleInDegrees(this.attachedTo.getLocation(), towards);
        for (SwarmMember p : this.members) {
            float curr;
            float diff;
            if (p.fader.isFadingOut() || p.fader.isFadedOut()) continue;
            float w = 1000.0f;
            if (preferNonFlashing && p.flash != null) {
                w *= 0.001f;
            }
            if (preferNonPicked && p.recentlyPicked > 0.0f) {
                w *= 0.001f;
            }
            if ((diff = Misc.getAngleDiff(angle, curr = Misc.getAngleInDegrees(this.attachedTo.getLocation(), p.loc))) > 90.0f) {
                float f = Misc.normalizeAngle(diff - 90.0f) / 90.0f;
                if (f > 0.9999f) {
                    f = 0.9999f;
                }
                w *= 1.0f - f;
                w *= 0.05f;
            }
            picker.add(p, w);
        }
        return picker;
    }

    public WeightedRandomPicker<SwarmMember> getPicker(boolean preferNonFlashing, boolean preferNonPicked, Vector2f point, float preferMaxRangeFromPoint) {
        WeightedRandomPicker<SwarmMember> picker = new WeightedRandomPicker<SwarmMember>();
        for (SwarmMember p : this.members) {
            float dist;
            if (p.fader.isFadingOut() || p.fader.isFadedOut()) continue;
            float w = 1000.0f;
            if (preferNonFlashing && p.flash != null) {
                w *= 0.001f;
            }
            if (preferNonPicked && p.recentlyPicked > 0.0f) {
                w *= 0.001f;
            }
            if ((dist = Misc.getDistance(point, p.loc)) > preferMaxRangeFromPoint) {
                float f = (dist - preferMaxRangeFromPoint) / Math.max(1.0f, preferMaxRangeFromPoint);
                if (f > 0.9999f) {
                    f = 0.9999f;
                }
                w *= 1.0f - f;
            } else {
                w *= 0.25f + 0.75f * (1.0f - dist / Math.max(1.0f, preferMaxRangeFromPoint));
            }
            picker.add(p, w);
        }
        return picker;
    }

    public WeightedRandomPicker<SwarmMember> getPicker(boolean preferNonFlashing, boolean preferNonPicked) {
        WeightedRandomPicker<SwarmMember> picker = new WeightedRandomPicker<SwarmMember>();
        for (SwarmMember p : this.members) {
            if (p.fader.isFadingOut() || p.fader.isFadedOut()) continue;
            float w = 1000.0f;
            if (preferNonFlashing && p.flash != null) {
                w *= 0.001f;
            }
            if (preferNonPicked && p.recentlyPicked > 0.0f) {
                w *= 0.001f;
            }
            picker.add(p, w);
        }
        return picker;
    }

    public int getNumActiveMembers() {
        return this.getPicker(false, false).getItems().size();
    }

    public float getGlowForMember(SwarmMember p) {
        float glow = 0.0f;
        if (p.flash != null) {
            glow = p.flash.getBrightness();
            glow *= glow;
        }
        return glow;
    }

    public int getNumMembersToMaintain() {
        return this.params.baseMembersToMaintain;
    }

    @Override
    public void advance(float amount) {
        float minMaxSpeed;
        if (Global.getCombatEngine().isPaused() || this.entity == null || this.isExpired()) {
            return;
        }
        if (!this.spawnedInitial && this.params.withInitialMembers) {
            float origSpawnOffsetMult = this.params.spawnOffsetMult;
            if (this.params.spawnOffsetMultForInitialSpawn >= 0.0f) {
                this.params.spawnOffsetMult = this.params.spawnOffsetMultForInitialSpawn;
            }
            this.addMembers(this.params.initialMembers - this.getNumActiveMembers());
            this.params.spawnOffsetMult = origSpawnOffsetMult;
            this.spawnedInitial = true;
        }
        this.entity.getLocation().set((ReadableVector2f)this.attachedTo.getLocation());
        this.elapsed += amount;
        Vector2f aVel = this.attachedTo.getVelocity();
        float aSpeed = aVel.length();
        float leadAmount = aSpeed * this.params.swarmLeadsByFractionOfVelocity;
        Vector2f facingDir = Misc.getUnitVectorAtDegreeAngle(this.attachedTo.getFacing());
        if (this.attachedTo.getVelocity().length() > 1.0f) {
            facingDir = Misc.normalise(new Vector2f((ReadableVector2f)this.attachedTo.getVelocity()));
        }
        Vector2f aLoc = new Vector2f((ReadableVector2f)this.attachedTo.getLocation());
        ArrayList<SwarmMember> remove = new ArrayList<SwarmMember>();
        float maxSpeed = this.params.maxSpeed;
        if (this.params.outspeedAttachedEntityBy != 0.0f && (minMaxSpeed = this.attachedTo.getVelocity().length() + this.params.outspeedAttachedEntityBy) > maxSpeed) {
            maxSpeed = minMaxSpeed;
        }
        boolean despawnAll = this.shouldDespawnAll();
        float maxOffsetForProx = this.params.maxOffset;
        if (this.params.generateOffsetAroundAttachedEntityOval) {
            maxOffsetForProx += this.attachedTo.getCollisionRadius() * 0.75f;
        }
        float maxDistSq = 0.0f;
        this.maxDistFromCenterToFragment = 0.0f;
        for (SwarmMember p : this.members) {
            float distSq = (aLoc.x - p.loc.x) * (aLoc.x - p.loc.x) + (aLoc.y - p.loc.y) * (aLoc.y - p.loc.y);
            maxDistSq = Math.max(maxDistSq, distSq);
            if (this.params.despawnDist > 0.0f && this.params.despawnDist * this.params.despawnDist < distSq) {
                p.fader.fadeOut();
            }
            if (!despawnAll) {
                float speed;
                float lateralSpeed;
                Vector2f frictionDec;
                float relSpeed;
                Vector2f offset = new Vector2f((ReadableVector2f)p.offset);
                float prox = offset.length() / maxOffsetForProx;
                prox = 1.0f - prox;
                offset = Misc.rotateAroundOrigin(offset, this.attachedTo.getFacing() + this.elapsed * this.params.offsetRotationDegreesPerSecond);
                offset.x += facingDir.x * leadAmount;
                offset.y += facingDir.y * leadAmount;
                if (!this.params.keepProxBasedScaleForAllMembers) {
                    p.scale = this.params.baseScale + (1.0f - prox) * this.params.scaleRange;
                    if (p.scale > 1.0f) {
                        p.scale = 1.0f;
                    }
                }
                Vector2f dest = new Vector2f((ReadableVector2f)aLoc);
                Vector2f.add((Vector2f)dest, (Vector2f)offset, (Vector2f)dest);
                float dist = Misc.getDistance(p.loc, dest);
                Vector2f dirToDest = Misc.getUnitVector(p.loc, dest);
                Vector2f perp = new Vector2f(-dirToDest.y, dirToDest.x);
                float friction = this.params.baseFriction + this.params.frictionRange * prox;
                float k = this.params.baseSpringConstant - this.params.springConstantNegativeRange * prox;
                float freeLength = this.params.baseSpringFreeLength + this.params.springFreeLengthRange * prox;
                float stretch = dist - freeLength;
                stretch = (float)(Math.sqrt(Math.abs(stretch * this.params.springStretchMult)) * (double)Math.signum(stretch));
                float forceMag = k * Math.abs(stretch);
                if (stretch < 0.0f) {
                    forceMag = 0.0f;
                }
                float forceMagReduction = Math.min(Math.abs(forceMag), friction);
                friction -= forceMagReduction;
                Vector2f force = new Vector2f((ReadableVector2f)dirToDest);
                force.scale((forceMag -= forceMagReduction) * Math.signum(stretch));
                Vector2f acc = new Vector2f((ReadableVector2f)force);
                acc.scale(amount);
                Vector2f.add((Vector2f)p.vel, (Vector2f)acc, (Vector2f)p.vel);
                if (friction > 0.0f && (relSpeed = Vector2f.sub((Vector2f)aVel, (Vector2f)p.vel, (Vector2f)new Vector2f()).length()) > this.params.minSpeedForFriction) {
                    frictionDec = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(p.vel));
                    frictionDec.negate();
                    frictionDec.scale(Math.min(friction, p.vel.length()) * amount);
                    Vector2f.add((Vector2f)p.vel, (Vector2f)frictionDec, (Vector2f)p.vel);
                }
                if ((lateralSpeed = Math.abs(Vector2f.dot((Vector2f)p.vel, (Vector2f)perp))) > 0.0f) {
                    frictionDec = new Vector2f((ReadableVector2f)perp);
                    if (Vector2f.dot((Vector2f)frictionDec, (Vector2f)p.vel) > 0.0f) {
                        frictionDec.negate();
                    }
                    float lateralFactor = this.params.lateralFrictionFactor;
                    float lateralFriction = lateralSpeed * (lateralFactor += Math.min(Math.abs(this.attachedTo.getAngularVelocity()), 100.0f) * this.params.lateralFrictionTurnRateFactor);
                    frictionDec.scale(Math.min(lateralFriction, p.vel.length()) * amount);
                    Vector2f.add((Vector2f)p.vel, (Vector2f)frictionDec, (Vector2f)p.vel);
                }
                if ((speed = p.vel.length()) > maxSpeed) {
                    p.vel.scale(maxSpeed / speed);
                }
            }
            p.advance(amount, this.params);
            if (despawnAll && !p.fader.isFadingOut() && !p.fader.isFadedOut()) {
                p.fader.setDurationOut(this.params.minDespawnTime + (this.params.maxDespawnTime - this.params.minDespawnTime) * (float)Math.random());
                p.fader.fadeOut();
            }
            if (!p.fader.isFadedOut()) continue;
            remove.add(p);
        }
        this.maxDistFromCenterToFragment = (float)Math.sqrt(maxDistSq);
        this.members.removeAll(remove);
        if (despawnAll && !this.despawning && this.params.despawnSound != null) {
            Global.getSoundPlayer().playSound(this.params.despawnSound, 1.0f, 1.0f, this.entity.getLocation(), aVel);
            this.despawning = true;
        }
        if (!(this.isExpired() || despawnAll || this.despawning)) {
            this.exchangeWithNearbySwarms(amount);
        }
        if (!despawnAll) {
            this.respawnChecker.advance(amount * this.params.memberRespawnRate);
            if (this.respawnChecker.intervalElapsed() && this.params.withRespawn) {
                int num = this.getNumMembersToMaintain();
                if (this.members.size() < num) {
                    int add = Math.min(this.params.numToRespawn, num - this.members.size());
                    this.addMembers(add);
                    if (this.params.offsetRerollFractionOnMemberRespawn > 0.0f) {
                        int reroll = Math.round(this.params.offsetRerollFractionOnMemberRespawn * (float)this.members.size());
                        if (reroll < 1) {
                            reroll = 1;
                        }
                        WeightedRandomPicker<SwarmMember> picker = this.getPicker(true, false);
                        int i = 0;
                        while (i < reroll) {
                            SwarmMember pick = picker.pickAndRemove();
                            if (pick != null) {
                                pick.rollOffset(this.params, this.attachedTo);
                                ++i;
                                continue;
                            }
                            break;
                        }
                    }
                } else if (this.members.size() > num && this.params.removeMembersAboveMaintainLevel) {
                    this.despawnMembers(1);
                } else if (this.params.maxNumMembersToAlwaysRemoveAbove >= 0 && this.members.size() > this.params.maxNumMembersToAlwaysRemoveAbove) {
                    int extra = this.members.size() - this.params.maxNumMembersToAlwaysRemoveAbove;
                    int numRemove = (int)Math.min((float)extra * 0.1f, 5.0f);
                    if (numRemove < 1) {
                        numRemove = 1;
                    }
                    this.despawnMembers(numRemove);
                }
            }
            this.flashChecker.advance(amount * this.params.flashFrequency);
            this.params.preFlashDelay -= amount;
            if (this.params.preFlashDelay < 0.0f) {
                this.params.preFlashDelay = 0.0f;
            }
            if (this.flashChecker.intervalElapsed() && this.params.preFlashDelay <= 0.0f && this.params.flashProbability > 0.0f) {
                WeightedRandomPicker<SwarmMember> notFlashing = new WeightedRandomPicker<SwarmMember>();
                for (SwarmMember p : this.members) {
                    if (p.flash != null) continue;
                    notFlashing.add(p);
                }
                int i = 0;
                while (i < this.params.numToFlash) {
                    SwarmMember pick;
                    if ((float)Math.random() < this.params.flashProbability && (pick = (SwarmMember)notFlashing.pickAndRemove()) != null) {
                        pick.flash();
                    }
                    ++i;
                }
            }
        }
        this.sinceExchange += amount;
    }

    public void exchangeWithNearbySwarms(float amount) {
        RoilingSwarmEffect other2;
        if (this.params.memberExchangeClass == null || this.params.memberExchangeRange <= 0.0f) {
            return;
        }
        this.transferChecker.advance(amount * this.params.memberExchangeRate);
        if (!this.transferChecker.intervalElapsed()) {
            return;
        }
        WeightedRandomPicker<RoilingSwarmEffect> swarmPicker = new WeightedRandomPicker<RoilingSwarmEffect>();
        for (RoilingSwarmEffect other2 : RoilingSwarmEffect.getExchangeMap().getList(this.params.memberExchangeClass)) {
            float dist;
            if (other2 == this || other2.getEntity() == null || other2.despawning || other2.attachedTo == null || this.attachedTo == null || other2.attachedTo.getOwner() != this.attachedTo.getOwner() || other2.params.memberExchangeClass == null || !other2.params.memberExchangeClass.equals(this.params.memberExchangeClass) || (dist = Misc.getDistance(this.entity.getLocation(), other2.getEntity().getLocation())) > this.params.memberExchangeRange) continue;
            swarmPicker.add(other2);
        }
        other2 = (RoilingSwarmEffect)swarmPicker.pick();
        if (other2 == null) {
            return;
        }
        int num = this.params.minMembersToExchange + Misc.random.nextInt(this.params.maxMembersToExchange - this.params.minMembersToExchange + 1);
        WeightedRandomPicker<SwarmMember> picker = this.getPicker(true, true);
        WeightedRandomPicker<SwarmMember> pickerOther = other2.getPicker(true, true);
        num = Math.min(num, picker.getItems().size());
        num = Math.min(num, pickerOther.getItems().size());
        int i = 0;
        while (i < num) {
            SwarmMember pick = picker.pickAndRemove();
            SwarmMember otherPick = pickerOther.pickAndRemove();
            if (pick == null || otherPick == null) break;
            this.removeMember(pick);
            other2.addMember(pick);
            pick.rollOffset(other2.params, other2.attachedTo);
            other2.removeMember(otherPick);
            this.addMember(otherPick);
            otherPick.rollOffset(this.params, this.attachedTo);
            this.sinceExchange = 0.0f;
            ++i;
        }
    }

    public boolean shouldDespawnAll() {
        if (this.forceDespawn) {
            return true;
        }
        if (this.attachedTo instanceof ShipAPI) {
            ShipAPI ship = (ShipAPI)this.attachedTo;
            return !Global.getCombatEngine().isShipAlive(ship);
        }
        if (this.attachedTo instanceof MissileAPI) {
            MissileAPI missile = (MissileAPI)this.attachedTo;
            return !Global.getCombatEngine().isMissileAlive(missile);
        }
        return this.attachedTo.isExpired() || !Global.getCombatEngine().isEntityInPlay(this.attachedTo);
    }

    @Override
    public boolean isExpired() {
        boolean expired;
        boolean bl = expired = this.shouldDespawnAll() && this.members.isEmpty();
        if (expired) {
            RoilingSwarmEffect.getShipMap().remove(this.attachedTo);
            RoilingSwarmEffect.getFlockingMap().remove(this.params.flockingClass, this);
            RoilingSwarmEffect.getExchangeMap().remove(this.params.memberExchangeClass, this);
        }
        return expired;
    }

    @Override
    public void render(CombatEngineLayers layer, ViewportAPI viewport) {
        Color color = this.params.color;
        float alphaMult = viewport.getAlphaMult();
        if (alphaMult <= 0.0f) {
            return;
        }
        alphaMult *= this.params.alphaMult;
        if (layer == CombatEngineLayers.FIGHTERS_LAYER) {
            if (!this.members.isEmpty()) {
                this.members.get((int)0).sprite.bindTexture();
            }
            for (SwarmMember p : this.members) {
                float size = this.params.baseSpriteSize;
                float b = p.fader.getBrightness();
                p.sprite.setAngle(p.angle);
                p.sprite.setSize(size *= p.scale * p.fader.getBrightness(), size);
                p.sprite.setAlphaMult(alphaMult * b * this.params.alphaMultBase);
                p.sprite.setColor(color);
                p.sprite.renderAtCenterNoBind(p.loc.x, p.loc.y);
                float glow = this.getGlowForMember(p);
                if (!(glow > 0.0f) || !(this.params.flashCoreRadiusMult <= 0.0f)) continue;
                p.sprite.setAlphaMult(alphaMult * b * glow * this.params.alphaMultFlash);
                p.sprite.setColor(this.params.flashCoreColor);
                p.sprite.setAdditiveBlend();
                p.sprite.renderAtCenter(p.loc.x, p.loc.y);
                p.sprite.setNormalBlend();
            }
        }
        if (layer == CombatEngineLayers.ABOVE_PARTICLES_LOWER && !this.params.renderFlashOnSameLayer || layer == CombatEngineLayers.FIGHTERS_LAYER && this.params.renderFlashOnSameLayer) {
            SpriteAPI glowSprite = Global.getSettings().getSprite("misc", "threat_swarm_glow");
            glowSprite.setAdditiveBlend();
            for (SwarmMember p : this.members) {
                float glow = this.getGlowForMember(p);
                if (!(glow > 0.0f)) continue;
                float size = this.params.flashRadius * (0.5f + 0.5f * glow) * 2.0f;
                size *= p.scale * p.fader.getBrightness();
                float b = p.fader.getBrightness();
                if (b > 0.0f && size > 0.0f) {
                    glowSprite.setSize(size, size);
                    glowSprite.setAlphaMult(alphaMult * b * glow * 0.5f * this.params.alphaMultFlash);
                    glowSprite.setColor(this.params.flashFringeColor);
                    glowSprite.renderAtCenter(p.loc.x, p.loc.y);
                }
                float memberSize = this.params.baseSpriteSize;
                memberSize *= p.scale;
                memberSize *= 2.0f;
                memberSize *= this.params.flashCoreRadiusMult;
                if (!(b > 0.0f) || !(memberSize > 0.0f)) continue;
                glowSprite.setSize(memberSize, memberSize);
                glowSprite.setAlphaMult(alphaMult * b * p.fader.getBrightness() * glow * 0.5f * this.params.alphaMultFlash);
                glowSprite.setColor(this.params.flashCoreColor);
                glowSprite.renderAtCenter(p.loc.x, p.loc.y);
            }
        }
    }

    public RoilingSwarmParams getParams() {
        return this.params;
    }

    public List<SwarmMember> getMembers() {
        return this.members;
    }

    public CombatEntityAPI getAttachedTo() {
        return this.attachedTo;
    }

    public boolean isDespawning() {
        return this.despawning;
    }

    public boolean isForceDespawn() {
        return this.forceDespawn;
    }

    public void setForceDespawn(boolean forceDespawn) {
        this.forceDespawn = forceDespawn;
    }

    public static class RoilingSwarmParams {
        public String spriteCat = "misc";
        public String spriteKey = "threat_swarm_pieces";
        public String despawnSound = "threat_swarm_destroyed";
        public String memberExchangeClass = null;
        public float memberExchangeRange = 500.0f;
        public int minMembersToExchange = 1;
        public int maxMembersToExchange = 3;
        public float memberExchangeRate = 0.1f;
        public String flockingClass = null;
        public float baseSpriteSize = 20.0f;
        public float baseDur = 100000.0f;
        public float durRange = 0.0f;
        public float despawnDist = 0.0f;
        public float baseScale = 0.5f;
        public float scaleRange = 0.5f;
        public float baseFriction = 100.0f;
        public float frictionRange = 500.0f;
        public float baseSpringConstant = 50.0f;
        public float springConstantNegativeRange = 20.0f;
        public float baseSpringFreeLength = 20.0f;
        public float springFreeLengthRange = 20.0f;
        public float offsetRotationDegreesPerSecond = 0.0f;
        public float lateralFrictionFactor = 20.0f;
        public float lateralFrictionTurnRateFactor = 0.0f;
        public float minSpeedForFriction = 25.0f;
        public float flashRateMult = 1.0f;
        public float flashRadius = 100.0f;
        public float flashCoreRadiusMult = 1.0f;
        public float flashFrequency = 1.0f;
        public int numToFlash = 1;
        public int numToRespawn = 1;
        public float preFlashDelay = 0.0f;
        public float flashProbability = 0.0f;
        public boolean renderFlashOnSameLayer = false;
        public Color flashFringeColor = new Color(255, 0, 0, 255);
        public Color flashCoreColor = Color.white;
        public float alphaMult = 1.0f;
        public float alphaMultBase = 1.0f;
        public float alphaMultFlash = 1.0f;
        public Color color = Color.white;
        public float minFadeoutTime = 1.0f;
        public float maxFadeoutTime = 1.0f;
        public float minDespawnTime = 2.0f;
        public float maxDespawnTime = 1.0f;
        public boolean autoscale = false;
        public float springStretchMult = 10.0f;
        public float swarmLeadsByFractionOfVelocity = 0.03f;
        public float outspeedAttachedEntityBy = 100.0f;
        public float visibleRange = 500.0f;
        public float maxTurnRate = 60.0f;
        public float spawnOffsetMult = 0.0f;
        public float spawnOffsetMultForInitialSpawn = -1.0f;
        public float maxSpeed = 500.0f;
        public float minOffset = 0.0f;
        public float maxOffset = 20.0f;
        public boolean generateOffsetAroundAttachedEntityOval = false;
        public SwarmMemberOffsetModifier offsetModifier = null;
        public boolean withInitialMembers = true;
        public boolean withRespawn = true;
        public int initialMembers = 50;
        public int baseMembersToMaintain = 50;
        public boolean removeMembersAboveMaintainLevel = true;
        public int maxNumMembersToAlwaysRemoveAbove = -1;
        public float memberRespawnRate = 1.0f;
        public float offsetRerollFractionOnMemberRespawn = 0.0f;
        public Set<String> tags = new LinkedHashSet<String>();
        public boolean keepProxBasedScaleForAllMembers = false;
    }

    public static class SwarmMember {
        public SpriteAPI sprite;
        public Vector2f offset = new Vector2f();
        public Vector2f loc = new Vector2f();
        public Vector2f vel = new Vector2f();
        public float scale = 1.0f;
        public float turnRate = 1.0f;
        public float angle = 1.0f;
        public float recentlyPicked = 0.0f;
        public float dur;
        public FaderUtil fader;
        public FaderUtil flash;
        public FaderUtil flashNext;
        public FaderUtil scaler;
        public float minScale;
        public boolean keepScale = false;

        public SwarmMember(Vector2f startingLoc, RoilingSwarmParams params, CombatEntityAPI attachedTo) {
            this.sprite = Global.getSettings().getSprite(params.spriteCat, params.spriteKey);
            float i = Misc.random.nextInt(4);
            float j = Misc.random.nextInt(4);
            this.sprite.setTexWidth(0.25f);
            this.sprite.setTexHeight(0.25f);
            this.sprite.setTexX(i * 0.25f);
            this.sprite.setTexY(j * 0.25f);
            this.sprite.setNormalBlend();
            this.angle = (float)Math.random() * 360.0f;
            this.rollOffset(params, attachedTo);
            Vector2f spawnOffset = new Vector2f((ReadableVector2f)this.offset);
            spawnOffset.scale(params.spawnOffsetMult);
            if (params.spawnOffsetMult != 0.0f) {
                spawnOffset = Misc.rotateAroundOrigin(spawnOffset, attachedTo.getFacing());
            }
            Vector2f.add((Vector2f)startingLoc, (Vector2f)spawnOffset, (Vector2f)this.loc);
            this.vel = Misc.getPointWithinRadius(new Vector2f(), params.maxSpeed * 0.25f);
            this.dur = params.baseDur + (float)Math.random() * params.durRange;
            this.scale = 1.0f;
            this.turnRate = Math.signum((float)Math.random() - 0.5f) * params.maxTurnRate * (float)Math.random();
            this.fader = new FaderUtil(0.0f, 0.5f + (float)Math.random() * 0.5f, params.minFadeoutTime + (params.maxFadeoutTime - params.minFadeoutTime) * (float)Math.random());
            this.fader.fadeIn();
            this.scaler = new FaderUtil(0.0f, 0.5f + (float)Math.random() * 0.5f, 0.5f + (float)Math.random() * 0.5f);
            this.scaler.setBounce(true, true);
            this.scaler.fadeIn();
        }

        public void rollOffset(RoilingSwarmParams params, CombatEntityAPI attachedTo) {
            if (params.generateOffsetAroundAttachedEntityOval && attachedTo instanceof ShipAPI) {
                ShipAPI ship = (ShipAPI)attachedTo;
                float angle = (float)Math.random() * 360.0f;
                Vector2f dir = Misc.getUnitVectorAtDegreeAngle(angle);
                Vector2f from = new Vector2f((ReadableVector2f)dir);
                from.scale(ship.getCollisionRadius() + 1000.0f);
                Vector2f.add((Vector2f)from, (Vector2f)ship.getLocation(), (Vector2f)from);
                float min = Misc.getTargetingRadius(from, ship, false);
                float max = min + params.maxOffset;
                float f = (min += params.minOffset) / Math.max(1.0f, max);
                f = Math.max(0.1f, f * 0.75f);
                float r = -1.0f;
                int i = 0;
                while (i < 10) {
                    float test = (float)Math.sqrt(Math.random());
                    if (test >= f) {
                        r = test;
                        break;
                    }
                    ++i;
                }
                if (r < 0.0f) {
                    r = f + (1.0f - f) * (float)Math.random();
                }
                dir.scale(max * r);
                this.offset = dir;
                this.offset = Misc.rotateAroundOrigin(this.offset, -attachedTo.getFacing());
            } else {
                this.offset = Misc.getPointWithinRadiusUniform(new Vector2f(), params.minOffset, params.maxOffset, Misc.random);
            }
            if (params.offsetModifier != null) {
                params.offsetModifier.modifyOffset(this);
            }
        }

        public void advance(float amount, RoilingSwarmParams params) {
            this.loc.x += this.vel.x * amount;
            this.loc.y += this.vel.y * amount;
            this.angle += this.turnRate * amount;
            this.dur -= amount;
            if (this.dur <= 0.0f) {
                this.fader.fadeOut();
            }
            this.recentlyPicked -= amount;
            if (this.recentlyPicked < 0.0f) {
                this.recentlyPicked = 0.0f;
            }
            this.fader.advance(amount);
            if (this.flash != null) {
                this.flash.advance(amount * params.flashRateMult);
                if (this.flash.isFadedOut()) {
                    this.flash = null;
                }
            }
            if (this.flash == null && this.flashNext != null) {
                this.flash = this.flashNext;
                this.flashNext = null;
            }
            if (params.autoscale && !this.keepScale) {
                this.scaler.advance(amount * 0.5f);
                this.scale = this.minScale + (1.0f - this.minScale) * this.scaler.getBrightness() * this.scaler.getBrightness();
            }
        }

        public void flash() {
            if (this.flash == null) {
                this.flash = new FaderUtil(0.0f, 0.25f, 1.0f);
                this.flash.setBounceDown(true);
                this.flash.fadeIn();
            }
        }

        public void flashNext() {
            this.flashNext = new FaderUtil(0.0f, 0.25f, 1.0f);
            this.flashNext.setBounceDown(true);
            this.flashNext.fadeIn();
        }

        public void setRecentlyPicked(float pickDuration) {
            this.recentlyPicked = Math.max(this.recentlyPicked, pickDuration);
        }
    }

    public static interface SwarmMemberOffsetModifier {
        public void modifyOffset(SwarmMember var1);
    }
}

