/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.plugins;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.loading.WeaponSlotAPI;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import java.util.List;
import java.util.Random;

public interface AutofitPlugin {
    public List<AutofitOption> getOptions();

    public void doFit(ShipVariantAPI var1, ShipVariantAPI var2, int var3, AutofitPluginDelegate var4);

    public float getRating(ShipVariantAPI var1, ShipVariantAPI var2, AutofitPluginDelegate var3);

    public int getCreditCost();

    public String getQuickActionText();

    public void doQuickAction(ShipVariantAPI var1, AutofitPluginDelegate var2);

    public String getQuickActionTooltip();

    public void autoAssignOfficers(CampaignFleetAPI var1);

    public boolean isQuickActionEnabled(ShipVariantAPI var1);

    public void setRandom(Random var1);

    public static class AutofitOption {
        public String id;
        public String text;
        public boolean checked;
        public String tooltip;

        public AutofitOption(String id, String text, boolean checked, String tooltip) {
            this.id = id;
            this.text = text;
            this.checked = checked;
            this.tooltip = tooltip;
        }
    }

    public static interface AutofitPluginDelegate {
        public void fitFighterInSlot(int var1, AvailableFighter var2, ShipVariantAPI var3);

        public void clearFighterSlot(int var1, ShipVariantAPI var2);

        public void fitWeaponInSlot(WeaponSlotAPI var1, AvailableWeapon var2, ShipVariantAPI var3);

        public void clearWeaponSlot(WeaponSlotAPI var1, ShipVariantAPI var2);

        public List<AvailableWeapon> getAvailableWeapons();

        public List<AvailableFighter> getAvailableFighters();

        public boolean isPriority(WeaponSpecAPI var1);

        public boolean isPriority(FighterWingSpecAPI var1);

        public List<String> getAvailableHullmods();

        public void syncUIWithVariant(ShipVariantAPI var1);

        public ShipAPI getShip();

        public FactionAPI getFaction();

        public boolean isAllowSlightRandomization();

        public boolean isPlayerCampaignRefit();

        public boolean canAddRemoveHullmodInPlayerCampaignRefit(String var1);

        public MarketAPI getMarket();

        public FleetMemberAPI getFleetMember();
    }

    public static interface AvailableFighter {
        public String getId();

        public FighterWingSpecAPI getWingSpec();

        public float getPrice();

        public CargoAPI getSource();

        public SubmarketAPI getSubmarket();

        public int getQuantity();

        public void setQuantity(int var1);
    }

    public static interface AvailableWeapon {
        public String getId();

        public WeaponSpecAPI getSpec();

        public float getPrice();

        public CargoAPI getSource();

        public SubmarketAPI getSubmarket();

        public int getQuantity();

        public void setQuantity(int var1);

        public float getOPCost(MutableCharacterStatsAPI var1, MutableShipStatsAPI var2);
    }
}

