/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.plugins;

import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.combat.DeployedFleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public interface SimulatorPlugin {
    public static final boolean ENABLE_OPTION_CHECKBOX_ICONS = true;
    public static final float DEFAULT_PAD_AFTER = 20.0f;

    public void applySettingsToFleetMembers(List<FleetMemberAPI> var1, SimCategoryData var2, Map<String, String> var3);

    public void applySettingsToDeployed(List<DeployedFleetMemberAPI> var1, Map<String, String> var2);

    public List<SimCategoryData> getCategories();

    public SimCategoryData getCustomCategory();

    public List<AdvancedSimOption> getSimOptions(SimCategoryData var1);

    public boolean showGroupDeploymentWidget(SimCategoryData var1);

    public SimUIStateData getUIStateData();

    public void loadUIStateData();

    public void saveUIStateData();

    public void addCustomOpponents(List<String> var1);

    public void removeCustomOpponents(List<String> var1);

    public void loadCustomOpponents();

    public void saveCustomOpponents();

    public List<String> generateSelection(SimCategoryData var1, int var2);

    public void reportPlayerBattleOccurred(CampaignFleetAPI var1, BattleAPI var2);

    public void appendToTooltip(TooltipMakerAPI var1, float var2, float var3, AdvancedSimOption var4, Object var5);

    public void resetToDefaults(boolean var1);

    public static interface AdvancedSimOption {
        public String getId();

        public float getPadAfter();
    }

    public static class SimCategoryData {
        public String id;
        public String name;
        public Color nameColor;
        public String iconName;
        public Object data;
        public boolean custom = false;
        public boolean nonFactionCategory = false;
        public FactionAPI faction;
        public List<String> variants;
        public int maxVariants;
    }

    public static class SimOptionCheckboxData
    implements AdvancedSimOption {
        public String id;
        public String text;
        public String tooltip;
        public boolean showOnOffState = true;
        public float padAfter = 20.0f;
        public boolean enabled = true;
        public String unmetReq = null;

        public SimOptionCheckboxData(String id, String text, String tooltip) {
            this.id = id;
            this.text = text;
            this.tooltip = tooltip;
        }

        public SimOptionCheckboxData(String id, String text, String tooltip, boolean enabled, String unmetReq) {
            this.id = id;
            this.text = text;
            this.tooltip = tooltip;
            this.enabled = enabled;
            this.unmetReq = unmetReq;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public float getPadAfter() {
            return this.padAfter;
        }
    }

    public static class SimOptionData {
        public String id;
        public String text;
        public String tooltip;
        public String iconKey = null;
        public boolean enabled = true;
        public String unmetReq = null;
        public float extraPad = 0.0f;

        public SimOptionData(String id, String text, String tooltip, String iconKey) {
            this.id = id;
            this.text = text;
            this.tooltip = tooltip;
            this.iconKey = iconKey;
        }

        public SimOptionData(String id, String text, String tooltip, boolean enabled, String unmetReq, String iconKey) {
            this.id = id;
            this.text = text;
            this.tooltip = tooltip;
            this.enabled = enabled;
            this.unmetReq = unmetReq;
            this.iconKey = iconKey;
        }
    }

    public static class SimOptionSelectorData
    implements AdvancedSimOption {
        public String id;
        public String text;
        public List<SimOptionData> options = new ArrayList<SimOptionData>();
        public boolean compact = true;
        public float padAfter = 20.0f;

        public SimOptionSelectorData(String id, String text, boolean compact) {
            this.id = id;
            this.text = text;
            this.compact = compact;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public float getPadAfter() {
            return this.padAfter;
        }
    }

    public static class SimUIStateData {
        public String selectedCategory = null;
        public boolean showAdvanced = false;
        public int groupSize;
        public Map<String, String> settings = new LinkedHashMap<String, String>();

        public void fromJSON(JSONObject json) {
            this.selectedCategory = json.optString("selected", null);
            this.showAdvanced = json.optBoolean("advanced", false);
            this.groupSize = json.optInt("groupSize", 0);
            this.settings = new LinkedHashMap<String, String>();
            JSONObject map = json.optJSONObject("settings");
            if (map != null) {
                String[] stringArray = JSONObject.getNames((JSONObject)map);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    String value = map.optString(id, null);
                    if (value != null) {
                        this.settings.put(id, value);
                    }
                    ++n2;
                }
            }
        }

        public JSONObject toJSON() throws JSONException {
            JSONObject json = new JSONObject();
            if (this.selectedCategory != null) {
                json.put("selected", (Object)this.selectedCategory);
            }
            json.put("advanced", this.showAdvanced);
            json.put("groupSize", this.groupSize);
            JSONObject map = new JSONObject();
            json.put("settings", (Object)map);
            for (String id : this.settings.keySet()) {
                map.put(id, (Object)this.settings.get(id));
            }
            return json;
        }
    }
}

