/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CustomEntitySpecAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.BaseCustomEntityPlugin;
import com.fs.starfarer.api.util.FlickerUtilV2;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class FusionLampEntityPlugin
extends BaseCustomEntityPlugin {
    public static Color GLOW_COLOR = new Color(255, 165, 100, 255);
    public static Color LIGHT_COLOR = new Color(255, 165, 100, 255);
    public static String VOLATILES_SHORTAGE_KEY = "$core_volatilesShortage";
    public static String GLOW_COLOR_KEY = "$core_lampGlowColor";
    public static String LIGHT_COLOR_KEY = "$core_lampLightColor";
    public static float GLOW_FREQUENCY = 0.2f;
    private transient SpriteAPI sprite;
    private transient SpriteAPI glow;
    protected float phase = 0.0f;
    protected FlickerUtilV2 flicker = new FlickerUtilV2();

    @Override
    public void init(SectorEntityToken entity, Object pluginParams) {
        super.init(entity, pluginParams);
        entity.setDetectionRangeDetailsOverrideMult(Float.valueOf(0.75f));
        this.readResolve();
    }

    Object readResolve() {
        this.glow = Global.getSettings().getSprite("campaignEntities", "fusion_lamp_glow");
        return this;
    }

    @Override
    public void advance(float amount) {
        this.phase += amount * GLOW_FREQUENCY;
        while (this.phase > 1.0f) {
            this.phase -= 1.0f;
        }
        this.flicker.advance(amount * 1.0f);
        SectorEntityToken focus = this.entity.getOrbitFocus();
        if (focus instanceof PlanetAPI) {
            PlanetAPI planet = (PlanetAPI)focus;
            float lightAlpha = this.getLightAlpha();
            lightAlpha *= this.entity.getSensorFaderBrightness();
            planet.setSecondLight(new Vector3f(this.entity.getLocation().x, this.entity.getLocation().y, this.entity.getCircularOrbitRadius() * 0.75f), Misc.scaleColor(this.getLightColor(), lightAlpha *= this.entity.getSensorContactFaderBrightness()));
        }
    }

    public float getFlickerBasedMult() {
        float shortage = this.entity.getMemoryWithoutUpdate().getFloat(VOLATILES_SHORTAGE_KEY);
        if ((shortage *= 0.33f) <= 0.0f) {
            return 1.0f;
        }
        float f = 1.0f - shortage * this.flicker.getBrightness();
        return f;
    }

    public float getGlowAlpha() {
        float glowAlpha = 0.0f;
        if (this.phase < 0.5f) {
            glowAlpha = this.phase * 2.0f;
        }
        if (this.phase >= 0.5f) {
            glowAlpha = 1.0f - (this.phase - 0.5f) * 2.0f;
        }
        glowAlpha = 0.75f + glowAlpha * 0.25f;
        if ((glowAlpha *= this.getFlickerBasedMult()) < 0.0f) {
            glowAlpha = 0.0f;
        }
        if (glowAlpha > 1.0f) {
            glowAlpha = 1.0f;
        }
        return glowAlpha;
    }

    public float getLightAlpha() {
        float lightAlpha = 0.0f;
        if (this.phase < 0.5f) {
            lightAlpha = this.phase * 2.0f;
        }
        if (this.phase >= 0.5f) {
            lightAlpha = 1.0f - (this.phase - 0.5f) * 2.0f;
        }
        lightAlpha = 0.5f + lightAlpha * 0.5f;
        if ((lightAlpha *= this.getFlickerBasedMult()) < 0.0f) {
            lightAlpha = 0.0f;
        }
        if (lightAlpha > 1.0f) {
            lightAlpha = 1.0f;
        }
        return lightAlpha;
    }

    public Color getGlowColor() {
        Color glowColor = GLOW_COLOR;
        if (this.entity.getMemoryWithoutUpdate().contains(GLOW_COLOR_KEY)) {
            glowColor = (Color)this.entity.getMemoryWithoutUpdate().get(GLOW_COLOR_KEY);
        }
        return glowColor;
    }

    public Color getLightColor() {
        Color lightColor = LIGHT_COLOR;
        if (this.entity.getMemoryWithoutUpdate().contains(LIGHT_COLOR_KEY)) {
            lightColor = (Color)this.entity.getMemoryWithoutUpdate().get(LIGHT_COLOR_KEY);
        }
        return lightColor;
    }

    public void setGlowColor(Color color) {
        this.entity.getMemoryWithoutUpdate().set(GLOW_COLOR_KEY, color);
    }

    public void setLightColor(Color color) {
        this.entity.getMemoryWithoutUpdate().set(LIGHT_COLOR_KEY, color);
    }

    @Override
    public float getRenderRange() {
        return this.entity.getRadius() + 1200.0f;
    }

    @Override
    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        float alphaMult = viewport.getAlphaMult();
        alphaMult *= this.entity.getSensorFaderBrightness();
        if ((alphaMult *= this.entity.getSensorContactFaderBrightness()) <= 0.0f) {
            return;
        }
        CustomEntitySpecAPI spec = this.entity.getCustomEntitySpec();
        if (spec == null) {
            return;
        }
        float w = spec.getSpriteWidth();
        float h = spec.getSpriteHeight();
        Vector2f loc = this.entity.getLocation();
        if (this.sprite != null) {
            this.sprite.setAngle(this.entity.getFacing() - 90.0f);
            this.sprite.setSize(w, h);
            this.sprite.setAlphaMult(alphaMult);
            this.sprite.setNormalBlend();
            this.sprite.renderAtCenter(loc.x, loc.y);
        }
        float glowAlpha = this.getGlowAlpha();
        float glowAngle1 = (this.phase * 1.3f % 1.0f - 0.5f) * 12.0f;
        float glowAngle2 = (this.phase * 1.9f % 1.0f - 0.5f) * 12.0f;
        this.glow.setColor(this.getGlowColor());
        w = 600.0f;
        h = 600.0f;
        this.glow.setSize(w, h);
        this.glow.setAlphaMult(alphaMult * glowAlpha * 0.5f);
        this.glow.setAdditiveBlend();
        this.glow.renderAtCenter(loc.x, loc.y);
        int i = 0;
        while (i < 5) {
            this.glow.setSize(w *= 0.3f, h *= 0.3f);
            this.glow.setAlphaMult(alphaMult * glowAlpha * 0.67f);
            this.glow.renderAtCenter(loc.x, loc.y);
            ++i;
        }
    }
}

