/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.List;

public class SmugglingScanScript
implements EveryFrameScript {
    public static final String SCAN_COMPLETE_KEY = "$smugglingScanComplete";
    public static final String MARKET_TIMEOUT_KEY = "$smugglingScanTimeout";
    private IntervalUtil interval = new IntervalUtil(0.1f, 0.3f);
    private float currDuration = 0.0f;
    private float currElapsed = 0.0f;
    private CampaignFleetAPI curr = null;

    @Override
    public void advance(float amount) {
        boolean doScan;
        float days = Global.getSector().getClock().convertToDays(amount);
        if (this.curr != null) {
            this.maintainOngoingScan(days);
            return;
        }
        this.interval.advance(days);
        if (!this.interval.intervalElapsed()) {
            return;
        }
        float MAX_RANGE_FROM_MARKET = 5000.0f;
        float MAX_RANGE_FROM_PLAYER = 2000.0f;
        final CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        if (player == null || player.isInHyperspace()) {
            return;
        }
        final MarketAPI market = Misc.findNearestLocalMarket(player, 5000.0f, new BaseEventPlugin.MarketFilter(){

            @Override
            public boolean acceptMarket(MarketAPI market) {
                if (market.hasCondition("free_market")) {
                    return false;
                }
                MemoryAPI mem = market.getMemoryWithoutUpdate();
                return !mem.contains(SmugglingScanScript.MARKET_TIMEOUT_KEY);
            }
        });
        if (market == null) {
            return;
        }
        if (!market.getFaction().getCustomBoolean("allowsTransponderOffTrade") && !player.isTransponderOn()) {
            return;
        }
        if (market.getFaction().isHostileTo(player.getFaction())) {
            return;
        }
        List<CampaignFleetAPI> patrols = Misc.findNearbyFleets(player, 2000.0f, new Misc.FleetFilter(){

            @Override
            public boolean accept(CampaignFleetAPI curr) {
                SectorEntityToken.VisibilityLevel vis;
                if (curr.getFaction() != market.getFaction()) {
                    return false;
                }
                if (curr.getFaction().isPlayerFaction()) {
                    return false;
                }
                if (curr.isHostileTo(player)) {
                    return false;
                }
                if (curr.isStationMode()) {
                    return false;
                }
                if (Misc.getSourceMarket(curr) != market) {
                    return false;
                }
                if (!curr.getMemoryWithoutUpdate().getBoolean("$isPatrol")) {
                    return false;
                }
                if (curr.getAI() instanceof ModularFleetAIAPI) {
                    ModularFleetAIAPI ai = (ModularFleetAIAPI)curr.getAI();
                    if (ai.isFleeing()) {
                        return false;
                    }
                    if (curr.getInteractionTarget() instanceof CampaignFleetAPI) {
                        return false;
                    }
                }
                return (vis = player.getVisibilityLevelTo(curr)) != SectorEntityToken.VisibilityLevel.NONE;
            }
        });
        if (patrols.isEmpty()) {
            return;
        }
        float minDist = Float.MAX_VALUE;
        CampaignFleetAPI closestPatrol = null;
        float closestSuspicion = 0.0f;
        for (CampaignFleetAPI curr : patrols) {
            float dist = Misc.getDistance(player.getLocation(), curr.getLocation());
            float extra = curr.getMemoryWithoutUpdate().getFloat("$patrolExtraSuspicion");
            if (!(dist < minDist) && !(extra > closestSuspicion)) continue;
            minDist = dist;
            closestSuspicion = extra;
            closestPatrol = curr;
        }
        if (closestPatrol == null) {
            return;
        }
        this.curr = closestPatrol;
        float threshold = 0.05f;
        MemoryAPI marketMemory = market.getMemory();
        float suspicionLevel = marketMemory.getFloat("$smugglingSuspicion");
        boolean bl = doScan = (float)Math.random() < (suspicionLevel += closestSuspicion) * 5.0f && suspicionLevel >= threshold;
        if (doScan) {
            this.currDuration = 10.0f + (float)Math.random() * 5.0f;
            this.currElapsed = 0.0f;
            MemoryAPI mem = this.curr.getMemoryWithoutUpdate();
            Misc.setFlagWithReason(mem, "$pursuePlayer", "smugglingScan", true, 1.0f);
            Misc.setFlagWithReason(mem, "$keepPursuingPlayer", "smugglingScan", true, this.currDuration);
        } else {
            this.curr = null;
        }
        if (suspicionLevel >= threshold) {
            float timeoutDuration = 20.0f + (float)Math.random() * 10.0f;
            marketMemory.set(MARKET_TIMEOUT_KEY, true, timeoutDuration);
        }
    }

    public void maintainOngoingScan(float days) {
        if (!this.curr.isAlive()) {
            this.cleanUpCurr();
            return;
        }
        if (this.curr.isHostileTo(Global.getSector().getPlayerFleet())) {
            this.cleanUpCurr();
            return;
        }
        this.currElapsed += days;
        if (this.currElapsed > this.currDuration) {
            this.cleanUpCurr();
            return;
        }
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        if (player.isInHyperspace() || player.isInHyperspaceTransition()) {
            this.cleanUpCurr();
            return;
        }
        SectorEntityToken.VisibilityLevel vis = player.getVisibilityLevelTo(this.curr);
        if (vis != SectorEntityToken.VisibilityLevel.NONE) {
            MemoryAPI mem = this.curr.getMemoryWithoutUpdate();
            if (mem.getBoolean(SCAN_COMPLETE_KEY)) {
                this.cleanUpCurr();
                return;
            }
            Misc.setFlagWithReason(mem, "$pursuePlayer", "smugglingScan", true, 1.0f);
        }
    }

    protected void cleanUpCurr() {
        if (this.curr != null) {
            ModularFleetAIAPI ai;
            CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
            FleetAssignmentDataAPI a = this.curr.getCurrentAssignment();
            if (a != null && a.getAssignment() == FleetAssignment.INTERCEPT && a.getTarget() == pf) {
                this.curr.removeFirstAssignmentIfItIs(a.getAssignment());
            }
            this.curr.setInteractionTarget(null);
            if (this.curr.getAI() instanceof ModularFleetAIAPI && (ai = (ModularFleetAIAPI)this.curr.getAI()).getTacticalModule().getTarget() == pf) {
                ai.getTacticalModule().setTarget(null);
            }
            MemoryAPI mem = this.curr.getMemoryWithoutUpdate();
            Misc.setFlagWithReason(mem, "$pursuePlayer", "smugglingScan", false, 0.0f);
            Misc.setFlagWithReason(mem, "$keepPursuingPlayer", "smugglingScan", false, 0.0f);
            mem.unset(SCAN_COMPLETE_KEY);
            this.curr = null;
            this.currElapsed = 0.0f;
            this.currDuration = 0.0f;
        }
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }
}

