/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionDoctrineAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.CommodityMarketDataAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketImmigrationModifier;
import com.fs.starfarer.api.campaign.listeners.ColonyOtherFactorsListener;
import com.fs.starfarer.api.characters.MarketConditionSpecAPI;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.impl.campaign.econ.CommRelayCondition;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.econ.impl.ConstructionQueue;
import com.fs.starfarer.api.impl.campaign.econ.impl.ItemEffectsRepo;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.intel.misc.HypershuntIntel;
import com.fs.starfarer.api.impl.campaign.population.PopulationComposition;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.loading.IndustrySpecAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Pair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.lwjgl.util.vector.Vector2f;

public class PopulationAndInfrastructure
extends BaseIndustry
implements MarketImmigrationModifier {
    public static float OFFICER_BASE_PROB = Global.getSettings().getFloat("officerBaseProb");
    public static float OFFICER_PROB_PER_SIZE = Global.getSettings().getFloat("officerProbPerColonySize");
    public static float OFFICER_ADDITIONAL_BASE_PROB = Global.getSettings().getFloat("officerAdditionalBaseProb");
    public static float OFFICER_BASE_MERC_PROB = Global.getSettings().getFloat("officerBaseMercProb");
    public static float ADMIN_BASE_PROB = Global.getSettings().getFloat("adminBaseProb");
    public static float ADMIN_PROB_PER_SIZE = Global.getSettings().getFloat("adminProbPerColonySize");
    public static float IMPROVE_STABILITY_BONUS = 1.0f;
    public static boolean HAZARD_INCREASES_DEFENSE = false;
    public static int[] MAX_IND = null;
    protected String addedHeatCondition = null;
    protected String removedHeatCondition = null;
    protected SectorEntityToken lamp;

    @Override
    public void apply() {
        float sizeBonus;
        PopulationAndInfrastructure.modifyStability(this, this.market, this.getModId(3));
        super.apply(true);
        int size = this.market.getSize();
        this.demand("food", size);
        if (!this.market.hasCondition("habitable")) {
            this.demand("organics", size - 1);
        }
        int luxuryThreshold = 3;
        this.demand("domestic_goods", size - 1);
        this.demand("luxury_goods", size - luxuryThreshold);
        this.demand("drugs", size - 2);
        this.demand("organs", size - 3);
        this.demand("supplies", Math.min(size, 3));
        this.supply("crew", size - 3);
        this.supply("drugs", size - 4);
        this.supply("organs", size - 5);
        Pair<String, Integer> deficit = this.getMaxDeficit("domestic_goods");
        if ((Integer)deficit.two <= 0) {
            this.market.getStability().modifyFlat(this.getModId(0), 1.0f, "Domestic goods demand met");
        } else {
            this.market.getStability().unmodifyFlat(this.getModId(0));
        }
        deficit = this.getMaxDeficit("luxury_goods");
        if ((Integer)deficit.two <= 0 && size > luxuryThreshold) {
            this.market.getStability().modifyFlat(this.getModId(1), 1.0f, "Luxury goods demand met");
        } else {
            this.market.getStability().unmodifyFlat(this.getModId(1));
        }
        deficit = this.getMaxDeficit("food");
        if (!this.market.hasCondition("habitable")) {
            deficit = this.getMaxDeficit("food", "organics");
        }
        if ((Integer)deficit.two > 0) {
            this.market.getStability().modifyFlat(this.getModId(2), -((Integer)deficit.two).intValue(), PopulationAndInfrastructure.getDeficitText((String)deficit.one));
        } else {
            this.market.getStability().unmodifyFlat(this.getModId(2));
        }
        boolean spaceportFirstInQueue = false;
        Iterator<ConstructionQueue.ConstructionQueueItem> iterator = this.market.getConstructionQueue().getItems().iterator();
        if (iterator.hasNext()) {
            ConstructionQueue.ConstructionQueueItem item = iterator.next();
            IndustrySpecAPI spec = Global.getSettings().getIndustrySpec(item.id);
            if (spec.hasTag("spaceport")) {
                spaceportFirstInQueue = true;
            }
        }
        if (spaceportFirstInQueue && Misc.getCurrentlyBeingConstructed(this.market) != null) {
            spaceportFirstInQueue = false;
        }
        if (!this.market.hasSpaceport() && !spaceportFirstInQueue) {
            float accessibilityNoSpaceport = Global.getSettings().getFloat("accessibilityNoSpaceport");
            this.market.getAccessibilityMod().modifyFlat(this.getModId(0), accessibilityNoSpaceport, "No spaceport");
        }
        if ((sizeBonus = PopulationAndInfrastructure.getAccessibilityBonus(size)) > 0.0f) {
            this.market.getAccessibilityMod().modifyFlat(this.getModId(1), sizeBonus, "Colony size");
        }
        float stability = this.market.getPrevStability();
        float stabilityQualityMod = FleetFactoryV3.getShipQualityModForStability(stability);
        float doctrineQualityMod = this.market.getFaction().getDoctrine().getShipQualityContribution();
        this.market.getStats().getDynamic().getMod("fleet_quality_mod").modifyFlatAlways(this.getModId(0), stabilityQualityMod, "Stability");
        this.market.getStats().getDynamic().getMod("fleet_quality_mod").modifyFlatAlways(this.getModId(1), doctrineQualityMod, String.valueOf(Misc.ucFirst(this.market.getFaction().getEntityNamePrefix())) + " fleet doctrine");
        float stabilityDefenseMult = 0.25f + stability / 10.0f * 0.75f;
        this.market.getStats().getDynamic().getMod("ground_defenses_mod").modifyMultAlways(this.getModId(), stabilityDefenseMult, "Stability");
        float baseDef = PopulationAndInfrastructure.getBaseGroundDefenses(this.market.getSize());
        this.market.getStats().getDynamic().getMod("ground_defenses_mod").modifyFlatAlways(this.getModId(), baseDef, "Base value for a size " + this.market.getSize() + " colony");
        if (HAZARD_INCREASES_DEFENSE) {
            this.market.getStats().getDynamic().getMod("ground_defenses_mod").modifyMultAlways(this.getModId(1), Math.max(this.market.getHazardValue(), 1.0f), "Colony hazard rating");
        }
        this.market.getStats().getDynamic().getMod("max_industries").modifyFlat(this.getModId(), this.getMaxIndustries(), null);
        FactionDoctrineAPI doctrine = this.market.getFaction().getDoctrine();
        float doctrineShipsMult = FleetFactoryV3.getDoctrineNumShipsMult(doctrine.getNumShips());
        float marketSizeShipsMult = FleetFactoryV3.getNumShipsMultForMarketSize(this.market.getSize());
        float deficitShipsMult = FleetFactoryV3.getShipDeficitFleetSizeMult(this.market);
        float stabilityShipsMult = FleetFactoryV3.getNumShipsMultForStability(stability);
        this.market.getStats().getDynamic().getMod("combat_fleet_size_mult").modifyFlatAlways(this.getModId(0), marketSizeShipsMult, "Colony size");
        this.market.getStats().getDynamic().getMod("combat_fleet_size_mult").modifyMultAlways(this.getModId(1), doctrineShipsMult, String.valueOf(Misc.ucFirst(this.market.getFaction().getEntityNamePrefix())) + " fleet doctrine");
        if (deficitShipsMult != 1.0f) {
            this.market.getStats().getDynamic().getMod("combat_fleet_size_mult").modifyMult(this.getModId(2), deficitShipsMult, PopulationAndInfrastructure.getDeficitText("ships"));
        } else {
            this.market.getStats().getDynamic().getMod("combat_fleet_size_mult").modifyMultAlways(this.getModId(2), deficitShipsMult, PopulationAndInfrastructure.getDeficitText("ships").replaceAll("shortage", "demand met"));
        }
        this.market.getStats().getDynamic().getMod("combat_fleet_size_mult").modifyMultAlways(this.getModId(3), stabilityShipsMult, "Stability");
        this.market.getStats().getDynamic().getMod("officer_prob").modifyFlat(this.getModId(0), OFFICER_BASE_PROB);
        this.market.getStats().getDynamic().getMod("officer_prob").modifyFlat(this.getModId(1), OFFICER_PROB_PER_SIZE * (float)Math.max(0, this.market.getSize() - 3));
        this.market.getStats().getDynamic().getMod("additional_officer_prob_mult").modifyFlat(this.getModId(0), OFFICER_ADDITIONAL_BASE_PROB);
        this.market.getStats().getDynamic().getMod("officer_is_merc_prob").modifyFlat(this.getModId(0), OFFICER_BASE_MERC_PROB);
        this.market.getStats().getDynamic().getMod("admin_prob").modifyFlat(this.getModId(0), ADMIN_BASE_PROB);
        this.market.getStats().getDynamic().getMod("admin_prob").modifyFlat(this.getModId(1), ADMIN_PROB_PER_SIZE * (float)Math.max(0, this.market.getSize() - 3));
        PopulationAndInfrastructure.modifyStability2(this, this.market, this.getModId(3));
        this.market.addTransientImmigrationModifier(this);
    }

    public static float getAccessibilityBonus(int marketSize) {
        if (marketSize <= 4) {
            return 0.0f;
        }
        if (marketSize == 5) {
            return 0.1f;
        }
        if (marketSize == 6) {
            return 0.15f;
        }
        if (marketSize == 7) {
            return 0.2f;
        }
        if (marketSize == 8) {
            return 0.25f;
        }
        return 0.3f;
    }

    public static float getBaseGroundDefenses(int marketSize) {
        if (marketSize <= 1) {
            return 10.0f;
        }
        if (marketSize <= 2) {
            return 20.0f;
        }
        if (marketSize <= 3) {
            return 50.0f;
        }
        return (marketSize - 3) * 100;
    }

    @Override
    public void unapply() {
        super.unapply();
        this.market.getStability().unmodify(this.getModId(0));
        this.market.getStability().unmodify(this.getModId(1));
        this.market.getStability().unmodify(this.getModId(2));
        this.market.getAccessibilityMod().unmodifyFlat(this.getModId(0));
        this.market.getAccessibilityMod().unmodifyFlat(this.getModId(1));
        this.market.getStats().getDynamic().getMod("fleet_quality_mod").unmodifyFlat(this.getModId(0));
        this.market.getStats().getDynamic().getMod("fleet_quality_mod").unmodifyFlat(this.getModId(1));
        this.market.getStats().getDynamic().getMod("ground_defenses_mod").unmodifyFlat(this.getModId());
        this.market.getStats().getDynamic().getMod("ground_defenses_mod").unmodifyMult(this.getModId());
        if (HAZARD_INCREASES_DEFENSE) {
            this.market.getStats().getDynamic().getMod("ground_defenses_mod").unmodifyMult(this.getModId(1));
        }
        this.market.getStats().getDynamic().getMod("max_industries").unmodifyFlat(this.getModId());
        this.market.getStats().getDynamic().getMod("combat_fleet_size_mult").unmodifyFlat(this.getModId(0));
        this.market.getStats().getDynamic().getMod("combat_fleet_size_mult").unmodifyMult(this.getModId(1));
        this.market.getStats().getDynamic().getMod("combat_fleet_size_mult").unmodifyMult(this.getModId(2));
        this.market.getStats().getDynamic().getMod("combat_fleet_size_mult").unmodifyMult(this.getModId(3));
        this.market.getStats().getDynamic().getMod("officer_prob").unmodifyFlat(this.getModId(0));
        this.market.getStats().getDynamic().getMod("officer_prob").unmodifyFlat(this.getModId(1));
        this.market.getStats().getDynamic().getMod("additional_officer_prob_mult").unmodifyFlat(this.getModId(0));
        this.market.getStats().getDynamic().getMod("officer_is_merc_prob").unmodifyFlat(this.getModId(0));
        this.market.getStats().getDynamic().getMod("admin_prob").unmodifyFlat(this.getModId(0));
        this.market.getStats().getDynamic().getMod("admin_prob").unmodifyFlat(this.getModId(1));
        PopulationAndInfrastructure.unmodifyStability(this.market, this.getModId(3));
        this.market.removeTransientImmigrationModifier(this);
    }

    @Override
    protected boolean hasPostDemandSection(boolean hasDemand, Industry.IndustryTooltipMode mode) {
        return true;
    }

    @Override
    protected void addPostDemandSection(TooltipMakerAPI tooltip, boolean hasDemand, Industry.IndustryTooltipMode mode) {
        if (mode != Industry.IndustryTooltipMode.NORMAL || this.isFunctional()) {
            MutableStat stabilityMods = new MutableStat(0.0f);
            float total = 0.0f;
            for (MutableStat.StatMod mod : this.market.getStability().getFlatMods().values()) {
                if (!mod.source.startsWith(this.getModId())) continue;
                stabilityMods.modifyFlat(mod.source, mod.value, mod.desc);
                total += mod.value;
            }
            String totalStr = "+" + Math.round(total);
            Color h = Misc.getHighlightColor();
            if (total < 0.0f) {
                totalStr = "" + Math.round(total);
                h = Misc.getNegativeHighlightColor();
            }
            float opad = 10.0f;
            float pad = 3.0f;
            if (total >= 0.0f) {
                tooltip.addPara("Stability bonus: %s", opad, h, totalStr);
            } else {
                tooltip.addPara("Stability penalty: %s", opad, h, totalStr);
            }
            tooltip.addStatModGrid(400.0f, 30.0f, opad, pad, stabilityMods, new TooltipMakerAPI.StatModValueGetter(){

                @Override
                public String getPercentValue(MutableStat.StatMod mod) {
                    return null;
                }

                @Override
                public String getMultValue(MutableStat.StatMod mod) {
                    return null;
                }

                @Override
                public Color getModColor(MutableStat.StatMod mod) {
                    if (mod.value < 0.0f) {
                        return Misc.getNegativeHighlightColor();
                    }
                    return null;
                }

                @Override
                public String getFlatValue(MutableStat.StatMod mod) {
                    return null;
                }
            });
        }
    }

    @Override
    public String getCurrentImage() {
        float size = this.market.getSize();
        if (size <= (float)SIZE_FOR_SMALL_IMAGE) {
            return Global.getSettings().getSpriteName("industry", "pop_low");
        }
        if (size >= (float)SIZE_FOR_LARGE_IMAGE) {
            return Global.getSettings().getSpriteName("industry", "pop_high");
        }
        return super.getCurrentImage();
    }

    public static float getIncomeStabilityMult(float stability) {
        if (stability <= 5.0f) {
            return Math.max(0.0f, stability / 5.0f);
        }
        return 1.0f;
    }

    public static float getUpkeepHazardMult(float hazard) {
        float hazardMult = hazard;
        float min = Global.getSettings().getFloat("minUpkeepMult");
        if (hazardMult < min) {
            hazardMult = min;
        }
        return hazardMult;
    }

    public static int getMismanagementPenalty() {
        int outposts = 0;
        for (MarketAPI curr : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!curr.isPlayerOwned() || !curr.getAdmin().isPlayer()) continue;
            ++outposts;
        }
        MutableCharacterStatsAPI stats = Global.getSector().getCharacterData().getPerson().getStats();
        int maxOutposts = stats.getOutpostNumber().getModifiedInt();
        int overOutposts = outposts - maxOutposts;
        int penaltyOrBonus = (int)((float)overOutposts * Misc.getOutpostPenalty());
        return penaltyOrBonus;
    }

    public static void modifyStability2(Industry industry, MarketAPI market, String modId) {
        if (Misc.getNumIndustries(market) > Misc.getMaxIndustries(market)) {
            market.getStability().modifyFlat("_" + modId + "_overmax", -Misc.OVER_MAX_INDUSTRIES_PENALTY, "Maximum number of industries exceeded");
        } else {
            market.getStability().unmodifyFlat("_" + modId + "_overmax");
        }
    }

    public static void modifyUpkeepByHazardRating(MarketAPI market, String modId) {
        market.getUpkeepMult().modifyMultAlways(modId, PopulationAndInfrastructure.getUpkeepHazardMult(market.getHazardValue()), "Hazard rating");
    }

    public static void modifyStability(Industry industry, MarketAPI market, String modId) {
        market.getIncomeMult().modifyMultAlways(modId, PopulationAndInfrastructure.getIncomeStabilityMult(market.getPrevStability()), "Stability");
        market.getStability().modifyFlat("_" + modId + "_ms", Global.getSettings().getFloat("stabilityBaseValue"), "Base value");
        float inFactionSupply = 0.0f;
        float totalDemand = 0.0f;
        for (CommodityOnMarketAPI com : market.getCommoditiesCopy()) {
            int d;
            if (com.isNonEcon() || (d = com.getMaxDemand()) <= 0) continue;
            totalDemand += (float)d;
            CommodityMarketDataAPI cmd = com.getCommodityMarketData();
            int inFaction = Math.max(Math.min(com.getMaxSupply(), com.getAvailable()), Math.min(cmd.getMaxShipping(market, true), cmd.getMaxExport(market.getFactionId())));
            if (inFaction > d) {
                inFaction = d;
            }
            if (inFaction < d) {
                inFaction = Math.max(Math.min(com.getMaxSupply(), com.getAvailable()), 0);
            }
            inFactionSupply += (float)Math.max(0, Math.min(inFaction, com.getAvailable()));
        }
        if (totalDemand > 0.0f) {
            float max = Global.getSettings().getFloat("upkeepReductionFromInFactionImports");
            float f = inFactionSupply / totalDemand;
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            if (f > 0.0f) {
                float mult = (float)Math.round(100.0f - f * max * 100.0f) / 100.0f;
                String desc = "Demand supplied in-faction (" + Math.round(f * 100.0f) + "%)";
                if (f == 1.0f) {
                    desc = "All demand supplied in-faction";
                }
                market.getUpkeepMult().modifyMultAlways(String.valueOf(modId) + "ifi", mult, desc);
            } else {
                market.getUpkeepMult().modifyMultAlways(String.valueOf(modId) + "ifi", 1.0f, "All demand supplied out-of-faction; no upkeep reduction");
            }
        }
        if (market.isPlayerOwned() && market.getAdmin().isPlayer()) {
            int penalty = PopulationAndInfrastructure.getMismanagementPenalty();
            if (penalty > 0) {
                market.getStability().modifyFlat("_" + modId + "_mm", -penalty, "Mismanagement penalty");
            } else if (penalty < 0) {
                market.getStability().modifyFlat("_" + modId + "_mm", -penalty, "Management bonus");
            } else {
                market.getStability().unmodifyFlat("_" + modId + "_mm");
            }
        } else {
            market.getStability().unmodifyFlat(String.valueOf(modId) + "_mm");
        }
        if (!market.hasCondition("comm_relay")) {
            market.getStability().modifyFlat(CommRelayCondition.COMM_RELAY_MOD_ID, CommRelayCondition.NO_RELAY_PENALTY, "No active comm relay in-system");
        }
    }

    public static void unmodifyStability(MarketAPI market, String modId) {
        market.getIncomeMult().unmodifyMult(modId);
        market.getUpkeepMult().unmodifyMult(modId);
        market.getUpkeepMult().unmodifyMult(String.valueOf(modId) + "ifi");
        market.getStability().unmodifyFlat(modId);
        market.getStability().unmodifyFlat("_" + modId + "_mm");
        market.getStability().unmodifyFlat("_" + modId + "_ms");
        market.getStability().unmodifyFlat("_" + modId + "_overmax");
        if (!market.hasCondition("comm_relay")) {
            market.getStability().unmodifyFlat(CommRelayCondition.COMM_RELAY_MOD_ID);
        }
    }

    @Override
    public boolean showShutDown() {
        return false;
    }

    @Override
    public String getCanNotShutDownReason() {
        return null;
    }

    @Override
    public boolean canShutDown() {
        return false;
    }

    @Override
    protected String getDescriptionOverride() {
        int size = this.market.getSize();
        String cid = null;
        if (size >= 1 && size <= 9) {
            cid = "population_" + size;
            MarketConditionSpecAPI mcs = Global.getSettings().getMarketConditionSpec(cid);
            if (mcs != null) {
                return String.valueOf(this.spec.getDesc()) + "\n\n" + mcs.getDesc().replaceAll("\\$marketName", this.market.getName());
            }
        }
        return super.getDescriptionOverride();
    }

    @Override
    public String getBuildOrUpgradeProgressText() {
        if (this.isUpgrading()) {
            return "total growth: " + Misc.getRoundedValue(Misc.getMarketSizeProgress(this.market) * 100.0f) + "%";
        }
        return super.getBuildOrUpgradeProgressText();
    }

    @Override
    public float getBuildOrUpgradeProgress() {
        if (!super.isBuilding() && this.market.getSize() < Misc.getMaxMarketSize(this.market)) {
            return Misc.getMarketSizeProgress(this.market);
        }
        return super.getBuildOrUpgradeProgress();
    }

    @Override
    public boolean isBuilding() {
        if (!super.isBuilding() && this.market.getSize() < Misc.getMaxMarketSize(this.market) && this.getBuildOrUpgradeProgress() > 0.0f) {
            return true;
        }
        return super.isBuilding();
    }

    @Override
    public boolean isUpgrading() {
        if (!super.isBuilding() && this.market.getSize() < Misc.getMaxMarketSize(this.market)) {
            return true;
        }
        return super.isUpgrading();
    }

    @Override
    public void modifyIncoming(MarketAPI market, PopulationComposition incoming) {
        float patherLevel = 0.0f;
        for (Industry curr : market.getIndustries()) {
            patherLevel += this.getAICoreImpact(curr.getAICoreId());
        }
        String adminCoreId = market.getAdmin().getAICoreId();
        if (adminCoreId != null) {
            patherLevel += 10.0f * this.getAICoreImpact(adminCoreId);
        }
        ArrayList<String> targeted = new ArrayList<String>();
        targeted.add("techmining");
        targeted.add("heavyindustry");
        targeted.add("fuelprod");
        targeted.add("starfortress");
        for (String curr : targeted) {
            if (!market.hasIndustry(curr)) continue;
            patherLevel += 10.0f;
        }
        if (patherLevel > 0.0f) {
            incoming.add("luddic_path", patherLevel * 0.2f);
        }
    }

    private float getAICoreImpact(String coreId) {
        if ("alpha_core".equals(coreId)) {
            return 10.0f;
        }
        if ("beta_core".equals(coreId)) {
            return 4.0f;
        }
        if ("gamma_core".equals(coreId)) {
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    public boolean canBeDisrupted() {
        return false;
    }

    public int getMaxIndustries() {
        return PopulationAndInfrastructure.getMaxIndustries(this.market.getSize());
    }

    public static int getMaxIndustries(int size) {
        if (MAX_IND == null) {
            try {
                MAX_IND = new int[10];
                JSONArray a = Global.getSettings().getJSONArray("maxIndustries");
                int i = 0;
                while (i < MAX_IND.length) {
                    PopulationAndInfrastructure.MAX_IND[i] = a.getInt(i);
                    ++i;
                }
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        if (--size < 0) {
            size = 0;
        }
        if (size > 9) {
            size = 9;
        }
        return MAX_IND[size];
    }

    @Override
    public boolean canImprove() {
        return true;
    }

    @Override
    protected void applyImproveModifiers() {
        if (this.isImproved()) {
            this.market.getStability().modifyFlat("PAI_improve", IMPROVE_STABILITY_BONUS, String.valueOf(this.getImprovementsDescForModifiers()) + " (" + this.getNameForModifier() + ")");
        } else {
            this.market.getStability().unmodifyFlat("PAI_improve");
        }
    }

    @Override
    public void addImproveDesc(TooltipMakerAPI info, Industry.ImprovementDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        if (mode == Industry.ImprovementDescriptionMode.INDUSTRY_TOOLTIP) {
            info.addPara("Stability increased by %s.", 0.0f, highlight, "" + (int)IMPROVE_STABILITY_BONUS);
        } else {
            info.addPara("Increases stability by %s.", 0.0f, highlight, "" + (int)IMPROVE_STABILITY_BONUS);
        }
        info.addSpacer(opad);
        super.addImproveDesc(info, mode);
    }

    @Override
    public void setSpecialItem(SpecialItemData special) {
        super.setSpecialItem(special);
        if (!(this.addedHeatCondition == null || special != null && special.getId().equals("orbital_fusion_lamp"))) {
            this.market.removeCondition(this.addedHeatCondition);
            this.addedHeatCondition = null;
            if (this.removedHeatCondition != null) {
                this.market.addCondition(this.removedHeatCondition);
                this.removedHeatCondition = null;
            }
        }
        if (special != null && special.getId().equals("orbital_fusion_lamp")) {
            if (this.lamp == null) {
                SectorEntityToken focus = this.market.getPlanetEntity();
                if (focus == null) {
                    focus = this.market.getPrimaryEntity();
                }
                if (focus != null) {
                    BaseThemeGenerator.EntityLocation loc = new BaseThemeGenerator.EntityLocation();
                    float radius = focus.getRadius() + 100.0f;
                    loc.orbit = Global.getFactory().createCircularOrbit(focus, (float)Math.random() * 360.0f, radius, radius / (10.0f + 10.0f * (float)Math.random()));
                    BaseThemeGenerator.AddedEntity added = BaseThemeGenerator.addNonSalvageEntity(this.market.getContainingLocation(), loc, "fusion_lamp", this.getMarket().getFactionId());
                    if (added != null) {
                        this.lamp = added.entity;
                        this.market.getContainingLocation().addScript(new LampRemover(this.lamp, this.market, this));
                    }
                }
            }
            if (!(this.addedHeatCondition != null || this.market.hasCondition("cold") || this.market.hasCondition("very_cold") || this.market.hasCondition("very_hot"))) {
                if (this.market.hasCondition("hot")) {
                    this.addedHeatCondition = "very_hot";
                    this.removedHeatCondition = "hot";
                } else {
                    this.addedHeatCondition = "hot";
                }
                if (this.removedHeatCondition != null) {
                    this.market.removeCondition(this.removedHeatCondition);
                }
                if (this.addedHeatCondition != null) {
                    this.market.addCondition(this.addedHeatCondition);
                }
            }
        }
    }

    @Override
    public boolean wantsToUseSpecialItem(SpecialItemData data) {
        if (this.special != null) {
            return false;
        }
        if ("orbital_fusion_lamp".equals(data.getId())) {
            for (String mc : ItemEffectsRepo.FUSION_LAMP_CONDITIONS) {
                if (!this.market.hasCondition(mc)) continue;
                return true;
            }
            return false;
        }
        return super.wantsToUseSpecialItem(data);
    }

    public static Pair<SectorEntityToken, Float> getNearestCoronalTap(Vector2f locInHyper, boolean usable) {
        return PopulationAndInfrastructure.getNearestCoronalTap(locInHyper, usable, false);
    }

    public static Pair<SectorEntityToken, Float> getNearestCoronalTap(Vector2f locInHyper, boolean usable, boolean requireDefendersDefeated) {
        SectorEntityToken nearest = null;
        float minDist = Float.MAX_VALUE;
        for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(HypershuntIntel.class)) {
            HypershuntIntel hypershunt = (HypershuntIntel)intel;
            if (requireDefendersDefeated && !hypershunt.defendersDefeated()) continue;
            SectorEntityToken entity = hypershunt.getEntity();
            if (usable && !entity.getMemoryWithoutUpdate().contains("$usable")) continue;
            float dist = Misc.getDistanceLY(locInHyper, entity.getLocationInHyperspace());
            if (dist > (float)ItemEffectsRepo.CORONAL_TAP_LIGHT_YEARS && (float)Math.round(dist * 10.0f) <= (float)ItemEffectsRepo.CORONAL_TAP_LIGHT_YEARS * 10.0f) {
                dist = ItemEffectsRepo.CORONAL_TAP_LIGHT_YEARS;
            }
            if (!(dist < minDist)) continue;
            minDist = dist;
            nearest = entity;
        }
        if (nearest == null) {
            return null;
        }
        return new Pair<Object, Float>(nearest, Float.valueOf(minDist));
    }

    public static class CoronalTapFactor
    implements ColonyOtherFactorsListener {
        @Override
        public boolean isActiveFactorFor(SectorEntityToken entity) {
            return PopulationAndInfrastructure.getNearestCoronalTap(entity.getLocationInHyperspace(), true) != null;
        }

        @Override
        public void printOtherFactors(TooltipMakerAPI text, SectorEntityToken entity) {
            Pair<SectorEntityToken, Float> p = PopulationAndInfrastructure.getNearestCoronalTap(entity.getLocationInHyperspace(), true);
            if (p != null) {
                Color h = Misc.getHighlightColor();
                float opad = 10.0f;
                String dStr = Misc.getRoundedValueMaxOneAfterDecimal(((Float)p.two).floatValue());
                String lights = "light-years";
                if (dStr.equals("1")) {
                    lights = "light-year";
                }
                if (((Float)p.two).floatValue() > (float)ItemEffectsRepo.CORONAL_TAP_LIGHT_YEARS) {
                    text.addPara("The nearest coronal tap is located in the " + ((SectorEntityToken)p.one).getContainingLocation().getNameWithLowercaseType() + ", %s " + lights + " away. The maximum " + "range at a portal can connect to a tap is %s light-years.", opad, h, Misc.getRoundedValueMaxOneAfterDecimal(((Float)p.two).floatValue()), "" + ItemEffectsRepo.CORONAL_TAP_LIGHT_YEARS);
                } else {
                    text.addPara("The nearest coronal tap is located in the " + ((SectorEntityToken)p.one).getContainingLocation().getNameWithLowercaseType() + ", %s " + lights + " away, allowing " + "a coronal portal located here to connect to it.", opad, h, Misc.getRoundedValueMaxOneAfterDecimal(((Float)p.two).floatValue()));
                }
            }
        }
    }

    protected static class LampRemover
    implements EveryFrameScript {
        protected SectorEntityToken lamp;
        protected MarketAPI market;
        protected PopulationAndInfrastructure industry;

        public LampRemover(SectorEntityToken lamp, MarketAPI market, PopulationAndInfrastructure industry) {
            this.lamp = lamp;
            this.market = market;
            this.industry = industry;
        }

        @Override
        public void advance(float amount) {
            SpecialItemData item;
            Industry ind = this.market.getIndustry("population");
            SpecialItemData specialItemData = item = ind == null ? null : ind.getSpecialItem();
            if (item == null || !item.getId().equals("orbital_fusion_lamp")) {
                Misc.fadeAndExpire(this.lamp);
                this.industry.lamp = null;
                this.lamp = null;
            }
        }

        @Override
        public boolean isDone() {
            return this.lamp == null;
        }

        @Override
        public boolean runWhilePaused() {
            return false;
        }
    }
}

