/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.graid;

import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.graid.GroundRaidObjectivePlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.IconGroupAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public abstract class BaseGroundRaidObjectivePluginImpl
implements GroundRaidObjectivePlugin {
    protected String id;
    protected MarketAPI market;
    protected Industry source;
    protected int marinesAssigned;
    protected int marinesRequired;
    protected String nameOverride;
    protected String assignedForcesColumnText;
    protected Color assignedForcesColumnColor = Misc.getNegativeHighlightColor();
    protected int quantityLooted;
    protected int xpGained;

    public BaseGroundRaidObjectivePluginImpl(MarketAPI market, String id) {
        this.market = market;
        this.id = id;
    }

    public abstract float getQuantity(int var1);

    public abstract int getValue(int var1);

    @Override
    public int getCargoSpaceNeeded() {
        return 0;
    }

    @Override
    public int getFuelSpaceNeeded() {
        return 0;
    }

    @Override
    public CargoStackAPI getStackForIcon() {
        return null;
    }

    @Override
    public String getIconName() {
        return null;
    }

    @Override
    public void addIcons(IconGroupAPI iconGroup) {
    }

    @Override
    public int getDeficitCaused() {
        return 0;
    }

    public String getDisruptedAlreadyString() {
        return "";
    }

    public Color getDisruptedAlreadyColor() {
        return Misc.getHighlightColor();
    }

    @Override
    public int getDisruptionDaysSort(int marines) {
        return 0;
    }

    @Override
    public String getDisruptionDaysString(int marines) {
        return "";
    }

    @Override
    public Color getDisruptionDaysColor(int marines) {
        if (marines <= 0) {
            return Misc.getGrayColor();
        }
        return Misc.getHighlightColor();
    }

    @Override
    public String getNameOverride() {
        return this.nameOverride;
    }

    @Override
    public void setNameOverride(String nameOverride) {
        this.nameOverride = nameOverride;
    }

    @Override
    public MarketCMD.RaidDangerLevel getDangerLevel() {
        return MarketCMD.RaidDangerLevel.MEDIUM;
    }

    @Override
    public String getQuantityString(int marines) {
        return Misc.getWithDGS(this.getQuantity(Math.max(1, marines)));
    }

    @Override
    public Color getQuantityColor(int marines) {
        if (marines <= 0) {
            return Misc.getGrayColor();
        }
        return Misc.getHighlightColor();
    }

    @Override
    public String getValueString(int marines) {
        return Misc.getDGSCredits(this.getValue(Math.max(1, marines)));
    }

    @Override
    public Color getValueColor(int marines) {
        if (marines <= 0) {
            return Misc.getGrayColor();
        }
        return Misc.getHighlightColor();
    }

    @Override
    public float getValueSortValue() {
        float add = 1.0E8f;
        if (this.getMarinesAssigned() == 0) {
            add = 0.0f;
        }
        return (float)this.getValue(Math.max(1, this.getMarinesAssigned())) + add;
    }

    @Override
    public int getMarinesAssigned() {
        return this.marinesAssigned;
    }

    @Override
    public void setMarinesAssigned(int marines) {
        this.marinesAssigned = marines;
    }

    @Override
    public int getMarinesRequired() {
        return this.marinesRequired;
    }

    @Override
    public void setMarinesRequired(int marines) {
        if ((marines = Math.min(MarketCMD.MAX_MARINE_TOKENS, marines)) < 0) {
            marines = 0;
        }
        this.marinesRequired = marines;
    }

    @Override
    public String getSourceString() {
        if (this.source != null) {
            return this.source.getCurrentName();
        }
        return "";
    }

    @Override
    public Industry getSource() {
        return this.source;
    }

    @Override
    public void setSource(Industry source) {
        this.source = source;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public MarketAPI getMarket() {
        return this.market;
    }

    @Override
    public void setMarket(MarketAPI market) {
        this.market = market;
    }

    @Override
    public String getCommodityIdForDeficitIcons() {
        return null;
    }

    @Override
    public String getAssignedForcesColumnText() {
        return this.assignedForcesColumnText;
    }

    @Override
    public void setAssignedForcesColumnText(String assignedForcesColumnText) {
        this.assignedForcesColumnText = assignedForcesColumnText;
    }

    @Override
    public Color getAssignedForcesColumnColor() {
        return this.assignedForcesColumnColor;
    }

    @Override
    public void setAssignedForcesColumnColor(Color assignedForcesColumnColor) {
        this.assignedForcesColumnColor = assignedForcesColumnColor;
    }

    @Override
    public boolean hasTooltip() {
        return false;
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
    }

    @Override
    public float getTooltipWidth() {
        return 500.0f;
    }

    @Override
    public boolean isTooltipExpandable() {
        return false;
    }

    public int getQuantityLooted() {
        return this.quantityLooted;
    }

    public void setQuantityLooted(int quantityLooted) {
        this.quantityLooted = quantityLooted;
    }

    public int getXpGained() {
        return this.xpGained;
    }

    public void setXpGained(int xpGained) {
        this.xpGained = xpGained;
    }

    @Override
    public boolean withContinueBeforeResult() {
        return false;
    }
}

