/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.graid;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.graid.BaseGroundRaidObjectivePluginImpl;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.IconGroupAPI;
import com.fs.starfarer.api.ui.IconRenderMode;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Random;

public class CreditsGroundRaidObjectivePluginImpl
extends BaseGroundRaidObjectivePluginImpl {
    public static float CREDITS_PER_MARKET_SIZE = 2500.0f;
    public static float MAX_TOKENS = 5.0f;

    public CreditsGroundRaidObjectivePluginImpl(MarketAPI market) {
        super(market, "credits");
        this.setSource(null);
    }

    @Override
    public void addIcons(IconGroupAPI iconGroup) {
        CommoditySpecAPI spec = this.getCommoditySpec();
        if (spec == null) {
            return;
        }
        int base = Math.round(this.getBaseSizeValue());
        int minus = this.getNumMinusTokens();
        int plus = this.getNumPlusTokens();
        if (base > 0) {
            iconGroup.addIconGroup(this.id, IconRenderMode.NORMAL, base, null);
        }
        if (minus > 0) {
            iconGroup.addIconGroup(this.id, IconRenderMode.RED, minus, null);
        }
        if (plus > 0) {
            iconGroup.addIconGroup(this.id, IconRenderMode.GREEN, plus, null);
        }
    }

    @Override
    public String getSourceString() {
        return null;
    }

    @Override
    public int getProjectedCreditsValue() {
        return (int)this.getQuantity(this.getMarinesAssigned());
    }

    public CommoditySpecAPI getCommoditySpec() {
        return Global.getSettings().getCommoditySpec(this.getId());
    }

    @Override
    public MarketCMD.RaidDangerLevel getDangerLevel() {
        MarketCMD.RaidDangerLevel danger = this.getCommoditySpec().getBaseDanger();
        float mult = this.getCreditsLootedMult();
        if (mult <= 0.75f) {
            danger = danger.next();
        } else if (mult >= 1.25f) {
            danger = danger.prev();
        }
        return danger;
    }

    @Override
    public float getQuantitySortValue() {
        return 100000.0f;
    }

    @Override
    public String getQuantityString(int marines) {
        return "";
    }

    @Override
    public int getValue(int marines) {
        return (int)(this.getQuantity(marines) * this.getCommoditySpec().getBasePrice());
    }

    @Override
    public float getQuantity(int marines) {
        float base = this.getBaseRaidQuantity();
        return base * (float)marines;
    }

    public int getNumPlusTokens() {
        float incomeMult = this.market.getIncomeMult().getModifiedValue();
        int num = 0;
        if (incomeMult > 1.0f) {
            ++num;
        }
        if (incomeMult > 1.25f) {
            ++num;
        }
        float a = this.market.getAccessibilityMod().computeEffective(0.0f);
        num += Math.round((a - 1.0f) / 0.2f);
        num = Math.max(num, 0);
        num = (int)Math.min((float)num, MAX_TOKENS);
        return num;
    }

    public int getNumMinusTokens() {
        if (this.getNumPlusTokens() > 0) {
            return 0;
        }
        float incomeMult = this.market.getIncomeMult().getModifiedValue();
        int num = 0;
        if (incomeMult < 1.0f) {
            ++num;
        }
        if (incomeMult < 0.75f) {
            ++num;
        }
        float a = this.market.getAccessibilityMod().computeEffective(0.0f);
        num += Math.round((1.0f - a) / 0.1f);
        num = Math.max(num, 0);
        num = (int)Math.min((float)num, MAX_TOKENS);
        return num;
    }

    public float getCreditsLootedMult() {
        float mult = 1.0f + (float)(this.getNumPlusTokens() - this.getNumMinusTokens()) / (MAX_TOKENS + 1.0f);
        mult = (float)Math.round(mult * 100.0f) / 100.0f;
        return mult;
    }

    public float getBaseSizeValue() {
        return Math.max(1, this.market.getSize() - 3);
    }

    public float getBaseRaidQuantity() {
        float result = this.getBaseSizeValue() * CREDITS_PER_MARKET_SIZE;
        return result *= this.getCreditsLootedMult();
    }

    @Override
    public String getName() {
        return this.getCommoditySpec().getName();
    }

    @Override
    public CargoStackAPI getStackForIcon() {
        CargoStackAPI stack = Global.getFactory().createCargoStack(CargoAPI.CargoItemType.RESOURCES, this.getId(), null);
        return stack;
    }

    @Override
    public int performRaid(CargoAPI loot, Random random, float lootMult, TextPanelAPI text) {
        if (this.marinesAssigned <= 0) {
            return 0;
        }
        float base = this.getQuantity(this.marinesAssigned);
        base *= lootMult;
        float mult = 0.9f + random.nextFloat() * 0.2f;
        this.quantityLooted = (int)(base *= mult);
        if (this.quantityLooted < 1) {
            this.quantityLooted = 1;
        }
        loot.getCredits().add(this.quantityLooted);
        this.xpGained = (int)((float)this.quantityLooted * this.getCommoditySpec().getBasePrice() * 0.2f * 0.01f);
        return this.xpGained;
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    @Override
    public void createTooltip(TooltipMakerAPI t, boolean expanded) {
        float opad = 10.0f;
        float pad = 3.0f;
        Color h = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        Color good = Misc.getPositiveHighlightColor();
    }
}

