/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.FullName;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.bar.PortsideBarData;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BaseBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.contacts.ContactIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.PirateBasePirateActivityCause2;
import com.fs.starfarer.api.util.Misc;
import java.util.Map;
import java.util.Random;

public class PirateBaseRumorBarEvent
extends BaseBarEvent {
    protected PirateBaseIntel intel;
    protected long seed;
    protected transient boolean done = false;
    protected transient FullName.Gender gender;
    protected transient PersonAPI person;

    @Override
    public boolean isAlwaysShow() {
        return true;
    }

    public PirateBaseRumorBarEvent(PirateBaseIntel intel) {
        this.intel = intel;
        this.seed = Misc.random.nextLong();
    }

    @Override
    public boolean shouldShowAtMarket(MarketAPI market) {
        HostileActivityEventIntel ha;
        if (this.intel.getTarget() == market.getContainingLocation()) {
            return true;
        }
        if (market.isPlayerOwned() && (ha = HostileActivityEventIntel.get()) != null) {
            return PirateBasePirateActivityCause2.getBaseIntel(market.getStarSystem()) == this.intel;
        }
        return false;
    }

    @Override
    public boolean shouldRemoveEvent() {
        return this.intel.isEnding() || this.intel.isEnded() || this.intel.isPlayerVisible();
    }

    @Override
    public void addPromptAndOption(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.addPromptAndOption(dialog, memoryMap);
        Random random = new Random(this.seed + (long)dialog.getInteractionTarget().getMarket().getId().hashCode());
        this.gender = FullName.Gender.MALE;
        if (random.nextFloat() > 0.5f) {
            this.gender = FullName.Gender.FEMALE;
        }
        this.person = Global.getSector().getFaction("pirates").createRandomPerson(this.gender, random);
        this.person.setPostId(Ranks.POST_MINORCRIMINAL);
        this.person.setImportanceAndVoice(PersonImportance.VERY_LOW, random);
        this.person.addTag("underworld");
        String himOrHer = "him";
        if (this.gender == FullName.Gender.FEMALE) {
            himOrHer = "her";
        }
        TextPanelAPI text = dialog.getTextPanel();
        text.addPara("A grizzled spacer sits at the bar, downing shots of what looks like the cheapest liquor available.");
        dialog.getOptionPanel().addOption("Approach the spacer and offer to buy " + himOrHer + " something more palatable", this);
    }

    @Override
    public void init(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.init(dialog, memoryMap);
        String himOrHerSelf = "himself";
        if (this.gender == FullName.Gender.FEMALE) {
            himOrHerSelf = "herself";
        }
        TextPanelAPI text = dialog.getTextPanel();
        text.addPara("You keep the drinks flowing and mostly just listen, letting the spacer unburden " + himOrHerSelf + ".");
        dialog.getVisualPanel().showPersonInfo(this.person, true);
        this.done = true;
        this.intel.makeKnown();
        this.intel.sendUpdate(PirateBaseIntel.DISCOVERED_PARAM, text);
        PortsideBarData.getInstance().removeEvent(this);
        ContactIntel.addPotentialContact(this.person, dialog.getInteractionTarget().getMarket(), text);
    }

    @Override
    public void optionSelected(String optionText, Object optionData) {
    }

    @Override
    public boolean isDialogFinished() {
        return this.done;
    }

    protected boolean showCargoCap() {
        return false;
    }
}

