/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.NPCHassler;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HegemonyAICoresActivityCause;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.inspection.HegemonyInspectionIntel;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.DelayedActionScript;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class HegemonyHostileActivityFactor
extends BaseHostileActivityFactor
implements HegemonyInspectionIntel.InspectionEndedListener {
    public static final String HASSLE_REASON = "hegemonyInvestigator";
    public static String DEFEATED_HEGEMONY = "$defeatedHegemony";
    public static String INSPECTION_ATTEMPTS = "$hegemonyInspectionAttempts";
    public static String INSPECTIONS_DEFEATED = "$hegemonyInspectionsDefeated";
    public static int INSPECTIONS_TO_DEFEAT = 3;
    public static float INSPECTION_STRENGTH_FIRST = 150.0f;
    public static float INSPECTION_STRENGTH_SECOND = 600.0f;
    public static float INSPECTION_STRENGTH_FINAL = 1400.0f;

    public static boolean isPlayerDefeatedHegemony() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(DEFEATED_HEGEMONY);
    }

    public static void setPlayerDefeatedHegemony() {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(DEFEATED_HEGEMONY, true);
    }

    public static int getInspectionAttempts() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getInt(INSPECTION_ATTEMPTS);
    }

    public static void incrInspectionAttempts() {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(INSPECTION_ATTEMPTS, HegemonyHostileActivityFactor.getInspectionAttempts() + 1);
    }

    public static int getInspectionsDefeated() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getInt(INSPECTIONS_DEFEATED);
    }

    public static void incrInspectionsDefeated() {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(INSPECTIONS_DEFEATED, HegemonyHostileActivityFactor.getInspectionsDefeated() + 1);
    }

    public HegemonyHostileActivityFactor(HostileActivityEventIntel intel) {
        super(intel);
    }

    @Override
    public String getProgressStr(BaseEventIntel intel) {
        return "";
    }

    @Override
    public int getProgress(BaseEventIntel intel) {
        if (!HegemonyHostileActivityFactor.checkFactionExists("hegemony", true)) {
            return 0;
        }
        return super.getProgress(intel);
    }

    @Override
    public float getEffectMagnitude(StarSystemAPI system) {
        if (!HegemonyHostileActivityFactor.checkFactionExists("hegemony", true)) {
            return 0.0f;
        }
        return super.getEffectMagnitude(system);
    }

    @Override
    public String getDesc(BaseEventIntel intel) {
        return "Hegemony";
    }

    @Override
    public String getNameForThreatList(boolean first) {
        return "Hegemony";
    }

    @Override
    public Color getDescColor(BaseEventIntel intel) {
        if (this.getProgress(intel) <= 0) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getFaction("hegemony").getBaseUIColor();
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getMainRowTooltip(BaseEventIntel intel) {
        return new BaseFactorTooltip(){

            @Override
            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("The Hegemony considers the use of AI cores illegal and will not tolerate it even outside the volume of the core worlds.", 0.0f);
                tooltip.addPara("Fleets investigating your AI core use can sometimes be found in your space, not overtly hostile, but harassing your shipping and generally acting in a high-handed way.", opad);
            }
        };
    }

    @Override
    public boolean shouldShow(BaseEventIntel intel) {
        boolean shouldShowDueToCause = false;
        for (HostileActivityCause2 cause : this.getCauses()) {
            shouldShowDueToCause |= cause.shouldShow();
        }
        return this.getProgress(intel) > 0 || shouldShowDueToCause;
    }

    @Override
    public int getMaxNumFleets(StarSystemAPI system) {
        return Global.getSettings().getInt("hegemonyMaxFleets");
    }

    @Override
    public CampaignFleetAPI createFleet(StarSystemAPI system, Random random) {
        float f = 0.0f;
        if ((f += this.intel.getMarketPresenceFactor(system)) > 1.0f) {
            f = 1.0f;
        }
        boolean recon = false;
        int difficulty = 0;
        if (recon) {
            difficulty = 1 + random.nextInt(2);
        } else {
            difficulty = 3;
            difficulty += Math.round(f * 5.0f);
            difficulty += random.nextInt(4);
        }
        FleetCreatorMission m = new FleetCreatorMission(random);
        m.beginFleet();
        Vector2f loc = system.getLocation();
        String factionId = "hegemony";
        if (recon) {
            m.createStandardFleet(difficulty, factionId, loc);
        } else {
            m.createStandardFleet(difficulty, factionId, loc);
        }
        m.triggerSetFleetType("investigators");
        m.triggerSetPatrol();
        if (!recon) {
            m.triggerSetFleetHasslePlayer(HASSLE_REASON);
            m.triggerSetFleetFlag("$hegemonyInvestigator");
            m.triggerFleetAllowLongPursuit();
        }
        m.triggerMakeLowRepImpact();
        CampaignFleetAPI fleet = m.createFleet();
        if (fleet != null && !recon) {
            fleet.addScript(new NPCHassler(fleet, system));
        }
        return fleet;
    }

    @Override
    public void notifyFactorRemoved() {
    }

    @Override
    public void notifyEventEnding() {
        this.notifyFactorRemoved();
    }

    @Override
    public void addBulletPointForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        if (!(stage.rollData instanceof HostileActivityEventIntel.HAERandomEventData)) {
            return;
        }
        HostileActivityEventIntel.HAERandomEventData data = (HostileActivityEventIntel.HAERandomEventData)stage.rollData;
        MarketAPI target = (MarketAPI)data.custom;
        if (target == null) {
            return;
        }
        MarketAPI from = this.pickSourceMarket();
        if (from == null) {
            return;
        }
        Color c = Global.getSector().getFaction("hegemony").getBaseUIColor();
        LabelAPI label = info.addPara("Upcoming Hegemony AI inspection targeting %s", initPad, tc, tc, target.getName());
        label.setHighlight("Hegemony", target.getName());
        label.setHighlightColors(c, Misc.getBasePlayerColor());
    }

    @Override
    public void addBulletPointForEventReset(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        info.addPara("Hegemony AI inspection averted", tc, initPad);
    }

    @Override
    public void addStageDescriptionForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info) {
        if (!(stage.rollData instanceof HostileActivityEventIntel.HAERandomEventData)) {
            return;
        }
        HostileActivityEventIntel.HAERandomEventData data = (HostileActivityEventIntel.HAERandomEventData)stage.rollData;
        MarketAPI target = (MarketAPI)data.custom;
        if (target == null) {
            return;
        }
        MarketAPI from = this.pickSourceMarket();
        if (from == null) {
            return;
        }
        Color c = Global.getSector().getFaction("hegemony").getBaseUIColor();
        float small = 0.0f;
        float opad = 10.0f;
        small = 8.0f;
        LabelAPI label = info.addPara("You've received intel that the Hegemony is planning an AI insprection targeting %s. If the inspection arrives at your colony, your options would include open hostilities with the Hegemony, or the loss of at least some of your AI cores.", small, c, target.getName());
        label.setHighlight(target.getName(), "open hostilities", "loss of at least some of your AI cores");
        label.setHighlightColors(Misc.getBasePlayerColor(), Misc.getNegativeHighlightColor(), Misc.getNegativeHighlightColor());
        int defeated = HegemonyHostileActivityFactor.getInspectionsDefeated();
        if (defeated < INSPECTIONS_TO_DEFEAT - 1) {
            label = info.addPara("If this inspection is defeated by military means, the Hegemony is likely to escalate the conflict, although only up to a point.", opad, Misc.getNegativeHighlightColor(), "escalate the conflict");
            label.setHighlight("escalate the conflict", "up to a point");
            label.setHighlightColors(Misc.getNegativeHighlightColor(), Misc.getPositiveHighlightColor());
        } else {
            info.addPara("If this massive inspection force - a declaration of war in all but name - is defeated, the Hegemony is likely to reconsider the viability of their approach.", opad, Misc.getPositiveHighlightColor(), "reconsider");
        }
        stage.beginResetReqList(info, true, "crisis", opad);
        info.addPara("The %s has no functional military bases", 0.0f, c, "Hegemony");
        stage.endResetReqList(info, false, "crisis", -1, -1);
        this.addBorder(info, Global.getSector().getFaction("hegemony").getBaseUIColor());
    }

    @Override
    public String getEventStageIcon(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        return Global.getSector().getFaction("hegemony").getCrest();
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getStageTooltipImpl(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT) {
            return this.getDefaultEventTooltip("Hegemony AI inspection", intel, stage);
        }
        return null;
    }

    @Override
    public float getEventFrequency(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT && this.pickTargetMarket() != null && this.pickSourceMarket() != null) {
            return 10.0f;
        }
        return 0.0f;
    }

    public MarketAPI pickTargetMarket() {
        WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<MarketAPI>(this.getRandomizedStageRandom());
        float alpha = Global.getSettings().getFloat("hegemonyPointsAlpha");
        float beta = Global.getSettings().getFloat("hegemonyPointsBeta");
        float gamma = Global.getSettings().getFloat("hegemonyPointsGamma");
        float threshold = alpha + beta + gamma;
        for (MarketAPI market : Misc.getPlayerMarkets(false)) {
            float w;
            if (market.getDaysInExistence() < 180.0f && !Global.getSettings().isDevMode() || (w = HegemonyAICoresActivityCause.getAICorePoints(market)) <= threshold) continue;
            picker.add(market, w * w);
        }
        return (MarketAPI)picker.pick();
    }

    public MarketAPI pickSourceMarket() {
        WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<MarketAPI>(this.getRandomizedStageRandom(7));
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!market.getFactionId().equals("hegemony")) continue;
            Industry b = market.getIndustry("militarybase");
            if (b == null) {
                b = market.getIndustry("highcommand");
            }
            if (b == null || b.isDisrupted() || !b.isFunctional()) continue;
            picker.add(market, market.getSize());
        }
        MarketAPI from = (MarketAPI)picker.pick();
        return from;
    }

    @Override
    public void rollEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (HegemonyHostileActivityFactor.isPlayerDefeatedHegemony()) {
            return;
        }
        MarketAPI market = this.pickTargetMarket();
        if (market == null) {
            return;
        }
        MarketAPI from = this.pickSourceMarket();
        if (from == null) {
            return;
        }
        HostileActivityEventIntel.HAERandomEventData data = new HostileActivityEventIntel.HAERandomEventData(this, stage);
        data.custom = market;
        stage.rollData = data;
        intel.sendUpdateIfPlayerHasIntel((Object)data, false);
    }

    @Override
    public boolean fireEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (HegemonyHostileActivityFactor.isPlayerDefeatedHegemony()) {
            return false;
        }
        if (!(stage.rollData instanceof HostileActivityEventIntel.HAERandomEventData)) {
            return false;
        }
        HostileActivityEventIntel.HAERandomEventData data = (HostileActivityEventIntel.HAERandomEventData)stage.rollData;
        MarketAPI market = (MarketAPI)data.custom;
        if (market == null) {
            return false;
        }
        if (!market.isInEconomy()) {
            return false;
        }
        MarketAPI from = this.pickSourceMarket();
        if (from == null) {
            return false;
        }
        StarSystemAPI system = market.getStarSystem();
        if (system == null) {
            return false;
        }
        return this.createInspection(market, null);
    }

    public boolean createInspection(MarketAPI target, Integer fpOverride) {
        HegemonyInspectionIntel inspection;
        MarketAPI from = this.pickSourceMarket();
        if (from == null) {
            return false;
        }
        int defeated = HegemonyHostileActivityFactor.getInspectionsDefeated();
        float fp = defeated <= 0 ? INSPECTION_STRENGTH_FIRST : (defeated == 1 ? INSPECTION_STRENGTH_SECOND : INSPECTION_STRENGTH_FINAL);
        if (fpOverride != null) {
            fp = fpOverride.intValue();
        }
        if ((inspection = new HegemonyInspectionIntel(from, target, fp)).isDone()) {
            inspection = null;
            return false;
        }
        inspection.setListener(this);
        HegemonyHostileActivityFactor.incrInspectionAttempts();
        return true;
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        BaseEventIntel.EventStageData stage = this.intel.getDataFor((Object)HostileActivityEventIntel.Stage.HA_EVENT);
        if (stage != null && stage.rollData instanceof HostileActivityEventIntel.HAERandomEventData && ((HostileActivityEventIntel.HAERandomEventData)stage.rollData).factor == this && this.pickSourceMarket() == null) {
            this.intel.resetHA_EVENT();
        }
    }

    public static void avertInspectionIfNotInProgress() {
        HostileActivityEventIntel intel = HostileActivityEventIntel.get();
        if (intel == null) {
            return;
        }
        HostileActivityEventIntel.HAERandomEventData data = intel.getRollDataForEvent();
        if (data != null && data.factor instanceof HegemonyHostileActivityFactor) {
            intel.resetHA_EVENT();
        }
    }

    @Override
    public void notifyInspectionEnded(HegemonyInspectionIntel.HegemonyInspectionOutcome outcome) {
        if (outcome == HegemonyInspectionIntel.HegemonyInspectionOutcome.TASK_FORCE_DESTROYED) {
            HegemonyHostileActivityFactor.incrInspectionsDefeated();
            int defeated = HegemonyHostileActivityFactor.getInspectionsDefeated();
            if (defeated >= INSPECTIONS_TO_DEFEAT) {
                HegemonyHostileActivityFactor.setPlayerDefeatedHegemony();
                Global.getSector().addScript(new DelayedActionScript(0.1f){

                    @Override
                    public void doAction() {
                        MessageIntel msg = new MessageIntel();
                        msg.addLine("Major Hegemony defeat!", Misc.getBasePlayerColor());
                        msg.addLine("    - You may be able to discuss the situation with the High Hegemon on Chicomoztoc");
                        msg.setIcon(Global.getSector().getFaction("hegemony").getCrest());
                        msg.setSound(Sounds.REP_GAIN);
                        Global.getSector().getCampaignUI().addMessage(msg, CommMessageAPI.MessageClickAction.NOTHING);
                    }
                });
            }
        }
    }
}

