/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.ColonyPlayerHostileActListener;
import com.fs.starfarer.api.campaign.listeners.ColonySizeChangeListener;
import com.fs.starfarer.api.impl.campaign.NPCHassler;
import com.fs.starfarer.api.impl.campaign.econ.LuddicMajority;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HAHersperusTacBombardmentFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.group.FGBlockadeAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FleetGroupIntel;
import com.fs.starfarer.api.impl.campaign.intel.group.GenericRaidFGI;
import com.fs.starfarer.api.impl.campaign.intel.group.KnightsOfLuddTakeoverExpedition;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class LuddicChurchHostileActivityFactor
extends BaseHostileActivityFactor
implements FleetGroupIntel.FGIEventListener,
ColonyPlayerHostileActListener,
ColonySizeChangeListener {
    public static final String HASSLE_REASON = "sacredProtectors";
    public static final String DEFEATED_LUDDIC_CHURCH_EXPEDITION = "$defeatedLuddicChurchExpedition";
    public static final String MADE_IMMIGRATION_DEAL_WITH_LUDDIC_CHURCH = "$madeImmigrationDealWithLuddicChurch";
    public static final String BROKE_LUDDIC_CHURCH_DEAL = "$brokeLuddicChurchDeal";

    public static boolean isDefeatedExpedition() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(DEFEATED_LUDDIC_CHURCH_EXPEDITION);
    }

    public static void setDefeatedExpedition(boolean value) {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(DEFEATED_LUDDIC_CHURCH_EXPEDITION, value);
    }

    public static boolean isMadeDeal() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(MADE_IMMIGRATION_DEAL_WITH_LUDDIC_CHURCH);
    }

    public static void setMadeDeal(boolean value) {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(MADE_IMMIGRATION_DEAL_WITH_LUDDIC_CHURCH, value);
    }

    public static boolean brokeDeal() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(BROKE_LUDDIC_CHURCH_DEAL);
    }

    public static void setBrokeDeal(boolean broke) {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(BROKE_LUDDIC_CHURCH_DEAL, broke);
    }

    public LuddicChurchHostileActivityFactor(HostileActivityEventIntel intel) {
        super(intel);
        Global.getSector().getListenerManager().addListener(this);
    }

    @Override
    public String getProgressStr(BaseEventIntel intel) {
        return "";
    }

    @Override
    public int getProgress(BaseEventIntel intel) {
        if (!LuddicChurchHostileActivityFactor.checkFactionExists("luddic_church", true)) {
            return 0;
        }
        return super.getProgress(intel);
    }

    @Override
    public String getDesc(BaseEventIntel intel) {
        return "Luddic Church";
    }

    @Override
    public String getNameForThreatList(boolean first) {
        return "Knights of Ludd";
    }

    @Override
    public Color getDescColor(BaseEventIntel intel) {
        if (this.getProgress(intel) <= 0) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getFaction("luddic_church").getBaseUIColor();
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getMainRowTooltip(BaseEventIntel intel) {
        return new BaseFactorTooltip(){

            @Override
            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("A large community of the faithful - not under their direct control, and with potential to emerge as a major cultural center - is a growing source of concern to the Church. \"Protector\" fleets operated by the Knights of Ludd can be found in your systems, ostensibly there to protect the interests of the local Luddic population.", 0.0f);
            }
        };
    }

    @Override
    public boolean shouldShow(BaseEventIntel intel) {
        return this.getProgress(intel) > 0;
    }

    public Color getNameColor(float mag) {
        if (mag <= 0.0f) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getFaction("luddic_church").getBaseUIColor();
    }

    @Override
    public int getMaxNumFleets(StarSystemAPI system) {
        return Global.getSettings().getInt("luddicChurchMaxFleets");
    }

    @Override
    public float getSpawnInHyperProbability(StarSystemAPI system) {
        return 0.0f;
    }

    @Override
    public CampaignFleetAPI createFleet(StarSystemAPI system, Random random) {
        int maxSize = 0;
        for (MarketAPI curr : Misc.getMarketsInLocation(system, "player")) {
            maxSize = Math.max(curr.getSize(), maxSize);
        }
        int difficulty = maxSize + 1;
        if ((difficulty += random.nextInt(4)) > 10) {
            difficulty = 10;
        }
        FleetCreatorMission m = new FleetCreatorMission(random);
        m.beginFleet();
        Vector2f loc = system.getLocation();
        String factionId = "luddic_church";
        m.createStandardFleet(difficulty, factionId, loc);
        m.triggerSetFleetQuality(HubMissionWithTriggers.FleetQuality.HIGHER);
        m.triggerSetFleetType(HASSLE_REASON);
        m.triggerSetPatrol();
        m.triggerSetFleetHasslePlayer(HASSLE_REASON);
        m.triggerSetFleetFlag("$sacredProtectors");
        m.triggerFleetAllowLongPursuit();
        m.triggerMakeLowRepImpact();
        CampaignFleetAPI fleet = m.createFleet();
        if (fleet != null) {
            fleet.setName("Knights of Ludd " + fleet.getName());
            fleet.setNoFactionInName(true);
            NPCHassler hassle = new NPCHassler(fleet, system);
            hassle.getParams().crDamageMult = 0.0f;
            fleet.addScript(hassle);
        }
        return fleet;
    }

    @Override
    public void addBulletPointForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        Color c = Global.getSector().getFaction("luddic_church").getBaseUIColor();
        info.addPara("Impending Luddic Church takeover operation", initPad, tc, c, "Luddic Church");
    }

    @Override
    public void addBulletPointForEventReset(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        info.addPara("Luddic Church takeover averted", tc, initPad);
    }

    @Override
    public void addStageDescriptionForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info) {
        float small = 0.0f;
        float opad = 10.0f;
        small = 8.0f;
        LabelAPI label = info.addPara("You've received intel that the Knights of Ludd, under the aegis of the Luddic Church, are planning an operation to take over one of your colonies that has a Luddic Majority population.", small, Misc.getNegativeHighlightColor(), "take over one of your colonies");
        label.setHighlight("take over one of your colonies", "Luddic Majority");
        label.setHighlightColors(Misc.getNegativeHighlightColor(), Global.getSector().getFaction("luddic_church").getBaseUIColor());
        label = info.addPara("If the expedition is defeated, the Luddic faithful leaving the Church worlds will feel more secure, resulting in increased immigration, stability, and productivity, and the Luddic Church will likely abandon further efforts of this sort.", opad);
        label.setHighlight("increased immigration, stability, and productivity", "Luddic Church");
        label.setHighlightColors(Misc.getPositiveHighlightColor(), Global.getSector().getFaction("luddic_church").getBaseUIColor());
        Color c = Global.getSector().getFaction("luddic_church").getBaseUIColor();
        stage.beginResetReqList(info, true, "crisis", opad);
        info.addPara("You make an agreement with the Church", 0.0f);
        info.addPara("%s is tactically bombarded", 0.0f, c, "Hesperus");
        stage.endResetReqList(info, false, "crisis", -1, -1);
        this.addBorder(info, Global.getSector().getFaction("luddic_church").getBaseUIColor());
    }

    @Override
    public String getEventStageIcon(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        return Global.getSector().getFaction("luddic_church").getCrest();
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getStageTooltipImpl(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT) {
            return this.getDefaultEventTooltip("Luddic Church expedition", intel, stage);
        }
        return null;
    }

    @Override
    public float getEventFrequency(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT) {
            if (LuddicChurchHostileActivityFactor.isDefeatedExpedition() || LuddicChurchHostileActivityFactor.getHesperus(true) == null) {
                return 0.0f;
            }
            if (KnightsOfLuddTakeoverExpedition.get() != null) {
                return 0.0f;
            }
            MarketAPI target = this.findExpeditionTarget(intel, stage);
            MarketAPI source = this.getExpeditionSource(intel, stage, target);
            if (target != null && source != null) {
                return 20.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public void rollEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        HostileActivityEventIntel.HAERandomEventData data = new HostileActivityEventIntel.HAERandomEventData(this, stage);
        stage.rollData = data;
        intel.sendUpdateIfPlayerHasIntel((Object)data, false);
    }

    @Override
    public boolean fireEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        MarketAPI target = this.findExpeditionTarget(intel, stage);
        MarketAPI source = this.getExpeditionSource(intel, stage, target);
        if (source == null || target == null) {
            return false;
        }
        stage.rollData = null;
        return this.startExpedition(source, target, stage, this.getRandomizedStageRandom(3));
    }

    public MarketAPI findExpeditionTarget(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<MarketAPI>(this.getRandomizedStageRandom());
        for (MarketAPI market : Misc.getPlayerMarkets(false)) {
            if (market.getStarSystem() == null || !market.hasCondition("luddic_majority")) continue;
            float size = market.getSize();
            float w = Math.max(size - 3.0f, 1.0f);
            w = w * w * w;
            picker.add(market, w);
        }
        return (MarketAPI)picker.pick();
    }

    public MarketAPI getExpeditionSource(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, MarketAPI target) {
        return LuddicChurchHostileActivityFactor.getHesperus(true);
    }

    public static MarketAPI getHesperus(boolean requireMilitaryBase) {
        MarketAPI hesperus = Global.getSector().getEconomy().getMarket("hesperus");
        if (hesperus == null || hesperus.hasCondition("decivilized") || !hesperus.getFactionId().equals("luddic_church")) {
            return null;
        }
        if (requireMilitaryBase) {
            Industry b = hesperus.getIndustry("militarybase");
            if (b == null) {
                b = hesperus.getIndustry("highcommand");
            }
            if (b == null || b.isDisrupted() || !b.isFunctional()) {
                return null;
            }
        }
        return hesperus;
    }

    public boolean startExpedition(MarketAPI source, MarketAPI target, BaseEventIntel.EventStageData stage, Random random) {
        GenericRaidFGI.GenericRaidParams params = new GenericRaidFGI.GenericRaidParams(new Random(random.nextLong()), true);
        params.factionId = source.getFactionId();
        params.source = source;
        params.prepDays = 7.0f + random.nextFloat() * 14.0f;
        params.payloadDays = 180.0f;
        params.makeFleetsHostile = false;
        FGBlockadeAction.FGBlockadeParams bParams = new FGBlockadeAction.FGBlockadeParams();
        bParams.where = target.getStarSystem();
        bParams.targetFaction = "player";
        bParams.specificMarket = target;
        params.noun = "takeover";
        params.forcesNoun = "Luddic forces";
        params.style = FleetCreatorMission.FleetStyle.STANDARD;
        params.fleetSizes.add(10);
        params.fleetSizes.add(4);
        params.fleetSizes.add(4);
        params.fleetSizes.add(3);
        params.fleetSizes.add(3);
        KnightsOfLuddTakeoverExpedition blockade = new KnightsOfLuddTakeoverExpedition(params, bParams);
        blockade.setListener(this);
        Global.getSector().getIntelManager().addIntel(blockade);
        return true;
    }

    @Override
    public void reportFGIAborted(FleetGroupIntel intel) {
        LuddicChurchHostileActivityFactor.setDefeatedExpedition(true);
    }

    @Override
    public void notifyFactorRemoved() {
        Global.getSector().getListenerManager().removeListener(this);
    }

    @Override
    public void notifyEventEnding() {
        this.notifyFactorRemoved();
    }

    @Override
    public void reportRaidForValuablesFinishedBeforeCargoShown(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData, CargoAPI cargo) {
    }

    @Override
    public void reportRaidToDisruptFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData, Industry industry) {
    }

    @Override
    public void reportTacticalBombardmentFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData) {
        BaseEventIntel.EventStageData stage;
        MarketAPI hesperus = LuddicChurchHostileActivityFactor.getHesperus(false);
        if (market != null && market == hesperus && (stage = this.intel.getDataFor((Object)HostileActivityEventIntel.Stage.HA_EVENT)) != null) {
            int points;
            boolean thisEvent;
            boolean bl = thisEvent = stage.rollData instanceof HostileActivityEventIntel.HAERandomEventData && ((HostileActivityEventIntel.HAERandomEventData)stage.rollData).factor == this;
            if (!thisEvent && (points = Global.getSettings().getInt("HA_tacBombardHesperus")) > 0) {
                this.intel.addFactor(new HAHersperusTacBombardmentFactor(-points));
            }
        }
    }

    @Override
    public void reportSaturationBombardmentFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData) {
    }

    @Override
    public void advance(float amount) {
        MarketAPI hesperus;
        super.advance(amount);
        BaseEventIntel.EventStageData stage = this.intel.getDataFor((Object)HostileActivityEventIntel.Stage.HA_EVENT);
        if (stage != null && stage.rollData instanceof HostileActivityEventIntel.HAERandomEventData && ((HostileActivityEventIntel.HAERandomEventData)stage.rollData).factor == this && (hesperus = LuddicChurchHostileActivityFactor.getHesperus(true)) == null) {
            this.intel.resetHA_EVENT();
        }
    }

    @Override
    public void reportColonySizeChanged(MarketAPI market, int prevSize) {
        if (!market.isPlayerOwned()) {
            return;
        }
        boolean matches = LuddicMajority.matchesBonusConditions(market);
        if (market.hasCondition("luddic_majority") && !matches) {
            market.removeCondition("luddic_majority");
        } else if (!market.hasCondition("luddic_majority") && matches) {
            market.addCondition("luddic_majority");
        }
    }
}

