/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events.ht;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HTHighBurnFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HTPoints;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HTScanFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HyperspaceTopographyEventIntel;
import com.fs.starfarer.api.impl.campaign.terrain.PulsarBeamTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.StarCoronaTerrainPlugin;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.LinkedHashSet;

public class HTFactorTracker
implements EveryFrameScript {
    public static float CHECK_DAYS = 0.05f;
    protected IntervalUtil interval = new IntervalUtil(CHECK_DAYS * 0.8f, CHECK_DAYS * 1.2f);
    protected float burnBasedPoints = 0.0f;
    protected float daysSinceAtHighBurn = 1.0f;
    protected boolean canCheckSB = true;
    protected LinkedHashSet<String> scanned = new LinkedHashSet();

    protected Object readResolve() {
        if (this.scanned == null) {
            this.scanned = new LinkedHashSet();
        }
        return this;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    @Override
    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.interval.advance(days);
        if (this.interval.intervalElapsed()) {
            this.checkHighBurn(this.interval.getIntervalDuration());
            this.checkSensorBursts();
        }
    }

    protected void checkHighBurn(float days) {
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        if (pf != null && pf.isInHyperspace()) {
            int chunk;
            float burn = pf.getCurrBurnLevel();
            this.daysSinceAtHighBurn = burn > 20.0f ? 0.0f : (this.daysSinceAtHighBurn += days);
            float add = 0.0f;
            float min = 0.0f;
            float max = 0.0f;
            float f = 0.0f;
            if (burn > 40.0f) {
                min = HTPoints.PER_DAY_AT_BURN_40;
                max = HTPoints.PER_DAY_AT_BURN_50;
                f = (Math.min(burn, (float)HTPoints.MAX_BURN_FOR_POINT_GAIN) - 40.0f) / 10.0f;
            } else if (burn > 30.0f) {
                min = HTPoints.PER_DAY_AT_BURN_30;
                max = HTPoints.PER_DAY_AT_BURN_40;
                f = (burn - 30.0f) / 10.0f;
            } else if (burn > 20.0f) {
                min = HTPoints.PER_DAY_AT_BURN_20;
                max = HTPoints.PER_DAY_AT_BURN_30;
                f = (burn - 20.0f) / 10.0f;
            }
            add = min + (max - min) * f;
            add *= CHECK_DAYS;
            if (pf.getMemoryWithoutUpdate().getBoolean("$noHighBurnTopographyReadings")) {
                add = 0.0f;
            }
            if (add > 0.0f) {
                this.burnBasedPoints += add;
            }
            if (this.burnBasedPoints >= (float)(chunk = HTPoints.BURN_POINT_CHUNK_SIZE) && this.daysSinceAtHighBurn > 0.3f) {
                int mult = (int)this.burnBasedPoints / chunk;
                int points = chunk * mult;
                this.burnBasedPoints -= (float)points;
                HyperspaceTopographyEventIntel.addFactorCreateIfNecessary(new HTHighBurnFactor(points), null);
            }
        } else {
            this.daysSinceAtHighBurn = 1.0f;
        }
    }

    public void checkSensorBursts() {
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        if (pf == null) {
            return;
        }
        AbilityPlugin sb = pf.getAbility("sensor_burst");
        if (sb == null) {
            return;
        }
        if (sb.isUsable() || sb.getLevel() <= 0.0f) {
            this.canCheckSB = true;
        }
        if (this.canCheckSB && !pf.isInHyperspace() && sb.isInProgress() && sb.getLevel() > 0.9f && !pf.getContainingLocation().hasTag("no_topography_scans")) {
            for (SectorEntityToken entity : pf.getContainingLocation().getAllEntities()) {
                this.checkBlackHole(entity);
                this.checkIonStorm(entity);
                this.checkGasGiant(entity);
                this.checkPulsar(entity);
            }
            for (CampaignTerrainAPI terrain : pf.getContainingLocation().getTerrainCopy()) {
                this.checkMagneticField(terrain);
            }
            this.checkSystemCenter();
            this.canCheckSB = false;
        }
    }

    protected void checkBlackHole(SectorEntityToken entity) {
        if (!(entity instanceof PlanetAPI)) {
            return;
        }
        PlanetAPI planet = (PlanetAPI)entity;
        if (!planet.getSpec().isBlackHole()) {
            return;
        }
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        float dist = Misc.getDistance(pf.getLocation(), entity.getLocation());
        StarCoronaTerrainPlugin eventHorizon = Misc.getCoronaFor(planet);
        if (eventHorizon == null) {
            return;
        }
        String id1 = String.valueOf(planet.getId()) + "_1";
        String id2 = String.valueOf(planet.getId()) + "_2";
        float closeRange = planet.getRadius() + 300.0f;
        if (dist < closeRange) {
            if (this.scanned.contains(id2)) {
                this.addMessage("Black hole already scanned at short range");
            } else {
                HyperspaceTopographyEventIntel.addFactorCreateIfNecessary(new HTScanFactor("Black hole scanned at short range (" + planet.getName() + ")", HTPoints.SCAN_BLACK_HOLE_SHORT_RANGE), null);
                this.scanned.add(id2);
            }
        } else if (eventHorizon.containsEntity(pf)) {
            if (this.scanned.contains(id1)) {
                this.addMessage("Black hole already scanned at long range");
            } else {
                HyperspaceTopographyEventIntel.addFactorCreateIfNecessary(new HTScanFactor("Black hole scanned at long range (" + planet.getName() + ")", HTPoints.SCAN_BLACK_HOLE_LONG_RANGE), null);
                this.scanned.add(id1);
            }
        }
    }

    protected void checkIonStorm(SectorEntityToken entity) {
        if (!(entity instanceof PlanetAPI)) {
            return;
        }
        PlanetAPI planet = (PlanetAPI)entity;
        if (!planet.isGasGiant()) {
            return;
        }
        StarCoronaTerrainPlugin ionStorm = Misc.getCoronaFor(planet);
        if (ionStorm == null) {
            return;
        }
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        String id = ionStorm.getEntity().getId();
        if (ionStorm.containsEntity(pf)) {
            if (this.scanned.contains(id)) {
                this.addMessage("Ion storm already scanned");
            } else {
                HyperspaceTopographyEventIntel.addFactorCreateIfNecessary(new HTScanFactor("Ion storm scanned (" + planet.getName() + ")", HTPoints.SCAN_ION_STORM), null);
                this.scanned.add(id);
            }
        }
    }

    protected void checkMagneticField(CampaignTerrainAPI terrain) {
        if (terrain.getPlugin() == null) {
            return;
        }
        if (!"magnetic_field".equals(terrain.getType())) {
            return;
        }
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        String id = terrain.getId();
        if (terrain.getPlugin().containsEntity(pf)) {
            if (this.scanned.contains(id)) {
                this.addMessage("Magnetic field already scanned");
            } else {
                HyperspaceTopographyEventIntel.addFactorCreateIfNecessary(new HTScanFactor("Magnetic field scanned", HTPoints.SCAN_MAGNETIC_FIELD), null);
                this.scanned.add(id);
            }
        }
    }

    protected void checkGasGiant(SectorEntityToken entity) {
        boolean inRange;
        if (!(entity instanceof PlanetAPI)) {
            return;
        }
        PlanetAPI planet = (PlanetAPI)entity;
        if (!planet.isGasGiant()) {
            return;
        }
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        String id = planet.getId();
        float dist = Misc.getDistance(pf.getLocation(), entity.getLocation());
        boolean bl = inRange = dist < 500.0f + planet.getRadius();
        if (inRange) {
            if (this.scanned.contains(id)) {
                this.addMessage("Gas giant already scanned");
            } else {
                HyperspaceTopographyEventIntel.addFactorCreateIfNecessary(new HTScanFactor("Gas giant scanned (" + planet.getName() + ")", HTPoints.SCAN_GAS_GIANT), null);
                this.scanned.add(id);
            }
        }
    }

    protected void checkSystemCenter() {
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        StarSystemAPI system = pf.getStarSystem();
        if (system == null) {
            return;
        }
        String type = null;
        int points = 0;
        switch (system.getType()) {
            case BINARY_CLOSE: {
                type = "Center of binary system";
                points = HTPoints.SCAN_BINARY;
                break;
            }
            case NEBULA: {
                type = "Center of starless nebula";
                points = HTPoints.SCAN_NEBULA;
                break;
            }
            case TRINARY_1CLOSE_1FAR: {
                type = "Center of binary system";
                points = HTPoints.SCAN_BINARY;
                break;
            }
            case TRINARY_2CLOSE: {
                type = "Center of trinary system";
                points = HTPoints.SCAN_TRINARY;
                break;
            }
            default: {
                int count = 0;
                for (PlanetAPI curr : system.getPlanets()) {
                    float dist;
                    if (!curr.isStar() || !((dist = Misc.getDistance(curr.getLocation(), pf.getLocation())) < 2000.0f + curr.getRadius())) continue;
                    ++count;
                }
                if (count <= true) break;
                type = "Stellar conflux";
                points = count == 2 ? HTPoints.SCAN_BINARY : HTPoints.SCAN_TRINARY;
            }
        }
        if (type == null) {
            return;
        }
        String id = "systemtypescan_" + system.getId();
        float range = pf.getLocation().length();
        if (range < 2000.0f) {
            if (this.scanned.contains(id)) {
                this.addMessage("Center of star system already scanned");
            } else {
                HyperspaceTopographyEventIntel.addFactorCreateIfNecessary(new HTScanFactor(String.valueOf(type) + " scanned (" + system.getBaseName() + ")", points), null);
                this.scanned.add(id);
            }
        }
    }

    protected void checkPulsar(SectorEntityToken entity) {
        if (!(entity instanceof PlanetAPI)) {
            return;
        }
        PlanetAPI planet = (PlanetAPI)entity;
        if (!planet.getSpec().isPulsar()) {
            return;
        }
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        StarCoronaTerrainPlugin corona = Misc.getCoronaFor(planet);
        if (corona == null) {
            return;
        }
        PulsarBeamTerrainPlugin pulsar = Misc.getPulsarFor(planet);
        if (pulsar == null) {
            return;
        }
        String id1 = String.valueOf(planet.getId()) + "_1";
        String id2 = String.valueOf(planet.getId()) + "_2";
        if (corona.containsEntity(pf)) {
            if (this.scanned.contains(id2)) {
                this.addMessage("Neutron star already scanned");
            } else {
                HyperspaceTopographyEventIntel.addFactorCreateIfNecessary(new HTScanFactor("Neutron star scanned (" + planet.getName() + ")", HTPoints.SCAN_NEUTRON_STAR), null);
                this.scanned.add(id2);
            }
        }
        if (pulsar.containsEntity(pf)) {
            if (this.scanned.contains(id1)) {
                this.addMessage("Pulsar beam already scanned");
            } else {
                HyperspaceTopographyEventIntel.addFactorCreateIfNecessary(new HTScanFactor("Pulsar beam scanned (" + planet.getName() + ")", HTPoints.SCAN_PULSAR_BEAM), null);
                this.scanned.add(id1);
            }
        }
    }

    protected void addMessage(String text) {
        Global.getSector().getCampaignUI().getMessageDisplay().addMessage(String.valueOf(text) + ", no new topographic data acquired", Misc.getNegativeHighlightColor());
    }
}

