/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.group;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.group.FGAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FGRaidAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FGTravelAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FGWaitAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FleetGroupIntel;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.lwjgl.util.vector.Vector2f;

public class GenericRaidFGI
extends FleetGroupIntel {
    public static String PREPARE_ACTION = "prepare_action";
    public static String TRAVEL_ACTION = "travel_action";
    public static String PAYLOAD_ACTION = "payload_action";
    public static String RETURN_ACTION = "return_action";
    protected GenericRaidParams params;
    protected SectorEntityToken origin;
    protected GenericPayloadAction raidAction;
    protected FGTravelAction travelAction;
    protected FGTravelAction returnAction;
    protected FGWaitAction waitAction;

    public static GenericRaidFGI get(String key) {
        return (GenericRaidFGI)Global.getSector().getMemoryWithoutUpdate().get(key);
    }

    public GenericRaidFGI(GenericRaidParams params) {
        if (params != null) {
            this.params = params;
            this.setRandom(params.random);
            this.initActions();
            if (params.memoryKey != null) {
                Global.getSector().getMemoryWithoutUpdate().set(params.memoryKey, this);
            }
        }
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        if (this.params != null && this.params.memoryKey != null) {
            Global.getSector().getMemoryWithoutUpdate().unset(this.params.memoryKey);
        }
    }

    protected void initActions() {
        this.setFaction(this.params.factionId);
        this.waitAction = new FGWaitAction(this.params.source.getPrimaryEntity(), this.params.prepDays, "preparing for departure");
        this.addAction(this.waitAction, PREPARE_ACTION);
        this.raidAction = this.createPayloadAction();
        this.travelAction = new FGTravelAction(this.params.source.getPrimaryEntity(), this.raidAction.getWhere().getCenter());
        this.addAction(this.travelAction, TRAVEL_ACTION);
        this.addAction(this.raidAction, PAYLOAD_ACTION);
        SectorEntityToken returnWhere = this.params.source.getPrimaryEntity();
        if (returnWhere.getStarSystem() != null) {
            returnWhere = returnWhere.getStarSystem().getCenter();
        }
        this.returnAction = new FGTravelAction(this.raidAction.getWhere().getCenter(), this.params.source.getPrimaryEntity());
        this.returnAction.setTravelText("returning to " + this.params.source.getPrimaryEntity().getName());
        this.addAction(this.returnAction, RETURN_ACTION);
        this.origin = this.params.source.getPrimaryEntity();
        int total = 0;
        for (Integer i : this.params.fleetSizes) {
            total += i.intValue();
        }
        this.createRoute(this.params.factionId, total, this.params.fleetSizes.size(), null, this.params);
    }

    protected GenericPayloadAction createPayloadAction() {
        return new FGRaidAction(this.params.raidParams, this.params.payloadDays);
    }

    @Override
    protected void spawnFleets() {
        Float damage = null;
        if (this.route != null && this.route.getExtra() != null) {
            damage = this.route.getExtra().damage;
        }
        if (damage == null) {
            damage = Float.valueOf(0.0f);
        }
        WeightedRandomPicker<Integer> picker = new WeightedRandomPicker<Integer>(this.getRandom());
        picker.addAll(this.params.fleetSizes);
        int total = 0;
        for (Integer i : this.params.fleetSizes) {
            total += i.intValue();
        }
        float spawnsToSkip = (float)total * damage.floatValue() * 0.5f;
        float skipped = 0.0f;
        while (!picker.isEmpty()) {
            Integer size = (Integer)picker.pickAndRemove();
            if (skipped < spawnsToSkip && this.getRandom().nextFloat() < damage.floatValue()) {
                skipped += (float)size.intValue();
                continue;
            }
            CampaignFleetAPI fleet = this.createFleet(size, damage.floatValue());
            if (fleet == null || this.route == null) continue;
            GenericRaidFGI.setLocationAndCoordinates(fleet, this.route.getCurrent());
            this.fleets.add(fleet);
        }
    }

    protected CampaignFleetAPI createFleet(int size, float damage) {
        Vector2f loc = this.origin.getLocationInHyperspace();
        boolean pirate = this.faction.getCustomBoolean("pirateBehavior");
        FleetCreatorMission m = new FleetCreatorMission(this.getRandom());
        this.preConfigureFleet(size, m);
        m.beginFleet();
        String factionId = this.getFleetCreationFactionOverride(size);
        if (factionId == null) {
            factionId = this.params.factionId;
        }
        m.createFleet(this.params.style, size, factionId, loc);
        m.triggerSetFleetFaction(this.params.factionId);
        m.setFleetSource(this.params.source);
        this.setFleetCreatorQualityFromRoute(m);
        m.setFleetDamageTaken(damage);
        if (pirate) {
            m.triggerSetPirateFleet();
        } else {
            m.triggerSetWarFleet();
        }
        if (this.params.remnant) {
            m.triggerSetRemnantConfigActive();
        }
        if (this.params.makeFleetsHostile) {
            for (MarketAPI market : this.params.raidParams.allowedTargets) {
                m.triggerMakeHostileToFaction(market.getFactionId());
            }
            m.triggerMakeHostile();
            if ("luddic_path".equals(this.faction.getId())) {
                m.triggerFleetPatherNoDefaultTithe();
            }
        }
        if (this.params.repImpact == HubMissionWithTriggers.ComplicationRepImpact.LOW || this.params.repImpact == null) {
            m.triggerMakeLowRepImpact();
        } else if (this.params.repImpact == HubMissionWithTriggers.ComplicationRepImpact.NONE) {
            m.triggerMakeNoRepImpact();
        }
        if (this.params.repImpact != HubMissionWithTriggers.ComplicationRepImpact.FULL) {
            m.triggerMakeAlwaysSpreadTOffHostility();
        }
        this.configureFleet(size, m);
        CampaignFleetAPI fleet = m.createFleet();
        if (fleet != null) {
            this.configureFleet(size, fleet);
        }
        return fleet;
    }

    protected String getFleetCreationFactionOverride(int size) {
        return null;
    }

    protected void preConfigureFleet(int size, FleetCreatorMission m) {
    }

    protected void configureFleet(int size, FleetCreatorMission m) {
    }

    protected void configureFleet(int size, CampaignFleetAPI fleet) {
    }

    protected void addTargetingBulletPoint(TooltipMakerAPI info, Color tc, Object param, IntelInfoPlugin.ListInfoMode mode, float initPad) {
        StarSystemAPI system = this.raidAction.getWhere();
        Color s = this.raidAction.getSystemNameHighlightColor();
        LabelAPI label = info.addPara("Targeting the " + system.getNameWithLowercaseTypeShort(), tc, initPad);
        label.setHighlightColors(s);
        label.setHighlight(system.getNameWithNoType());
    }

    @Override
    protected void addNonUpdateBulletPoints(TooltipMakerAPI info, Color tc, Object param, IntelInfoPlugin.ListInfoMode mode, float initPad) {
        Color h = Misc.getHighlightColor();
        Color s = this.raidAction.getSystemNameHighlightColor();
        FGAction curr = this.getCurrentAction();
        StarSystemAPI system = this.raidAction.getWhere();
        String forces = this.getForcesNoun();
        float untilDeployment = this.getETAUntil(PREPARE_ACTION);
        float untilDeparture = this.getETAUntil(TRAVEL_ACTION);
        float untilRaid = this.getETAUntil(PAYLOAD_ACTION);
        float untilReturn = this.getETAUntil(RETURN_ACTION, true);
        if (!this.isEnding()) {
            if (mode == IntelInfoPlugin.ListInfoMode.MESSAGES || this.getElapsed() <= 0.0f) {
                this.addTargetingBulletPoint(info, tc, param, mode, initPad);
                initPad = 0.0f;
            }
            if (untilDeployment > 0.0f) {
                this.addETABulletPoints(null, null, false, untilDeployment, FleetGroupIntel.ETAType.DEPLOYMENT, info, tc, initPad);
                initPad = 0.0f;
            } else if (untilDeparture > 0.0f) {
                this.addETABulletPoints(null, null, false, untilDeparture, FleetGroupIntel.ETAType.DEPARTURE, info, tc, initPad);
                initPad = 0.0f;
            }
            if (untilRaid > 0.0f && this.getSource().getContainingLocation() != system) {
                this.addETABulletPoints(system.getNameWithLowercaseTypeShort(), s, false, untilRaid, FleetGroupIntel.ETAType.ARRIVING, info, tc, initPad);
                initPad = 0.0f;
            }
            if (untilReturn > 0.0f && RETURN_ACTION.equals(curr.getId()) && this.getSource().getContainingLocation() != system && mode != IntelInfoPlugin.ListInfoMode.INTEL) {
                StarSystemAPI from = this.getSource().getStarSystem();
                this.addETABulletPoints(from.getNameWithLowercaseTypeShort(), null, false, untilReturn, FleetGroupIntel.ETAType.RETURNING, info, tc, initPad);
                initPad = 0.0f;
            }
            if ((mode == IntelInfoPlugin.ListInfoMode.INTEL || mode == IntelInfoPlugin.ListInfoMode.MAP_TOOLTIP) && curr != null && curr.getId().equals(PAYLOAD_ACTION)) {
                LabelAPI label = info.addPara("Operating in the " + system.getNameWithLowercaseTypeShort(), tc, initPad);
                label.setHighlightColors(s);
                label.setHighlight(system.getNameWithNoType());
                initPad = 0.0f;
            }
        }
        if (mode != IntelInfoPlugin.ListInfoMode.IN_DESC && this.isEnding() && !this.isSucceeded()) {
            if (!this.isAborted() && !this.isFailed()) {
                info.addPara("The " + forces + " have failed to achieve their objective", tc, initPad);
            } else if (this.isFailedButNotDefeated()) {
                info.addPara("The " + forces + " have failed to achieve their objective", tc, initPad);
            } else {
                info.addPara("The " + forces + " have been defeated and scatter", tc, initPad);
            }
        }
    }

    @Override
    protected void addUpdateBulletPoints(TooltipMakerAPI info, Color tc, Object param, IntelInfoPlugin.ListInfoMode mode, float initPad) {
        StarSystemAPI system = this.raidAction.getWhere();
        String forces = this.getForcesNoun();
        String noun = this.getNoun();
        Color s = this.raidAction.getSystemNameHighlightColor();
        if (ABORT_UPDATE.equals(param)) {
            if (this.isInPreLaunchDelay()) {
                info.addPara("The " + noun + " was aborted in the planning stages", tc, initPad);
            } else {
                info.addPara("The " + forces + " have been defeated and scatter", tc, initPad);
            }
        } else if (FLEET_LAUNCH_UPDATE.equals(param)) {
            float untilDeparture = this.getETAUntil(TRAVEL_ACTION);
            float untilRaid = this.getETAUntil(PAYLOAD_ACTION);
            info.addPara("Fleet deployment in progress", tc, initPad);
            initPad = 0.0f;
            if (untilDeparture > 0.0f) {
                this.addETABulletPoints(null, null, false, untilDeparture, FleetGroupIntel.ETAType.DEPARTURE, info, tc, initPad);
            }
            if (untilRaid > 0.0f && this.getSource().getContainingLocation() != system) {
                this.addETABulletPoints(system.getNameWithLowercaseTypeShort(), s, false, untilRaid, FleetGroupIntel.ETAType.ARRIVING, info, tc, initPad);
            }
        } else if (PREPARE_ACTION.equals(param)) {
            float untilRaid = this.getETAUntil(PAYLOAD_ACTION);
            this.addETABulletPoints(system.getNameWithLowercaseTypeShort(), s, true, untilRaid, FleetGroupIntel.ETAType.ARRIVING, info, tc, initPad);
        } else if (TRAVEL_ACTION.equals(param)) {
            this.addArrivedBulletPoint(system.getNameWithLowercaseTypeShort(), s, info, tc, initPad);
        } else if (PAYLOAD_ACTION.equals(param)) {
            if (this.isSucceeded()) {
                info.addPara("The " + forces + " are withdrawing", tc, initPad);
            } else if (this.isAborted()) {
                info.addPara("The " + forces + " have been defeated and scatter", tc, initPad);
            } else {
                info.addPara("The " + forces + " have failed to achieve their objective", tc, initPad);
            }
        }
    }

    @Override
    protected boolean shouldSendIntelUpdateWhenActionFinished(FGAction action) {
        if (RETURN_ACTION.equals(action.getId())) {
            return false;
        }
        if (PAYLOAD_ACTION.equals(action.getId())) {
            return this.isSucceeded() || this.isFailed() && !this.isAborted();
        }
        if (TRAVEL_ACTION.equals(action.getId())) {
            if (action instanceof FGTravelAction && (this.isAborted() || this.isFailed())) {
                return false;
            }
            return this.getSource().getContainingLocation() != this.raidAction.getWhere();
        }
        return super.shouldSendIntelUpdateWhenActionFinished(action);
    }

    @Override
    protected void addBasicDescription(TooltipMakerAPI info, float width, float height, float opad) {
        info.addImage(this.getFaction().getLogo(), width, 128.0f, opad);
        StarSystemAPI system = this.raidAction.getWhere();
        String noun = this.getNoun();
        info.addPara(String.valueOf(Misc.ucFirst(this.faction.getPersonNamePrefixAOrAn())) + " %s " + noun + " against " + "the " + system.getNameWithLowercaseTypeShort() + ".", opad, this.faction.getBaseUIColor(), this.faction.getPersonNamePrefix());
    }

    @Override
    protected void addAssessmentSection(TooltipMakerAPI info, float width, float height, float opad) {
        Color h = Misc.getHighlightColor();
        FactionAPI faction = this.getFaction();
        List<MarketAPI> targets = this.params.raidParams.allowedTargets;
        String noun = this.getNoun();
        if (!(this.isEnding() || this.isSucceeded() || this.isFailed())) {
            info.addSectionHeading("Assessment", faction.getBaseUIColor(), faction.getDarkUIColor(), Alignment.MID, opad);
            if (targets.isEmpty()) {
                info.addPara("There are no colonies for the " + noun + " to target in the system.", opad);
            } else {
                String forces;
                StarSystemAPI system = this.raidAction.getWhere();
                boolean potentialDanger = this.addStrengthDesc(info, opad, system, forces = this.getForcesNoun(), "the " + noun + " is unlikely to find success", "the outcome of the " + noun + " is uncertain", "the " + noun + " is likely to find success");
                if (potentialDanger) {
                    String safe = "should be safe from the " + noun;
                    String risk = "are at risk of being raided and losing stability:";
                    String highlight = "losing stability:";
                    if (this.params.raidParams.bombardment == MarketCMD.BombardType.SATURATION) {
                        risk = "are at risk of suffering a saturation bombardment resulting in catastrophic damage:";
                        highlight = "catastrophic damage";
                    } else if (this.params.raidParams.bombardment == MarketCMD.BombardType.TACTICAL) {
                        risk = "are at risk of suffering a tactical bombardment and having their military infrastructure disrupted:";
                        highlight = "military infrastructure disrupted";
                    } else if (!this.params.raidParams.disrupt.isEmpty()) {
                        risk = "are at risk of being raided and having their operations severely disrupted";
                        highlight = "operations severely disrupted";
                    }
                    if (this.getAssessmentRiskStringOverride() != null) {
                        risk = this.getAssessmentRiskStringOverride();
                    }
                    if (this.getAssessmentRiskStringHighlightOverride() != null) {
                        highlight = this.getAssessmentRiskStringHighlightOverride();
                    }
                    this.showMarketsInDanger(info, opad, width, system, targets, safe, risk, highlight);
                }
            }
            this.addPostAssessmentSection(info, width, height, opad);
        }
    }

    protected void addPostAssessmentSection(TooltipMakerAPI info, float width, float height, float opad) {
    }

    protected String getAssessmentRiskStringOverride() {
        return null;
    }

    protected String getAssessmentRiskStringHighlightOverride() {
        return null;
    }

    protected void addPayloadActionStatus(TooltipMakerAPI info, float width, float height, float opad) {
        StarSystemAPI to = this.raidAction.getWhere();
        info.addPara("Conducting operations in the " + to.getNameWithLowercaseTypeShort() + ".", opad);
    }

    @Override
    protected void addStatusSection(TooltipMakerAPI info, float width, float height, float opad) {
        boolean showStatus;
        FGAction curr = this.getCurrentAction();
        boolean bl = showStatus = curr != null || this.isEnding() || this.isSucceeded();
        if (showStatus) {
            String noun = this.getNoun();
            String forces = this.getForcesNoun();
            info.addSectionHeading("Status", this.faction.getBaseUIColor(), this.faction.getDarkUIColor(), Alignment.MID, opad);
            if (this.isEnding() && !this.isSucceeded()) {
                if (this.isFailed() || this.isAborted()) {
                    if (this.isFailedButNotDefeated()) {
                        info.addPara("The " + forces + " are withdrawing.", opad);
                    } else {
                        info.addPara("The " + forces + " have been defeated and any " + "remaining ships are retreating in disarray.", opad);
                    }
                } else {
                    info.addPara("The " + forces + " are withdrawing.", opad);
                }
            } else if (this.isEnding() || this.isSucceeded()) {
                info.addPara("The " + noun + " was successful and the " + forces + " are withdrawing.", opad);
            } else if (curr != null) {
                StarSystemAPI to = this.raidAction.getWhere();
                if (this.isInPreLaunchDelay()) {
                    if (this.getSource().getMarket() != null) {
                        BaseHubMission.addStandardMarketDesc("The " + noun + " is in the planning stages on", this.getSource().getMarket(), info, opad);
                        boolean mil = this.isSourceFunctionalMilitaryMarket();
                        if (mil) {
                            info.addPara("Disrupting the military facilities " + this.getSource().getMarket().getOnOrAt() + " " + this.getSource().getMarket().getName() + " will abort the " + noun + ".", opad);
                        }
                    }
                } else if (PREPARE_ACTION.equals(curr.getId())) {
                    if (this.getSource().getMarket() != null) {
                        BaseHubMission.addStandardMarketDesc("Making preparations in orbit around", this.getSource().getMarket(), info, opad);
                    } else {
                        info.addPara("Making preparations in orbit around " + this.getSource().getName() + ".", opad);
                    }
                } else if (TRAVEL_ACTION.equals(curr.getId())) {
                    if (this.getSource().getMarket() == null) {
                        info.addPara("Traveling to the " + to.getNameWithLowercaseTypeShort() + ".", opad);
                    } else {
                        info.addPara("Traveling from " + this.getSource().getMarket().getName() + " to the " + to.getNameWithLowercaseTypeShort() + ".", opad);
                    }
                } else if (RETURN_ACTION.equals(curr.getId())) {
                    if (this.getSource().getMarket() == null) {
                        info.addPara("Returning to their port of origin.", opad);
                    } else {
                        info.addPara("Returning to " + this.getSource().getMarket().getName() + " in the " + this.origin.getContainingLocation().getNameWithLowercaseTypeShort() + ".", opad);
                    }
                } else if (PAYLOAD_ACTION.equals(curr.getId())) {
                    this.addPayloadActionStatus(info, width, height, opad);
                }
            }
        }
    }

    public String getNoun() {
        if (this.params.noun != null) {
            return this.params.noun;
        }
        String noun = "raid";
        if (this.params.raidParams.bombardment != null) {
            noun = "attack";
        }
        return noun;
    }

    public String getForcesNoun() {
        if (this.params.forcesNoun != null) {
            return this.params.forcesNoun;
        }
        String forces = "raiding forces";
        if (!this.getNoun().equals("raid")) {
            forces = "attacking forces";
        }
        return forces;
    }

    @Override
    public String getBaseName() {
        return String.valueOf(Misc.ucFirst(this.getFaction().getPersonNamePrefix())) + " " + Misc.ucFirst(this.getNoun());
    }

    @Override
    public boolean isSucceeded() {
        return this.raidAction.getSuccessFraction() > 0.0f && this.raidAction.isActionFinished() && !this.isAborted();
    }

    @Override
    public boolean isFailed() {
        return this.isAborted() || this.raidAction.getSuccessFraction() <= 0.0f && this.raidAction.isActionFinished();
    }

    @Override
    protected SectorEntityToken getSource() {
        return this.origin;
    }

    @Override
    protected SectorEntityToken getDestination() {
        return this.raidAction.getWhere().getHyperspaceAnchor();
    }

    protected StarSystemAPI getTargetSystem() {
        return this.raidAction.getWhere();
    }

    public GenericPayloadAction getRaidAction() {
        return this.raidAction;
    }

    public FGTravelAction getTravelAction() {
        return this.travelAction;
    }

    public FGTravelAction getReturnAction() {
        return this.returnAction;
    }

    public FGWaitAction getWaitAction() {
        return this.waitAction;
    }

    @Override
    public String getCommMessageSound() {
        if (this.isSendingUpdate()) {
            return GenericRaidFGI.getSoundStandardUpdate();
        }
        if (this.params.playerTargeted) {
            return GenericRaidFGI.getSoundColonyThreat();
        }
        return super.getCommMessageSound();
    }

    @Override
    public boolean isPlayerTargeted() {
        return this.params.playerTargeted;
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        return super.getIntelTags(map);
    }

    @Override
    public List<IntelInfoPlugin.ArrowData> getArrowData(SectorMapAPI map) {
        if (this.isAborted() || this.isFailed() || this.isSucceeded() || this.isEnded() || this.isEnding()) {
            return null;
        }
        return super.getArrowData(map);
    }

    public GenericRaidParams getParams() {
        return this.params;
    }

    public void setOrigin(SectorEntityToken origin) {
        this.origin = origin;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        if (this.getCurrentAction() != null && PREPARE_ACTION.equals(this.getCurrentAction().getId()) || this.getDelayRemaining() > 0.0f) {
            return this.getSource();
        }
        return this.getDestination();
    }

    public boolean hasCustomRaidAction() {
        return false;
    }

    public void doCustomRaidAction(CampaignFleetAPI fleet, MarketAPI market, float raidStr) {
    }

    public void setFleetCreatorQualityFromRoute(FleetCreatorMission m) {
        if (m == null || this.route == null || this.route.getExtra() == null || this.route.getExtra().quality == null) {
            return;
        }
        m.getPreviousCreateFleetAction().qualityOverride = this.route.getExtra().quality;
    }

    public static interface GenericPayloadAction
    extends FGAction {
        public Color getSystemNameHighlightColor();

        public float getSuccessFraction();

        public StarSystemAPI getWhere();
    }

    public static class GenericRaidParams {
        public Random random = new Random();
        public boolean playerTargeted;
        public boolean remnant = false;
        public MarketAPI source;
        public String factionId;
        public List<Integer> fleetSizes = new ArrayList<Integer>();
        public FleetCreatorMission.FleetStyle style = FleetCreatorMission.FleetStyle.STANDARD;
        public FGRaidAction.FGRaidParams raidParams = new FGRaidAction.FGRaidParams();
        public float prepDays = 5.0f;
        public float payloadDays = 30.0f;
        public boolean makeFleetsHostile = true;
        public HubMissionWithTriggers.ComplicationRepImpact repImpact = HubMissionWithTriggers.ComplicationRepImpact.LOW;
        public String noun;
        public String forcesNoun;
        public Object custom;
        public String memoryKey = null;

        public GenericRaidParams(Random random, boolean playerTargeted) {
            this.random = random;
            this.playerTargeted = playerTargeted;
        }
    }
}

