/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.listeners.CoreDiscoverEntityPlugin;
import com.fs.starfarer.api.impl.campaign.intel.misc.FleetLogIntel;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Set;

public class SurveyDataForPlanetIntel
extends FleetLogIntel {
    protected String longText;
    protected PlanetAPI planet;

    public SurveyDataForPlanetIntel(PlanetAPI planet, String longText, TextPanelAPI textPanel) {
        this.planet = planet;
        this.longText = longText;
        this.setSound("ui_discovered_entity");
        this.setIconId("found_planet_data");
        this.setRemoveTrigger(planet);
        this.setListInfoParam(DISCOVERED_PARAM);
        Global.getSector().getIntelManager().addIntel(this, false, textPanel);
        this.setListInfoParam(null);
        if (planet.getStarSystem() != null && Misc.hasUnexploredRuins(planet.getMarket())) {
            CoreDiscoverEntityPlugin.addSalvorsTallyIfNeeded(planet.getStarSystem());
        }
    }

    @Override
    protected String getName() {
        String classStr = Misc.getPlanetSurveyClass(this.planet);
        String name = "Survey Data: " + classStr + " " + this.planet.getTypeNameWithWorld();
        return name;
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        initPad = 0.0f;
        this.unindent(info);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        TooltipMakerAPI.PlanetInfoParams params = new TooltipMakerAPI.PlanetInfoParams();
        params.showConditions = true;
        params.showName = true;
        params.withClass = true;
        params.scaleEvenWhenShowingName = true;
        params.conditionsYOffset = 32.0f;
        params.showHazardRating = true;
        info.showPlanetInfo(this.planet, width, width / 1.62f, params, opad + params.conditionsYOffset);
        info.addPara(this.longText, opad + 18.0f);
        this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        this.addLogTimestamp(info, tc, opad);
        this.addDeleteButton(info, width);
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.remove("Fleet log");
        tags.add("Exploration");
        return tags;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.planet;
    }
}

