/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.intel.misc.MapMarkerIntel;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class WormholeIntel
extends MapMarkerIntel {
    public WormholeIntel(SectorEntityToken entity, TextPanelAPI textPanel, boolean deployed) {
        String title = entity.getName();
        String text = null;
        this.setSound("ui_discovered_entity");
        if (deployed) {
            this.setDiscoveredPrefixOverride("Deployed: ");
        }
        this.setWithDeleteButton(false);
        this.init(entity, title, text, null, true, textPanel);
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("intel", "wormhole");
    }

    @Override
    protected boolean withTextInDesc() {
        return true;
    }

    @Override
    protected boolean withCustomVisual() {
        return true;
    }

    @Override
    protected boolean withCustomDescription() {
        return true;
    }

    @Override
    protected void addCustomVisual(TooltipMakerAPI info, float width, float height) {
        info.addImage(Global.getSettings().getSpriteName("illustrations", "jump_point_wormhole"), width, 10.0f);
    }

    @Override
    protected void addCustomDescription(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        info.addPara("Wormholes can be used for rapid transit between termini located many light-years apart.", opad);
    }

    @Override
    protected void addExtraBulletPoints(TooltipMakerAPI info, Color tc, float initPad, IntelInfoPlugin.ListInfoMode mode) {
        if (!(this.entity instanceof JumpPointAPI)) {
            return;
        }
        JumpPointAPI jumpPoint = (JumpPointAPI)this.entity;
        float dur = jumpPoint.getMemoryWithoutUpdate().getExpire("$unstable");
        if (dur > 0.0f) {
            String durStr = "" + (int)dur;
            String days = "days";
            if ((int)dur == 1) {
                days = "day";
            }
            if ((int)dur <= 0) {
                days = "day";
                durStr = "1";
            }
            info.addPara("%s " + days + " until stabilized", initPad, tc, Misc.getHighlightColor(), durStr);
        }
    }

    @Override
    protected void addPostDescriptionSection(TooltipMakerAPI info, float width, float height, float opad) {
    }

    public static WormholeIntel getWormholeIntel(SectorEntityToken entity) {
        for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(WormholeIntel.class)) {
            if (((WormholeIntel)intel).getEntity() != entity) continue;
            return (WormholeIntel)intel;
        }
        return null;
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Gates");
        return tags;
    }

    @Override
    public String getSortString() {
        if (this.getTagsForSort().contains("Fleet log") || this.getTagsForSort().contains("Exploration")) {
            return super.getSortString();
        }
        return "AAAA";
    }

    @Override
    public List<IntelInfoPlugin.ArrowData> getArrowData(SectorMapAPI map) {
        if (!(this.entity instanceof JumpPointAPI)) {
            return null;
        }
        JumpPointAPI jp = (JumpPointAPI)this.entity;
        ArrayList<IntelInfoPlugin.ArrowData> result = new ArrayList<IntelInfoPlugin.ArrowData>();
        for (JumpPointAPI.JumpDestination dest : jp.getDestinations()) {
            SectorEntityToken target = dest.getDestination();
            if (WormholeIntel.getWormholeIntel(target) == null) continue;
            IntelInfoPlugin.ArrowData arrow = new IntelInfoPlugin.ArrowData(this.entity, target);
            arrow.color = new Color(255, 75, 255, 255);
            arrow.width = 7.0f;
            result.add(arrow);
        }
        return result;
    }
}

