/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.punitive;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.punitive.PunitiveExpeditionIntel;
import com.fs.starfarer.api.impl.campaign.intel.punitive.PunitiveExpeditionManager;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.SetStoryOption;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Map;

public class PEAvertInteractionDialogPluginImpl
implements InteractionDialogPlugin {
    public static int BRIBE_MULT = 10000;
    public static int BRIBE_MAX = 100000;
    public static RepLevel MIN_REP = RepLevel.WELCOMING;
    public static float REP_COST = 0.2f;
    protected InteractionDialogAPI dialog;
    protected TextPanelAPI textPanel;
    protected OptionPanelAPI options;
    protected VisualPanelAPI visual;
    protected CampaignFleetAPI playerFleet;
    protected PunitiveExpeditionIntel intel;
    protected IntelUIAPI ui;
    protected OptionId beingConfirmed = null;

    public PEAvertInteractionDialogPluginImpl(PunitiveExpeditionIntel intel, IntelUIAPI ui) {
        this.intel = intel;
        this.ui = ui;
    }

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.visual.setVisualFade(0.25f, 0.25f);
        this.visual.showPlanetInfo(this.intel.getTarget().getPrimaryEntity());
        dialog.setOptionOnEscape("Leave", (Object)OptionId.LEAVE);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return null;
    }

    @Override
    public void backFromEngagement(EngagementResultAPI result) {
    }

    protected int computeBribeAmount() {
        int bribe;
        PunitiveExpeditionManager.PunExData data = PunitiveExpeditionManager.getInstance().getDataFor(this.intel.getFaction());
        int numAttempts = 1;
        if (data != null) {
            numAttempts = data.numAttempts;
        }
        if ((bribe = (int)(Math.pow(2.0, numAttempts) * (double)BRIBE_MULT)) > BRIBE_MAX) {
            bribe = BRIBE_MAX;
        }
        return bribe;
    }

    protected void printOptionDesc(OptionId option) {
        Color tc = Misc.getTextColor();
        FactionAPI faction = this.intel.getFaction();
        switch (option) {
            case BRIBE: {
                int bribe = this.computeBribeAmount();
                this.textPanel.addPara("Sufficient funding allocated to proper official and unofficial actors should ensure that the expedition does not go beyond the planning stages.");
                int credits = (int)this.playerFleet.getCargo().getCredits().get();
                Color costColor = Misc.getHighlightColor();
                if (bribe > credits) {
                    costColor = Misc.getNegativeHighlightColor();
                }
                this.textPanel.addPara("A total of %s should be enough to get the job done, and will also ensure that your standing with " + faction.getDisplayNameWithArticle() + " does not suffer.", costColor, Misc.getDGSCredits(bribe));
                this.textPanel.addPara("You have %s available.", Misc.getHighlightColor(), Misc.getDGSCredits(credits));
                break;
            }
            case USE_CONNECTIONS: {
                boolean canUseConnections = faction.isAtWorst("player", MIN_REP);
                if (canUseConnections) {
                    this.textPanel.addPara("You can use your connections to pull a few strings and ensure the operation never gets beyond the planning stages.");
                } else {
                    this.textPanel.addPara("You do not have sufficient connections with " + faction.getPersonNamePrefix() + " officials to stall out this kind of an operation.");
                    CoreReputationPlugin.addRequiredStanding(faction, MIN_REP, null, this.textPanel, null, tc, 0.0f, true);
                }
                CoreReputationPlugin.addCurrentStanding(faction, null, this.textPanel, null, tc, 0.0f);
                if (!canUseConnections) break;
                this.textPanel.addPara("Calling in these favors will reduce your standing with " + faction.getDisplayNameWithArticle() + " by %s points.", Misc.getHighlightColor(), "" + Math.round(REP_COST * 100.0f));
            }
        }
    }

    protected void addChoiceOptions() {
        this.options.clearOptions();
        this.options.addOption("Allocate sufficient funds for bribes and other means of disrupting the planning", (Object)OptionId.BRIBE, null);
        this.options.addOption("Use your connections to disrupt the planning", (Object)OptionId.USE_CONNECTIONS, null);
        this.dialog.setOptionColor((Object)OptionId.BRIBE, Misc.getStoryOptionColor());
        this.options.addOption("Dismiss", (Object)OptionId.LEAVE, null);
        this.options.setShortcut((Object)OptionId.LEAVE, 1, false, false, false, true);
    }

    protected void addDismissOption() {
        this.options.clearOptions();
        this.options.addOption("Dismiss", (Object)OptionId.LEAVE, null);
        this.options.setShortcut((Object)OptionId.LEAVE, 1, false, false, false, true);
    }

    protected void addConfirmOptions() {
        FactionAPI faction;
        boolean canUseConnections;
        if (this.beingConfirmed == null) {
            return;
        }
        this.options.clearOptions();
        this.printOptionDesc(this.beingConfirmed);
        this.options.addOption("Take the necessary actions", (Object)OptionId.CONFIRM, null);
        this.options.addOption("Never mind", (Object)OptionId.CANCEL, null);
        this.options.setShortcut((Object)OptionId.CANCEL, 1, false, false, false, true);
        if (this.beingConfirmed == OptionId.BRIBE) {
            SetStoryOption.set(this.dialog, 1, (Object)OptionId.CONFIRM, "bribePunitiveExpedition", Sounds.STORY_POINT_SPEND_INDUSTRY, "Issued bribe to avert " + this.intel.getFaction().getDisplayName() + " punitive expedition");
            int bribe = this.computeBribeAmount();
            if ((float)bribe > this.playerFleet.getCargo().getCredits().get()) {
                this.options.setEnabled((Object)OptionId.CONFIRM, false);
                this.options.setTooltip((Object)OptionId.CONFIRM, "Not enough credits.");
            }
        } else if (this.beingConfirmed == OptionId.USE_CONNECTIONS && !(canUseConnections = (faction = this.intel.getFaction()).isAtWorst("player", MIN_REP))) {
            this.options.setEnabled((Object)OptionId.CONFIRM, false);
            this.options.setTooltip((Object)OptionId.CONFIRM, "Standing not high enough.");
        }
    }

    public void printInit() {
        TooltipMakerAPI info = this.textPanel.beginTooltip();
        info.setParaSmallInsignia();
        this.intel.addInitialDescSection(info, 0.0f);
        this.textPanel.addTooltip();
        this.textPanel.addPara("The operation is still in the planning stages, and you have several options at your disposal to ensure it never gets off the ground.");
    }

    @Override
    public void optionSelected(String text, Object optionData) {
        if (optionData == null) {
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        if (text != null) {
            this.dialog.addOptionSelectedText((Object)option);
        }
        switch (option) {
            case INIT: {
                this.printInit();
                this.addChoiceOptions();
                break;
            }
            case BRIBE: {
                this.beingConfirmed = OptionId.BRIBE;
                this.addConfirmOptions();
                break;
            }
            case USE_CONNECTIONS: {
                this.beingConfirmed = OptionId.USE_CONNECTIONS;
                this.addConfirmOptions();
                break;
            }
            case CONFIRM: {
                if (this.beingConfirmed == OptionId.BRIBE) {
                    int bribe = this.computeBribeAmount();
                    AddRemoveCommodity.addCreditsLossText(bribe, this.textPanel);
                    this.playerFleet.getCargo().getCredits().subtract(bribe);
                } else if (this.beingConfirmed == OptionId.USE_CONNECTIONS) {
                    CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
                    impact.delta = -REP_COST;
                    ReputationActionResponsePlugin.ReputationAdjustmentResult reputationAdjustmentResult = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, this.textPanel, false, true), this.intel.getFaction().getId());
                }
                this.intel.getOrganizeStage().abort();
                this.intel.setOutcome(PunitiveExpeditionIntel.PunExOutcome.AVERTED);
                this.intel.forceFail(false);
                this.intel.sendUpdate(PunitiveExpeditionIntel.OUTCOME_UPDATE, this.textPanel);
                this.addDismissOption();
                break;
            }
            case CANCEL: {
                this.addChoiceOptions();
                break;
            }
            case LEAVE: {
                this.leave();
            }
        }
    }

    protected void leave() {
        this.dialog.dismiss();
        this.ui.updateUIForItem(this.intel);
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public void advance(float amount) {
    }

    @Override
    public Object getContext() {
        return null;
    }

    private static enum OptionId {
        INIT,
        USE_CONNECTIONS,
        BRIBE,
        LEAVE,
        CONFIRM,
        CANCEL;

    }
}

