/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.academy;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.academy.GABaseMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.TransmitterTrapSpecial;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;

public class GATransverseJump
extends GABaseMission {
    protected StarSystemAPI system;
    protected PlanetAPI planet;
    protected PersonAPI researcher;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$gaTJ_ref")) {
            return false;
        }
        this.resetSearch();
        this.requireSystemTags(ReqMode.ANY, "theme_misc", "theme_misc_skip", "theme_ruins");
        this.requireSystemTags(ReqMode.NOT_ANY, "theme_unsafe", "theme_core");
        this.requireSystemNotAlreadyUsedForStory();
        this.requireSystemNotHasPulsar();
        this.requireSystemHasAtLeastNumJumpPoints(2);
        this.preferSystemHasAtLeastNumJumpPoints(3);
        this.preferSystemOnFringeOfSector();
        this.preferSystemUnexplored();
        this.requirePlanetNotStar();
        this.requirePlanetUnpopulated();
        this.requirePlanetNotGasGiant();
        this.preferPlanetNotNearJumpPoint(5000.0f);
        this.preferPlanetNotNearJumpPoint(2000.0f);
        this.preferPlanetNotFullySurveyed();
        this.planet = this.pickPlanet();
        if (this.planet == null) {
            return false;
        }
        this.system = this.planet.getStarSystem();
        this.setStartingStage((Object)Stage.GO_TO_OUTPOST);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.addFailureStages(new Object[]{Stage.FAILED});
        this.setStoryMission();
        this.makeImportant(this.planet, "$gaTJ_targetPlanet", Stage.GO_TO_OUTPOST);
        this.makeImportant(this.getPerson(), "$gaTJ_needToReturn", Stage.RETURN_TO_ACADEMY);
        this.connectWithGlobalFlag((Object)Stage.GO_TO_OUTPOST, (Object)Stage.RETURN_TO_ACADEMY, "$gaTJ_needToReturn");
        this.setStageOnGlobalFlag((Object)Stage.COMPLETED, "$gaTJ_completed");
        this.setCreditReward(BaseHubMission.CreditReward.HIGH);
        this.researcher = Global.getSector().getFaction("independent").createRandomPerson(this.genRandom);
        this.researcher.setRankId(Ranks.CITIZEN);
        this.researcher.setPostId(Ranks.POST_ACADEMICIAN);
        List<SectorEntityToken> jumpPoints = this.system.getJumpPoints();
        for (SectorEntityToken point : jumpPoints) {
            this.addMercFleet(point);
        }
        this.beginStageTrigger(new Object[]{Stage.COMPLETED});
        this.triggerSetGlobalMemoryValuePermanent("$asebSayBairdWantsToTalk", true);
        this.endTrigger();
        this.setSystemWasUsedForStory((Object)Stage.GO_TO_OUTPOST, this.system);
        return true;
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog != null && action.equals("showResearcher")) {
            this.showPersonInfo(this.researcher, dialog, false, false);
            return true;
        }
        if ("triggerMercFleets".equals(action)) {
            for (CampaignFleetAPI fleet : this.system.getFleets()) {
                if (!fleet.getMemoryWithoutUpdate().contains("$gaTJ_merc")) continue;
                TransmitterTrapSpecial.makeFleetInterceptPlayer(fleet, true, false, true, 1000.0f);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$gaTJ_planetId", this.planet.getId());
        this.set("$gaTJ_planetName", this.planet.getName());
        this.set("$gaTJ_systemName", this.planet.getStarSystem().getNameWithNoType());
        this.set("$gaTJ_dist", this.getDistanceLY(this.planet));
        this.set("$gaTJ_reward", Misc.getWithDGS(this.getCreditsReward()));
        this.set("$gaTJ_researcherName", this.researcher.getNameString());
        this.set("$gaTJ_heOrShe", this.researcher.getHeOrShe());
        this.set("$gaTJ_HeOrShe", String.valueOf(this.researcher.getHeOrShe().substring(0, 1).toUpperCase()) + this.researcher.getHeOrShe().substring(1));
        this.set("$gaTJ_hisOrHer", this.researcher.getHisOrHer());
        this.set("$gaTJ_HisOrHet", String.valueOf(this.researcher.getHisOrHer().substring(0, 1).toUpperCase()) + this.researcher.getHisOrHer().substring(1));
        this.set("$gaTJ_himOrHer", this.researcher.getHimOrHer());
        this.set("$gaTJ_HimOrHet", String.valueOf(this.researcher.getHimOrHer().substring(0, 1).toUpperCase()) + this.researcher.getHimOrHer().substring(1));
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_OUTPOST) {
            info.addPara(String.valueOf(this.getGoToPlanetTextPre(this.planet)) + ", and contact the 'researcher' at the Tri-Tachyon black research site located there.", opad);
        } else if (this.currentStage == Stage.RETURN_TO_ACADEMY) {
            info.addPara(String.valueOf(this.getReturnText("the Galatia Academy")) + ".", opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_OUTPOST) {
            info.addPara(this.getGoToPlanetTextShort(this.planet), tc, pad);
            return true;
        }
        if (this.currentStage == Stage.RETURN_TO_ACADEMY) {
            info.addPara(this.getReturnTextShort("the Galatia Academy"), tc, pad);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "Extract 'Researcher'";
    }

    protected void addMercFleet(SectorEntityToken patrolPoint) {
        this.beginWithinHyperspaceRangeTrigger(this.planet, 3.0f, false, new Object[]{Stage.GO_TO_OUTPOST});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.VERY_HIGH, "mercenary", "patrolLarge", this.system);
        this.triggerSetFleetFaction("independent");
        this.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
        this.triggerMakeHostileAndAggressive();
        this.triggerMakeNoRepImpact();
        this.triggerFleetAllowLongPursuit();
        this.triggerSetFleetAlwaysPursue();
        this.triggerPickLocationAroundEntity(patrolPoint, 1000.0f);
        this.triggerSpawnFleetAtPickedLocation("$gaTJ_merc", null);
        this.triggerOrderFleetPatrol(true, patrolPoint);
        this.endTrigger();
    }

    public static enum Stage {
        GO_TO_OUTPOST,
        RETURN_TO_ACADEMY,
        COMPLETED,
        FAILED;

    }
}

