/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;

public class IsSoughtByPatrols
extends BaseCommandPlugin {
    public static boolean areFactionPatrolsSeekingPlayer(String factionId) {
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        for (CampaignFleetAPI fleet : playerFleet.getContainingLocation().getFleets()) {
            if (!fleet.getFaction().getId().equals(factionId) || !IsSoughtByPatrols.isPatrol(fleet) || fleet.getFaction().isPlayerFaction() || fleet.getBattle() != null) continue;
            MemoryAPI mem = fleet.getMemoryWithoutUpdate();
            boolean caresAboutTransponder = Misc.caresAboutPlayerTransponder(fleet);
            float dist = Misc.getDistance(fleet.getLocation(), playerFleet.getLocation());
            if (dist > 1000.0f || (!mem.contains("$sawPlayerTransponderOff") || !caresAboutTransponder) && !mem.contains("$pursuePlayer")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        String factionId = params.get(0).getString(memoryMap);
        return IsSoughtByPatrols.areFactionPatrolsSeekingPlayer(factionId);
    }

    public static boolean isPatrol(CampaignFleetAPI fleet) {
        if (!fleet.getMemoryWithoutUpdate().contains("$isPatrol")) {
            return false;
        }
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            if (member.isCivilian()) continue;
            return true;
        }
        return false;
    }
}

