/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.impl.campaign.terrain.BaseTiledTerrain;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.Arrays;
import java.util.Random;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class HyperspaceAutomaton {
    protected transient int[][] cells;
    protected transient int[][] next;
    protected String savedCells;
    protected String savedNext;
    protected IntervalUtil interval;
    protected boolean doneWithIteration = false;
    protected int currentColumn = 0;
    protected int width;
    protected int height;

    public HyperspaceAutomaton(int width, int height, float minInterval, float maxInterval) {
        this.width = width;
        this.height = height;
        this.cells = new int[width][height];
        this.next = new int[width][height];
        this.interval = new IntervalUtil(minInterval, maxInterval);
        this.setLive(0.1f);
        this.interval.forceIntervalElapsed();
    }

    Object readResolve() {
        if (this.savedCells != null) {
            try {
                this.cells = HyperspaceAutomaton.decodeTiles(this.savedCells, this.width, this.height);
            }
            catch (DataFormatException e) {
                throw new RuntimeException("Error decoding hyperspace automaton tiles", e);
            }
        } else {
            this.cells = new int[this.width][this.height];
        }
        if (this.savedNext != null) {
            try {
                this.next = HyperspaceAutomaton.decodeTiles(this.savedNext, this.width, this.height);
            }
            catch (DataFormatException e) {
                throw new RuntimeException("Error decoding hyperspace automaton tiles", e);
            }
        } else {
            this.next = new int[this.width][this.height];
        }
        return this;
    }

    Object writeReplace() {
        this.savedCells = HyperspaceAutomaton.encodeTiles(this.cells);
        this.savedNext = HyperspaceAutomaton.encodeTiles(this.next);
        return this;
    }

    public IntervalUtil getInterval() {
        return this.interval;
    }

    public void advance(float days) {
        this.updateCells(days);
        this.interval.advance(days);
        if (this.interval.intervalElapsed()) {
            this.doneWithIteration = false;
            this.setLive(0.01f);
            this.cells = this.next;
            this.next = new int[this.cells.length][this.cells[0].length];
            int i = 0;
            while (i < this.next.length) {
                int j = 0;
                while (j < this.next[0].length) {
                    this.next[i][j] = this.cells[i][j];
                    ++j;
                }
                ++i;
            }
            this.currentColumn = 0;
        }
    }

    public int[][] getCells() {
        return this.cells;
    }

    protected void updateCells(float days) {
        if (this.currentColumn >= this.cells.length) {
            return;
        }
        int chunk = (int)(days * 1.5f / this.interval.getMinInterval() * (float)this.cells.length);
        if (chunk < 1) {
            chunk = 1;
        }
        int maxColumn = this.currentColumn + chunk;
        int i = this.currentColumn;
        while (i < this.cells.length && i < maxColumn) {
            int j = 0;
            while (j < this.cells[0].length) {
                int val = this.cells[i][j];
                if (val == 0) {
                    int count = this.getLiveCountAround(i, j);
                    if (count == 2) {
                        this.next[i][j] = 1;
                    }
                } else if (val == 1) {
                    this.next[i][j] = 2;
                } else if (val == 2) {
                    this.next[i][j] = 0;
                }
                ++j;
            }
            ++i;
        }
        this.currentColumn = maxColumn;
    }

    public void setLive(float fraction) {
        float count = (float)(this.next.length * this.next[0].length) * fraction;
        if (count <= 0.0f) {
            count = (float)Math.random() < count ? 1 : 0;
        }
        Random r = new Random();
        int i = 0;
        while ((float)i < count) {
            int x = r.nextInt(this.next.length);
            int y = r.nextInt(this.next[0].length);
            this.next[x][y] = 1;
            ++i;
        }
    }

    protected int getLiveCountAround(int x, int y) {
        int count = 0;
        int i = Math.max(0, x - 1);
        while (i <= Math.min(x + 1, this.cells.length - 1)) {
            int j = Math.max(0, y - 1);
            while (j <= Math.min(y + 1, this.cells[0].length - 1)) {
                if ((i != x || j != y) && this.cells[i][j] == 1) {
                    ++count;
                }
                ++j;
            }
            ++i;
        }
        return count;
    }

    public static String encodeTiles(int[][] tiles) {
        int w = tiles.length;
        int h = tiles[0].length;
        int total = w * h;
        int[] masks = new int[]{192, 48, 12, 3};
        int bitPair = 0;
        int curr = 0;
        byte[] input = new byte[(int)Math.ceil(total / 4)];
        int i = 0;
        while (i < total) {
            int x = i % w;
            int y = i / w;
            int val = tiles[x][y];
            int mask = masks[bitPair];
            if (val >= 0) {
                curr |= val << 8 - (bitPair + 1) * 2 & mask;
            }
            ++bitPair;
            if ((bitPair %= 4) == 0) {
                input[i / 4] = (byte)curr;
                curr = 0;
            }
            ++i;
        }
        if (bitPair != 0) {
            input[(total - 1) / 8] = (byte)curr;
            curr = 0;
        }
        Deflater compresser = new Deflater();
        compresser.setInput(input);
        compresser.finish();
        StringBuilder result = new StringBuilder();
        byte[] temp = new byte[100];
        while (!compresser.finished()) {
            int read = compresser.deflate(temp);
            result.append(BaseTiledTerrain.toHexString(Arrays.copyOf(temp, read)));
        }
        compresser.end();
        return result.toString();
    }

    public static int[][] decodeTiles(String string, int w, int h) throws DataFormatException {
        byte[] input = BaseTiledTerrain.toByteArray(string);
        Inflater decompresser = new Inflater();
        decompresser.setInput(input);
        int[] masks = new int[]{192, 48, 12, 3};
        int[][] tiles = new int[w][h];
        int total = w * h;
        int curr = 0;
        byte[] temp = new byte[100];
        block0: while (!decompresser.finished()) {
            int read = decompresser.inflate(temp);
            int i = 0;
            while (i < read) {
                byte b = temp[i];
                int j = 3;
                while (j >= 0) {
                    int x = curr % w;
                    int y = curr / w;
                    if (++curr > total) break block0;
                    tiles[x][y] = b >> j * 2 & 3;
                    --j;
                }
                ++i;
            }
        }
        decompresser.end();
        return tiles;
    }

    public static void main(String[] args) throws DataFormatException {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 3;
        nArray[4] = 1;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{3, 1, 2, 3, 2};
        nArrayArray[2] = new int[]{2, 2, 1, 3, 3};
        nArrayArray[3] = new int[]{1, 1, 2, 3, 2};
        int[][] tiles = nArrayArray;
        System.out.println("Original:");
        int i = 0;
        while (i < tiles.length) {
            int j = 0;
            while (j < tiles[0].length) {
                System.out.print(String.format("% 2d,", tiles[i][j]));
                ++j;
            }
            System.out.println();
            ++i;
        }
        String result = HyperspaceAutomaton.encodeTiles(tiles);
        System.out.println(result);
        int[][] tilesBack = HyperspaceAutomaton.decodeTiles(result, tiles.length, tiles[0].length);
        System.out.println("Decoded:");
        int i2 = 0;
        while (i2 < tilesBack.length) {
            int j = 0;
            while (j < tilesBack[0].length) {
                System.out.print(String.format("% 2d,", tilesBack[i2][j]));
                ++j;
            }
            System.out.println();
            ++i2;
        }
        boolean equals = true;
        int i3 = 0;
        while (i3 < tiles.length) {
            int j = 0;
            while (j < tiles[0].length) {
                if (tiles[i3][j] != tilesBack[i3][j]) {
                    equals = false;
                }
                ++j;
            }
            ++i3;
        }
        System.out.println("Equal: " + equals);
    }
}

