/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.WeaponAPI;

public class SensorDishRotationEffect
implements EveryFrameWeaponEffectPlugin {
    private float currDir = Math.signum((float)Math.random() - 0.5f);

    @Override
    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {
        if (engine.isPaused()) {
            return;
        }
        float curr = weapon.getCurrAngle();
        float arc = weapon.getArc();
        float facing = weapon.getArcFacing() + (weapon.getShip() != null ? weapon.getShip().getFacing() : 0.0f);
        if (!SensorDishRotationEffect.isBetween(facing - arc / 2.0f, facing + arc / 2.0f, curr += this.currDir * amount * 10.0f)) {
            this.currDir = -this.currDir;
        }
        weapon.setFacing(curr);
    }

    public static boolean isBetween(float one, float two, float check) {
        one = SensorDishRotationEffect.normalizeAngle(one);
        two = SensorDishRotationEffect.normalizeAngle(two);
        if ((check = SensorDishRotationEffect.normalizeAngle(check)) >= one && check <= two) {
            return true;
        }
        if (one > two) {
            if (check <= two) {
                return true;
            }
            if (check >= one) {
                return true;
            }
        }
        return false;
    }

    public static float normalizeAngle(float angleDeg) {
        return (angleDeg % 360.0f + 360.0f) % 360.0f;
    }
}

