/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.BeamEffectPlugin;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.EmpArcEntityAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.NegativeExplosionVisual;
import com.fs.starfarer.api.impl.combat.RiftCascadeMineExplosion;
import com.fs.starfarer.api.impl.combat.dweller.DarkenedGazeSystemScript;
import com.fs.starfarer.api.impl.combat.dweller.RiftLightningEffect;
import com.fs.starfarer.api.loading.DamagingExplosionSpec;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class AbyssalGlareEffect
implements BeamEffectPlugin {
    public static float RIFT_DAMAGE = 200.0f;
    public static float DAMAGE_MULT_NORMAL_WEAPON = 0.5f;
    protected IntervalUtil fireInterval = new IntervalUtil(0.2f, 0.3f);
    protected boolean hadDamageTargetPrev = false;
    protected boolean lengthChangedPrev = false;
    protected float sinceRiftSpawn = 0.0f;
    protected Vector2f prevTo = null;
    protected Vector2f prevFrom = null;

    public AbyssalGlareEffect() {
        this.fireInterval.randomize();
    }

    @Override
    public void advance(float amount, CombatEngineAPI engine, BeamAPI beam) {
        boolean forceRiftSpawn;
        boolean primary;
        if (beam.getSource() == null || beam.getWeapon() == null) {
            return;
        }
        boolean normalWeaponMode = !beam.getSource().hasTag(DarkenedGazeSystemScript.DARKENED_GAZE_SYSTEM_TAG);
        boolean bl = primary = beam.getWeapon().getCustom() == DarkenedGazeSystemScript.DARKENED_GAZE_PRIMARY_WEAPON_TAG;
        if (normalWeaponMode) {
            primary = true;
        }
        this.sinceRiftSpawn += amount;
        float maxRange = beam.getWeapon().getRange();
        Vector2f from = beam.getFrom();
        Vector2f to = beam.getRayEndPrevFrame();
        Vector2f to2 = beam.getTo();
        float dist = Misc.getDistance(from, to);
        float dist2 = Misc.getDistance(from, to2);
        if (dist2 < dist) {
            to = to2;
            dist = dist2;
        }
        boolean hasDamageTarget = beam.getDamageTarget() != null;
        boolean lengthChanged = this.prevTo == null || Math.abs(Misc.getDistance(this.prevFrom, this.prevTo) - Misc.getDistance(from, to)) > 2.0f;
        boolean bl2 = forceRiftSpawn = hasDamageTarget && !this.hadDamageTargetPrev || !lengthChanged && this.lengthChangedPrev;
        if (!primary) {
            forceRiftSpawn = false;
        }
        this.lengthChangedPrev = lengthChanged;
        this.hadDamageTargetPrev = hasDamageTarget;
        this.prevFrom = new Vector2f((ReadableVector2f)from);
        this.prevTo = new Vector2f((ReadableVector2f)to);
        this.fireInterval.advance(amount);
        if (this.fireInterval.intervalElapsed() || forceRiftSpawn) {
            if (beam.getDamageTarget() == null && dist < maxRange * 0.9f) {
                return;
            }
            if (beam.getBrightness() < 1.0f) {
                return;
            }
            Color color = RiftLightningEffect.RIFT_LIGHTNING_COLOR;
            boolean spawnedExplosion = false;
            float maxTimeWithoutExplosion = 1.0f;
            if (normalWeaponMode) {
                maxTimeWithoutExplosion = 0.5f;
            }
            if ((float)Math.random() > 0.8f || forceRiftSpawn || primary && this.sinceRiftSpawn > maxTimeWithoutExplosion) {
                DamagingProjectileAPI explosion = engine.spawnDamagingExplosion(this.createExplosionSpec(normalWeaponMode ? DAMAGE_MULT_NORMAL_WEAPON : 1.0f), beam.getSource(), to);
                float distFactor = 0.0f;
                if (dist > 500.0f) {
                    distFactor = (dist - 500.0f) / 1500.0f;
                    if (distFactor < 0.0f) {
                        distFactor = 0.0f;
                    }
                    if (distFactor > 1.0f) {
                        distFactor = 1.0f;
                    }
                }
                float sizeAdd = 5.0f * distFactor;
                float baseSize = 15.0f;
                if (normalWeaponMode) {
                    baseSize *= 0.5f;
                    sizeAdd = 0.0f;
                }
                NegativeExplosionVisual.NEParams p = RiftCascadeMineExplosion.createStandardRiftParams(color, baseSize + sizeAdd);
                p.noiseMult = 6.0f;
                p.thickness = 25.0f;
                p.fadeOut = 0.5f;
                p.spawnHitGlowAt = 1.0f;
                p.additiveBlend = true;
                p.blackColor = Color.white;
                p.underglow = null;
                p.withNegativeParticles = false;
                p.withHitGlow = false;
                p.fadeIn = 0.0f;
                RiftCascadeMineExplosion.spawnStandardRift(explosion, p);
                spawnedExplosion = true;
                this.sinceRiftSpawn = 0.0f;
            }
            if (dist > 100.0f && ((float)Math.random() > 0.5f || normalWeaponMode && spawnedExplosion)) {
                float fraction;
                EmpArcEntityAPI.EmpArcParams params = new EmpArcEntityAPI.EmpArcParams();
                params.segmentLengthMult = 8.0f;
                params.zigZagReductionFactor = 0.15f;
                params.fadeOutDist = 50.0f;
                params.minFadeOutMult = 10.0f;
                params.flickerRateMult = 0.3f;
                params.brightSpotFullFraction = fraction = Math.min(0.33f, 300.0f / dist);
                params.brightSpotFadeFraction = fraction;
                float arcSpeed = RiftLightningEffect.RIFT_LIGHTNING_SPEED;
                params.movementDurOverride = Math.max(0.05f, dist / arcSpeed);
                ShipAPI ship = beam.getSource();
                EmpArcEntityAPI arc = engine.spawnEmpArcVisual(from, ship, to, ship, 80.0f, color, new Color(255, 255, 255, 255), params);
                arc.setCoreWidthOverride(40.0f);
                arc.setRenderGlowAtStart(false);
                arc.setFadedOutAtStart(true);
                arc.setSingleFlickerMode(true);
                Vector2f pt = Vector2f.add((Vector2f)from, (Vector2f)to, (Vector2f)new Vector2f());
                pt.scale(0.5f);
                Global.getSoundPlayer().playSound("abyssal_glare_lightning", 1.0f, 1.0f, pt, new Vector2f());
            }
        }
        if (normalWeaponMode) {
            pt = Vector2f.add((Vector2f)from, (Vector2f)to, (Vector2f)new Vector2f());
            pt.scale(0.5f);
            Global.getSoundPlayer().playLoop("abyssal_glare_loop", beam.getSource(), 1.0f, beam.getBrightness(), pt, beam.getSource().getVelocity());
        } else if (primary) {
            pt = Vector2f.add((Vector2f)from, (Vector2f)to, (Vector2f)new Vector2f());
            pt.scale(0.5f);
            Global.getSoundPlayer().playLoop("darkened_gaze_loop", beam.getSource(), 1.0f, beam.getBrightness(), pt, beam.getSource().getVelocity());
        }
    }

    public DamagingExplosionSpec createExplosionSpec(float damageMult) {
        float damage = RIFT_DAMAGE * damageMult;
        DamagingExplosionSpec spec = new DamagingExplosionSpec(0.1f, 75.0f, 50.0f, damage, damage / 2.0f, CollisionClass.PROJECTILE_FF, CollisionClass.PROJECTILE_FIGHTER, 3.0f, 3.0f, 0.5f, 0, new Color(255, 255, 255, 0), new Color(255, 100, 100, 0));
        spec.setDamageType(DamageType.ENERGY);
        spec.setUseDetailedExplosion(false);
        spec.setSoundSetId("abyssal_glare_explosion");
        spec.setSoundVolume(damageMult);
        return spec;
    }
}

