/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.threat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class SecondaryFabricatorHullmod
extends BaseHullMod {
    public static float RATE_INCREASE = 30.0f;
    public static float SMOD_RATE_INCREASE = 20.0f;

    @Override
    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getDynamic().getStat("fragment_swarm_respawn_rate_mult").modifyPercent(id, RATE_INCREASE);
        boolean sMod = this.isSMod(stats);
        if (sMod) {
            stats.getDynamic().getStat("fragment_swarm_respawn_rate_mult").modifyPercent(id, SMOD_RATE_INCREASE);
        }
    }

    @Override
    public CargoStackAPI getRequiredItem() {
        return Global.getSettings().createCargoStack(CargoAPI.CargoItemType.SPECIAL, new SpecialItemData("fragment_fabricator", null), null);
    }

    @Override
    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return (int)RATE_INCREASE + "%";
        }
        return null;
    }

    @Override
    public String getSModDescriptionParam(int index, ShipAPI.HullSize hullSize, ShipAPI ship) {
        if (index == 0) {
            return (int)SMOD_RATE_INCREASE + "%";
        }
        return null;
    }

    @Override
    public boolean isApplicableToShip(ShipAPI ship) {
        return ship.getVariant().hasHullMod("fragment_swarm");
    }

    @Override
    public String getUnapplicableReason(ShipAPI ship) {
        return "Requires Fragment Swarm hullmod";
    }
}

