/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.threat;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.EmpArcEntityAPI;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.OnFireEffectPlugin;
import com.fs.starfarer.api.combat.OnHitEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.ApplyDamageResultAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class VoltaicCannonEffect
implements OnHitEffectPlugin,
OnFireEffectPlugin,
EveryFrameWeaponEffectPlugin {
    public int MIN_NUM_ARCS = 10;
    public int MAX_NUM_ARCS = 14;

    @Override
    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {
    }

    @Override
    public void onFire(DamagingProjectileAPI projectile, WeaponAPI weapon, CombatEngineAPI engine) {
    }

    @Override
    public void onHit(DamagingProjectileAPI projectile, CombatEntityAPI target, Vector2f point, boolean shieldHit, ApplyDamageResultAPI damageResult, CombatEngineAPI engine) {
        int numArcs = this.MIN_NUM_ARCS + Misc.random.nextInt(this.MAX_NUM_ARCS - this.MIN_NUM_ARCS + 1);
        float pierceChance = 0.0f;
        if (target instanceof ShipAPI) {
            pierceChance = ((ShipAPI)target).getHardFluxLevel() - 0.1f;
            pierceChance *= ((ShipAPI)target).getMutableStats().getDynamic().getValue("shield_pierced_mult");
        }
        float emp = projectile.getEmpAmount();
        float dam = 0.0f;
        EmpArcEntityAPI.EmpArcParams params = new EmpArcEntityAPI.EmpArcParams();
        params.segmentLengthMult = 8.0f;
        params.zigZagReductionFactor = 0.5f;
        params.flickerRateMult = 1.0f;
        params.fadeOutDist = 1000.0f;
        params.minFadeOutMult = 1.0f;
        params.glowSizeMult = 0.5f;
        params.glowAlphaMult = 0.75f;
        int i = 0;
        while (i < numArcs) {
            boolean piercedShield;
            boolean bl = piercedShield = shieldHit && (float)Math.random() < pierceChance;
            if (!shieldHit || piercedShield) {
                EmpArcEntityAPI arc = engine.spawnEmpArcPierceShields(projectile.getSource(), point, target, target, DamageType.ENERGY, dam, emp, 100000.0f, "voltaic_discharge_emp_impact", 20.0f, projectile.getProjectileSpec().getFringeColor(), Color.white, params);
                arc.setRenderGlowAtStart(false);
            }
            ++i;
        }
    }
}

