/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.util.Misc;

public class RecoveryShuttles
extends BaseHullMod {
    public static float CREW_LOSS_MULT = 0.25f;
    public static float SMOD_CREW_LOSS_MULT = 0.05f;

    @Override
    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        boolean sMod = this.isSMod(stats);
        float mult = CREW_LOSS_MULT;
        if (sMod) {
            mult = SMOD_CREW_LOSS_MULT;
        }
        stats.getDynamic().getStat("fighter_crew_loss_mult").modifyMult(id, mult);
    }

    @Override
    public String getSModDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return (int)((1.0f - SMOD_CREW_LOSS_MULT) * 100.0f) + "%";
        }
        return null;
    }

    @Override
    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return (int)((1.0f - CREW_LOSS_MULT) * 100.0f) + "%";
        }
        return null;
    }

    @Override
    public boolean isApplicableToShip(ShipAPI ship) {
        if (Misc.isAutomated(ship.getVariant())) {
            return false;
        }
        if (ship.getVariant().hasHullMod("converted_hangar")) {
            return true;
        }
        int bays = (int)ship.getMutableStats().getNumFighterBays().getModifiedValue();
        return ship != null && bays > 0;
    }

    @Override
    public String getUnapplicableReason(ShipAPI ship) {
        if (ship != null && Misc.isAutomated(ship.getVariant())) {
            return "Can not be installed on automated ships";
        }
        return "Ship does not have fighter bays";
    }
}

