/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.starfarer.api.campaign.CoreUITabId;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.accidents.AccidentRisk;
import com.fs.starfarer.campaign.fleet.CampaignFleet;
import com.fs.starfarer.campaign.fleet.CargoData;
import com.fs.starfarer.campaign.fleet.FleetMember;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.starfarer.ui.newui.supersuper;
import com.fs.starfarer.ui.public;
import com.fs.starfarer.util.IntervalTracker;
import com.fs.util.DoNotObfuscate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CampaignHelpManager
implements DoNotObfuscate {
    public static final String OPEN_TRADE = "chmOpenTrade";
    public static final String HYPER_STORM = "chmHyperStorm";
    public static final String DEPLOY_CRITICAL_CR = "chmDeployCritCR";
    public static final String DEPLOY_LOW_CR = "chmDeployLowCR";
    public static final String DEPLOY_COSTS_CR = "chmDeployCostsCR";
    public static final String WEAPON_GROUPS = "chmWeaponGroups";
    public static final String BOUGHT_SHIP = "chmShipPurchase";
    public static final String BOUGHT_WING = "chmWingPurchase";
    public static final String REFIT_ON_STATION = "chmRefitOnStation";
    public static final String LOOT_OVER_CAPACITY = "chmLootOverCapacity";
    public static final String OVER_CARGO_CAPACITY = "chmOverCargoCapacity";
    public static final String OVER_FUEL_CAPACITY = "chmOverFuelCapacity";
    public static final String OVER_CREW_CAPACITY = "chmOverCrewCapacity";
    public static final String LOW_FUEL = "chmLowFuel";
    public static final String LOW_SUPPLIES = "chmLowSupplies";
    public static final String NOT_ENOUGH_CREW = "chmNotEnoughCrew";
    public static final String SOME_CRITICAL_CR = "chmSomeCritCR";
    public static final String ALL_CRITICAL_CR = "chmAllCritCR";
    public static final String SOME_LOW_CR = "chmSomeLowCR";
    public static final String INCREASED_SUPPLY_USE_AFTER_BATTLE = "chmSupplyUseAfterBattle";
    public static final String RISK_OF_ACCIDENTS = "chmRiskOfAccidents";
    public static final String ENTERED_HYPERSPACE = "chmEnteredHyper";
    public static final String REFIT_CR_LOSS = "chmRefitCRLoss";
    public static final String OVER_CAPACITY_STATUS_KEY = "chmOverAnyCapacityStatusKey";
    public static final float TRIP_RESET_TIME = 10.0f;
    private boolean enabled = true;
    private Set<String> doNotShow = new HashSet<String>();
    private Map<String, HelpDialogStatus> statuses = new HashMap<String, HelpDialogStatus>();
    private IntervalTracker tracker = new IntervalTracker(1.0f, 2.0f);
    private boolean shownWelcome = false;
    private float durInHyper = 0.0f;
    private transient boolean showingDialog = false;

    public void advance(float f2) {
        if (CampaignEngine.getInstance().isPaused()) {
            return;
        }
        this.tracker.advance(f2);
        if (!this.tracker.intervalElapsed()) {
            return;
        }
        CampaignFleet campaignFleet = CampaignEngine.getInstance().getPlayerFleet();
        CargoData cargoData = campaignFleet.getCargo();
        HelpDialogStatus helpDialogStatus = this.getStatus(OVER_CAPACITY_STATUS_KEY);
        boolean bl = cargoData.getSpaceUsed() > cargoData.getMaxCapacity() * 1.2f;
        boolean bl2 = cargoData.getFuel() > cargoData.getMaxFuel() * 1.2f;
        boolean bl3 = (float)(cargoData.getTotalCrew() + cargoData.getMarines()) > cargoData.getMaxPersonnel() * 1.2f;
        String string = OVER_CARGO_CAPACITY;
        if (bl) {
            string = OVER_CARGO_CAPACITY;
        } else if (bl2) {
            string = OVER_FUEL_CAPACITY;
        } else if (bl3) {
            string = OVER_CREW_CAPACITY;
        }
        this.updateStatusAndShowDialogIfNeeded(string, bl2 || bl || bl3, helpDialogStatus, new public.o(){

            @Override
            public void dialogDismissed(public public_, int n) {
                CampaignEngine.getInstance().setPaused(false);
                if (n == 0) {
                    CampaignEngine.getInstance().getCampaignUI().showCoreUITab(CoreUITabId.CARGO);
                }
            }
        });
        helpDialogStatus = this.getStatus(LOW_FUEL);
        boolean bl4 = campaignFleet.getLogistics().getFuelCostPerLightYear() * 1.0f > cargoData.getFuel();
        this.updateStatusAndShowDialogIfNeeded(LOW_FUEL, bl4, helpDialogStatus, new public.o(){

            @Override
            public void dialogDismissed(public public_, int n) {
                CampaignEngine.getInstance().setPaused(false);
            }
        });
        helpDialogStatus = this.getStatus(LOW_SUPPLIES);
        boolean bl5 = campaignFleet.getLogistics().getTotalSuppliesPerDay() * 5.0f > cargoData.getSupplies();
        this.updateStatusAndShowDialogIfNeeded(LOW_SUPPLIES, bl5, helpDialogStatus, new public.o(){

            @Override
            public void dialogDismissed(public public_, int n) {
                CampaignEngine.getInstance().setPaused(false);
                if (n == 0) {
                    CampaignEngine.getInstance().getCampaignUI().showCoreUITab(CoreUITabId.FLEET);
                }
            }
        });
        helpDialogStatus = this.getStatus(NOT_ENOUGH_CREW);
        boolean bl6 = (float)cargoData.getTotalCrew() < campaignFleet.getFleetData().getMinCrew();
        this.updateStatusAndShowDialogIfNeeded(NOT_ENOUGH_CREW, bl6, helpDialogStatus, new public.o(){

            @Override
            public void dialogDismissed(public public_, int n) {
                CampaignEngine.getInstance().setPaused(false);
                if (n == 0) {
                    CampaignEngine.getInstance().getCampaignUI().showCoreUITab(CoreUITabId.FLEET);
                }
            }
        });
        helpDialogStatus = this.getStatus(ALL_CRITICAL_CR);
        boolean bl7 = true;
        boolean bl8 = false;
        boolean bl9 = false;
        for (FleetMember fleetMember : campaignFleet.getMembers()) {
            if (fleetMember.isMothballed()) continue;
            if (!fleetMember.isFighterWing() && fleetMember.getCR() >= StarfarerSettings.float.String().getCriticalMalfunctionThreshold((MutableShipStatsAPI)fleetMember.getStats())) {
                bl7 = false;
            }
            if (!fleetMember.isFighterWing() && fleetMember.getCR() < StarfarerSettings.float.String().getCriticalMalfunctionThreshold((MutableShipStatsAPI)fleetMember.getStats())) {
                bl8 = true;
            }
            if (fleetMember.isFighterWing() || !(fleetMember.getCR() < StarfarerSettings.float.String().getMalfunctionThreshold((MutableShipStatsAPI)fleetMember.getStats()))) continue;
            bl9 = true;
        }
        this.updateStatusAndShowDialogIfNeeded(ALL_CRITICAL_CR, bl7, helpDialogStatus, new public.o(){

            @Override
            public void dialogDismissed(public public_, int n) {
                CampaignEngine.getInstance().setPaused(false);
                if (n == 0) {
                    CampaignEngine.getInstance().getCampaignUI().showCoreUITab(CoreUITabId.FLEET);
                }
            }
        });
        helpDialogStatus = this.getStatus(SOME_CRITICAL_CR);
        this.updateStatusAndShowDialogIfNeeded(SOME_CRITICAL_CR, bl8 && !bl7, helpDialogStatus, new public.o(){

            @Override
            public void dialogDismissed(public public_, int n) {
                CampaignEngine.getInstance().setPaused(false);
                if (n == 0) {
                    CampaignEngine.getInstance().getCampaignUI().showCoreUITab(CoreUITabId.FLEET);
                }
            }
        });
        helpDialogStatus = this.getStatus(SOME_LOW_CR);
        this.updateStatusAndShowDialogIfNeeded(SOME_LOW_CR, bl9 && !bl8 && !bl7, helpDialogStatus, new public.o(){

            @Override
            public void dialogDismissed(public public_, int n) {
                CampaignEngine.getInstance().setPaused(false);
                if (n == 0) {
                    CampaignEngine.getInstance().getCampaignUI().showCoreUITab(CoreUITabId.FLEET);
                }
            }
        });
        helpDialogStatus = this.getStatus(INCREASED_SUPPLY_USE_AFTER_BATTLE);
        boolean bl10 = false;
        if (CampaignEngine.getInstance().getClock().getElapsedDaysSince(CampaignEngine.getInstance().getLastPlayerBattleTimestamp()) < 0.5f && campaignFleet.getAccidentManager().getHighestSeverity() == AccidentRisk.o.\u00d600000) {
            for (FleetMember fleetMember : campaignFleet.getMembers()) {
                if (fleetMember.getBaseCR() < fleetMember.getRepairTracker().getMaxCR()) {
                    bl10 = true;
                    break;
                }
                if (!fleetMember.needsRepairs() || !fleetMember.canBeRepaired()) continue;
                bl10 = true;
                break;
            }
        }
        this.updateStatusAndShowDialogIfNeeded(INCREASED_SUPPLY_USE_AFTER_BATTLE, bl10, helpDialogStatus, new public.o(){

            @Override
            public void dialogDismissed(public public_, int n) {
                CampaignEngine.getInstance().setPaused(false);
                if (n == 0) {
                    CampaignEngine.getInstance().getCampaignUI().showCoreUITab(CoreUITabId.FLEET);
                }
            }
        });
        helpDialogStatus = this.getStatus(RISK_OF_ACCIDENTS);
        boolean bl11 = campaignFleet.getAccidentManager().getHighestSeverity() != AccidentRisk.o.\u00d600000;
        this.updateStatusAndShowDialogIfNeeded(RISK_OF_ACCIDENTS, bl11, helpDialogStatus, new public.o(){

            @Override
            public void dialogDismissed(public public_, int n) {
                CampaignEngine.getInstance().setPaused(false);
                if (n != 0) {
                    // empty if block
                }
            }
        });
        helpDialogStatus = this.getStatus(ENTERED_HYPERSPACE);
        boolean bl12 = campaignFleet.isInHyperspace();
        this.durInHyper = bl12 ? (this.durInHyper += 1.5f) : 0.0f;
        if (this.durInHyper < 2.0f) {
            bl12 = false;
        }
        this.updateStatusAndShowDialogIfNeeded(ENTERED_HYPERSPACE, bl12, helpDialogStatus, new public.o(){

            @Override
            public void dialogDismissed(public public_, int n) {
                CampaignEngine.getInstance().setPaused(false);
                if (n != 0) {
                    // empty if block
                }
            }
        });
    }

    public boolean isShowingDialog() {
        return this.showingDialog;
    }

    private void updateStatusAndShowDialogIfNeeded(String string, boolean bl, HelpDialogStatus helpDialogStatus, final public.o o2) {
        boolean bl2;
        helpDialogStatus.conditionTripped = bl;
        if (!helpDialogStatus.dialogShown && helpDialogStatus.conditionTripped && !CampaignEngine.getInstance().getCampaignUI().isShowingDialog() && !this.showingDialog && (bl2 = supersuper.showIfNeeded(string, CampaignEngine.getInstance().getCampaignUI().getDialogParent(), new supersuper.o(){

            @Override
            public boolean super() {
                return true;
            }
        }, new public.o(){

            @Override
            public void dialogDismissed(public public_, int n) {
                CampaignHelpManager.this.showingDialog = false;
                o2.dialogDismissed(public_, n);
            }
        }))) {
            helpDialogStatus.dialogShown = true;
            this.showingDialog = true;
            return;
        }
        helpDialogStatus.elapsedUntripped = helpDialogStatus.conditionTripped ? 0.0f : (helpDialogStatus.elapsedUntripped += 1.5f);
        if (helpDialogStatus.elapsedUntripped > 10.0f) {
            helpDialogStatus.dialogShown = false;
        }
    }

    private HelpDialogStatus getStatus(String string) {
        HelpDialogStatus helpDialogStatus = this.statuses.get(string);
        if (helpDialogStatus == null) {
            helpDialogStatus = new HelpDialogStatus();
            this.statuses.put(string, helpDialogStatus);
        }
        return helpDialogStatus;
    }

    public boolean canShow(String string) {
        if (!this.enabled) {
            return false;
        }
        return !this.doNotShow.contains(string);
    }

    public void setDoNotShow(String string) {
        this.doNotShow.add(string);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public static class HelpDialogStatus
    implements DoNotObfuscate {
        public boolean conditionTripped = false;
        public boolean dialogShown = false;
        public float elapsedUntripped = 0.0f;
    }
}

