/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.ModPlugin;
import com.fs.starfarer.api.PluginPick;
import com.fs.starfarer.api.campaign.AICoreAdminPlugin;
import com.fs.starfarer.api.campaign.AICoreOfficerPlugin;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.BattleAutoresolverPlugin;
import com.fs.starfarer.api.campaign.BattleCreationPlugin;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignPlugin;
import com.fs.starfarer.api.campaign.FleetInflater;
import com.fs.starfarer.api.campaign.FleetStubAPI;
import com.fs.starfarer.api.campaign.FleetStubConverterPlugin;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.PluginPickerAPI;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.AbilityAIPlugin;
import com.fs.starfarer.api.campaign.ai.AssignmentModulePlugin;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.campaign.ai.NavigationModulePlugin;
import com.fs.starfarer.api.campaign.ai.StrategicModulePlugin;
import com.fs.starfarer.api.campaign.ai.TacticalModulePlugin;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.ImmigrationPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.AICoreOfficerPluginImpl;
import com.fs.starfarer.api.plugins.AutofitPlugin;
import com.fs.starfarer.launcher.ModManager;
import com.fs.starfarer.loading.scripts.ScriptStore;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ModAndPluginData
implements DoNotObfuscate,
Cloneable,
PluginPickerAPI {
    private List<EnabledModData> allModsEverEnabled = new ArrayList<EnabledModData>();
    private List<EnabledModData> enabledMods = new ArrayList<EnabledModData>();
    private Map<String, Object> persistentData = new HashMap<String, Object>();
    private List<CampaignPlugin> plugins = new ArrayList<CampaignPlugin>();
    private transient List<String> retainModList;

    public ModAndPluginData clone() {
        try {
            ModAndPluginData modAndPluginData = (ModAndPluginData)super.clone();
            modAndPluginData.plugins = new ArrayList<CampaignPlugin>(this.plugins);
            return modAndPluginData;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected Object readResolve() {
        return this;
    }

    protected Object writeReplace() {
        ModAndPluginData modAndPluginData = this.clone();
        Iterator<CampaignPlugin> iterator = modAndPluginData.plugins.iterator();
        while (iterator.hasNext()) {
            CampaignPlugin campaignPlugin = iterator.next();
            if (!campaignPlugin.isTransient()) continue;
            iterator.remove();
        }
        return modAndPluginData;
    }

    public void notifyRunningWithMod(String string) {
        int n;
        ModManager.ModSpec modSpec;
        if (this.retainModList == null) {
            this.retainModList = new ArrayList<String>();
        }
        if ((modSpec = ModManager.getInstance().getModSpec(string)) == null) {
            return;
        }
        this.retainModList.add(string);
        boolean bl = false;
        boolean bl2 = false;
        for (EnabledModData enabledModData : this.enabledMods) {
            if (enabledModData.getId() == null || !enabledModData.getId().equals(string)) continue;
            bl = true;
            break;
        }
        for (EnabledModData enabledModData : this.allModsEverEnabled) {
            if (enabledModData.getId() == null || !enabledModData.getId().equals(string)) continue;
            bl2 = true;
            break;
        }
        if (modSpec.getModPluginClassName() != null && !bl) {
            EnabledModData enabledModData;
            enabledModData = (ModPlugin)ScriptStore.\u00d200000(modSpec.getModPluginClassName());
            enabledModData.onEnabled(bl2);
        }
        if (!this.wasEverEnabled(string)) {
            this.allModsEverEnabled.add(new EnabledModData(modSpec));
        } else {
            for (EnabledModData enabledModData : this.allModsEverEnabled) {
                if (enabledModData.getId() == null || !enabledModData.getId().equals(string)) continue;
                n = this.allModsEverEnabled.indexOf(enabledModData);
                this.allModsEverEnabled.add(n, new EnabledModData(modSpec));
                this.allModsEverEnabled.remove(enabledModData);
                break;
            }
        }
        if (!this.isInEnabledList(string)) {
            this.enabledMods.add(new EnabledModData(modSpec));
        } else {
            for (EnabledModData enabledModData : this.enabledMods) {
                if (enabledModData.getId() == null || !enabledModData.getId().equals(string)) continue;
                n = this.enabledMods.indexOf(enabledModData);
                this.enabledMods.add(n, new EnabledModData(modSpec));
                this.enabledMods.remove(enabledModData);
                break;
            }
        }
    }

    private boolean wasEverEnabled(String string) {
        for (EnabledModData enabledModData : this.allModsEverEnabled) {
            if (!enabledModData.getId().equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean isInEnabledList(String string) {
        for (EnabledModData enabledModData : this.enabledMods) {
            if (!enabledModData.getId().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void finishNotify() {
        if (this.retainModList != null) {
            Iterator<EnabledModData> iterator = this.enabledMods.iterator();
            while (iterator.hasNext()) {
                EnabledModData enabledModData = iterator.next();
                if (this.retainModList.contains(enabledModData.getId())) continue;
                iterator.remove();
            }
        } else {
            this.enabledMods.clear();
        }
        this.retainModList = null;
    }

    public void addPlugin(CampaignPlugin campaignPlugin) {
        if (campaignPlugin.getId() != null) {
            this.removePlugin(campaignPlugin.getId());
        }
        this.plugins.add(campaignPlugin);
    }

    public void removePlugin(String string) {
        for (CampaignPlugin campaignPlugin : this.plugins) {
            if (campaignPlugin.getId() == null || !campaignPlugin.getId().equals(string)) continue;
            this.plugins.remove(campaignPlugin);
            break;
        }
    }

    public List<EnabledModData> getAllModsEverEnabled() {
        return this.allModsEverEnabled;
    }

    public List<EnabledModData> getEnabledMods() {
        return this.enabledMods;
    }

    public Map<String, Object> getPersistentData() {
        return this.persistentData;
    }

    public List<CampaignPlugin> getPlugins() {
        return this.plugins;
    }

    public ReputationActionResponsePlugin pickReputationActionResponsePlugin(final Object object, final String string) {
        return this.getPriorityPlugin(new o<ReputationActionResponsePlugin>(){

            @Override
            public PluginPick<ReputationActionResponsePlugin> o00000(CampaignPlugin campaignPlugin) {
                return campaignPlugin.pickReputationActionResponsePlugin(object, string);
            }
        });
    }

    public ReputationActionResponsePlugin pickReputationActionResponsePlugin(final Object object, final PersonAPI personAPI) {
        return this.getPriorityPlugin(new o<ReputationActionResponsePlugin>(){

            @Override
            public PluginPick<ReputationActionResponsePlugin> o00000(CampaignPlugin campaignPlugin) {
                return campaignPlugin.pickReputationActionResponsePlugin(object, personAPI);
            }
        });
    }

    public BattleAutoresolverPlugin pickAutoresolver(final BattleAPI battleAPI) {
        return this.getPriorityPlugin(new o<BattleAutoresolverPlugin>(){

            @Override
            public PluginPick<BattleAutoresolverPlugin> o00000(CampaignPlugin campaignPlugin) {
                return campaignPlugin.pickBattleAutoresolverPlugin(battleAPI);
            }
        });
    }

    public ImmigrationPlugin pickImmigrationPlugin(final MarketAPI marketAPI) {
        return this.getPriorityPlugin(new o<ImmigrationPlugin>(){

            @Override
            public PluginPick<ImmigrationPlugin> o00000(CampaignPlugin campaignPlugin) {
                return campaignPlugin.pickImmigrationPlugin(marketAPI);
            }
        });
    }

    public AICoreAdminPlugin pickAICoreAdminPlugin(final String string) {
        return this.getPriorityPlugin(new o<AICoreAdminPlugin>(){

            @Override
            public PluginPick<AICoreAdminPlugin> o00000(CampaignPlugin campaignPlugin) {
                return campaignPlugin.pickAICoreAdminPlugin(string);
            }
        });
    }

    public AICoreOfficerPlugin pickAICoreOfficerPlugin(final String string) {
        CommoditySpecAPI commoditySpecAPI;
        AICoreOfficerPlugin aICoreOfficerPlugin = this.getPriorityPlugin(new o<AICoreOfficerPlugin>(){

            @Override
            public PluginPick<AICoreOfficerPlugin> o00000(CampaignPlugin campaignPlugin) {
                return campaignPlugin.pickAICoreOfficerPlugin(string);
            }
        });
        if (aICoreOfficerPlugin == null && Global.getCurrentState() == GameState.COMBAT && !Global.getCombatEngine().isInCampaign() && !Global.getCombatEngine().isInCampaignSim() && (commoditySpecAPI = Global.getSettings().getCommoditySpec(string)) != null && commoditySpecAPI.hasTag("ai_core")) {
            return new AICoreOfficerPluginImpl();
        }
        return aICoreOfficerPlugin;
    }

    public FleetInflater pickFleetInflater(final CampaignFleetAPI campaignFleetAPI, final Object object) {
        return this.getPriorityPlugin(new o<FleetInflater>(){

            @Override
            public PluginPick<FleetInflater> o00000(CampaignPlugin campaignPlugin) {
                return campaignPlugin.pickFleetInflater(campaignFleetAPI, object);
            }
        });
    }

    public FleetStubConverterPlugin pickFleetStubConverter(final CampaignFleetAPI campaignFleetAPI) {
        return this.getPriorityPlugin(new o<FleetStubConverterPlugin>(){

            @Override
            public PluginPick<FleetStubConverterPlugin> o00000(CampaignPlugin campaignPlugin) {
                return campaignPlugin.pickStubConverter(campaignFleetAPI);
            }
        });
    }

    public FleetStubConverterPlugin pickFleetStubConverter(final FleetStubAPI fleetStubAPI) {
        return this.getPriorityPlugin(new o<FleetStubConverterPlugin>(){

            @Override
            public PluginPick<FleetStubConverterPlugin> o00000(CampaignPlugin campaignPlugin) {
                return campaignPlugin.pickStubConverter(fleetStubAPI);
            }
        });
    }

    public AutofitPlugin pickAutofitPlugin(final FleetMemberAPI fleetMemberAPI) {
        return this.getPriorityPlugin(new o<AutofitPlugin>(){

            @Override
            public PluginPick<AutofitPlugin> o00000(CampaignPlugin campaignPlugin) {
                return campaignPlugin.pickAutofitPlugin(fleetMemberAPI);
            }
        });
    }

    public InteractionDialogPlugin pickRespawnPlugin() {
        return this.getPriorityPlugin(new o<InteractionDialogPlugin>(){

            @Override
            public PluginPick<InteractionDialogPlugin> o00000(CampaignPlugin campaignPlugin) {
                return campaignPlugin.pickRespawnPlugin();
            }
        });
    }

    public InteractionDialogPlugin pickInteractionDialogPlugin(final SectorEntityToken sectorEntityToken) {
        return this.getPriorityPlugin(new o<InteractionDialogPlugin>(){

            @Override
            public PluginPick<InteractionDialogPlugin> o00000(CampaignPlugin campaignPlugin) {
                return campaignPlugin.pickInteractionDialogPlugin(sectorEntityToken);
            }
        });
    }

    public InteractionDialogPlugin pickInteractionDialogPlugin(final Object object, final SectorEntityToken sectorEntityToken) {
        return this.getPriorityPlugin(new o<InteractionDialogPlugin>(){

            @Override
            public PluginPick<InteractionDialogPlugin> o00000(CampaignPlugin campaignPlugin) {
                return campaignPlugin.pickInteractionDialogPlugin(object, sectorEntityToken);
            }
        });
    }

    public BattleCreationPlugin pickBattleCreationPlugin(final SectorEntityToken sectorEntityToken) {
        return this.getPriorityPlugin(new o<BattleCreationPlugin>(){

            @Override
            public PluginPick<BattleCreationPlugin> o00000(CampaignPlugin campaignPlugin) {
                return campaignPlugin.pickBattleCreationPlugin(sectorEntityToken);
            }
        });
    }

    public AssignmentModulePlugin pickAssignmentAIModule(final CampaignFleetAPI campaignFleetAPI, final ModularFleetAIAPI modularFleetAIAPI) {
        AssignmentModulePlugin assignmentModulePlugin = this.getPriorityPlugin(new o<AssignmentModulePlugin>(){

            @Override
            public PluginPick<AssignmentModulePlugin> o00000(CampaignPlugin campaignPlugin) {
                return campaignPlugin.pickAssignmentAIModule(campaignFleetAPI, modularFleetAIAPI);
            }
        });
        return assignmentModulePlugin;
    }

    public StrategicModulePlugin pickStrategicAIModule(final CampaignFleetAPI campaignFleetAPI, final ModularFleetAIAPI modularFleetAIAPI) {
        StrategicModulePlugin strategicModulePlugin = this.getPriorityPlugin(new o<StrategicModulePlugin>(){

            @Override
            public PluginPick<StrategicModulePlugin> o00000(CampaignPlugin campaignPlugin) {
                return campaignPlugin.pickStrategicAIModule(campaignFleetAPI, modularFleetAIAPI);
            }
        });
        return strategicModulePlugin;
    }

    public TacticalModulePlugin pickTacticalAIModule(final CampaignFleetAPI campaignFleetAPI, final ModularFleetAIAPI modularFleetAIAPI) {
        TacticalModulePlugin tacticalModulePlugin = this.getPriorityPlugin(new o<TacticalModulePlugin>(){

            @Override
            public PluginPick<TacticalModulePlugin> o00000(CampaignPlugin campaignPlugin) {
                return campaignPlugin.pickTacticalAIModule(campaignFleetAPI, modularFleetAIAPI);
            }
        });
        return tacticalModulePlugin;
    }

    public NavigationModulePlugin pickNavigationAIModule(final CampaignFleetAPI campaignFleetAPI, final ModularFleetAIAPI modularFleetAIAPI) {
        NavigationModulePlugin navigationModulePlugin = this.getPriorityPlugin(new o<NavigationModulePlugin>(){

            @Override
            public PluginPick<NavigationModulePlugin> o00000(CampaignPlugin campaignPlugin) {
                return campaignPlugin.pickNavigationAIModule(campaignFleetAPI, modularFleetAIAPI);
            }
        });
        return navigationModulePlugin;
    }

    public AbilityAIPlugin pickAbilityAI(final AbilityPlugin abilityPlugin, final ModularFleetAIAPI modularFleetAIAPI) {
        AbilityAIPlugin abilityAIPlugin = this.getPriorityPlugin(new o<AbilityAIPlugin>(){

            @Override
            public PluginPick<AbilityAIPlugin> o00000(CampaignPlugin campaignPlugin) {
                return campaignPlugin.pickAbilityAI(abilityPlugin, modularFleetAIAPI);
            }
        });
        return abilityAIPlugin;
    }

    public <T> T getPriorityPlugin(o<T> o2) {
        ArrayList<PluginPick<T>> arrayList = new ArrayList<PluginPick<T>>();
        for (CampaignPlugin campaignPlugin : this.getPlugins()) {
            PluginPick<T> pluginPick = o2.o00000(campaignPlugin);
            if (pluginPick == null) continue;
            arrayList.add(pluginPick);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (T)((PluginPick)arrayList.get((int)0)).plugin;
        }
        Collections.sort(arrayList, new Comparator<PluginPick<T>>(){

            public int o00000(PluginPick<T> pluginPick, PluginPick<T> pluginPick2) {
                return pluginPick.priority.ordinal() - pluginPick2.priority.ordinal();
            }
        });
        return (T)((PluginPick)arrayList.get((int)(arrayList.size() - 1))).plugin;
    }

    public static class EnabledModData
    implements DoNotObfuscate {
        private ModManager.ModSpec spec;

        public EnabledModData(ModManager.ModSpec modSpec) {
            this.spec = modSpec;
        }

        public String getId() {
            return this.spec.getId();
        }

        public String getName() {
            return this.spec.getName();
        }

        public String getVersion() {
            return this.spec.getVersion();
        }

        public boolean isTc() {
            return this.spec.isTotalConversion();
        }

        public ModManager.ModSpec getSpec() {
            return this.spec;
        }
    }

    public static interface o<T> {
        public PluginPick<T> o00000(CampaignPlugin var1);
    }
}

