/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.ai;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.campaign.BaseCampaignEntity;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.Hyperspace;
import com.fs.starfarer.campaign.JumpPoint;
import com.fs.starfarer.campaign.ai.CampaignFleetAI;
import com.fs.starfarer.campaign.fleet.CampaignFleet;
import com.fs.starfarer.combat.ai.M;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.util.IntervalTracker;
import com.fs.util.DoNotObfuscate;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class PursuitAndEvasionModule
implements DoNotObfuscate {
    private CampaignFleet fleet;
    private final CampaignFleetAI ai;
    private IntervalTracker tracker = new IntervalTracker(0.1f, 0.2f);
    private float pursueDetectionRange = 350.0f;
    private float fleeDetectionRange = 350.0f;
    private float pursueCourseOffset = 0.0f;
    private float pursueDuration;
    private boolean followMode = false;
    private SectorEntityToken target;
    private Goal goal;
    private CampaignFleetAI.JumpPlan plan;

    public PursuitAndEvasionModule(CampaignFleet campaignFleet, CampaignFleetAI campaignFleetAI) {
        this.fleet = campaignFleet;
        this.ai = campaignFleetAI;
    }

    public SectorEntityToken getTarget() {
        return this.target;
    }

    public CampaignFleetAPI getTargetFleet() {
        if (this.target instanceof CampaignFleetAPI) {
            return (CampaignFleetAPI)this.target;
        }
        return null;
    }

    public void pursueTarget(SectorEntityToken sectorEntityToken, float f2) {
        this.pursueTarget(sectorEntityToken, f2, false);
    }

    public void pursueTarget(SectorEntityToken sectorEntityToken, float f2, boolean bl) {
        this.pursueDuration = f2;
        this.followMode = bl;
        this.goal = Goal.PURSUE;
        this.setTarget(sectorEntityToken);
    }

    private void setTarget(SectorEntityToken sectorEntityToken) {
        if (sectorEntityToken != null && this.target != sectorEntityToken && sectorEntityToken.isPlayerFleet() && this.goal != Goal.PURSUE) {
        }
        this.target = sectorEntityToken;
    }

    public boolean isFleeing() {
        return this.goal == Goal.AVOID && this.getTargetFleet() != null;
    }

    public boolean isPursuing() {
        return this.goal == Goal.PURSUE && this.getTargetFleet() != null;
    }

    public void advance(float f2) {
        float f3;
        Object object;
        List list;
        LocationAPI locationAPI;
        float f4 = CampaignEngine.getInstance().getClock().convertToDays(f2);
        this.tracker.advance(f4);
        if (this.isBusy() && this.fleet.getOrbit() != null) {
            this.fleet.setOrbit(null);
        }
        if (this.target != null && !this.target.isAlive()) {
            this.target = null;
        }
        this.pursueDuration -= f4;
        boolean bl = true;
        if (this.target != null && this.pursueDuration > 0.0f) {
            bl = false;
            this.goal = Goal.PURSUE;
        }
        if (this.tracker.intervalElapsed()) {
            float f5;
            locationAPI = this.fleet.getContainingLocation();
            list = locationAPI.getObjects().getList(CampaignFleet.class);
            CampaignFleet campaignFleet = null;
            object = null;
            f3 = Float.MAX_VALUE;
            float f6 = Float.MAX_VALUE;
            for (CampaignFleet campaignFleet2 : list) {
                if (this.fleet == campaignFleet2 || campaignFleet2.getFleetPoints() <= 0) continue;
                boolean bl2 = this.fleet.getAI() != null && this.fleet.getAI().isHostileTo((CampaignFleetAPI)campaignFleet2);
                if (!(bl2 |= campaignFleet2.getAI() != null && campaignFleet2.getAI().isHostileTo((CampaignFleetAPI)this.fleet)) || (f5 = Utils.void(this.fleet.getLocation(), campaignFleet2.getLocation())) > this.fleeDetectionRange && f5 > this.pursueDetectionRange) continue;
                CampaignFleetAIAPI.EncounterOption encounterOption = this.ai.pickEncounterOption(null, campaignFleet2);
                if (encounterOption == CampaignFleetAIAPI.EncounterOption.ENGAGE && f5 < f6 && this.isOkToPursue(campaignFleet2)) {
                    object = campaignFleet2;
                    f6 = f5;
                    continue;
                }
                if (encounterOption == CampaignFleetAIAPI.EncounterOption.DISENGAGE && f5 < f3) {
                    campaignFleet = campaignFleet2;
                    f3 = f5;
                    continue;
                }
                if (encounterOption != CampaignFleetAIAPI.EncounterOption.HOLD || campaignFleet2.isPlayerFleet() || !this.isOkToPursue(campaignFleet2)) continue;
                object = campaignFleet2;
                f6 = f5;
            }
            this.pursueCourseOffset = 0.0f;
            if (object != null) {
                for (CampaignFleet campaignFleet2 : list) {
                    if (this.fleet == campaignFleet2 || campaignFleet2 == object || campaignFleet2.getFaction() != this.fleet.getFaction()) continue;
                    float f7 = Utils.\u00d300000(this.fleet.getLocation(), ((BaseCampaignEntity)object).getLocation());
                    f5 = Utils.void(this.fleet.getLocation(), ((BaseCampaignEntity)object).getLocation());
                    float f8 = Utils.void(this.fleet.getLocation(), campaignFleet2.getLocation());
                    float f9 = Utils.\u00d300000(this.fleet.getLocation(), campaignFleet2.getLocation());
                    float f10 = Utils.void(campaignFleet2.getLocation(), ((BaseCampaignEntity)object).getLocation());
                    float f11 = Utils.super(f7, f9);
                    if (!(f8 < f5) || !(f11 < 60.0f)) continue;
                    float f12 = Utils.\u00d200000(f9, f7);
                    this.pursueCourseOffset = (30.0f + 30.0f * (float)Math.random()) * f12;
                }
            }
            if (campaignFleet != null && f3 < this.fleeDetectionRange) {
                this.goal = Goal.AVOID;
                this.setTarget(campaignFleet);
            } else if (object != null && f6 < this.pursueDetectionRange && bl) {
                this.goal = Goal.PURSUE;
                this.followMode = false;
                this.setTarget((SectorEntityToken)object);
            } else if (bl) {
                this.goal = null;
                this.setTarget(null);
            }
        }
        if (this.target != null) {
            locationAPI = this.target.getLocation();
            this.plan = this.computeJumpPlanTo(this.target.getContainingLocation());
            if (this.plan != null) {
                this.fleet.setInteractionTarget(this.plan.point);
                locationAPI = this.plan.point.getLocation();
                float f13 = Utils.void((Vector2f)locationAPI, this.fleet.getLocation());
                if (this.plan != null && f13 < 100.0f) {
                    CampaignEngine.getInstance().doHyperspaceTransition(this.fleet, this.plan.point, this.plan.dest);
                }
            }
            list = this.fleet.getLocation();
            if (this.goal == Goal.PURSUE) {
                if (this.pursueCourseOffset != 0.0f) {
                    locationAPI = new Vector2f((ReadableVector2f)locationAPI);
                    float f14 = Utils.\u00d300000(this.fleet.getLocation(), (Vector2f)locationAPI);
                    object = Utils.\u00d300000(f14 += this.pursueCourseOffset);
                    f3 = Utils.void(this.fleet.getLocation(), (Vector2f)locationAPI);
                    object.scale(f3);
                    Vector2f.add((Vector2f)this.fleet.getLocation(), (Vector2f)object, (Vector2f)locationAPI);
                }
                this.fleet.setMoveDestination(locationAPI.x, locationAPI.y);
                if (!this.followMode) {
                    this.fleet.setInteractionTarget(this.target);
                }
            } else {
                float f15 = Utils.\u00d300000((Vector2f)locationAPI, (Vector2f)list);
                object = Utils.\u00d300000(f15);
                object.scale(500.0f);
                Vector2f.add((Vector2f)object, (Vector2f)list, (Vector2f)object);
                this.fleet.setMoveDestination(((Vector2f)object).x, ((Vector2f)object).y);
            }
        } else {
            this.fleet.setInteractionTarget(null);
            this.plan = null;
        }
    }

    public CampaignFleetAI.JumpPlan computeJumpPlanTo(LocationAPI locationAPI) {
        boolean bl;
        if (locationAPI == this.fleet.getContainingLocation()) {
            return null;
        }
        if (this.fleet.getCargo().getFuel() <= 0.0f && !this.fleet.isAIMode()) {
            return null;
        }
        List list = this.fleet.getContainingLocation().getEntities(JumpPoint.class);
        JumpPoint jumpPoint = null;
        JumpPointAPI.JumpDestination jumpDestination = null;
        float f2 = Float.MAX_VALUE;
        Hyperspace hyperspace = CampaignEngine.getInstance().getHyperspace();
        boolean bl2 = bl = locationAPI == null;
        if (hyperspace != locationAPI && hyperspace != this.fleet.getContainingLocation()) {
            bl = true;
        }
        block0: for (JumpPoint jumpPoint2 : list) {
            if (jumpPoint2.isStarAnchor()) continue;
            for (JumpPointAPI.JumpDestination jumpDestination2 : jumpPoint2.getDestinations()) {
                float f3;
                if (jumpDestination2.getDestination() == null || jumpDestination2.getDestination().getContainingLocation() != locationAPI && (!bl || hyperspace != jumpDestination2.getDestination().getContainingLocation()) || !((f3 = Utils.void(jumpPoint2.getLocation(), this.fleet.getLocation())) < f2)) continue;
                f2 = f3;
                jumpPoint = jumpPoint2;
                jumpDestination = jumpDestination2;
                continue block0;
            }
        }
        if (jumpPoint == null) {
            return null;
        }
        return new CampaignFleetAI.JumpPlan(jumpPoint, jumpDestination);
    }

    private boolean isOkToPursue(CampaignFleet campaignFleet) {
        float f2 = Utils.void(this.fleet.getLocation(), campaignFleet.getLocation());
        float f3 = Vector2f.dot((Vector2f)Utils.super(new Vector2f((ReadableVector2f)this.fleet.getVelocity())), (Vector2f)Utils.super(new Vector2f((ReadableVector2f)campaignFleet.getVelocity())));
        float f4 = M.super(this.fleet.getLocation(), this.fleet.getVelocity(), campaignFleet.getLocation(), campaignFleet.getVelocity());
        float f5 = f2 / Math.max(f4, 1.0f);
        return !(f3 > 0.9f) || !(f5 > 15.0f);
    }

    public void setPursueDetectionRange(float f2) {
        this.pursueDetectionRange = this.fleet.getStats().getMovementSpeedMod().computeEffective(f2);
    }

    public void setFleeDetectionRange(float f2) {
        this.fleeDetectionRange = f2;
    }

    public boolean isBusy() {
        return this.target != null;
    }

    public IntervalTracker getTracker() {
        return this.tracker;
    }

    public boolean isFollowMode() {
        return this.followMode;
    }

    private static enum Goal implements DoNotObfuscate
    {
        AVOID,
        PURSUE;

    }
}

