/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.fleet;

import com.fs.graphics.anim.Animation;
import com.fs.graphics.anim.BaseAnimation;
import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.BattleAutoresolverPlugin;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.EngagementResultForFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import com.fs.starfarer.campaign.BaseLocation;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.Faction;
import com.fs.starfarer.campaign.ai.ModularFleetAI;
import com.fs.starfarer.campaign.fleet.CampaignFleet;
import com.fs.starfarer.campaign.fleet.FleetData;
import com.fs.starfarer.campaign.fleet.FleetMember;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.starfarer.util.IntervalTracker;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class Battle
implements DoNotObfuscate,
BattleAPI,
EveryFrameScript {
    private List<CampaignFleetAPI> sideOne = new ArrayList<CampaignFleetAPI>();
    private List<CampaignFleetAPI> sideTwo = new ArrayList<CampaignFleetAPI>();
    private transient List<CampaignFleetAPI> snapshotSideOne = new ArrayList<CampaignFleetAPI>();
    private transient List<CampaignFleetAPI> snapshotSideTwo = new ArrayList<CampaignFleetAPI>();
    private IntervalTracker tracker = new IntervalTracker(Global.getSettings().getFloat("autoresolveBaseInterval") * 0.8f, Global.getSettings().getFloat("autoresolveBaseInterval") * 1.2f);
    private IntervalTracker flash = new IntervalTracker(0.8f, 1.2f);
    private transient Map<FleetMemberAPI, CampaignFleetAPI> memberSource = new HashMap<FleetMemberAPI, CampaignFleetAPI>();
    private transient CampaignFleetAPI combinedOne;
    private transient CampaignFleetAPI combinedTwo;
    private transient CampaignFleetAPI primaryOne;
    private transient CampaignFleetAPI primaryTwo;
    private boolean playerInvolvedAtStart = false;
    private float playerInvolvementFraction = 0.0f;
    private long seed = new Random().nextLong();
    private boolean done = false;

    public Battle(CampaignFleetAPI campaignFleetAPI, CampaignFleetAPI campaignFleetAPI2) {
        if (campaignFleetAPI2.isPlayerFleet()) {
            CampaignFleetAPI campaignFleetAPI3 = campaignFleetAPI;
            campaignFleetAPI = campaignFleetAPI2;
            campaignFleetAPI2 = campaignFleetAPI3;
        }
        this.sideOne.add(campaignFleetAPI);
        campaignFleetAPI.setBattle((BattleAPI)this);
        this.sideTwo.add(campaignFleetAPI2);
        campaignFleetAPI2.setBattle((BattleAPI)this);
        this.notifyAbilitiesJoined(campaignFleetAPI);
        this.notifyAbilitiesJoined(campaignFleetAPI2);
        this.primaryOne = campaignFleetAPI;
        this.primaryTwo = campaignFleetAPI2;
        this.playerInvolvedAtStart = campaignFleetAPI.isPlayerFleet() || campaignFleetAPI2.isPlayerFleet();
        campaignFleetAPI.getContainingLocation().addScript((EveryFrameScript)this);
    }

    public long getSeed() {
        return this.seed;
    }

    protected void notifyAbilitiesJoined(CampaignFleetAPI campaignFleetAPI) {
        for (String string : campaignFleetAPI.getAbilities().keySet()) {
            AbilityPlugin abilityPlugin = (AbilityPlugin)campaignFleetAPI.getAbilities().get(string);
            abilityPlugin.fleetJoinedBattle((BattleAPI)this);
        }
    }

    protected void notifyAbilitiesLeft(CampaignFleetAPI campaignFleetAPI, boolean bl) {
        for (String string : campaignFleetAPI.getAbilities().keySet()) {
            AbilityPlugin abilityPlugin = (AbilityPlugin)campaignFleetAPI.getAbilities().get(string);
            abilityPlugin.fleetLeftBattle((BattleAPI)this, bl);
        }
    }

    public boolean isPlayerInvolvedAtStart() {
        return this.playerInvolvedAtStart;
    }

    public void setPlayerInvolvedAtStart(boolean bl) {
        this.playerInvolvedAtStart = bl;
    }

    public boolean isStationInvolvedOnPlayerSide() {
        for (CampaignFleetAPI campaignFleetAPI : this.getPlayerSide()) {
            if (!campaignFleetAPI.isStationMode()) continue;
            return true;
        }
        for (CampaignFleetAPI campaignFleetAPI : this.getPlayerSideSnapshot()) {
            if (!campaignFleetAPI.isStationMode()) continue;
            return true;
        }
        return false;
    }

    public List<CampaignFleetAPI> getStationSide() {
        if (this.isStationInvolved(this.sideOne)) {
            return this.sideOne;
        }
        if (this.isStationInvolved(this.sideTwo)) {
            return this.sideTwo;
        }
        return null;
    }

    public boolean isStationInvolved(List<CampaignFleetAPI> list) {
        if (list == null) {
            return false;
        }
        for (CampaignFleetAPI campaignFleetAPI : list) {
            if (!campaignFleetAPI.isStationMode()) continue;
            return true;
        }
        for (CampaignFleetAPI campaignFleetAPI : this.getSnapshotFor(list)) {
            if (!campaignFleetAPI.isStationMode()) continue;
            return true;
        }
        return false;
    }

    public boolean isStationInvolved() {
        for (CampaignFleetAPI campaignFleetAPI : this.sideOne) {
            if (!campaignFleetAPI.isStationMode()) continue;
            return true;
        }
        for (CampaignFleetAPI campaignFleetAPI : this.sideTwo) {
            if (!campaignFleetAPI.isStationMode()) continue;
            return true;
        }
        for (CampaignFleetAPI campaignFleetAPI : this.getSnapshotSideOne()) {
            if (!campaignFleetAPI.isStationMode()) continue;
            return true;
        }
        for (CampaignFleetAPI campaignFleetAPI : this.getSnapshotSideTwo()) {
            if (!campaignFleetAPI.isStationMode()) continue;
            return true;
        }
        return false;
    }

    public void takeSnapshots() {
        this.snapshotSideOne = new ArrayList<CampaignFleetAPI>(this.sideOne);
        this.snapshotSideTwo = new ArrayList<CampaignFleetAPI>(this.sideTwo);
        for (CampaignFleetAPI campaignFleetAPI : this.sideOne) {
            campaignFleetAPI.getFleetData().takeSnapshot();
        }
        for (CampaignFleetAPI campaignFleetAPI : this.sideTwo) {
            campaignFleetAPI.getFleetData().takeSnapshot();
        }
    }

    public List<CampaignFleetAPI> getBothSides() {
        ArrayList<CampaignFleetAPI> arrayList = new ArrayList<CampaignFleetAPI>();
        arrayList.addAll(this.sideOne);
        arrayList.addAll(this.sideTwo);
        return arrayList;
    }

    public boolean onSameSide(CampaignFleetAPI campaignFleetAPI, CampaignFleetAPI campaignFleetAPI2) {
        List<CampaignFleetAPI> list;
        List<CampaignFleetAPI> list2 = this.getSideFor(campaignFleetAPI);
        return list2 == (list = this.getSideFor(campaignFleetAPI2)) && list2 != null;
    }

    public boolean onPlayerSide(CampaignFleetAPI campaignFleetAPI) {
        List<CampaignFleetAPI> list;
        List<CampaignFleetAPI> list2 = this.getSideFor(campaignFleetAPI);
        return list2 == (list = this.getSideFor(Global.getSector().getPlayerFleet())) && list2 != null;
    }

    public List<CampaignFleetAPI> getSnapshotBothSides() {
        ArrayList<CampaignFleetAPI> arrayList = new ArrayList<CampaignFleetAPI>();
        arrayList.addAll(this.getSnapshotSideOne());
        arrayList.addAll(this.getSnapshotSideTwo());
        return arrayList;
    }

    public List<CampaignFleetAPI> getSnapshotSideOne() {
        if (this.snapshotSideOne == null) {
            this.takeSnapshots();
        }
        return this.snapshotSideOne;
    }

    public List<CampaignFleetAPI> getSnapshotSideTwo() {
        if (this.snapshotSideTwo == null) {
            this.takeSnapshots();
        }
        return this.snapshotSideTwo;
    }

    public boolean hasSnapshots() {
        return this.snapshotSideOne != null && this.snapshotSideTwo != null;
    }

    public List<CampaignFleetAPI> getSnapshotSideFor(CampaignFleetAPI campaignFleetAPI) {
        if (this.getSnapshotSideOne().contains(campaignFleetAPI)) {
            return this.getSnapshotSideOne();
        }
        if (this.getSnapshotSideTwo().contains(campaignFleetAPI)) {
            return this.getSnapshotSideTwo();
        }
        if (this.sideOne.contains(campaignFleetAPI)) {
            return this.getSnapshotSideOne();
        }
        if (this.sideTwo.contains(campaignFleetAPI)) {
            return this.getSnapshotSideTwo();
        }
        if (this.combinedOne == campaignFleetAPI) {
            return this.getSnapshotSideOne();
        }
        if (this.combinedTwo == campaignFleetAPI) {
            return this.getSnapshotSideTwo();
        }
        return null;
    }

    public List<CampaignFleetAPI> getSnapshotOtherSideFor(CampaignFleetAPI campaignFleetAPI) {
        if (this.getSnapshotSideOne().contains(campaignFleetAPI)) {
            return this.getSnapshotSideTwo();
        }
        if (this.getSnapshotSideTwo().contains(campaignFleetAPI)) {
            return this.getSnapshotSideOne();
        }
        if (this.sideOne.contains(campaignFleetAPI)) {
            return this.getSnapshotSideTwo();
        }
        if (this.sideTwo.contains(campaignFleetAPI)) {
            return this.getSnapshotSideOne();
        }
        if (this.combinedOne == campaignFleetAPI) {
            return this.getSnapshotSideTwo();
        }
        if (this.combinedTwo == campaignFleetAPI) {
            return this.getSnapshotSideOne();
        }
        return null;
    }

    public List<CampaignFleetAPI> getSnapshotFor(List<CampaignFleetAPI> list) {
        if (list == this.sideOne || list == this.snapshotSideOne) {
            return this.getSnapshotSideOne();
        }
        if (list == this.sideTwo || list == this.snapshotSideTwo) {
            return this.getSnapshotSideTwo();
        }
        return null;
    }

    public List<CampaignFleetAPI> getOtherSideSnapshotFor(List<CampaignFleetAPI> list) {
        if (list == this.sideOne || list == this.snapshotSideOne) {
            return this.getSnapshotSideTwo();
        }
        if (list == this.sideTwo || list == this.snapshotSideTwo) {
            return this.getSnapshotSideOne();
        }
        return null;
    }

    public List<CampaignFleetAPI> getOtherSideSnapshotFor(CampaignFleetAPI campaignFleetAPI) {
        return this.getOtherSideSnapshotFor(this.getSideFor(campaignFleetAPI));
    }

    protected Object readResolve() {
        this.memberSource = new HashMap<FleetMemberAPI, CampaignFleetAPI>();
        return this;
    }

    public List<CampaignFleetAPI> getSideOne() {
        return this.sideOne;
    }

    public List<CampaignFleetAPI> getSideTwo() {
        return this.sideTwo;
    }

    public void advance(float f2) {
        float f3;
        this.snapshotSideTwo = null;
        this.snapshotSideOne = null;
        this.primaryTwo = null;
        this.primaryOne = null;
        this.combinedTwo = null;
        this.combinedOne = null;
        if (this.isDone()) {
            return;
        }
        this.removeEmptyFleets();
        if (this.sideOne.isEmpty() || this.sideOne.size() == 1 && this.sideOne.get(0).getFleetData().getNumMembers() <= 0 || this.sideTwo.isEmpty() || this.sideTwo.size() == 1 && this.sideTwo.get(0).getFleetData().getNumMembers() <= 0) {
            BattleAPI.BattleSide battleSide = BattleAPI.BattleSide.TWO;
            if (this.sideTwo.isEmpty() || this.sideTwo.size() == 1 && this.sideTwo.get(0).getFleetData().getNumMembers() <= 0) {
                battleSide = BattleAPI.BattleSide.ONE;
            }
            this.finish(battleSide, false);
            return;
        }
        ArrayList<CampaignFleetAPI> arrayList = new ArrayList<CampaignFleetAPI>();
        arrayList.addAll(this.sideOne);
        arrayList.addAll(this.sideTwo);
        boolean bl = this.isStationInvolved();
        CampaignFleetAPI campaignFleetAPI = null;
        for (CampaignFleetAPI campaignFleetAPI2 : arrayList) {
            float f4;
            float[] fArray = Battle.getMovementData(campaignFleetAPI2, this);
            Vector2f vector2f = campaignFleetAPI2.getLocation();
            if (campaignFleetAPI2.getOrbit() == null) {
                f4 = 1.0f;
                if (bl) {
                    f4 = 4.0f;
                }
                campaignFleetAPI2.setMoveDestination(vector2f.x + fArray[0] * f4, vector2f.y + fArray[1] * f4);
                ((CampaignFleet)campaignFleetAPI2).setDesiredFacing(fArray[2]);
            }
            this.applyVisibilityMod(campaignFleetAPI2);
            if (!CampaignEngine.getInstance().isInFastAdvance()) continue;
            if (campaignFleetAPI == null) {
                campaignFleetAPI = campaignFleetAPI2;
                continue;
            }
            f4 = Utils.void(campaignFleetAPI.getLocation(), campaignFleetAPI2.getLocation()) - campaignFleetAPI2.getRadius() - campaignFleetAPI.getRadius();
            if (!(f4 > 100.0f)) continue;
            campaignFleetAPI2.setLocation(campaignFleetAPI.getLocation().x, campaignFleetAPI.getLocation().y);
        }
        float f5 = 1.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        for (CampaignFleetAPI campaignFleetAPI2 : this.sideOne) {
            f6 += (float)campaignFleetAPI2.getFleetPoints();
        }
        for (CampaignFleetAPI campaignFleetAPI3 : this.sideTwo) {
            f7 += (float)campaignFleetAPI3.getFleetPoints();
        }
        if (f6 >= 1.0f && f7 >= 1.0f) {
            f5 = Math.max(f6, f7) / Math.min(f6 * 2.0f, f7 * 2.0f);
            if (f5 < 1.0f) {
                f5 = 1.0f;
            }
            if (f5 > 5.0f) {
                f5 = 5.0f;
            }
        }
        if (this.isStationInvolved()) {
            f5 *= 0.25f;
        }
        float f8 = CampaignEngine.getInstance().getClock().convertToDays(f2);
        this.tracker.advance(f8 * f5);
        if (this.tracker.intervalElapsed() && !this.isDone()) {
            this.doAutoresolveRound();
        }
        if ((f3 = (float)(this.sideOne.size() + this.sideTwo.size()) - 1.0f) < 1.0f) {
            f3 = 1.0f;
        }
        f3 = 1.0f;
        this.flash.advance(f2 * f3 * 1.0f);
        if (this.flash.intervalElapsed()) {
            this.addFlash();
        }
        this.snapshotSideTwo = null;
        this.snapshotSideOne = null;
        this.primaryTwo = null;
        this.primaryOne = null;
        this.combinedTwo = null;
        this.combinedOne = null;
    }

    protected void addFlash() {
        CampaignFleetAPI campaignFleetAPI = this.getPrimary(this.sideOne);
        if (campaignFleetAPI == null) {
            return;
        }
        if (CampaignEngine.getInstance().getCurrentLocation() != campaignFleetAPI.getContainingLocation()) {
            return;
        }
        CampaignEngine.getInstance().getViewport().isNearViewport(campaignFleetAPI.getLocation(), 1000.0f);
        float f2 = (float)this.getBothSides().size() * (0.5f + (float)Math.random() * 1.0f) * 1.0f;
        if (f2 < 1.0f) {
            f2 = 1.0f;
        }
        int n = 0;
        while ((float)n < f2) {
            BaseAnimation baseAnimation = new BaseAnimation(){

                public void finished() {
                    CampaignFleetAPI campaignFleetAPI2;
                    WeightedRandomPicker weightedRandomPicker = new WeightedRandomPicker();
                    for (CampaignFleetAPI campaignFleetAPI2 : Battle.this.getBothSides()) {
                        weightedRandomPicker.add((Object)campaignFleetAPI2, (float)campaignFleetAPI2.getFleetPoints());
                    }
                    campaignFleetAPI2 = (CampaignFleetAPI)weightedRandomPicker.pick();
                    if (campaignFleetAPI2 == null) {
                        return;
                    }
                    Vector2f vector2f = campaignFleetAPI2.getLocation();
                    Vector2f vector2f2 = Misc.getPointWithinRadius((Vector2f)vector2f, (float)(campaignFleetAPI2.getRadius() * 1.5f));
                    Color color = ((FleetMember)campaignFleetAPI2.getFlagship()).getHullSpec().getHullStyle().Object();
                    float f2 = 10.0f + (float)Math.random() * 20.0f;
                    float f3 = 0.5f + (float)Math.random() * 1.0f;
                    ((BaseLocation)campaignFleetAPI2.getContainingLocation()).addHitParticle(vector2f2, null, f2, 0.4f, f3, color);
                    ((BaseLocation)campaignFleetAPI2.getContainingLocation()).addHitParticle(vector2f2, null, f2 * 0.25f, 0.4f, f3, color);
                    ((BaseLocation)campaignFleetAPI2.getContainingLocation()).addHitParticle(vector2f2, null, f2 * 0.15f, 1.0f, f3, Color.white);
                }
            };
            float f3 = (float)Math.random();
            baseAnimation.setDuration(f3 * f3);
            CampaignEngine.getInstance().getAnimationManager().addAnimation((Animation)baseAnimation);
            ++n;
        }
    }

    protected void doAutoresolveRound() {
        this.getMemberSourceMap().clear();
        this.takeSnapshots();
        this.genCombined();
        BattleAutoresolverPlugin battleAutoresolverPlugin = CampaignEngine.getInstance().getModAndPluginData().pickAutoresolver(this);
        if (battleAutoresolverPlugin == null) {
            return;
        }
        battleAutoresolverPlugin.resolve();
        CampaignFleetAIAPI.EncounterOption encounterOption = this.getCombinedOne().getAI().pickEncounterOption(battleAutoresolverPlugin.getContext(), this.getCombinedTwo());
        CampaignFleetAIAPI.EncounterOption encounterOption2 = this.getCombinedTwo().getAI().pickEncounterOption(battleAutoresolverPlugin.getContext(), this.getCombinedOne());
        CampaignFleetAPI campaignFleetAPI = null;
        if (battleAutoresolverPlugin.getContext().getWinner() != null) {
            campaignFleetAPI = this.getPrimary(this.getSideFor(battleAutoresolverPlugin.getContext().getWinner()));
        }
        if (campaignFleetAPI != null) {
            Global.getSector().reportBattleOccurred(campaignFleetAPI, (BattleAPI)this);
        }
        this.removeEmptyFleets();
        if (this.sideOne.isEmpty() || this.sideOne.size() == 1 && this.sideOne.get(0).getFleetData().getNumMembers() <= 0 || this.sideTwo.isEmpty() || this.sideTwo.size() == 1 && this.sideTwo.get(0).getFleetData().getNumMembers() <= 0 || encounterOption == CampaignFleetAIAPI.EncounterOption.DISENGAGE || encounterOption2 == CampaignFleetAIAPI.EncounterOption.DISENGAGE) {
            BattleAPI.BattleSide battleSide = BattleAPI.BattleSide.TWO;
            if (this.sideTwo.isEmpty() || this.sideTwo.size() == 1 && this.sideTwo.get(0).getFleetData().getNumMembers() <= 0 || encounterOption2 == CampaignFleetAIAPI.EncounterOption.DISENGAGE) {
                battleSide = BattleAPI.BattleSide.ONE;
            }
            this.finish(battleSide, true);
            if (campaignFleetAPI != null) {
                Global.getSector().reportBattleFinished(campaignFleetAPI, (BattleAPI)this);
            }
        }
    }

    protected boolean isValidFleet(CampaignFleetAPI campaignFleetAPI) {
        if (campaignFleetAPI.isEmpty()) {
            return false;
        }
        return campaignFleetAPI.isStationMode() || campaignFleetAPI.isAlive();
    }

    public void removeEmptyFleets() {
        CampaignFleetAPI campaignFleetAPI;
        Iterator<CampaignFleetAPI> iterator;
        if (this.sideOne.size() > 1) {
            iterator = this.sideOne.iterator();
            while (iterator.hasNext()) {
                campaignFleetAPI = iterator.next();
                if (campaignFleetAPI.isPlayerFleet() || this.isValidFleet(campaignFleetAPI)) continue;
                iterator.remove();
                this.notifyAbilitiesLeft(campaignFleetAPI, true);
                campaignFleetAPI.setBattle(null);
            }
        }
        if (this.sideTwo.size() > 1) {
            iterator = this.sideTwo.iterator();
            while (iterator.hasNext()) {
                campaignFleetAPI = iterator.next();
                if (campaignFleetAPI.isPlayerFleet() || this.isValidFleet(campaignFleetAPI)) continue;
                iterator.remove();
                this.notifyAbilitiesLeft(campaignFleetAPI, true);
                campaignFleetAPI.setBattle(null);
            }
        }
    }

    public void finish(BattleAPI.BattleSide battleSide) {
        this.finish(battleSide, true);
    }

    public void finish(BattleAPI.BattleSide battleSide, boolean bl) {
        this.uncombine();
        boolean bl2 = true;
        if (battleSide == null || battleSide == BattleAPI.BattleSide.NO_JOIN) {
            battleSide = BattleAPI.BattleSide.ONE;
            bl2 = false;
        }
        for (CampaignFleetAPI campaignFleetAPI : new ArrayList<CampaignFleetAPI>(this.getSide(battleSide))) {
            this.leave(campaignFleetAPI, bl);
            campaignFleetAPI.setVelocity(0.0f, 0.0f);
            if (!bl) continue;
            campaignFleetAPI.setNoEngaging(3.0f);
            this.applyVisibilityMod(campaignFleetAPI);
            if (campaignFleetAPI.getAI() == null || !bl2 || campaignFleetAPI.getAI().isCurrentAssignment(FleetAssignment.STANDING_DOWN)) continue;
            campaignFleetAPI.getAI().addAssignmentAtStart(FleetAssignment.STANDING_DOWN, (SectorEntityToken)campaignFleetAPI, 0.5f + 0.5f * (float)Math.random(), null);
        }
        boolean bl3 = bl2 && this.isPlayerSide(this.getSide(battleSide)) && this.getSide(battleSide).size() <= 1;
        for (CampaignFleetAPI campaignFleetAPI : new ArrayList<CampaignFleetAPI>(this.getOtherSide(battleSide))) {
            this.leave(campaignFleetAPI, bl);
            campaignFleetAPI.setVelocity(0.0f, 0.0f);
            if (!bl) continue;
            campaignFleetAPI.setNoEngaging(3.0f);
            this.applyVisibilityMod(campaignFleetAPI);
            if (!bl3) continue;
            campaignFleetAPI.getMemoryWithoutUpdate().set("$cfai_recentlyDefeatedByPlayer", (Object)true, 7.0f);
        }
        this.sideOne.clear();
        this.sideTwo.clear();
        this.done = true;
    }

    public void applyVisibilityMod(CampaignFleetAPI campaignFleetAPI) {
        float f2 = Global.getSettings().getFloat("battleDetectabilityMult");
        float f3 = Global.getSettings().getFloat("battleDetectabilityFlat");
        campaignFleetAPI.getStats().addTemporaryModFlat(0.1f, "battle_mod_flat", "Engaged in battle", f3, campaignFleetAPI.getStats().getDetectedRangeMod());
        campaignFleetAPI.getStats().addTemporaryModMult(0.1f, "battle_mod_mult", "Engaged in battle", f2, campaignFleetAPI.getStats().getDetectedRangeMod());
    }

    public List<CampaignFleetAPI> getFleetsFor(EngagementResultForFleetAPI engagementResultForFleetAPI) {
        if (engagementResultForFleetAPI.getFleet() == this.combinedOne) {
            return this.sideOne;
        }
        if (engagementResultForFleetAPI.getFleet() == this.combinedTwo) {
            return this.sideTwo;
        }
        return null;
    }

    public CampaignFleetAPI getSourceFleet(FleetMemberAPI fleetMemberAPI) {
        return this.getMemberSourceMap().get(fleetMemberAPI);
    }

    public Map<FleetMemberAPI, CampaignFleetAPI> getMemberSourceMap() {
        if (this.memberSource == null) {
            this.memberSource = new HashMap<FleetMemberAPI, CampaignFleetAPI>();
        }
        return this.memberSource;
    }

    public CampaignFleetAPI getCombinedFor(CampaignFleetAPI campaignFleetAPI) {
        if (this.sideOne.contains(campaignFleetAPI)) {
            return this.combinedOne;
        }
        if (this.sideTwo.contains(campaignFleetAPI)) {
            return this.combinedTwo;
        }
        if (this.getSnapshotSideOne().contains(campaignFleetAPI)) {
            return this.combinedOne;
        }
        if (this.getSnapshotSideTwo().contains(campaignFleetAPI)) {
            return this.combinedTwo;
        }
        if (this.combinedOne == campaignFleetAPI) {
            return this.combinedOne;
        }
        if (this.combinedTwo == campaignFleetAPI) {
            return this.combinedTwo;
        }
        return null;
    }

    public List<CampaignFleetAPI> getSideFor(CampaignFleetAPI campaignFleetAPI) {
        if (this.sideOne.contains(campaignFleetAPI)) {
            return this.sideOne;
        }
        if (this.sideTwo.contains(campaignFleetAPI)) {
            return this.sideTwo;
        }
        if (this.getSnapshotSideOne().contains(campaignFleetAPI)) {
            return this.sideOne;
        }
        if (this.getSnapshotSideTwo().contains(campaignFleetAPI)) {
            return this.sideTwo;
        }
        if (this.sideTwo.contains(campaignFleetAPI)) {
            return this.sideTwo;
        }
        if (this.combinedOne == campaignFleetAPI) {
            return this.sideOne;
        }
        if (this.combinedTwo == campaignFleetAPI) {
            return this.sideTwo;
        }
        return null;
    }

    public List<CampaignFleetAPI> getOtherSideFor(CampaignFleetAPI campaignFleetAPI) {
        if (this.sideOne.contains(campaignFleetAPI)) {
            return this.sideTwo;
        }
        if (this.sideTwo.contains(campaignFleetAPI)) {
            return this.sideOne;
        }
        if (this.getSnapshotSideOne().contains(campaignFleetAPI)) {
            return this.sideTwo;
        }
        if (this.getSnapshotSideTwo().contains(campaignFleetAPI)) {
            return this.sideOne;
        }
        if (this.combinedOne == campaignFleetAPI) {
            return this.sideTwo;
        }
        if (this.combinedTwo == campaignFleetAPI) {
            return this.sideOne;
        }
        return null;
    }

    public CampaignFleetAPI getPrimary(List<CampaignFleetAPI> list) {
        return this.getPrimary(list, !this.playerInvolvedAtStart);
    }

    public CampaignFleetAPI getPrimary(List<CampaignFleetAPI> list, boolean bl) {
        int n;
        if (list == null) {
            return null;
        }
        CampaignFleetAPI campaignFleetAPI = null;
        int n2 = -1;
        for (CampaignFleetAPI campaignFleetAPI2 : list) {
            n = campaignFleetAPI2.getFleetPoints();
            if (bl && campaignFleetAPI2.isPlayerFleet() && list.size() > 1) continue;
            if (n > n2) {
                n2 = n;
                campaignFleetAPI = campaignFleetAPI2;
            }
            if (campaignFleetAPI2 == this.primaryOne || campaignFleetAPI2 == this.primaryTwo) {
                return campaignFleetAPI2;
            }
            if (!campaignFleetAPI2.isPlayerFleet() || !this.playerInvolvedAtStart) continue;
            return campaignFleetAPI2;
        }
        if (campaignFleetAPI == null) {
            for (CampaignFleetAPI campaignFleetAPI2 : this.getSnapshotFor(list)) {
                if (bl && campaignFleetAPI2.isPlayerFleet() && list.size() > 1) continue;
                n = campaignFleetAPI2.getFleetPoints();
                if (n > n2) {
                    n2 = n;
                    campaignFleetAPI = campaignFleetAPI2;
                }
                if (campaignFleetAPI2 == this.primaryOne || campaignFleetAPI2 == this.primaryTwo) {
                    return campaignFleetAPI2;
                }
                if (!campaignFleetAPI2.isPlayerFleet() || !this.playerInvolvedAtStart) continue;
                return campaignFleetAPI2;
            }
        }
        return campaignFleetAPI;
    }

    public boolean isPlayerPrimary() {
        return this.getPlayerSide() != null && this.getPrimary(this.getPlayerSide()).isPlayerFleet();
    }

    public boolean isPlayerSide(EngagementResultForFleetAPI engagementResultForFleetAPI) {
        return this.isPlayerSide(this.getFleetsFor(engagementResultForFleetAPI));
    }

    public boolean isOnPlayerSide(CampaignFleetAPI campaignFleetAPI) {
        return this.isPlayerSide(this.getSideFor(campaignFleetAPI));
    }

    public boolean knowsWhoPlayerIs(List<CampaignFleetAPI> list) {
        for (CampaignFleetAPI campaignFleetAPI : list) {
            if (!campaignFleetAPI.knowsWhoPlayerIs()) continue;
            return true;
        }
        for (CampaignFleetAPI campaignFleetAPI : this.getSnapshotFor(list)) {
            if (!campaignFleetAPI.knowsWhoPlayerIs()) continue;
            return true;
        }
        return false;
    }

    public boolean isPlayerSide(List<CampaignFleetAPI> list) {
        if (list == null) {
            return false;
        }
        for (CampaignFleetAPI campaignFleetAPI : list) {
            if (campaignFleetAPI != Global.getSector().getPlayerFleet()) continue;
            return true;
        }
        for (CampaignFleetAPI campaignFleetAPI : this.getSnapshotFor(list)) {
            if (campaignFleetAPI != Global.getSector().getPlayerFleet()) continue;
            return true;
        }
        return false;
    }

    public List<CampaignFleetAPI> getPlayerSide() {
        if (this.isPlayerSide(this.sideOne)) {
            return this.sideOne;
        }
        if (this.isPlayerSide(this.sideTwo)) {
            return this.sideTwo;
        }
        return null;
    }

    public List<CampaignFleetAPI> getNonPlayerSide() {
        if (this.isPlayerSide(this.sideOne)) {
            return this.sideTwo;
        }
        if (this.isPlayerSide(this.sideTwo)) {
            return this.sideOne;
        }
        return null;
    }

    public List<CampaignFleetAPI> getPlayerSideSnapshot() {
        if (this.isPlayerSide(this.getSnapshotSideOne())) {
            return this.getSnapshotSideOne();
        }
        if (this.isPlayerSide(this.getSnapshotSideTwo())) {
            return this.getSnapshotSideTwo();
        }
        return null;
    }

    public List<CampaignFleetAPI> getNonPlayerSideSnapshot() {
        if (this.isPlayerSide(this.getSnapshotSideOne())) {
            return this.getSnapshotSideTwo();
        }
        if (this.isPlayerSide(this.getSnapshotSideTwo())) {
            return this.getSnapshotSideOne();
        }
        return null;
    }

    public CampaignFleetAPI getPlayerCombined() {
        if (this.isPlayerSide(this.sideOne)) {
            return this.combinedOne;
        }
        if (this.isPlayerSide(this.sideTwo)) {
            return this.combinedTwo;
        }
        return null;
    }

    public CampaignFleetAPI getNonPlayerCombined() {
        if (this.isPlayerSide(this.sideOne)) {
            return this.combinedTwo;
        }
        if (this.isPlayerSide(this.sideTwo)) {
            return this.combinedOne;
        }
        return null;
    }

    public boolean isPlayerInvolved() {
        return this.isInvolved(Global.getSector().getPlayerFleet());
    }

    public boolean isInvolved(CampaignFleetAPI campaignFleetAPI) {
        if (this.sideOne.contains(campaignFleetAPI)) {
            return true;
        }
        if (this.sideTwo.contains(campaignFleetAPI)) {
            return true;
        }
        if (this.getSnapshotSideOne().contains(campaignFleetAPI)) {
            return true;
        }
        if (this.getSnapshotSideTwo().contains(campaignFleetAPI)) {
            return true;
        }
        if (campaignFleetAPI != null && campaignFleetAPI == this.combinedOne) {
            return true;
        }
        return campaignFleetAPI != null && campaignFleetAPI == this.combinedTwo;
    }

    public float getPlayerInvolvementFraction() {
        if (!this.isPlayerInvolved()) {
            return 0.0f;
        }
        return this.playerInvolvementFraction;
    }

    public void setPlayerInvolvementFraction(float f2) {
        this.playerInvolvementFraction = f2;
    }

    public void genCombined() {
        this.genCombined(true);
    }

    public void genCombined(boolean bl) {
        this.removeEmptyFleets();
        this.combinedOne = this.genCombined(this.sideOne, this.combinedOne, bl);
        this.combinedTwo = this.genCombined(this.sideTwo, this.combinedTwo, bl);
    }

    public void genCombinedDoNotRemoveEmpty() {
        this.combinedOne = this.genCombined(this.sideOne, this.combinedOne, true);
        this.combinedTwo = this.genCombined(this.sideTwo, this.combinedTwo, true);
    }

    private CampaignFleetAPI genCombined(List<CampaignFleetAPI> list, CampaignFleetAPI campaignFleetAPI, boolean bl) {
        CampaignFleet campaignFleet;
        boolean bl2 = this.isPlayerSide(list);
        if (bl2 && list.contains(campaignFleet = CampaignEngine.getInstance().getPlayerFleet())) {
            list.remove(campaignFleet);
            list.add(0, campaignFleet);
        }
        if ((campaignFleet = this.getPrimary(list, !this.playerInvolvedAtStart)) == null) {
            if (campaignFleetAPI != null) {
                ((FleetData)campaignFleetAPI.getFleetData()).clear(false);
            }
            return campaignFleetAPI;
        }
        CampaignFleetAPI campaignFleetAPI2 = campaignFleetAPI;
        if (campaignFleetAPI2 == null) {
            campaignFleetAPI2 = new CampaignFleet((Faction)campaignFleet.getFaction());
            campaignFleetAPI2.getFleetData().setOnlySyncMemberLists(true);
            ModularFleetAI modularFleetAI = new ModularFleetAI((CampaignFleet)campaignFleetAPI2);
            campaignFleetAPI2.setAI((CampaignFleetAIAPI)modularFleetAI);
            campaignFleetAPI2.setMemory(campaignFleet.getMemoryWithoutUpdate());
            campaignFleetAPI2.getTags().addAll(campaignFleet.getTags());
            campaignFleetAPI2.setBattle((BattleAPI)this);
        } else {
            ((FleetData)campaignFleetAPI2.getFleetData()).clear(false);
        }
        campaignFleetAPI2.setName(campaignFleet.getName());
        campaignFleetAPI2.setCommander(campaignFleet.getCommander());
        campaignFleetAPI2.setAIMode(true);
        campaignFleetAPI2.setBattle((BattleAPI)this);
        ((CampaignFleet)campaignFleetAPI2).setContainingLocation((BaseLocation)campaignFleet.getContainingLocation());
        ((CampaignFleet)campaignFleetAPI2).setLocation(campaignFleet.getLocation().x, campaignFleet.getLocation().y);
        boolean bl3 = true;
        for (CampaignFleetAPI campaignFleetAPI3 : list) {
            if (!bl && campaignFleetAPI3.isStationMode()) continue;
            for (FleetMemberAPI fleetMemberAPI : campaignFleetAPI3.getFleetData().getMembersListCopy()) {
                boolean bl4 = fleetMemberAPI.isFlagship();
                fleetMemberAPI.setFleetCommanderForStats(campaignFleetAPI3.getCommander(), campaignFleetAPI3.getFleetData());
                campaignFleetAPI2.getFleetData().addFleetMember(fleetMemberAPI);
                if (bl4 && bl3) {
                    ((FleetMember)fleetMemberAPI).setFlagship(true, false);
                    bl3 = false;
                }
                if (bl2 && !campaignFleetAPI3.isPlayerFleet()) {
                    fleetMemberAPI.setAlly(true);
                } else {
                    fleetMemberAPI.setAlly(false);
                }
                this.getMemberSourceMap().put(fleetMemberAPI, campaignFleetAPI3);
            }
        }
        for (CampaignFleetAPI campaignFleetAPI3 : campaignFleetAPI2.getFleetData().getMembersListCopy()) {
            if (!campaignFleetAPI3.isStation()) continue;
            campaignFleetAPI2.getFleetData().removeFleetMember((FleetMemberAPI)campaignFleetAPI3);
            ((FleetData)campaignFleetAPI2.getFleetData()).addFleetMember(0, (FleetMember)campaignFleetAPI3);
        }
        campaignFleetAPI2.getCommander().getStats().refreshCharacterStatsEffects(false);
        return campaignFleetAPI2;
    }

    public CampaignFleetAPI getCombinedOne() {
        return this.combinedOne;
    }

    public CampaignFleetAPI getCombinedTwo() {
        return this.combinedTwo;
    }

    public boolean canJoin(CampaignFleetAPI campaignFleetAPI) {
        if (campaignFleetAPI.isInHyperspaceTransition()) {
            return false;
        }
        if (campaignFleetAPI.isStationMode() && this.isStationInvolved()) {
            return false;
        }
        return this.pickSide(campaignFleetAPI) != BattleAPI.BattleSide.NO_JOIN;
    }

    public BattleAPI.BattleSide pickSide(CampaignFleetAPI campaignFleetAPI) {
        return this.pickSide(campaignFleetAPI, true);
    }

    public BattleAPI.BattleSide pickSide(CampaignFleetAPI campaignFleetAPI, boolean bl) {
        boolean bl2;
        if (this.sideOne.contains(campaignFleetAPI)) {
            return BattleAPI.BattleSide.ONE;
        }
        if (this.sideTwo.contains(campaignFleetAPI)) {
            return BattleAPI.BattleSide.TWO;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        if (campaignFleetAPI.isPlayerFleet()) {
            for (CampaignFleetAPI campaignFleetAPI2 : this.getSideOne()) {
                if (!campaignFleetAPI2.getMemoryWithoutUpdate().getBoolean("$cfai_allowPlayerBattleJoinTOff")) continue;
                bl3 = true;
                break;
            }
            for (CampaignFleetAPI campaignFleetAPI2 : this.getSideTwo()) {
                if (!campaignFleetAPI2.getMemoryWithoutUpdate().getBoolean("$cfai_allowPlayerBattleJoinTOff")) continue;
                bl4 = true;
                break;
            }
        }
        if (bl && campaignFleetAPI.isPlayerFleet() && (bl3 || bl4)) {
            CampaignFleetAPI campaignFleetAPI2;
            campaignFleetAPI2 = this.pickSide(campaignFleetAPI, false);
            if (campaignFleetAPI2 == BattleAPI.BattleSide.ONE && bl3) {
                return campaignFleetAPI2;
            }
            if (campaignFleetAPI2 == BattleAPI.BattleSide.TWO && bl4) {
                return campaignFleetAPI2;
            }
        }
        boolean bl5 = campaignFleetAPI.getMemoryWithoutUpdate().is("$isPatrol", true);
        boolean bl6 = Misc.isWarFleet((CampaignFleetAPI)campaignFleetAPI);
        boolean bl7 = this.knowsWhoPlayerIs(this.sideOne) || this.isPlayerSide(this.sideOne) && this.sideOne.size() > 1;
        boolean bl8 = bl2 = this.knowsWhoPlayerIs(this.sideTwo) || this.isPlayerSide(this.sideTwo) && this.sideTwo.size() > 1;
        if (this.isPlayerSide(this.sideOne) && campaignFleetAPI.getFaction().isPlayerFaction()) {
            bl7 = true;
        }
        if (this.isPlayerSide(this.sideTwo) && campaignFleetAPI.getFaction().isPlayerFaction()) {
            bl2 = true;
        }
        boolean bl9 = campaignFleetAPI.isTransponderOn();
        if (!bl && campaignFleetAPI.isPlayerFleet()) {
            campaignFleetAPI.setTransponderOn(true);
        }
        if (!bl || !campaignFleetAPI.isPlayerFleet() && !this.isPlayerInvolved()) {
            bl2 = true;
            bl7 = true;
        }
        if (!campaignFleetAPI.isPlayerFleet() && !this.isPlayerSide(this.sideOne)) {
            bl7 = true;
        }
        if (!campaignFleetAPI.isPlayerFleet() && !this.isPlayerSide(this.sideTwo)) {
            bl2 = true;
        }
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = false;
        boolean bl15 = false;
        boolean bl16 = false;
        boolean bl17 = false;
        boolean bl18 = campaignFleetAPI.getMemoryWithoutUpdate().getBoolean("$noRepImpact");
        boolean bl19 = false;
        boolean bl20 = false;
        boolean bl21 = campaignFleetAPI.getMemoryWithoutUpdate().getBoolean("$everyoneJoinsBattleAgainst");
        boolean bl22 = false;
        boolean bl23 = false;
        for (CampaignFleetAPI campaignFleetAPI3 : this.sideOne) {
            if (campaignFleetAPI3.isHostileTo((SectorEntityToken)campaignFleetAPI)) {
                bl14 = true;
            }
            if (campaignFleetAPI3.isFriendlyTo((SectorEntityToken)campaignFleetAPI)) {
                bl16 = true;
            }
            if (campaignFleetAPI3.getFaction().isPlayerFaction()) {
                bl10 = true;
            }
            if (campaignFleetAPI3.getFaction() == campaignFleetAPI.getFaction()) {
                bl12 = true;
            }
            if (campaignFleetAPI3.getMemoryWithoutUpdate().getBoolean("$noRepImpact")) {
                bl19 = true;
            }
            if (!campaignFleetAPI3.getMemoryWithoutUpdate().getBoolean("$everyoneJoinsBattleAgainst")) continue;
            bl22 = true;
        }
        for (CampaignFleetAPI campaignFleetAPI3 : this.sideTwo) {
            if (campaignFleetAPI3.isHostileTo((SectorEntityToken)campaignFleetAPI)) {
                bl15 = true;
            }
            if (campaignFleetAPI3.isFriendlyTo((SectorEntityToken)campaignFleetAPI)) {
                bl17 = true;
            }
            if (campaignFleetAPI3.getFaction().isPlayerFaction()) {
                bl11 = true;
            }
            if (campaignFleetAPI3.getFaction() == campaignFleetAPI.getFaction()) {
                bl13 = true;
            }
            if (campaignFleetAPI3.getMemoryWithoutUpdate().getBoolean("$noRepImpact")) {
                bl20 = true;
            }
            if (!campaignFleetAPI3.getMemoryWithoutUpdate().getBoolean("$everyoneJoinsBattleAgainst")) continue;
            bl23 = true;
        }
        if (bl21 && bl22 && !bl23) {
            return BattleAPI.BattleSide.ONE;
        }
        if (bl21 && !bl22 && bl23) {
            return BattleAPI.BattleSide.TWO;
        }
        if (bl21) {
            return BattleAPI.BattleSide.NO_JOIN;
        }
        if (!bl && campaignFleetAPI.isPlayerFleet()) {
            campaignFleetAPI.setTransponderOn(bl9);
        }
        if (bl19 && !bl18) {
            bl16 = false;
            bl12 = false;
        }
        if (bl20 && !bl18) {
            bl17 = false;
            bl13 = false;
        }
        if (bl12) {
            bl17 = false;
            bl15 = true;
        }
        if (bl13) {
            bl16 = false;
            bl14 = true;
        }
        bl16 &= bl7;
        bl17 &= bl2;
        if (campaignFleetAPI.getFaction().isPlayerFaction()) {
            if (bl10) {
                bl17 = false;
            } else if (bl11) {
                bl16 = false;
            }
        }
        if (bl5 && !bl14 && !bl19 && bl15) {
            bl16 = true;
        }
        if (bl5 && !bl15 && !bl20 && bl14) {
            bl17 = true;
        }
        if (bl22) {
            bl12 = false;
            bl16 = false;
            bl14 = true;
        }
        if (bl23) {
            bl13 = false;
            bl17 = false;
            bl15 = true;
        }
        if (bl5 && this.isPlayerPrimary()) {
            boolean bl24 = true;
            boolean bl25 = false;
            boolean bl26 = campaignFleetAPI.isFriendlyTo((SectorEntityToken)Global.getSector().getPlayerFleet());
            if (!bl26) {
                List<CampaignFleetAPI> list = this.getNonPlayerSide();
                boolean bl27 = bl22;
                if (list == this.getSideTwo()) {
                    bl27 = bl23;
                }
                for (CampaignFleetAPI campaignFleetAPI4 : list) {
                    if (campaignFleetAPI4.isHostileTo((SectorEntityToken)Global.getSector().getPlayerFleet()) || bl27) {
                        bl24 = false;
                    }
                    if (!campaignFleetAPI4.isHostileTo((SectorEntityToken)campaignFleetAPI) && !bl27) continue;
                    bl25 = true;
                }
                if (bl24 && !bl25) {
                    if (this.sideOne == list) {
                        return BattleAPI.BattleSide.ONE;
                    }
                    return BattleAPI.BattleSide.TWO;
                }
            }
        }
        if (bl3 && !bl14) {
            return BattleAPI.BattleSide.ONE;
        }
        if (bl4 && !bl15) {
            return BattleAPI.BattleSide.TWO;
        }
        if (bl16 && bl7 && bl17 && bl2) {
            return BattleAPI.BattleSide.NO_JOIN;
        }
        if (bl14 && bl7 && bl15 && bl2) {
            return BattleAPI.BattleSide.NO_JOIN;
        }
        if (bl14 && !bl16 && !bl15 && bl2) {
            return BattleAPI.BattleSide.TWO;
        }
        if (!bl14 && bl15 && !bl17 && bl7) {
            return BattleAPI.BattleSide.ONE;
        }
        if (bl16 && !bl14 && !bl17 && bl7) {
            return BattleAPI.BattleSide.ONE;
        }
        if (!bl16 && bl17 && !bl15 && bl2) {
            return BattleAPI.BattleSide.TWO;
        }
        return BattleAPI.BattleSide.NO_JOIN;
    }

    public List<CampaignFleetAPI> getSide(BattleAPI.BattleSide battleSide) {
        if (battleSide == BattleAPI.BattleSide.ONE) {
            return this.sideOne;
        }
        if (battleSide == BattleAPI.BattleSide.TWO) {
            return this.sideTwo;
        }
        return null;
    }

    public List<CampaignFleetAPI> getOtherSide(BattleAPI.BattleSide battleSide) {
        if (battleSide == BattleAPI.BattleSide.ONE) {
            return this.sideTwo;
        }
        if (battleSide == BattleAPI.BattleSide.TWO) {
            return this.sideOne;
        }
        return null;
    }

    public CampaignFleetAPI getCombined(BattleAPI.BattleSide battleSide) {
        if (battleSide == BattleAPI.BattleSide.ONE) {
            return this.combinedOne;
        }
        if (battleSide == BattleAPI.BattleSide.TWO) {
            return this.combinedTwo;
        }
        return null;
    }

    public CampaignFleetAPI getOtherSideCombined(BattleAPI.BattleSide battleSide) {
        if (battleSide == BattleAPI.BattleSide.ONE) {
            return this.combinedTwo;
        }
        if (battleSide == BattleAPI.BattleSide.TWO) {
            return this.combinedOne;
        }
        return null;
    }

    public void uncombine() {
        this.uncombine(this.combinedOne);
        this.uncombine(this.combinedTwo);
    }

    private void uncombine(CampaignFleetAPI campaignFleetAPI) {
        if (campaignFleetAPI == null) {
            return;
        }
        HashSet<CampaignFleetAPI> hashSet = new HashSet<CampaignFleetAPI>();
        for (FleetMemberAPI fleetMemberAPI : campaignFleetAPI.getFleetData().getMembersListCopy()) {
            CampaignFleetAPI campaignFleetAPI2 = this.getMemberSourceMap().get(fleetMemberAPI);
            if (!hashSet.contains(campaignFleetAPI2)) {
                hashSet.add(campaignFleetAPI2);
                ((CampaignFleet)campaignFleetAPI2).getFleetData().setSyncNeeded();
            }
            fleetMemberAPI.setFleetCommanderForStats(null, null);
            if (campaignFleetAPI2 == null) continue;
            ((FleetMember)fleetMemberAPI).setFleetData(((CampaignFleet)campaignFleetAPI2).getFleetData());
        }
    }

    public void leave(CampaignFleetAPI campaignFleetAPI, boolean bl) {
        this.sideOne.remove(campaignFleetAPI);
        this.sideTwo.remove(campaignFleetAPI);
        for (FleetMemberAPI fleetMemberAPI : campaignFleetAPI.getFleetData().getMembersListCopy()) {
            fleetMemberAPI.setFleetCommanderForStats(null, null);
            ((FleetMember)fleetMemberAPI).setFleetData(((CampaignFleet)campaignFleetAPI).getFleetData());
        }
        ((CampaignFleet)campaignFleetAPI).getFleetData().setSyncNeeded();
        if (StarfarerSettings.O\u00d30000() && campaignFleetAPI.getBattle() != null && campaignFleetAPI.getBattle() != this) {
            throw new RuntimeException("Fleet " + campaignFleetAPI + " trying to leave a battle different from its getBattle()");
        }
        this.notifyAbilitiesLeft(campaignFleetAPI, bl);
        campaignFleetAPI.setBattle(null);
        this.genCombined();
    }

    public boolean join(CampaignFleetAPI campaignFleetAPI) {
        BattleAPI.BattleSide battleSide = this.pickSide(campaignFleetAPI);
        List<CampaignFleetAPI> list = this.getSide(battleSide);
        if (list != null) {
            for (CampaignFleetAPI campaignFleetAPI2 : list) {
                if (campaignFleetAPI2 != campaignFleetAPI) continue;
                return true;
            }
            list.add(campaignFleetAPI);
            campaignFleetAPI.setBattle((BattleAPI)this);
            campaignFleetAPI.setInteractionTarget(null);
            this.notifyAbilitiesJoined(campaignFleetAPI);
            return true;
        }
        return false;
    }

    public boolean join(CampaignFleetAPI campaignFleetAPI, BattleAPI.BattleSide battleSide) {
        List<CampaignFleetAPI> list = this.getSide(battleSide);
        if (list != null) {
            for (CampaignFleetAPI campaignFleetAPI2 : list) {
                if (campaignFleetAPI2 != campaignFleetAPI) continue;
                return true;
            }
            list.add(campaignFleetAPI);
            campaignFleetAPI.setBattle((BattleAPI)this);
            campaignFleetAPI.setInteractionTarget(null);
            this.notifyAbilitiesJoined(campaignFleetAPI);
            return true;
        }
        return false;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean runWhilePaused() {
        return false;
    }

    public Vector2f computeCenterOfMass() {
        Vector2f vector2f = new Vector2f();
        float f2 = 0.0f;
        for (CampaignFleetAPI campaignFleetAPI : this.getBothSides()) {
            float f3 = campaignFleetAPI.getRadius();
            vector2f.x += campaignFleetAPI.getLocation().x * f3;
            vector2f.y += campaignFleetAPI.getLocation().y * f3;
            f2 += f3;
        }
        if (f2 <= 0.0f) {
            return vector2f;
        }
        vector2f.scale(1.0f / f2);
        return vector2f;
    }

    public static float[] getMovementData(CampaignFleetAPI campaignFleetAPI, Battle battle) {
        float f2;
        Vector2f vector2f;
        float f3;
        float f4;
        Object object2;
        Vector2f vector2f2 = new Vector2f();
        float f5 = 0.0f;
        List<CampaignFleetAPI> list = battle.getSideFor(campaignFleetAPI);
        List<CampaignFleetAPI> list2 = battle.getOtherSideFor(campaignFleetAPI);
        Vector2f vector2f3 = new Vector2f();
        float f6 = campaignFleetAPI.getRadius();
        float f7 = 10.0f;
        float f8 = 10.0f;
        float f9 = 0.0f;
        for (Object object2 : list) {
            if (object2 == campaignFleetAPI) continue;
            f4 = Misc.getDistance((Vector2f)object2.getLocation(), (Vector2f)campaignFleetAPI.getLocation());
            f3 = object2.getRadius();
            vector2f = Misc.getUnitVectorAtDegreeAngle((float)Misc.getAngleInDegrees((Vector2f)object2.getLocation(), (Vector2f)campaignFleetAPI.getLocation()));
            if (f4 < f6 + f3) {
                f2 = f6 + f3 - f4;
                vector2f3.x += vector2f.x * f2 * f2 * f2 * f2 * f8 + f9;
                vector2f3.y += vector2f.y * f2 * f2 * f2 * f2 * f8 + f9;
                continue;
            }
            if (!(f4 > f6 + f3 + f7)) continue;
            f2 = f4 - f6 - f3;
            vector2f3.x -= vector2f.x * f2 * 2.0f;
            vector2f3.y -= vector2f.y * f2 * 2.0f;
        }
        for (Object object2 : list2) {
            f4 = Misc.getDistance((Vector2f)object2.getLocation(), (Vector2f)campaignFleetAPI.getLocation());
            f3 = object2.getRadius();
            vector2f = Misc.getUnitVectorAtDegreeAngle((float)Misc.getAngleInDegrees((Vector2f)object2.getLocation(), (Vector2f)campaignFleetAPI.getLocation()));
            if (f4 < f6 + f3) {
                f2 = f6 + f3 - f4;
                vector2f3.x += vector2f.x * f2 * f2 * f2 * f2 * f8 + f9;
                vector2f3.y += vector2f.y * f2 * f2 * f2 * f2 * f8 + f9;
            } else if (f4 > f6 + f3 + f7) {
                f2 = f4 - f6 - f3;
                vector2f3.x -= vector2f.x * f2;
                vector2f3.y -= vector2f.y * f2;
            }
            if (!(f4 < f6 + f3 + 100.0f)) continue;
            vector2f2.x += object2.getLocation().x * f3;
            vector2f2.y += object2.getLocation().y * f3;
            f5 += f3;
        }
        if (f5 > 0.0f) {
            vector2f2.x /= f5;
            vector2f2.y /= f5;
        }
        object2 = new float[3];
        float f10 = vector2f3.length();
        boolean bl = f10 < 2.0f;
        Misc.normalise((Vector2f)vector2f3);
        f3 = (float)Math.log(f10);
        if (f3 < 2.0f) {
            f3 = 2.0f;
        }
        vector2f3.scale(f3);
        object2[0] = (CampaignFleetAPI)vector2f3.x;
        object2[1] = (CampaignFleetAPI)vector2f3.y;
        if (bl) {
            object2[1] = (CampaignFleetAPI)0.0f;
            object2[0] = (CampaignFleetAPI)0.0f;
        }
        object2[2] = f5 > 0.0f ? (Object)Misc.getAngleInDegrees((Vector2f)campaignFleetAPI.getLocation(), (Vector2f)vector2f2) : (CampaignFleetAPI)((CampaignFleet)campaignFleetAPI).getDesiredFacing();
        return object2;
    }

    public CampaignFleetAPI getClosestInvolvedFleetTo(CampaignFleetAPI campaignFleetAPI) {
        float f2 = Float.MAX_VALUE;
        CampaignFleetAPI campaignFleetAPI2 = null;
        for (CampaignFleetAPI campaignFleetAPI3 : this.getBothSides()) {
            float f3;
            if (campaignFleetAPI3 == campaignFleetAPI || !((f3 = Misc.getDistance((Vector2f)campaignFleetAPI.getLocation(), (Vector2f)campaignFleetAPI3.getLocation())) < f2)) continue;
            campaignFleetAPI2 = campaignFleetAPI3;
            f2 = f3;
        }
        return campaignFleetAPI2;
    }

    public boolean wasFleetDefeated(CampaignFleetAPI campaignFleetAPI, CampaignFleetAPI campaignFleetAPI2) {
        if (campaignFleetAPI == null) {
            return false;
        }
        List<CampaignFleetAPI> list = this.getSideFor(campaignFleetAPI);
        if (list == null) {
            return false;
        }
        List<CampaignFleetAPI> list2 = this.getSideFor(campaignFleetAPI2);
        if (list2 == null) {
            return false;
        }
        return list2 != list;
    }

    public boolean wasFleetVictorious(CampaignFleetAPI campaignFleetAPI, CampaignFleetAPI campaignFleetAPI2) {
        if (campaignFleetAPI == null) {
            return false;
        }
        List<CampaignFleetAPI> list = this.getSideFor(campaignFleetAPI);
        if (list == null) {
            return false;
        }
        List<CampaignFleetAPI> list2 = this.getSideFor(campaignFleetAPI2);
        if (list2 == null) {
            return false;
        }
        return list2 == list;
    }
}

