/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.combat.entities;

import com.fs.graphics.B;
import com.fs.graphics.Sprite;
import com.fs.graphics.util.OoOO;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.OnHitEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.ApplyDamageResultAPI;
import com.fs.starfarer.api.loading.ProjectileSpawnType;
import com.fs.starfarer.api.loading.ProjectileSpecAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.TimeoutTracker;
import com.fs.starfarer.combat.CombatEngine;
import com.fs.starfarer.combat.CombatViewport;
import com.fs.starfarer.combat.E.OOoO;
import com.fs.starfarer.combat.E.new;
import com.fs.starfarer.combat.ai.ProximityFuseAI;
import com.fs.starfarer.combat.entities.BaseEntity;
import com.fs.starfarer.combat.entities.F;
import com.fs.starfarer.combat.entities.Missile;
import com.fs.starfarer.combat.entities.Ship;
import com.fs.starfarer.combat.entities.ship.A.E;
import com.fs.starfarer.combat.entities.ship.G;
import com.fs.starfarer.combat.systems.thissuper;
import com.fs.starfarer.loading.specs.D;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class PlasmaShot
extends BaseEntity
implements F,
DamagingProjectileAPI,
ProximityFuseAI.o {
    private float health = 0.0f;
    private float maxHealth;
    private OOoO damage;
    private float fadeTime;
    private float hpLossRate;
    private float maxFlightTime;
    private float flightTime = 0.0f;
    private float minSize;
    private float actualSize;
    private float launchPower;
    private float timeToFullBrightness;
    private float brightness = 0.0f;
    private B ray;
    private Sprite sprite;
    private List<o> rays = new ArrayList<o>();
    private Color coreColor;
    private Color fringeColor;
    private Ship source;
    private boolean attached = true;
    private D spec;
    private final thissuper weapon;
    private OnHitEffectPlugin effect = null;
    private Vector2f spawnLocation = new Vector2f();
    float angle = 0.0f;
    private boolean fadedOut = false;
    private new damageTarget;
    private List<new> damagedAlready = new ArrayList<new>();
    private TimeoutTracker<new> damageExempt = new TimeoutTracker();
    private EnumSet<CombatEngineLayers> layers = EnumSet.of(CombatEngineLayers.ABOVE_SHIPS_LAYER);
    private boolean fromMissile = false;

    public Vector2f getSpawnLocation() {
        return this.spawnLocation;
    }

    public PlasmaShot(Ship ship, D d2, thissuper thissuper2) {
        o o2;
        float f2;
        this.spec = d2;
        this.source = ship;
        this.weapon = thissuper2;
        if (ship != null) {
            this.setOwner(ship.getOwner());
        }
        this.minSize = 0.033333335f * d2.getMoveSpeed(ship.getStats(), thissuper2);
        this.timeToFullBrightness = this.minSize / d2.getWidth() * 2.0f;
        this.setCollisionClass(d2.getCollisionClass());
        if (ship.getCollisionClass() == CollisionClass.FIGHTER) {
            this.setCollisionClass(d2.getCollisionClassIfByFighter());
        }
        this.minSize = 5.0f;
        this.setCollisionRadius(d2.getWidth());
        this.setMass(1.0f);
        this.setDamage(d2.getDamage().clone());
        this.damage.setStats(ship.getStats());
        this.health = this.maxHealth = d2.getMaxHealth();
        float f3 = 0.0f;
        if (d2.getBehaviorSpec() != null && d2.getBehaviorSpec().getParams() != null) {
            f3 = (float)d2.getBehaviorSpec().getParams().optDouble("shotRangeVariance", 0.0);
            f2 = (float)d2.getBehaviorSpec().getParams().optDouble("probOfVariance", 1.0);
            if ((float)Math.random() >= f2) {
                f3 = 0.0f;
            }
        }
        f2 = com.fs.starfarer.combat.entities.ship.E.getAdjustedBaseRange(d2.getMaxRange(), ship, thissuper2);
        this.maxFlightTime = com.fs.starfarer.combat.entities.ship.E.getThresholdAdjustedRange(ship, thissuper2, f2 * (1.0f - f3 * (float)Math.random()) * com.fs.starfarer.combat.entities.ship.E.computeExtraRangeMult(ship, thissuper2) + com.fs.starfarer.combat.entities.ship.E.computeExtraRangeFlat(ship, thissuper2)) / d2.getMoveSpeed(ship.getStats(), thissuper2);
        this.fadeTime = d2.getFadeTime();
        this.coreColor = d2.getCoreColor();
        this.fringeColor = d2.getFringeColor();
        this.ray = com.fs.graphics.G.new((String)"graphics/fx/torpedoray32.png");
        this.sprite = new Sprite(this.ray);
        this.sprite.setBlendFunc(770, 1);
        int n = 0;
        while (n < 6) {
            o2 = new o();
            o2.String = (float)n * 360.0f / 6.0f;
            o2.\u00d200000 = 160.0f;
            o2.\u00d300000 = (float)Math.random() * 0.25f + 0.75f;
            this.rays.add(o2);
            ++n;
        }
        n = 0;
        while (n < 5) {
            o2 = new o();
            o2.String = (float)n * 360.0f / 5.0f;
            o2.\u00d200000 = -160.0f;
            o2.\u00d300000 = (float)Math.random() * 0.25f + 0.75f;
            this.rays.add(o2);
            ++n;
        }
        this.effect = d2.getOnHitEffect();
        this.setChargeProgress(1.0f);
        this.notifyDetached(1.0f);
    }

    @Override
    public WeaponAPI getWeapon() {
        return this.weapon;
    }

    private void updateSpriteSize(float f2) {
        float f3 = this.actualSize * f2 * Math.min(this.brightness * 5.0f, 1.0f);
        this.sprite.setSize(f3 / 4.0f, f3);
        this.sprite.setCenter(f3 / 8.0f, f3 * 0.2f);
    }

    @Override
    public void render(CombatEngineLayers combatEngineLayers, CombatViewport combatViewport) {
        if (!combatViewport.isNearViewport(this.getLocation(), this.getCollisionRadius() + 50.0f)) {
            return;
        }
        this.render(combatEngineLayers, combatViewport, 1.0f);
    }

    public float getBrightness() {
        int n = (int)(255.0f * this.health / this.maxHealth * this.brightness);
        return (float)n / 255.0f;
    }

    public void render(CombatEngineLayers combatEngineLayers, CombatViewport combatViewport, float f2) {
        int n = (int)(255.0f * this.health / this.maxHealth * this.brightness);
        this.sprite.setColorLL(OoOO.\u00d200000((Color)this.coreColor, (int)n));
        this.sprite.setColorLR(OoOO.\u00d200000((Color)this.coreColor, (int)n));
        this.sprite.setColorUL(OoOO.\u00d200000((Color)this.fringeColor, (int)n));
        this.sprite.setColorUR(OoOO.\u00d200000((Color)this.fringeColor, (int)n));
        for (o o2 : this.rays) {
            this.updateSpriteSize(o2.\u00d300000);
            this.sprite.setAlphaMult(f2);
            this.sprite.setAngle(o2.String);
            this.sprite.renderAtCenterWithCornerColors(this.getLocation().x, this.getLocation().y);
        }
    }

    @Override
    public void advance(float f2) {
        this.brightness = this.attached ? (this.brightness += f2 / this.timeToFullBrightness) : (this.brightness += f2 * 5.0f);
        if (this.brightness > 1.0f) {
            this.brightness = 1.0f;
        }
        for (o o2 : this.rays) {
            o2.String += o2.\u00d200000 * f2 * (this.launchPower * 0.5f + 0.5f);
        }
        if (!this.attached && this.flightTime >= this.maxFlightTime) {
            this.health -= f2 * this.hpLossRate;
            if (this.health <= 0.0f) {
                this.fadedOut = true;
            }
            this.damage.setMultiplier(this.launchPower * this.health / this.maxHealth);
            this.damage.setSoftFlux(true);
        } else if (!this.attached) {
            this.flightTime += f2;
        }
    }

    public void setChargeProgress(float f2) {
        this.launchPower = f2;
        this.health = this.maxHealth = this.launchPower * this.spec.getMaxHealth();
        this.damage.setMultiplier(this.launchPower);
        this.actualSize = Math.max(this.minSize, this.spec.getWidth() * this.launchPower);
        this.hpLossRate = this.maxHealth / this.fadeTime;
        this.setCollisionRadius(this.actualSize / 6.0f);
    }

    public OOoO getDamage() {
        return this.damage;
    }

    @Override
    public OOoO getDamage(Vector2f vector2f, new new_) {
        if (this.damagedAlready.contains(new_)) {
            return new OOoO(0.0f, false, this.damage.getType(), this.source.getStats());
        }
        return this.damage;
    }

    public void addDamagedAlready(new new_) {
        this.damagedAlready.add(new_);
    }

    public void removeDamagedAlready(new new_) {
        this.damagedAlready.remove(new_);
    }

    @Override
    public boolean isDestroyedByCollision(new new_) {
        boolean bl = false;
        if (this.spec.isPassThroughMissiles() && new_ instanceof Missile) {
            bl = true;
        } else if (this.spec.isPassThroughFighters() && new_ instanceof Ship && ((Ship)new_).isFighter() && (!this.spec.isPassThroughFightersOnlyWhenDestroyed() || new_.getHitpoints() <= 0.0f)) {
            bl = true;
        }
        return !bl;
    }

    @Override
    public boolean isExpired() {
        return this.fadedOut;
    }

    public void setDamage(OOoO oOoO2) {
        this.damage = oOoO2;
    }

    @Override
    public Ship getSource() {
        return this.source;
    }

    public void setSource(ShipAPI shipAPI) {
        this.source = (Ship)shipAPI;
    }

    public void setCoreColor(Color color) {
        this.coreColor = color;
    }

    public boolean isAttached() {
        return this.attached;
    }

    public void notifyDetached(float f2) {
        this.attached = false;
        float[] fArray = com.fs.starfarer.combat.entities.ship.E.computeExtraDamageComponents(this.source, this.weapon);
        if (fArray != null) {
            this.damage.getModifier().modifyPercent("core_edc_0", fArray[0]);
            this.damage.getModifier().modifyFlat("core_edc_1", fArray[1]);
            this.damage.getModifier().modifyMult("core_edc_2", fArray[2]);
        }
    }

    @Override
    public G applyDamage(Vector2f vector2f, OOoO oOoO2, boolean bl, float f2, Object object) {
        float f3 = oOoO2.computeDamageDealt(f2);
        this.health -= oOoO2.computeDamageDealt(f2);
        if (this.health < 0.0f) {
            f3 += this.health;
            this.health = 0.0f;
        }
        oOoO2.setMultiplier(this.launchPower * this.health / this.maxHealth);
        return new G(oOoO2.getType(), f3, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public F.o notifyDealtDamage(Vector2f vector2f, G g2, new new_) {
        if (this.damagedAlready.contains(new_)) {
            return F.o.new;
        }
        this.damagedAlready.add(new_);
        this.damageTarget = new_;
        float f2 = this.spec.getHitGlowRadius();
        if (f2 == 0.0f) {
            f2 = this.spec.getWidth() * 2.0f;
        }
        float f3 = f2 / 1.0f;
        float f4 = f2 / 2.0f;
        float f5 = f3 + (float)Math.random() * f4;
        f5 = Misc.getHitGlowSize((float)f5, (float)this.getDamage().getBaseDamage(), (ApplyDamageResultAPI)g2);
        E.o00000(vector2f, g2, f5 * (0.25f + this.damage.getMultiplier() * 0.75f), new_, this.coreColor, 0.25f + 0.75f * this.damage.getMultiplier(), 0.25f + 0.75f * this.damage.getMultiplier(), 1.0f);
        if (this.health < 0.0f) {
            this.health = 0.0f;
        }
        this.damage.setMultiplier(this.launchPower * this.health / this.maxHealth);
        if (this.effect != null) {
            this.effect.onHit((DamagingProjectileAPI)this, (CombatEntityAPI)new_, vector2f, g2.getDamageToShields() > 0.0f, (ApplyDamageResultAPI)g2, (CombatEngineAPI)CombatEngine.getInstance());
        }
        boolean bl = false;
        if (this.spec.isPassThroughMissiles() && new_ instanceof Missile) {
            bl = true;
        } else if (this.spec.isPassThroughFighters() && new_ instanceof Ship && ((Ship)new_).isFighter() && (!this.spec.isPassThroughFightersOnlyWhenDestroyed() || new_.getHitpoints() <= 0.0f)) {
            bl = true;
        }
        if (bl) {
            return F.o.new;
        }
        this.health = 0.0f;
        this.damage.setMultiplier(this.launchPower * this.health / this.maxHealth);
        return F.o.\u00d400000;
    }

    public float getFadeTime() {
        return this.fadeTime;
    }

    public void setFadeTime(float f2) {
        this.fadeTime = f2;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public EnumSet<CombatEngineLayers> getActiveLayers() {
        return this.layers;
    }

    @Override
    public void init() {
    }

    public float getLaunchPower() {
        return this.launchPower;
    }

    @Override
    public float getMass() {
        return this.spec.getImpactMass() * this.damage.getMultiplier();
    }

    public float getDamageAmount() {
        return this.damage.getDamage();
    }

    public float getBaseDamageAmount() {
        return this.damage.getBaseDamage();
    }

    public void setDamageAmount(float f2) {
        this.damage.setDamage(f2);
    }

    public DamageType getDamageType() {
        return this.damage.getType();
    }

    public String getProjectileSpecId() {
        return this.spec.getId();
    }

    @Override
    public boolean didDamage() {
        return this.damageTarget != null;
    }

    public float getEmpAmount() {
        return this.damage.getFluxComponent();
    }

    public CombatEntityAPI getDamageTarget() {
        return this.damageTarget instanceof CombatEntityAPI ? this.damageTarget : null;
    }

    @Override
    public boolean isFading() {
        return this.health < this.maxHealth;
    }

    public ProjectileSpawnType getSpawnType() {
        return this.spec.getSpawnType();
    }

    public float getElapsed() {
        return this.flightTime;
    }

    @Override
    public boolean isFromMissile() {
        return this.fromMissile;
    }

    public void setFromMissile(boolean bl) {
        this.fromMissile = bl;
    }

    public void addDamagedAlready(CombatEntityAPI combatEntityAPI) {
    }

    public void removeDamagedAlready(CombatEntityAPI combatEntityAPI) {
    }

    public float getMoveSpeed() {
        return this.spec.getMoveSpeed(this.source.getStats(), this.weapon);
    }

    public ProjectileSpecAPI getProjectileSpec() {
        return this.spec;
    }

    public Vector2f getTailEnd() {
        return null;
    }

    public List<CombatEntityAPI> getDamagedAlready() {
        return null;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class o {
        private float String;
        private float \u00d200000;
        private float \u00d300000;

        private o() {
        }
    }
}

