/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.renderers.damage;

import com.fs.graphics.B;
import com.fs.graphics.G;
import com.fs.graphics.H;
import com.fs.graphics.anim.Animation;
import com.fs.graphics.anim.AnimationManager;
import com.fs.graphics.anim.BaseAnimation;
import com.fs.graphics.float;
import com.fs.graphics.particle.BaseParticle;
import com.fs.graphics.particle.DynamicParticleGroup;
import com.fs.graphics.particle.GenericTextureParticle;
import com.fs.graphics.particle.SmoothParticle;
import com.fs.graphics.util.OoOO;
import com.fs.profiler.Profiler;
import com.fs.starfarer.combat.CombatEngine;
import com.fs.starfarer.combat.CombatViewport;
import com.fs.starfarer.combat.entities.BallisticProjectile;
import com.fs.starfarer.combat.entities.Missile;
import com.fs.starfarer.combat.entities.Ship;
import com.fs.starfarer.renderers.O;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.starfarer.util.oOOO.C;
import com.fs.starfarer.util.oOOO.new;
import com.fs.starfarer.util.oOOO.super;
import com.fs.util.ooOO;
import java.awt.Color;
import java.io.IOException;
import java.util.Iterator;
import java.util.Random;
import org.json.JSONException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class ExplosionParticleSystem
extends BaseAnimation {
    private DynamicParticleGroup[] groups = new DynamicParticleGroup[5];
    private B[] textures = new B[this.groups.length];
    private CombatViewport viewport = null;
    private Random random = new Random();

    public ExplosionParticleSystem() {
        this.textures[0] = G.new((String)"graphics/fx/explosion0.png");
        this.textures[1] = G.new((String)"graphics/fx/explosion1.png");
        this.textures[2] = G.new((String)"graphics/fx/explosion2.png");
        this.textures[3] = G.new((String)"graphics/fx/explosion_ring0.png");
        this.textures[4] = G.new((String)"fs.common/graphics/particlealpha32sq.png");
        int n = 0;
        while (n < this.groups.length) {
            this.groups[n] = new DynamicParticleGroup();
            ++n;
        }
    }

    public void advance(float f2) {
        Profiler.new((String)"ExplosionParticleSystem.advance()");
        if (this.viewport == null) {
            this.viewport = CombatEngine.getInstance().getViewport();
        }
        int n = 0;
        while (n < this.groups.length) {
            this.groups[n].advance(f2);
            ++n;
        }
        Profiler.o00000();
    }

    public void render(float f2, float f3) {
        int n = 0;
        while (n < this.groups.length) {
            this.groups[n].render(f2, f3);
            ++n;
        }
    }

    public float getExplosionSizeForCollidable(com.fs.starfarer.combat.E.new new_, float f2) {
        float f3 = (float)Math.sqrt(new_.getCollisionRadius()) * 15.0f * 4.0f;
        if (new_ instanceof Ship && ((Ship)new_).isFighter()) {
            f3 = (float)Math.sqrt(new_.getCollisionRadius()) * 15.0f * 1.75f;
        } else if (new_ instanceof Missile) {
            f3 = new_.getCollisionRadius() * 4.0f;
        } else if (new_ instanceof BallisticProjectile) {
            f3 = new_.getCollisionRadius() * 1.0f;
        }
        return f3 *= f2;
    }

    public void spawnExplosion(com.fs.starfarer.combat.E.new new_) {
        this.spawnExplosion(new_, 1.0f, null);
    }

    public void spawnExplosion(com.fs.starfarer.combat.E.new new_, float f2, Vector2f vector2f) {
        this.spawnExplosion(new_, f2, vector2f, null, null);
    }

    public void spawnExplosion(com.fs.starfarer.combat.E.new new_, float f2, Vector2f vector2f, Vector2f vector2f2, Color color) {
        Missile missile;
        float f3 = this.getExplosionSizeForCollidable(new_, f2);
        float f4 = 2.0f;
        if (new_ instanceof Ship && ((Ship)new_).isFighter()) {
            f4 = 1.0f;
        }
        if (vector2f == null && (vector2f = new Vector2f()) == null && new_ instanceof Ship) {
            vector2f.set((ReadableVector2f)new_.getVelocity());
        }
        Color color2 = new Color(255, 165, 100);
        if (new_ instanceof Missile) {
            missile = (Missile)new_;
            color2 = missile.getSpec().getDestroyedExplosionColor();
            if (missile.getDestroyedExplosionColorOverride() != null) {
                color2 = missile.getDestroyedExplosionColorOverride();
            }
        }
        if (color != null) {
            color2 = color;
        }
        missile = new_.getLocation();
        if (vector2f2 != null) {
            missile = vector2f2;
        }
        this.spawnExplosion((Vector2f)missile, vector2f, color2, f3, f4);
    }

    public void spawnExplosion(Vector2f vector2f, Vector2f vector2f2, Color color, float f2, float f3) {
        this.spawnExplosion(vector2f, vector2f2, color, f2, f3, true, null);
    }

    public void spawnExplosion(Vector2f vector2f, Vector2f vector2f2, Color color, float f2, float f3, boolean bl, Random random) {
        if (random == null) {
            random = this.random;
        }
        float f4 = 10.0f;
        float f5 = 0.0f;
        float f6 = 20.0f + 60.0f * f2 / 500.0f;
        float f7 = 20.0f * f2 / 500.0f;
        float f8 = f6;
        float f9 = f2 / 2.0f * f2 / 2.0f * (float)Math.PI;
        float f10 = f6 * 0.66f * f6 * 0.66f * (float)Math.PI;
        float f11 = f9 / f10 * 6.0f;
        if (f11 < 5.0f) {
            f11 = 5.0f;
        }
        int n = -1;
        int n2 = 0;
        while ((float)n2 < f11) {
            int n3 = (int)(random.nextDouble() * (double)(this.groups.length + n));
            if (n3 == 3) {
                n3 = (int)(random.nextDouble() * (double)(this.groups.length + n));
            }
            boolean bl2 = false;
            if (n3 >= this.groups.length - 1) {
                n3 = this.groups.length - 1;
                bl2 = true;
            }
            float f12 = f6 + f8 * random.nextFloat();
            float f13 = f12 * 1.25f;
            if (n3 == 3) {
                f13 = f12 * 3.0f;
                f12 = f13 / 10.0f;
            } else if (bl2) {
                f13 = f12 *= 1.5f;
            }
            GenericTextureParticle genericTextureParticle = new GenericTextureParticle(this.textures[n3], f12, f13, 0.0f);
            genericTextureParticle.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 50));
            if (bl) {
                genericTextureParticle.setBlendFunc(770, 1);
            } else {
                genericTextureParticle.setBlendFunc(770, 771);
            }
            genericTextureParticle.setMaxAge(f3);
            genericTextureParticle.setRampUpPeriod(0.0f);
            float f14 = random.nextFloat() * 360.0f;
            float f15 = (float)Math.cos(f14);
            float f16 = (float)Math.sin(f14);
            genericTextureParticle.setAngle(random.nextFloat() * 360.0f);
            float f17 = random.nextFloat();
            float f18 = f2 / 4.0f * f17;
            if (n3 == 3 || (float)n2 < 5.0f) {
                f18 = 0.0f;
            }
            float f19 = f4 + random.nextFloat() * f7;
            if (n3 == 3) {
                genericTextureParticle.setVel(vector2f2.x, vector2f2.y);
            } else {
                genericTextureParticle.setVel(f15 * f19 + vector2f2.x, f16 * f19 + vector2f2.y);
            }
            float f20 = f15 * f18 * 1.0f;
            float f21 = f16 * f18 * 1.0f;
            genericTextureParticle.setPos(vector2f.x + f20, vector2f.y + f21);
            this.groups[n3].add((BaseParticle)genericTextureParticle);
            ++n2;
        }
    }

    public static void main(String[] stringArray) throws IOException, JSONException {
        int n = 1024;
        int n2 = 768;
        float float_ = new float();
        float_.o00000("Explosion Test");
        float_.\u00d200000(StarfarerSettings.\u00d6\u00d60000());
        float_.Object(n);
        float_.\u00d500000(n2);
        float_.o00000(true);
        float_.Object(false);
        float_.\u00d200000(false, 0, 0);
        ooOO.\u00d300000().\u00d500000();
        ooOO.\u00d300000().\u00d500000("../starfarer.res/res");
        ooOO.\u00d300000().\u00d200000();
        StarfarerSettings.\u00f6\u00d40000();
        G.o00000((String)"graphics/fx/explosion0.png", (String)"graphics/fx/explosion0.png");
        G.o00000((String)"graphics/fx/explosion1.png", (String)"graphics/fx/explosion1.png");
        G.o00000((String)"graphics/fx/explosion2.png", (String)"graphics/fx/explosion2.png");
        G.o00000((String)"graphics/fx/explosion_ring0.png", (String)"graphics/fx/explosion_ring0.png");
        new SmoothParticle(Color.white, 1.0f);
        ExplosionParticleSystem explosionParticleSystem = new ExplosionParticleSystem();
        AnimationManager.getInstance().addAnimation((Animation)explosionParticleSystem);
        float f2 = 0.016666668f;
        float f3 = 100.0f;
        boolean bl = false;
        block11: while (true) {
            OoOO.return();
            boolean bl2 = Mouse.isButtonDown((int)0);
            if (bl2 && !bl) {
                System.out.println("Pressed");
            }
            if (bl && !bl2) {
                System.out.println("Released");
            }
            bl = bl2;
            float f4 = n;
            float f5 = n2;
            OoOO.o00000((float)f4, (float)f5, (float)1000.0f);
            H h2 = new H();
            h2.super((int)(-f3), (int)(-f3), (int)f3 * 2, (int)f3 * 2, false);
            explosionParticleSystem.render(0.0f, 0.0f);
            h2.\u00d200000();
            h2.\u00d600000();
            O.\u00d300000((float)n / 2.0f + (float)((int)(-f3)) + 20.0f, (float)n2 / 2.0f + (float)((int)(-f3)) + 20.0f, (int)f3 * 2 + 40, (int)f3 * 2 + 40, Color.red, 1.0f);
            h2.\u00d500000().renderAtCenter((float)n / 2.0f, (float)n2 / 2.0f);
            GL11.glDeleteTextures((int)h2.\u00d500000().getTexture().\u00f600000());
            OoOO.\u00d500000();
            if (Display.isCloseRequested() || Keyboard.isKeyDown((int)1)) break;
            Display.sync((int)60);
            long l2 = OoOO.\u00d400000();
            Display.update();
            long l3 = OoOO.\u00d400000();
            long l4 = l3 - l2;
            if (l4 > 20L) {
                System.out.println("Delta: " + l4);
            }
            AnimationManager.getInstance().advanceAll(f2);
            new new_ = super.\u00d300000();
            Iterator iterator = new_.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block11;
                C c2 = (C)iterator.next();
                if (c2.isMouseDownEvent() && c2.getEventValue() == 0) {
                    explosionParticleSystem.spawnExplosion(new Vector2f(), new Vector2f(), new Color(255, 165, 100), f3, 1.5f);
                }
                if (!c2.isKeyDownEvent()) continue;
                switch (c2.getEventValue()) {
                    case 2: {
                        f3 = 100.0f;
                        break;
                    }
                    case 3: {
                        f3 = 200.0f;
                        break;
                    }
                    case 4: {
                        f3 = 300.0f;
                        break;
                    }
                    case 5: {
                        f3 = 400.0f;
                        break;
                    }
                    case 6: {
                        f3 = 500.0f;
                        break;
                    }
                    case 7: {
                        f3 = 600.0f;
                        break;
                    }
                    case 8: {
                        f3 = 700.0f;
                        break;
                    }
                    case 9: {
                        f3 = 800.0f;
                        break;
                    }
                    case 10: {
                        f3 = 900.0f;
                    }
                }
                System.out.println("Size set to " + f3);
            }
            break;
        }
    }
}

