/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.renderers.fx;

import com.fs.graphics.particle.BaseParticle;
import com.fs.graphics.particle.BaseParticleEmitter;
import com.fs.graphics.particle.DynamicParticleGroup;
import com.fs.starfarer.combat.CombatEngine;
import com.fs.starfarer.combat.CombatViewport;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.renderers.fx.DetailedSmokeParticle;
import java.awt.Color;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SmokeEmitter
extends BaseParticleEmitter {
    private float emitDuration;
    private float size;
    private float duration;
    private Color color = new Color(255, 255, 255, 25);
    private Vector2f offset;
    private o delegate;
    private DynamicParticleGroup group;
    private CombatViewport viewport;
    private float totalElapsed = 0.0f;

    public SmokeEmitter(float f2, float f3, Vector2f vector2f, float f4, o o2) {
        this.emitDuration = f4;
        this.size = f2;
        this.duration = f3;
        this.offset = vector2f;
        this.delegate = o2;
        this.group = CombatEngine.getInstance().getSmokeParticles();
        this.viewport = CombatEngine.getInstance().getViewport();
    }

    public void emit(float f2) {
        this.totalElapsed += f2;
        Vector2f vector2f = this.computeSpawnLocation();
        if (!this.viewport.isNearViewport(vector2f, 100.0f)) {
            return;
        }
        Vector2f vector2f2 = Utils.\u00d300000(this.computeAngle() + (float)Math.random() * 40.0f - 20.0f);
        vector2f.x -= vector2f2.x * this.size / 2.0f;
        vector2f.y -= vector2f2.y * this.size / 2.0f;
        vector2f2.scale((float)Math.random() * 75.0f);
        float f3 = 10.0f;
        float f4 = (float)Math.random() * f3 - f3 / 2.0f;
        float f5 = (float)Math.random() * f3 - f3 / 2.0f;
        vector2f.x += f4;
        vector2f.y += f5;
        int n = (int)(25.0f + 100.0f * (float)Math.random());
        this.color = new Color(n * 2, n, n / 2, 50);
        DetailedSmokeParticle detailedSmokeParticle = new DetailedSmokeParticle(this.color, this.size, this.size * 3.0f);
        detailedSmokeParticle.setVel(vector2f2.x, vector2f2.y);
        detailedSmokeParticle.setPos(vector2f.x, vector2f.y);
        detailedSmokeParticle.setMaxAge(this.duration * 0.5f + this.duration * (float)Math.random());
        detailedSmokeParticle.setRampUpPeriod(Math.min(0.3f, 0.5f / this.duration));
        detailedSmokeParticle.setAngle((float)Math.random() * 360.0f);
        detailedSmokeParticle.setRotationSpeed((float)Math.random() * 140.0f - 70.0f);
        this.group.add((BaseParticle)detailedSmokeParticle);
    }

    public void everyFrame(float f2) {
    }

    public float getInterval() {
        return 0.05f;
    }

    public boolean isDone() {
        return this.delegate.super() || this.totalElapsed > this.emitDuration;
    }

    private float computeAngle() {
        return Utils.\u00d300000(new Vector2f(), this.offset) + this.delegate.\u00d200000();
    }

    private Vector2f computeSpawnLocation() {
        float f2 = this.delegate.\u00d200000();
        Vector2f vector2f = new Vector2f((ReadableVector2f)this.delegate.\u00d300000());
        float f3 = (float)Math.cos(Math.toRadians(f2));
        float f4 = (float)Math.sin(Math.toRadians(f2));
        vector2f.x += this.offset.x * f3 - this.offset.y * f4;
        vector2f.y += this.offset.x * f4 + this.offset.y * f3;
        return vector2f;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static interface o {
        public Vector2f \u00d300000();

        public boolean super();

        public float \u00d200000();
    }
}

