/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.starfarer.api.campaign.BuffManagerAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.campaign.fleet.FleetMember;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class BuffManager
implements DoNotObfuscate,
BuffManagerAPI {
    private FleetMember member;
    private List<BuffManagerAPI.Buff> buffs = new LinkedList<BuffManagerAPI.Buff>();

    public BuffManager(FleetMember fleetMember) {
        this.member = fleetMember;
    }

    protected Object readResolve() {
        if (this.buffs instanceof ArrayList) {
            this.buffs = new LinkedList<BuffManagerAPI.Buff>(this.buffs);
        }
        return this;
    }

    public void addBuff(BuffManagerAPI.Buff buff) {
        this.buffs.add(buff);
        this.member.setStatUpdateNeeded(true);
    }

    public void addBuffOnlyUpdateStat(BuffManagerAPI.Buff buff) {
        Iterator<BuffManagerAPI.Buff> iterator = this.buffs.iterator();
        while (iterator.hasNext()) {
            BuffManagerAPI.Buff buff2 = iterator.next();
            if (buff2.getId() == null || !buff2.getId().equals(buff.getId())) continue;
            iterator.remove();
            break;
        }
        this.buffs.add(buff);
        buff.apply((FleetMemberAPI)this.member);
    }

    public void applyBuffs(FleetMemberAPI fleetMemberAPI) {
        for (BuffManagerAPI.Buff buff : this.buffs) {
            buff.apply(fleetMemberAPI);
        }
    }

    public void removeBuff(String string) {
        Iterator<BuffManagerAPI.Buff> iterator = this.buffs.iterator();
        while (iterator.hasNext()) {
            BuffManagerAPI.Buff buff = iterator.next();
            if (buff.getId() == null || !buff.getId().equals(string)) continue;
            this.member.setStatUpdateNeeded(true);
            iterator.remove();
        }
    }

    public void advance(float f2) {
        Iterator<BuffManagerAPI.Buff> iterator = this.buffs.iterator();
        while (iterator.hasNext()) {
            BuffManagerAPI.Buff buff = iterator.next();
            buff.advance(f2);
            if (!buff.isExpired()) continue;
            this.member.setStatUpdateNeeded(true);
            iterator.remove();
        }
    }

    public List<BuffManagerAPI.Buff> getBuffs() {
        return this.buffs;
    }

    public BuffManagerAPI.Buff getBuff(String string) {
        for (BuffManagerAPI.Buff buff : this.buffs) {
            if (buff.getId() == null || !buff.getId().equals(string)) continue;
            return buff;
        }
        return null;
    }
}

