/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.graphics.Sprite;
import com.fs.graphics.util.Fader;
import com.fs.starfarer.String.M;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.RenderingAffectedByAbyssalDepth;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.shared.WormholeManager;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.BaseCampaignEntity;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.CampaignPlanet;
import com.fs.starfarer.campaign.DynamicRingBand;
import com.fs.starfarer.campaign.StarSystem;
import com.fs.starfarer.combat.CombatViewport;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.renderers.D;
import com.fs.starfarer.renderers.O;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.starfarer.ui.newui.O00O;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class JumpPoint
extends BaseCampaignEntity
implements JumpPointAPI,
RenderingAffectedByAbyssalDepth,
DoNotObfuscate {
    private float radius = 50.0f;
    private List<JumpPointAPI.JumpDestination> destinations = new ArrayList<JumpPointAPI.JumpDestination>();
    private transient Sprite ring;
    private transient Sprite ring2;
    private transient Sprite corona;
    private transient Sprite destSprite;
    private transient Sprite mask;
    private transient Sprite glow;
    private transient O00O planetRenderer;
    private String destSpriteCategory;
    private String destSpriteId;
    private CampaignPlanet destPlanet;
    private CampaignPlanet relatedPlanet;
    private float sinceOpened = 1000.0f;
    private Fader fader = new Fader(1.0f, 1.0f);
    private transient List<RingData> ringData = new ArrayList<RingData>();
    private transient List<CoronaData> coronaData = new ArrayList<CoronaData>();
    private transient RingData bgOffset = new RingData(0.1f);
    private transient boolean autoCreateEntranceFromHyperspace = true;
    private transient List<DynamicRingBand> bands = new ArrayList<DynamicRingBand>();
    protected Boolean computedAbyssState = null;
    private EnumSet<CampaignEngineLayers> layers = EnumSet.of(CampaignEngineLayers.JUMP_POINTS);

    public JumpPoint(String string, String string2) {
        super(string);
        this.setName(string2);
        this.fader.forceIn();
        this.addTag("jump_point");
        this.readResolve();
    }

    @Override
    protected Object readResolve() {
        Object object;
        int n;
        super.readResolve();
        this.bands = new ArrayList<DynamicRingBand>();
        this.bands.clear();
        float f2 = this.getRadius() * 0.45f;
        float f3 = this.getRadius() * (float)Math.PI * 2.0f;
        float f4 = f3 / 50.0f;
        if (f4 < 3.0f) {
            f4 = 3.0f;
        }
        if (f4 > 10.0f) {
            f4 = 10.0f;
        }
        float f5 = this.getRadius() * 1.25f;
        float f6 = this.getRadius() * 0.005f;
        if (f6 > 0.5f) {
            f6 = 0.5f;
        }
        this.bands.add(new DynamicRingBand("misc", "wormhole_bands", 64.0f, 2, Color.white, f5, f4, f2 + this.getRadius() * 0.25f - f5 * 0.05f, 5.0f, f6, 100.0f, 10.0f, true));
        this.bands.add(new DynamicRingBand("misc", "wormhole_bands", 64.0f, 2, Color.white, f5, f4, f2 + this.getRadius() * 0.25f - f5 * 0.05f, -5.0f, f6, 100.0f, 10.0f, true));
        this.ring = StarfarerSettings.\u00d600000("misc", "wormhole_ring");
        this.ring2 = StarfarerSettings.\u00d600000("misc", "wormhole_ring2");
        this.corona = StarfarerSettings.\u00d600000("misc", "wormhole_corona");
        this.mask = new Sprite("graphics/fx/circle64.png");
        this.glow = new Sprite("graphics/fx/hit_glow.png");
        this.updateDestGraphics();
        if (this.ringData == null) {
            this.ringData = new ArrayList<RingData>();
        }
        if (this.ringData.isEmpty()) {
            this.ringData.clear();
            n = 0;
            while (n < 25) {
                object = new RingData(1.0f);
                this.ringData.add((RingData)object);
                ++n;
            }
        }
        if (this.bgOffset == null) {
            this.bgOffset = new RingData(0.1f);
        }
        if (this.coronaData == null) {
            this.coronaData = new ArrayList<CoronaData>();
        }
        if (this.coronaData.isEmpty()) {
            this.coronaData.clear();
            n = 0;
            while (n < 6) {
                object = new CoronaData();
                this.coronaData.add((CoronaData)object);
                ++n;
            }
        }
        return this;
    }

    public StarSystemAPI getDestinationStarSystem() {
        for (JumpPointAPI.JumpDestination jumpDestination : this.getDestinations()) {
            if (jumpDestination.getDestination() == null || !(jumpDestination.getDestination().getContainingLocation() instanceof StarSystemAPI)) continue;
            return (StarSystemAPI)jumpDestination.getDestination().getContainingLocation();
        }
        return null;
    }

    public boolean isStarAnchor() {
        return this.destPlanet != null && this.destPlanet.isStar();
    }

    public boolean isGasGiantAnchor() {
        return this.destPlanet != null && this.destPlanet.isGasGiant();
    }

    @Override
    public void render(CampaignEngineLayers campaignEngineLayers, CombatViewport combatViewport) {
        float f2;
        float f3;
        float f4;
        if (!this.isVisible(this.getRadius() * 1.75f * 2.2f)) {
            return;
        }
        boolean bl = this.isWormhole();
        boolean bl2 = false;
        float f5 = combatViewport.getAlphaMult();
        f5 *= this.getAlphaMultFromAbyssalDepth();
        if (this.hasSensorProfile()) {
            f5 *= this.getSensorFaderBrightness();
        }
        if (f5 <= 0.0f) {
            return;
        }
        float f6 = 1.55f;
        float f7 = this.getLocation().getX();
        float f8 = this.getLocation().getY();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)f7, (float)f8, (float)0.0f);
        float f9 = this.fader.getBrightness();
        f9 *= f9;
        float f10 = this.getScale();
        if (f10 < 1.0f) {
            GL11.glScalef((float)f10, (float)f10, (float)1.0f);
        }
        f8 = 0.0f;
        f7 = 0.0f;
        if (this.destSprite != null) {
            f4 = this.getRadius() * 1.2f;
            this.mask.setSize(f4, f4);
            GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
            f3 = Math.max(this.destSprite.getWidth(), this.destSprite.getHeight());
            O.\u00d500000(f7 - f3, f8 - f3, f3 * 2.0f, f3 * 2.0f, D.o00000, 1.0f);
            this.mask.setAlphaMult(f5);
            this.mask.setBlendFunc(770, 0);
            this.mask.renderAtCenter(f7, f8);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            float f11 = this.destSprite.getWidth();
            f2 = this.destSprite.getHeight();
            float f12 = 1.0f;
            this.destSprite.setAlphaMult(f5);
            float f13 = this.bgOffset.xScale;
            f13 = (float)Math.sqrt(Math.sqrt(f13));
            this.destSprite.setSize(f11 * f12 * f13, f2 * f12 * f13);
            this.destSprite.setAngle(this.bgOffset.angle);
            this.destSprite.setBlendFunc(772, 773);
            this.destSprite.renderAtCenter(f7 + this.bgOffset.xOff * 1.0f, f8 + this.bgOffset.yOff * 1.0f);
            this.destSprite.setSize(f11, f2);
        }
        if (this.planetRenderer != null) {
            this.planetRenderer.updateLightSourceInfo();
            f4 = this.getRadius() * 1.0f + 20.0f - 30.0f;
            if (f4 > this.getRadius() * 0.85f) {
                f4 = this.getRadius() * 0.85f;
            }
            if (f4 < 60.0f) {
                f4 = 60.0f;
            }
            if (f4 < 50.0f) {
                f4 = 50.0f;
            }
            this.planetRenderer.setSize(f4, f4);
            this.planetRenderer.getPosition().setLocation(f7 - f4 / 2.0f, f8 - f4 / 2.0f);
            this.planetRenderer.render(f5 * f9);
        }
        f4 = this.getRadius() * 2.0f * f6;
        f4 *= 2.3f;
        if (bl) {
            f4 *= 0.9f;
        }
        this.corona.setAdditiveBlend();
        this.corona.setAlphaMult(f5 * 0.25f);
        this.corona.setAlphaMult(f5 * 1.0f);
        for (CoronaData coronaData : this.coronaData) {
            this.corona.setAngle(coronaData.angle);
            f2 = 1.0f + coronaData.coronaSizeSine * 0.1f;
            this.corona.setSize(f4 * (f2 *= 0.8f), f4 * f2);
            this.corona.renderAtCenter(f7 + coronaData.xOff, f8 + coronaData.yOff);
        }
        if (!bl2 && f9 < 1.0f) {
            for (DynamicRingBand dynamicRingBand : this.bands) {
                f2 = dynamicRingBand.getBandWidthInEngine();
                if (bl) {
                    dynamicRingBand.setBandWidthInEngine(f2 * 0.5f);
                }
                dynamicRingBand.render(f7, f8, f5 * (1.0f - f9) * 0.75f);
                dynamicRingBand.setBandWidthInEngine(f2);
            }
        }
        this.ring.setAdditiveBlend();
        this.ring.setAlphaMult(f5 * f9);
        this.ring2.setAdditiveBlend();
        this.ring2.setAlphaMult(f5 * f9);
        f3 = 0.28320312f * f4;
        float f14 = 5.0f;
        f14 = f3 / 75.0f;
        f4 = f3 + f14 * (float)this.ringData.size() - 5.0f;
        f4 = this.getRadius() * 1.0f * 2.0f * f6;
        if (f9 > 0.0f) {
            int n = 0;
            for (RingData ringData : this.ringData) {
                if (n % 2 == 0) {
                    this.ring2.setAngle(ringData.angle);
                    this.ring2.setSize(f4 * ringData.xScale * 0.61f, f4 * ringData.yScale * 0.61f);
                    this.ring2.renderAtCenter(f7 + ringData.xOff, f8 + ringData.yOff);
                } else {
                    this.ring.setAngle(ringData.angle);
                    this.ring.setSize(f4 * ringData.xScale * 0.61f, f4 * ringData.yScale * 0.61f);
                    this.ring.renderAtCenter(f7 + ringData.xOff, f8 + ringData.yOff);
                }
                if (bl) {
                    f4 -= f14;
                    f14 *= 0.995f;
                } else {
                    f4 -= f14;
                }
                ++n;
            }
        }
        if (!bl) {
            GL11.glPopMatrix();
        }
        f7 = this.getLocation().getX();
        f8 = this.getLocation().getY();
        if (bl) {
            f7 = 0.0f;
            f8 = 0.0f;
            float f15 = 1.5f;
            GL11.glScalef((float)(f15 / f10), (float)(f15 / f10), (float)1.0f);
        }
        if (f9 < 1.0f) {
            this.glow.setAngle(this.bgOffset.angle);
            float f16 = (this.getRadius() + 70.0f) * 2.0f * (1.0f - f9) * (1.0f - f9) * (1.0f - f9);
            f16 = (this.getRadius() + 70.0f) * 2.0f;
            if (bl) {
                f16 *= 0.75f;
            }
            this.glow.setAdditiveBlend();
            this.glow.setColor(new Color(255, 0, 255, 125));
            this.glow.setSize(f16, f16);
            this.glow.setAlphaMult(f5 * (1.0f - f9) * 0.67f * (1.0f - f9) * (1.0f - f9));
            this.glow.setSize(f16 * 0.25f, f16 * 0.25f);
            this.glow.setColor(new Color(255, 255, 255, 255));
            this.glow.renderAtCenter(f7, f8);
            this.glow.renderAtCenter(f7, f8);
        }
        if (bl) {
            GL11.glPopMatrix();
        }
    }

    public void open() {
        if (!this.fader.isFadingIn() && !this.fader.isFadedIn() && CampaignEngine.getInstance().getCurrentLocation() == this.getContainingLocation()) {
            M.o00000("jump_point_open", 1.0f, 1.0f, this.getLocation(), this.getVelocity());
        }
        this.sinceOpened = 0.0f;
        this.fader.fadeIn();
    }

    public void close() {
        if (!this.fader.isFadingOut() && !this.fader.isFadedOut() && CampaignEngine.getInstance().getCurrentLocation() == this.getContainingLocation()) {
            M.o00000("jump_point_close", 1.0f, 1.0f, this.getLocation(), this.getVelocity());
        }
        this.fader.fadeOut();
    }

    public void forceOpen() {
        this.sinceOpened = 0.0f;
        this.fader.forceIn();
    }

    public void forceClose() {
        this.fader.forceOut();
    }

    @Override
    public void advance(float f2) {
        float f3;
        super.advance(f2);
        this.fader.advance(f2);
        if (this.fader.isFadedIn()) {
            this.sinceOpened += f2;
        }
        if (!this.isVisible(this.getRadius() * 1.75f + 1000.0f)) {
            return;
        }
        if (!this.getContainingLocation().isHyperspaceMode()) {
            List<CampaignFleetAPI> list = this.getContainingLocation().getFleets();
            boolean bl = false;
            for (CampaignFleetAPI campaignFleetAPI : list) {
                float f32 = Utils.void(campaignFleetAPI.getLocation(), this.getLocation());
                if (campaignFleetAPI.getInteractionTarget() != this || !(f32 < 600.0f)) continue;
                bl = true;
            }
            if (bl) {
                this.open();
            } else if (this.sinceOpened > 5.0f) {
                this.close();
            }
        }
        if (!this.isVisible(this.getRadius() * 1.75f * 2.2f)) {
            return;
        }
        float f5 = this.fader.getBrightness();
        f5 *= f5;
        float f6 = this.getScale();
        float f4 = 1.0f;
        for (DynamicRingBand dynamicRingBand : this.bands) {
            dynamicRingBand.advance(f2);
        }
        float f7 = this.getRadius() * 0.45f;
        float f8 = f3 = this.getRadius() * 1.25f;
        float f9 = this.getRadius() * 0.01f;
        float f10 = this.getRadius() * (float)Math.PI * 2.0f * f6;
        float f11 = f10 / 50.0f;
        if (f11 < 3.0f) {
            f11 = 3.0f;
        }
        if (f11 > 10.0f) {
            f11 = 10.0f;
        }
        if (f9 > 0.5f) {
            f9 = 0.5f;
        }
        if (f5 == 0.0f) {
            f9 = 35.0f;
        }
        if (this.bands.size() > 0) {
            this.bands.get(0).setBandWidthInEngine(f8 * 0.3f + 20.0f + 0.6f * f8 / f6 + 20.0f * (1.0f - f5) / f6);
            this.bands.get(0).setInnerRadius(f7 + this.getRadius() * 0.25f - f3 * 0.05f);
            this.bands.get(0).setPixelsPerSegment(f11);
            this.bands.get(0).setMaxFluctuation(f9);
        }
        if (this.bands.size() > 1) {
            this.bands.get(1).setBandWidthInEngine(f8 * 0.3f + 20.0f + 0.6f * f8 / f6 + 20.0f * (1.0f - f5) / f6);
            this.bands.get(1).setInnerRadius(f7 + this.getRadius() * 0.25f - f3 * 0.05f);
            this.bands.get(1).setPixelsPerSegment(f11);
            this.bands.get(1).setMaxFluctuation(f9);
        }
        float f12 = CampaignEngine.getInstance().getClock().convertToDays(f2);
        float f13 = 25.0f;
        float f14 = (this.getRadius() - 50.0f) / 7.0f;
        if (f14 < 0.0f) {
            f14 = 0.0f;
        }
        if (f14 > 20.0f) {
            f14 = 20.0f;
        }
        f14 = 0.0f;
        int n = (int)(f13 + f14);
        if (this.isWormhole()) {
            n *= 4;
        }
        while (this.ringData.size() > n) {
            this.ringData.remove(this.ringData.size() - 1);
        }
        while (this.ringData.size() < n) {
            this.ringData.add(new RingData(1.0f));
        }
        for (RingData ringData : this.ringData) {
            ringData.advance(f12 * f4);
        }
        for (CoronaData coronaData : this.coronaData) {
            coronaData.advance(f12 * f4);
        }
        if (this.planetRenderer != null) {
            this.planetRenderer.getGraphics().advance(f2);
        }
        this.bgOffset.advance(f12 * 0.25f * 3.0f);
    }

    private float getScale() {
        float f2 = this.fader.getBrightness();
        f2 *= f2;
        float f3 = Math.max(0.1f, 10.0f / this.getRadius());
        f3 = 0.1f;
        if (this.isWormhole()) {
            f3 = 0.25f;
        }
        return f3 + (1.0f - f3) * f2;
    }

    public void addDestination(JumpPointAPI.JumpDestination jumpDestination) {
        this.destinations.add(jumpDestination);
    }

    public void clearDestinations() {
        this.destinations.clear();
    }

    public void removeDestination(SectorEntityToken sectorEntityToken) {
        for (JumpPointAPI.JumpDestination jumpDestination : this.destinations) {
            if (jumpDestination.getDestination() != sectorEntityToken) continue;
            this.destinations.remove(jumpDestination);
            break;
        }
    }

    public List<JumpPointAPI.JumpDestination> getDestinations() {
        return this.destinations;
    }

    @Override
    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float f2) {
        this.radius = f2;
    }

    @Override
    public EnumSet<CampaignEngineLayers> getActiveLayers() {
        return this.layers;
    }

    public void setDestinationVisual(String string, String string2, SectorEntityToken sectorEntityToken) {
        this.destSpriteCategory = string;
        this.destSpriteId = string2;
        if (sectorEntityToken instanceof CampaignPlanet) {
            this.destPlanet = (CampaignPlanet)sectorEntityToken;
            float f2 = this.destPlanet.getRadius();
            this.radius = 75.0f + Math.max(f2 - 150.0f, 0.0f) * 0.2f;
            if (this.radius > 250.0f) {
                this.radius = 250.0f;
            }
            if (this.destPlanet.isStar()) {
                this.radius = 125.0f + Math.max(f2 - 400.0f, 0.0f) * 0.125f;
                if (this.radius > 300.0f) {
                    this.radius = 300.0f;
                }
            }
        } else {
            this.destPlanet = null;
        }
        this.updateDestGraphics();
    }

    private void updateDestGraphics() {
        this.destSprite = this.destSpriteCategory != null && this.destSpriteId != null ? StarfarerSettings.\u00d600000(this.destSpriteCategory, this.destSpriteId) : null;
        if (this.destPlanet != null) {
            this.planetRenderer = new O00O(this.destPlanet);
            this.planetRenderer.removeNameLabel();
            this.planetRenderer.setRenderStarHalo(true);
        } else {
            this.planetRenderer = null;
        }
    }

    public void setStandardWormholeToStarOrPlanetVisual(SectorEntityToken sectorEntityToken) {
        this.setDestinationVisual("misc", "wormhole_stars", sectorEntityToken);
    }

    public void setStandardWormholeToHyperspaceVisual() {
        this.setDestinationVisual("misc", "wormhole_hyper", null);
    }

    public void setStandardWormholeToStarfieldVisual() {
        this.setDestinationVisual("misc", "wormhole_stars", null);
    }

    public void setStandardWormholeToNothingVisual() {
        this.setDestinationVisual("misc", "wormhole_black", null);
    }

    public boolean isAutoCreateEntranceFromHyperspace() {
        return this.autoCreateEntranceFromHyperspace;
    }

    public void setAutoCreateEntranceFromHyperspace(boolean bl) {
        this.autoCreateEntranceFromHyperspace = bl;
    }

    public SectorEntityToken getDestinationVisualEntity() {
        return this.destPlanet;
    }

    public CampaignPlanet getRelatedPlanet() {
        return this.relatedPlanet;
    }

    public void setRelatedPlanet(SectorEntityToken sectorEntityToken) {
        this.relatedPlanet = (CampaignPlanet)sectorEntityToken;
    }

    public void autoUpdateHyperJumpPointLocationBasedOnInSystemEntityAtRadius(SectorEntityToken sectorEntityToken, float f2) {
        this.setOrbit(new StarSystem.UpdateFromSystemLocationOrbit(((StarSystemAPI)sectorEntityToken.getContainingLocation()).getHyperspaceAnchor(), ((StarSystemAPI)sectorEntityToken.getContainingLocation()).getCenter(), sectorEntityToken, this, f2));
    }

    public boolean isStar() {
        return false;
    }

    @Override
    public boolean isRenderCircleIndicator() {
        return false;
    }

    public float getAlphaMultFromAbyssalDepth() {
        float f2 = Misc.getAbyssalDepthOfPlayer();
        float f3 = Misc.getAbyssalDepth((SectorEntityToken)this);
        if (f2 <= 0.0f && f3 <= 0.0f) {
            return 1.0f;
        }
        if (f2 > 0.0f && f3 <= 0.0f) {
            return 1.0f - f2;
        }
        if (!StarfarerSettings.while.super()) {
            return 1.0f;
        }
        if (this.isStarAnchor() && !this.hasTag("star_hidden_on_map")) {
            if (f2 <= 0.0f && f3 > 0.0f) {
                return 1.0f - f3;
            }
            float f4 = Math.abs(f2 - f3);
            return 1.0f - f4;
        }
        CampaignFleetAPI campaignFleetAPI = Global.getSector().getPlayerFleet();
        if (campaignFleetAPI == null) {
            return 1.0f;
        }
        float f5 = this.getSensorContactFaderBrightness();
        return f5;
    }

    public boolean isWormhole() {
        return this.getMemoryWithoutUpdate().getBoolean(WormholeManager.WORMHOLE);
    }

    public static class CoronaData
    implements DoNotObfuscate {
        public float angle = (float)Math.random() * 360.0f;
        public float coronaSizeSine = ((float)Math.random() - 0.5f) * 2.0f;
        public float xOff;
        public float yOff;
        private float elapsedDays = 1000.0f * (float)Math.random();
        private float rotSpeed = (100.0f + 100.0f * (float)Math.random()) * Math.signum((float)Math.random() - 0.5f);
        private float degreesPerDay = 200.0f + (float)Math.random() * 200.0f;

        public void advance(float f2) {
            this.angle = (float)((double)this.angle + (double)(this.rotSpeed * (f2 *= 2.0f)) * 0.25);
            this.elapsedDays += f2;
            this.coronaSizeSine = (float)Math.sin(Math.toRadians(this.elapsedDays * this.degreesPerDay));
            float f3 = (float)Math.sin(Math.toRadians(this.elapsedDays * this.rotSpeed));
            float f4 = (float)Math.cos(Math.toRadians(this.elapsedDays * this.rotSpeed));
            this.xOff = f4 * 6.0f;
            this.yOff = f3 * 6.0f;
        }
    }

    public static class RingData
    implements DoNotObfuscate {
        public float xOff;
        public float yOff;
        public float xScale = 1.0f;
        public float yScale = 1.0f;
        public float angle = (float)Math.random() * 360.0f;
        private float elapsedDays = 1000.0f * (float)Math.random();
        private float speed = (200.0f + 100.0f * (float)Math.random()) * Math.signum((float)Math.random() - 0.5f);
        private float rotSpeed = (100.0f + 100.0f * (float)Math.random()) * Math.signum((float)Math.random() - 0.5f);
        private float rotMult = 1.0f;

        public RingData(float f2) {
            this.rotMult = f2;
        }

        public void advance(float f2) {
            this.elapsedDays += (f2 *= 1.0f);
            float f3 = (float)Math.sin(Math.toRadians(this.elapsedDays * this.speed));
            float f4 = (float)Math.cos(Math.toRadians(this.elapsedDays * this.speed));
            this.xOff = f4 * 2.0f;
            this.yOff = f3 * 2.0f;
            this.xScale = 1.0f + f3 * 0.1f;
            this.yScale = 1.0f - f3 * 0.1f;
            this.xScale = 1.0f + f3 * 0.25f;
            this.yScale = 1.0f - f3 * 0.25f;
            this.angle += this.rotSpeed * f2 * 1.0f * this.rotMult;
        }
    }
}

