/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.NascentGravityWellAPI;
import com.fs.starfarer.api.campaign.OrbitAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.procgen.Constellation;
import com.fs.starfarer.api.impl.campaign.procgen.ProcgenUsedNames;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.BaseCampaignEntity;
import com.fs.starfarer.campaign.BaseLocation;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.CampaignEntity;
import com.fs.starfarer.campaign.CampaignPlanet;
import com.fs.starfarer.campaign.CampaignTerrain;
import com.fs.starfarer.campaign.CircularOrbit;
import com.fs.starfarer.campaign.Hyperspace;
import com.fs.starfarer.campaign.JumpPoint;
import com.fs.starfarer.campaign.NascentGravityWell;
import com.fs.starfarer.loading.supersuper;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.util.oOOO.new;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class StarSystem
extends BaseLocation
implements StarSystemAPI,
DoNotObfuscate {
    private StarSystemGenerator.StarSystemType type = StarSystemGenerator.StarSystemType.SINGLE;
    private Constellation constellation = null;
    private StarAge age = null;
    private Boolean hasSystemwideNebula = null;
    private boolean procgen = false;
    private String baseName;
    private String optionalUniqueId;
    private float maxRadiusInHyperspace = 100.0f;
    private SectorEntityToken center;
    private CampaignPlanet star;
    private CampaignPlanet secondary;
    private CampaignPlanet tertiary;
    private SectorEntityToken hyperspaceAnchor = null;
    private boolean enteredByPlayer = false;
    private Boolean doNotShowIntelFromThisLocationOnMap = null;
    private transient List<JumpPointAPI> autogeneratedJumpPointsInHyper = new ArrayList<JumpPointAPI>();
    private transient List<NascentGravityWellAPI> autogeneratedNascentWellsInHyper = new ArrayList<NascentGravityWellAPI>();
    private Float mapGridWidthOverride = null;
    private Float mapGridHeightOverride = null;

    public String toString() {
        return this.getName();
    }

    public StarSystem(String string) {
        super(false);
        this.baseName = string;
        this.setName(String.valueOf(string) + " Star System");
    }

    public String getOptionalUniqueId() {
        return this.optionalUniqueId;
    }

    public void setOptionalUniqueId(String string) {
        this.optionalUniqueId = string;
    }

    public boolean hasPulsar() {
        return this.star != null && this.star.getSpec().isPulsar() || this.secondary != null && this.secondary.getSpec().isPulsar() || this.tertiary != null && this.tertiary.getSpec().isPulsar();
    }

    public boolean hasBlackHole() {
        return this.star != null && this.star.getSpec().isBlackHole() || this.secondary != null && this.secondary.getSpec().isBlackHole() || this.tertiary != null && this.tertiary.getSpec().isBlackHole();
    }

    public boolean isEnteredByPlayer() {
        return this.enteredByPlayer || DebugFlags.ALLOW_VIEW_UNEXPLORED_SYSTEM_MAP;
    }

    public void setEnteredByPlayer(boolean bl) {
        this.enteredByPlayer = bl;
    }

    @Override
    public void advance(float f2, new new_) {
        super.advance(f2, new_);
    }

    public StarAge getAge() {
        if (this.age != null) {
            return this.age;
        }
        if (this.getConstellation() != null) {
            return this.getConstellation().getAge();
        }
        return this.age;
    }

    public void setAge(StarAge starAge) {
        this.age = starAge;
    }

    public Boolean hasSystemwideNebula() {
        if (this.hasSystemwideNebula != null) {
            return this.hasSystemwideNebula;
        }
        if (this.getConstellation() != null && this.getConstellation().getType() == Constellation.ConstellationType.NEBULA) {
            return true;
        }
        if (this.hasSystemwideNebula == null) {
            return false;
        }
        return this.hasSystemwideNebula;
    }

    public void setHasSystemwideNebula(Boolean bl) {
        this.hasSystemwideNebula = bl;
    }

    public void setBaseName(String string) {
        this.baseName = string;
        this.setName(String.valueOf(string) + " Star System");
        if (this.type == StarSystemGenerator.StarSystemType.NEBULA) {
            this.setName(String.valueOf(string) + " Nebula");
        }
    }

    public boolean isProcgen() {
        return this.procgen;
    }

    public void setProcgen(boolean bl) {
        this.procgen = bl;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public StarSystemGenerator.StarSystemType getType() {
        return this.type;
    }

    public void setType(StarSystemGenerator.StarSystemType starSystemType) {
        this.type = starSystemType;
    }

    @Override
    public Constellation getConstellation() {
        return this.constellation;
    }

    @Override
    public boolean isInConstellation() {
        return this.constellation != null && this.constellation.getSystems().size() > 1;
    }

    public void setConstellation(Constellation constellation) {
        this.constellation = constellation;
    }

    @Override
    public String getId() {
        return this.baseName.toLowerCase();
    }

    public PlanetAPI getStar() {
        return this.star;
    }

    public void setStar(PlanetAPI planetAPI) {
        this.star = (CampaignPlanet)planetAPI;
    }

    public SectorEntityToken initNonStarCenter() {
        this.removeObject(this.center);
        this.center = new BaseLocation.LocationToken(this, 0.0f, 0.0f);
        this.addObject(this.center);
        return this.center;
    }

    public SectorEntityToken getCenter() {
        if (this.center == null) {
            return this.star;
        }
        return this.center;
    }

    public void setCenter(SectorEntityToken sectorEntityToken) {
        this.center = sectorEntityToken;
    }

    public PlanetAPI getSecondary() {
        return this.secondary;
    }

    public void setSecondary(PlanetAPI planetAPI) {
        this.secondary = (CampaignPlanet)planetAPI;
    }

    public PlanetAPI getTertiary() {
        return this.tertiary;
    }

    public void setTertiary(PlanetAPI planetAPI) {
        this.tertiary = (CampaignPlanet)planetAPI;
    }

    public PlanetAPI initStar(String string, String string2, float f2, float f3) {
        return this.initStar(string, string2, f2, f3, 10.0f, 0.25f, 3.0f);
    }

    public PlanetAPI initStar(String string, String string2, float f2, float f3, float f4, float f5, float f6) {
        this.removeObject(this.star);
        String string3 = this.getDisplayName().replaceAll(" Star System", "");
        ProcgenUsedNames.notifyUsed((String)string3);
        this.star = new CampaignPlanet(string, string3, string2, f2, 0.0f, 0.0f, null);
        this.addObject(this.star);
        Vector2f vector2f = supersuper.new(string);
        if (vector2f != null) {
            this.getLocation().set((ReadableVector2f)vector2f);
        }
        this.addCorona(this.star, f3, f4, f5, f6);
        return this.star;
    }

    public PlanetAPI initStar(String string, String string2, Color color, float f2, float f3) {
        return this.initStar(string, string2, f2, f3);
    }

    public PlanetAPI initStar(String string, String string2, float f2, float f3, float f4, float f5) {
        this.initStar(string, string2, f2, f5);
        this.getLocation().set(f3, f4);
        this.generateAnchorIfNeeded();
        return this.star;
    }

    public SectorEntityToken getHyperspaceAnchor() {
        return this.hyperspaceAnchor;
    }

    public void setHyperspaceAnchor(SectorEntityToken sectorEntityToken) {
        this.hyperspaceAnchor = sectorEntityToken;
    }

    public void generateAnchorIfNeeded() {
        if (this.hyperspaceAnchor != null) {
            return;
        }
        Vector2f vector2f = this.getLocation();
        Hyperspace hyperspace = CampaignEngine.getInstance().getHyperspace();
        this.hyperspaceAnchor = new BaseLocation.LocationToken(hyperspace, vector2f.x, vector2f.y);
        this.hyperspaceAnchor.addTag("system_anchor");
        this.hyperspaceAnchor.getMemoryWithoutUpdate().set("$anchor_starSystem", (Object)this);
        this.hyperspaceAnchor.setOrbit((OrbitAPI)new UpdateFromHyperspaceLocation(this, this.hyperspaceAnchor));
        hyperspace.addEntity(this.hyperspaceAnchor);
    }

    public void autogenerateHyperspaceJumpPoints() {
        this.autogenerateHyperspaceJumpPoints(false, false);
    }

    public List<JumpPointAPI> getAutogeneratedJumpPointsInHyper() {
        return this.autogeneratedJumpPointsInHyper;
    }

    public List<NascentGravityWellAPI> getAutogeneratedNascentWellsInHyper() {
        return this.autogeneratedNascentWellsInHyper;
    }

    public void autogenerateHyperspaceJumpPoints(boolean bl, boolean bl2) {
        this.autogenerateHyperspaceJumpPoints(bl, bl2, true);
    }

    public void autogenerateHyperspaceJumpPoints(boolean bl, boolean bl2, boolean bl3) {
        float f2;
        Object object22;
        this.autogeneratedJumpPointsInHyper = new ArrayList<JumpPointAPI>();
        this.autogeneratedNascentWellsInHyper = new ArrayList<NascentGravityWellAPI>();
        this.updateAllOrbits();
        this.generateAnchorIfNeeded();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list = this.getObjects().getList(JumpPoint.class);
        List list2 = this.getObjects().getList(CampaignPlanet.class);
        List list3 = this.getObjects().getList(CampaignTerrain.class);
        for (JumpPoint jumpPoint : list) {
            if (jumpPoint.isSkipForJumpPointAutoGen() || jumpPoint.isWormhole() || !jumpPoint.isAutoCreateEntranceFromHyperspace()) continue;
            Iterator iterator = new o();
            ((o)((Object)iterator)).o00000 = jumpPoint;
            arrayList.add(iterator);
        }
        float f3 = 0.0f;
        for (Object object22 : list2) {
            if (((BaseCampaignEntity)object22).isSkipForJumpPointAutoGen()) continue;
            f2 = Utils.void(this.getCenter().getLocation(), ((BaseCampaignEntity)object22).getLocation());
            if (f2 > f3 && ((BaseCampaignEntity)object22).getOrbitFocus() == this.getCenter()) {
                f3 = f2;
            }
            if (!((CampaignPlanet)object22).isGasGiant() && !((CampaignPlanet)object22).isStar() || !bl && ((CampaignPlanet)object22).isGasGiant()) continue;
            o o2 = new o();
            o2.new = object22;
            arrayList.add(o2);
        }
        for (Object object22 : list3) {
            if (((BaseCampaignEntity)object22).isSkipForJumpPointAutoGen() || !((f2 = Utils.void(this.getCenter().getLocation(), ((BaseCampaignEntity)object22).getLocation())) > f3) || ((BaseCampaignEntity)object22).getOrbitFocus() != this.getCenter()) continue;
            f3 = f2;
        }
        block3: for (Object object22 : list2) {
            if (((BaseCampaignEntity)object22).isSkipForJumpPointAutoGen() || ((CampaignPlanet)object22).isMoon()) continue;
            for (o o3 : arrayList) {
                if (o3.new == object22) continue block3;
            }
            o o4 = new o();
            o4.new = object22;
            o4.\u00d300000 = true;
            arrayList.add(o4);
        }
        Collections.sort(arrayList, new Comparator<o>(){

            public int o00000(o o2, o o3) {
                float f2 = 0.0f;
                if (o2.o00000 != null) {
                    f2 = Utils.void(StarSystem.this.getCenter().getLocation(), o2.o00000.getLocation());
                }
                if (o2.new != null) {
                    f2 = Utils.void(StarSystem.this.getCenter().getLocation(), o2.new.getLocation());
                }
                float f3 = 0.0f;
                if (o3.o00000 != null) {
                    f3 = Utils.void(StarSystem.this.getCenter().getLocation(), o3.o00000.getLocation());
                }
                if (o3.new != null) {
                    f3 = Utils.void(StarSystem.this.getCenter().getLocation(), o3.new.getLocation());
                }
                return (int)Math.signum(f2 - f3);
            }
        });
        if (bl2) {
            object22 = new o();
            arrayList.add(object22);
        }
        object22 = CampaignEngine.getInstance().getHyperspace();
        float f4 = 50.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        for (o o5 : arrayList) {
            float f9;
            float f10;
            boolean bl4;
            float f11;
            Object object3;
            Object object4;
            if (o5.o00000 != null) {
                object4 = o5.o00000;
                object3 = o5.o00000.getAutogenJumpPointNameInHyper();
                if (object3 == null) {
                    object3 = ((BaseCampaignEntity)object4).getName();
                }
                JumpPointAPI jumpPointAPI = Global.getFactory().createJumpPoint(null, (String)object3);
                jumpPointAPI.addDestination(new JumpPointAPI.JumpDestination((SectorEntityToken)object4, ((BaseCampaignEntity)object4).getName()));
                if (((JumpPoint)object4).getRelatedPlanet() != null) {
                    jumpPointAPI.setStandardWormholeToStarOrPlanetVisual((SectorEntityToken)((JumpPoint)object4).getRelatedPlanet());
                } else {
                    jumpPointAPI.setStandardWormholeToStarfieldVisual();
                    jumpPointAPI.setRadius(50.0f);
                }
                f11 = o5.o00000.getCircularOrbitRadius();
                bl4 = f11 > 0.0f && Math.abs(f11 - f7) < 20.0f;
                f10 = o5.o00000.getCircularOrbitPeriod();
                bl4 |= f10 > 0.0f && Math.abs(f10 - f8) < 0.1f;
                boolean bl5 = o5.o00000.getOrbit() != null;
                f8 = f10;
                if (bl4 &= bl5) {
                    f6 = Math.max(f6, f4 + jumpPointAPI.getRadius() * 2.0f);
                } else {
                    f5 += f6;
                    f6 = f4 + jumpPointAPI.getRadius() * 2.0f;
                }
                f7 = f11;
                f9 = f5 + jumpPointAPI.getRadius();
                if (f11 < 20.0f && o5.o00000.getOrbit() != null) {
                    f9 = 0.0f;
                    f6 = f5 = jumpPointAPI.getRadius();
                }
                jumpPointAPI.setOrbit((OrbitAPI)new UpdateFromSystemLocationOrbit(this.hyperspaceAnchor, this.getCenter(), (SectorEntityToken)object4, (SectorEntityToken)jumpPointAPI, f9));
                ((BaseLocation)object22).addEntity((SectorEntityToken)jumpPointAPI);
                this.autogeneratedJumpPointsInHyper.add(jumpPointAPI);
                ((JumpPoint)object4).addDestination(new JumpPointAPI.JumpDestination((SectorEntityToken)jumpPointAPI, "hyperspace"));
                continue;
            }
            if (o5.new != null && o5.\u00d300000) {
                float f12 = Math.max(40.0f, o5.new.getRadius() * 0.3f);
                if (f12 > 150.0f) {
                    f12 = 150.0f;
                }
                object3 = new NascentGravityWell(o5.new, f12);
                float f13 = f4 + ((NascentGravityWell)object3).getRadius() * 0.5f;
                f11 = o5.new.getCircularOrbitRadius();
                bl4 = f11 > 0.0f && Math.abs(f11 - f7) < 20.0f;
                f10 = o5.new.getCircularOrbitPeriod();
                bl4 |= f10 > 0.0f && Math.abs(f10 - f8) < 0.1f;
                boolean bl6 = o5.new.getOrbit() != null;
                f8 = f10;
                if (bl4 &= bl6) {
                    f6 = Math.max(f6, f13);
                } else {
                    f5 += f6;
                    f6 = f13;
                }
                f7 = f11;
                f9 = f5 + f13 * 0.5f;
                if (f11 < 20.0f && o5.new.getOrbit() != null) {
                    f9 = 0.0f;
                    f6 = f5 = f13 * 0.5f;
                }
                ((BaseCampaignEntity)object3).setOrbit(new UpdateFromSystemLocationOrbit(this.hyperspaceAnchor, this.getCenter(), o5.new, (SectorEntityToken)object3, f9));
                ((BaseLocation)object22).addEntity((SectorEntityToken)object3);
                this.autogeneratedNascentWellsInHyper.add((NascentGravityWellAPI)object3);
                continue;
            }
            if (o5.new != null) {
                object4 = o5.new.getAutogenJumpPointNameInHyper();
                if (object4 == null) {
                    object4 = String.valueOf(o5.new.getName()) + " Gravity Well";
                    if (o5.new.isStar()) {
                        object4 = o5.new == this.star ? this.getName() : String.valueOf(o5.new.getName()) + ", " + o5.new.getSpec().getName();
                        object4 = String.valueOf(o5.new.getName()) + ", " + o5.new.getSpec().getName();
                    }
                }
                object3 = (JumpPoint)Global.getFactory().createJumpPoint(null, (String)object4);
                JumpPointAPI.JumpDestination jumpDestination = new JumpPointAPI.JumpDestination((SectorEntityToken)o5.new, o5.new.getName());
                jumpDestination.setMinDistFromToken(o5.new.getRadius() + 50.0f);
                jumpDestination.setMaxDistFromToken(o5.new.getRadius() + 400.0f);
                ((JumpPoint)object3).addDestination(jumpDestination);
                ((JumpPoint)object3).setStandardWormholeToStarOrPlanetVisual(o5.new);
                f11 = o5.new.getCircularOrbitRadius();
                bl4 = f11 > 0.0f && Math.abs(f11 - f7) < 20.0f;
                f10 = o5.new.getCircularOrbitPeriod();
                bl4 |= f10 > 0.0f && Math.abs(f10 - f8) < 0.1f;
                boolean bl7 = o5.new.getOrbit() != null;
                f8 = f10;
                if (bl4 &= bl7) {
                    f6 = Math.max(f6, f4 + ((JumpPoint)object3).getRadius() * 2.0f);
                } else {
                    f5 += f6;
                    f6 = f4 + ((JumpPoint)object3).getRadius() * 2.0f;
                }
                f7 = f11;
                f9 = f5 + ((JumpPoint)object3).getRadius();
                if (bl4) {
                    f9 += f4;
                }
                if (f11 < 20.0f && o5.new == this.getStar()) {
                    f9 = 0.0f;
                    f6 = f5 = ((JumpPoint)object3).getRadius();
                }
                ((BaseCampaignEntity)object3).setOrbit(new UpdateFromSystemLocationOrbit(this.hyperspaceAnchor, this.getCenter(), o5.new, (SectorEntityToken)object3, f9));
                ((BaseLocation)object22).addEntity((SectorEntityToken)object3);
                this.autogeneratedJumpPointsInHyper.add((JumpPointAPI)object3);
                continue;
            }
            object4 = (JumpPoint)Global.getFactory().createJumpPoint(null, String.valueOf(this.getBaseName()) + ", Fringe Jump-point");
            object3 = (JumpPoint)Global.getFactory().createJumpPoint(null, "Fringe Jump-point");
            ((JumpPoint)object4).setRadius(50.0f);
            ((JumpPoint)object4).addDestination(new JumpPointAPI.JumpDestination((SectorEntityToken)object3, "the fringe of the " + this.getBaseName() + " system"));
            ((JumpPoint)object4).setStandardWormholeToStarfieldVisual();
            ((JumpPoint)object3).addDestination(new JumpPointAPI.JumpDestination((SectorEntityToken)object4, "hyperspace"));
            ((JumpPoint)object3).setStandardWormholeToHyperspaceVisual();
            float f14 = (f3 + 2000.0f) * 0.1f;
            ((BaseCampaignEntity)object3).setOrbit(new CircularOrbit((SectorEntityToken)object3, this.getCenter(), f3 + 2000.0f + (float)Math.random() * 2000.0f).setPeriod(f14).setCurrAngle((float)Math.random() * 360.0f));
            this.addEntity((SectorEntityToken)object3);
            f6 = ((JumpPoint)object4).getRadius() * 2.0f + f4;
            f11 = (f5 += f6) + ((JumpPoint)object4).getRadius();
            ((BaseCampaignEntity)object4).setOrbit(new UpdateFromSystemLocationOrbit(this.hyperspaceAnchor, this.getCenter(), (SectorEntityToken)object3, (SectorEntityToken)object4, f11));
            ((BaseLocation)object22).addEntity((SectorEntityToken)object4);
            this.autogeneratedJumpPointsInHyper.add((JumpPointAPI)object4);
        }
        ((BaseLocation)object22).updateAllOrbits();
        this.maxRadiusInHyperspace = f5 + f6 - f4;
        if (bl3) {
            Misc.generatePlanetConditions((StarSystemAPI)this, (StarAge)StarAge.AVERAGE);
        }
    }

    public float getMaxRadiusInHyperspace() {
        return this.maxRadiusInHyperspace;
    }

    public void setMaxRadiusInHyperspace(float f2) {
        this.maxRadiusInHyperspace = f2;
    }

    @Override
    public CampaignEntity getLightSource() {
        return (CampaignEntity)this.getStar();
    }

    @Override
    public boolean isNebula() {
        return this.type == StarSystemGenerator.StarSystemType.NEBULA;
    }

    public Boolean getDoNotShowIntelFromThisLocationOnMap() {
        return this.doNotShowIntelFromThisLocationOnMap;
    }

    public void setDoNotShowIntelFromThisLocationOnMap(Boolean bl) {
        this.doNotShowIntelFromThisLocationOnMap = bl;
    }

    public Float getMapGridWidthOverride() {
        return this.mapGridWidthOverride;
    }

    public void setMapGridWidthOverride(Float f2) {
        this.mapGridWidthOverride = f2;
    }

    public Float getMapGridHeightOverride() {
        return this.mapGridHeightOverride;
    }

    public void setMapGridHeightOverride(Float f2) {
        this.mapGridHeightOverride = f2;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class o {
        public JumpPoint o00000;
        public CampaignPlanet new;
        public boolean \u00d300000 = false;

        private o() {
        }
    }

    public static class UpdateFromHyperspaceLocation
    implements DoNotObfuscate,
    OrbitAPI {
        private StarSystemAPI starSystem;
        private SectorEntityToken anchorPointInHyperspace;

        public OrbitAPI makeCopy() {
            UpdateFromHyperspaceLocation updateFromHyperspaceLocation = new UpdateFromHyperspaceLocation(this.starSystem, this.anchorPointInHyperspace);
            return updateFromHyperspaceLocation;
        }

        public UpdateFromHyperspaceLocation(StarSystemAPI starSystemAPI, SectorEntityToken sectorEntityToken) {
            this.starSystem = starSystemAPI;
            this.anchorPointInHyperspace = sectorEntityToken;
        }

        public void advance(float f2) {
            this.anchorPointInHyperspace.getLocation().set((ReadableVector2f)this.starSystem.getLocation());
        }

        public SectorEntityToken getFocus() {
            return null;
        }

        public void setEntity(SectorEntityToken sectorEntityToken) {
        }

        public Vector2f computeCurrentLocation() {
            return new Vector2f((ReadableVector2f)this.starSystem.getLocation());
        }

        public float getOrbitalPeriod() {
            return 100.0f;
        }

        public void updateLocation() {
        }

        public StarSystemAPI getStarSystem() {
            return this.starSystem;
        }
    }

    public static class UpdateFromSystemLocationOrbit
    implements DoNotObfuscate,
    OrbitAPI {
        private SectorEntityToken systemPoint;
        private SectorEntityToken star;
        private SectorEntityToken inSystemEntity;
        private SectorEntityToken inHyperJumpPoint;
        private float orbitRadius;
        private Vector2f prev = null;
        private Vector2f last = null;
        private float lastInterval = 0.0f;
        private float elapsedSinceUpdate = 0.0f;

        public OrbitAPI makeCopy() {
            UpdateFromSystemLocationOrbit updateFromSystemLocationOrbit = new UpdateFromSystemLocationOrbit(this.systemPoint, this.star, this.inSystemEntity, this.inHyperJumpPoint, this.orbitRadius);
            return updateFromSystemLocationOrbit;
        }

        public UpdateFromSystemLocationOrbit(SectorEntityToken sectorEntityToken, SectorEntityToken sectorEntityToken2, SectorEntityToken sectorEntityToken3, SectorEntityToken sectorEntityToken4, float f2) {
            this.systemPoint = sectorEntityToken;
            this.star = sectorEntityToken2;
            this.inSystemEntity = sectorEntityToken3;
            this.inHyperJumpPoint = sectorEntityToken4;
            this.orbitRadius = f2;
        }

        public void setEntity(SectorEntityToken sectorEntityToken) {
        }

        public SectorEntityToken getFocus() {
            return this.systemPoint;
        }

        public void advance(float f2) {
            Vector2f vector2f = this.getUpdatedLoc();
            if (this.prev == null || this.last == null) {
                this.prev = new Vector2f();
                this.last = new Vector2f();
                this.prev.set((ReadableVector2f)vector2f);
                this.last.set((ReadableVector2f)vector2f);
            }
            this.elapsedSinceUpdate += f2;
            if (vector2f.x != this.last.x || vector2f.y != this.last.y) {
                this.prev.set((ReadableVector2f)this.last);
                this.last.set((ReadableVector2f)vector2f);
                this.lastInterval = this.elapsedSinceUpdate;
                this.elapsedSinceUpdate = 0.0f;
            }
            if (this.lastInterval > 0.0f) {
                float f3 = this.elapsedSinceUpdate / this.lastInterval;
                if (f3 > 1.0f) {
                    f3 = 1.0f;
                }
                this.inHyperJumpPoint.getLocation().x = this.prev.x + (this.last.x - this.prev.x) * f3;
                this.inHyperJumpPoint.getLocation().y = this.prev.y + (this.last.y - this.prev.y) * f3;
            } else {
                this.inHyperJumpPoint.getLocation().set((ReadableVector2f)vector2f);
            }
        }

        public void updateLocation() {
        }

        private Vector2f getUpdatedLoc() {
            Vector2f vector2f = new Vector2f();
            float f2 = Utils.\u00d300000(this.inSystemEntity.getLocation());
            Vector2f.add((Vector2f)this.systemPoint.getLocation(), (Vector2f)((Vector2f)Utils.\u00d300000(f2).scale(this.orbitRadius)), (Vector2f)vector2f);
            return vector2f;
        }

        public Vector2f computeCurrentLocation() {
            return this.getUpdatedLoc();
        }

        public float getOrbitalPeriod() {
            if (this.inSystemEntity.getOrbit() == null) {
                return 100.0f;
            }
            return this.inSystemEntity.getOrbit().getOrbitalPeriod();
        }

        public SectorEntityToken getStar() {
            return this.star;
        }
    }
}

