/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.fleet;

import com.fs.starfarer.D;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.BaseScript;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class NoFuelDriftScript
extends BaseScript {
    protected boolean playerOutOfFuel = false;
    protected float sinceOvercapMessage = 100.0f;
    private Vector2f temp = new Vector2f();

    public void advance(float f2) {
        this.printOverCapacityWarning(f2);
        LocationAPI locationAPI = Global.getSector().getHyperspace();
        List list = locationAPI.getFleets();
        for (CampaignFleetAPI campaignFleetAPI : list) {
            if (campaignFleetAPI.getCargo().getFuel() == 0.0f && !campaignFleetAPI.isInHyperspaceTransition() && !campaignFleetAPI.isAIMode()) {
                JumpPointAPI jumpPointAPI;
                if (campaignFleetAPI.isPlayerFleet()) {
                    if (!this.playerOutOfFuel) {
                        jumpPointAPI = new MessageIntel("Your fleet is out of fuel and begins to drift towards the nearest gravity well", D.\u00d2\u00d30000);
                        Global.getSector().getCampaignUI().addMessage((IntelInfoPlugin)jumpPointAPI);
                    }
                    this.playerOutOfFuel = true;
                }
                if ((jumpPointAPI = this.findNearestGravityWell(campaignFleetAPI, locationAPI)) == null) continue;
                campaignFleetAPI.setMoveDestinationOverride(jumpPointAPI.getLocation().x, jumpPointAPI.getLocation().y);
                float f3 = Vector2f.sub((Vector2f)campaignFleetAPI.getLocation(), (Vector2f)jumpPointAPI.getLocation(), (Vector2f)this.temp).length();
                if (!(f3 <= campaignFleetAPI.getRadius())) continue;
                Global.getSector().doHyperspaceTransition(campaignFleetAPI, (SectorEntityToken)jumpPointAPI, (JumpPointAPI.JumpDestination)jumpPointAPI.getDestinations().get((int)(Math.random() * (double)jumpPointAPI.getDestinations().size())));
                continue;
            }
            if (!campaignFleetAPI.isPlayerFleet()) continue;
            this.playerOutOfFuel = false;
        }
    }

    protected void printOverCapacityWarning(float f2) {
        this.sinceOvercapMessage += f2;
        CampaignFleetAPI campaignFleetAPI = Global.getSector().getPlayerFleet();
        if (campaignFleetAPI != null && this.sinceOvercapMessage > 20.0f) {
            MessageIntel messageIntel;
            float f3;
            CargoAPI cargoAPI = campaignFleetAPI.getCargo();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (cargoAPI.getSpaceUsed() > cargoAPI.getMaxCapacity()) {
                arrayList.add("cargo");
            }
            if (cargoAPI.getFuel() > cargoAPI.getMaxFuel()) {
                arrayList.add("fuel");
            }
            if ((float)cargoAPI.getTotalPersonnel() > cargoAPI.getMaxPersonnel()) {
                arrayList.add("crew");
            }
            if (!arrayList.isEmpty() && cargoAPI.getSupplies() > 0.0f) {
                float f4;
                f3 = campaignFleetAPI.getLogistics().getExcessCargoCapacitySupplyCost() + campaignFleetAPI.getLogistics().getExcessFuelCapacitySupplyCost() + campaignFleetAPI.getLogistics().getExcessPersonnelCapacitySupplyCost();
                if ((f3 = Math.max(0.1f, f3)) > (f4 = Global.getSettings().getFloat("maxSuppliesPerDayForOverCapacity"))) {
                    f3 = f4;
                }
                messageIntel = new MessageIntel("Your fleet is over " + Misc.getAndJoined(arrayList) + " capacity and is using an extra %s supplies per day", D.\u00d2\u00d30000, new String[]{Misc.getRoundedValueMaxOneAfterDecimal((float)f3)}, new Color[]{D.\u00d5O0000});
                Global.getSector().getCampaignUI().addMessage((IntelInfoPlugin)messageIntel);
                this.sinceOvercapMessage = 0.0f;
            }
            if ((f3 = campaignFleetAPI.getLogistics().getExcessShipsSupplyCost()) > 0.0f && cargoAPI.getSupplies() > 0.0f) {
                f3 = Math.max(0.1f, f3);
                int n = Global.getSettings().getMaxShipsInFleet();
                messageIntel = new MessageIntel("Your fleet has more than " + n + " ships and is using an extra %s supplies per day", D.\u00d2\u00d30000, new String[]{Misc.getRoundedValueMaxOneAfterDecimal((float)f3)}, new Color[]{D.\u00d5O0000});
                Global.getSector().getCampaignUI().addMessage((IntelInfoPlugin)messageIntel);
                this.sinceOvercapMessage = 0.0f;
            }
        }
    }

    private JumpPointAPI findNearestGravityWell(CampaignFleetAPI campaignFleetAPI, LocationAPI locationAPI) {
        List list = locationAPI.getEntities(JumpPointAPI.class);
        float f2 = Float.MAX_VALUE;
        JumpPointAPI jumpPointAPI = null;
        for (JumpPointAPI jumpPointAPI2 : list) {
            float f3;
            StarSystemAPI starSystemAPI = jumpPointAPI2.getDestinationStarSystem();
            if (starSystemAPI.hasTag("system_abyssal") || !jumpPointAPI2.isStarAnchor() && !jumpPointAPI2.isGasGiantAnchor() || jumpPointAPI2.getDestinations().isEmpty() || !((f3 = Vector2f.sub((Vector2f)campaignFleetAPI.getLocation(), (Vector2f)jumpPointAPI2.getLocation(), (Vector2f)this.temp).length()) < f2)) continue;
            jumpPointAPI = jumpPointAPI2;
            f2 = f3;
        }
        return jumpPointAPI;
    }

    public boolean isDone() {
        return false;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }
}

