/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.combat.ai.movement;

import com.fs.starfarer.combat.ai.K;
import com.fs.starfarer.combat.ai.M;
import com.fs.starfarer.combat.ai.movement.EngineAI;
import com.fs.starfarer.combat.entities.Ship;
import com.fs.starfarer.prototype.Utils;

public class BasicEngineAI
implements EngineAI {
    private static final float ACCEPTABLE_DISTANCE = 200.0f;
    private static final float ACCEPTABLE_FACING_DIFF = 1.0f;
    private static final float ACCEPTABLE_HEADING_DIFF = 1.0f;
    private static final float ACCEPTABLE_SPEED_DIFF = 0.01f;
    private static final float STOPPED_VELOCITY_THRESHOLD = 0.0f;
    private float desiredFacing = Float.MAX_VALUE;
    private float desiredHeading = Float.MAX_VALUE;
    private float desiredSpeedFraction = 1.0f;
    private boolean alwaysAccelerate = false;
    private boolean isAvoidingCollision = false;
    private float sinceHeadingChange = 0.0f;
    private Ship ship;
    private float delay = 1.0f + (float)Math.random() * 2.0f;

    public BasicEngineAI(Ship ship) {
        this.ship = ship;
    }

    @Override
    public void setAlwaysAccelerate(boolean bl) {
        this.alwaysAccelerate = bl;
    }

    @Override
    public boolean isAlwaysAccelerate() {
        return this.alwaysAccelerate;
    }

    @Override
    public void setDesiredFacing(float f2) {
        this.desiredFacing = f2;
    }

    public boolean isAvoidingCollision() {
        return this.isAvoidingCollision;
    }

    @Override
    public void setAvoidingCollision(boolean bl) {
        this.isAvoidingCollision = bl;
    }

    @Override
    public void setDesiredHeading(float f2, float f3) {
        this.desiredSpeedFraction = f3;
        this.delay = 0.5f + (float)Math.random() * 0.5f;
        this.sinceHeadingChange = 0.0f;
        this.desiredHeading = f2;
    }

    @Override
    public void advance(float f2) {
        this.sinceHeadingChange += f2;
        if (this.desiredFacing != Float.MAX_VALUE) {
            if (this.desiredHeading != Float.MAX_VALUE) {
                M.\u00d200000((K)this.ship, this.desiredHeading, this.desiredSpeedFraction * 1000.0f);
            }
            M.super((K)this.ship, 0.0f, this.desiredFacing);
        } else if (this.desiredHeading != Float.MAX_VALUE) {
            this.establishHeading(this.desiredHeading, this.desiredSpeedFraction, f2, true);
        }
    }

    private boolean establishHeading(float f2, float f3, float f4, boolean bl) {
        float f5 = Utils.\u00d300000(this.ship.getVelocity());
        float f6 = Utils.super(f5, f2);
        boolean bl2 = this.ship.getVelocity().length() <= 0.0f;
        float f7 = Utils.super(this.ship.getFacing(), f2);
        float f8 = this.getSpeedChangeDir(f3);
        if (bl2 || f6 > 1.0f || f8 != 0.0f) {
            boolean bl3;
            boolean bl4 = false;
            boolean bl5 = bl3 = this.isAvoidingCollision && f7 > 45.0f && f7 < 135.0f;
            if (!bl3 && bl && this.isAvoidingCollision && f7 > 135.0f) {
                bl4 = true;
            }
            if (this.alwaysAccelerate) {
                this.ship.giveCommand(new Ship.Oo(Ship.oo.\u00d6O0000, null));
                bl4 = false;
                bl3 = false;
            }
            if (!(bl2 && this.desiredSpeedFraction == 0.0f || this.alwaysAccelerate || bl3)) {
                if (bl2 || f6 > 1.0f || f8 < 0.0f) {
                    if (f7 <= 30.0f) {
                        if (f8 < 0.0f) {
                            this.ship.giveCommand(new Ship.Oo(Ship.oo.new, null));
                        } else {
                            this.ship.giveCommand(new Ship.Oo(Ship.oo.\u00d6O0000, null));
                        }
                    } else if (f7 >= 125.0f) {
                        if (f8 < 0.0f) {
                            this.ship.giveCommand(new Ship.Oo(Ship.oo.new, null));
                        } else {
                            this.ship.giveCommand(new Ship.Oo(Ship.oo.\u00f600000, null));
                        }
                    }
                } else if (f8 > 0.0f) {
                    if (f7 <= 30.0f) {
                        this.ship.giveCommand(new Ship.Oo(Ship.oo.\u00d6O0000, null));
                    } else if (f7 >= 135.0f) {
                        this.ship.giveCommand(new Ship.Oo(Ship.oo.\u00f600000, null));
                    }
                }
            }
            float f9 = this.desiredHeading;
            if (bl4) {
                f9 += 180.0f;
            }
            if (Utils.super(f2, this.ship.getFacing() + 90.0f) <= 55.0f) {
                this.ship.giveCommand(new Ship.Oo(Ship.oo.interface, null));
                if (bl3) {
                    f9 -= 90.0f;
                }
            } else if (Utils.super(f2, this.ship.getFacing() - 90.0f) <= 55.0f) {
                this.ship.giveCommand(new Ship.Oo(Ship.oo.o00000, null));
                if (bl3) {
                    f9 += 90.0f;
                }
            }
            return this.turnTowards(f9, f4);
        }
        return this.turnTowards(this.desiredHeading, f4);
    }

    private float getSpeedChangeDir(float f2) {
        float f3 = this.ship.getVelocity().length() / this.ship.getMaxSpeed();
        if (f3 - 0.01f > f2) {
            return -1.0f;
        }
        if (f3 + 0.01f < this.desiredSpeedFraction) {
            return 1.0f;
        }
        return 0.0f;
    }

    private boolean turnTowards(float f2, float f3) {
        float f4 = this.ship.getAngularVelocity();
        float f5 = Math.abs(f4);
        float f6 = this.ship.getEngineController().getEffectiveTurnAcceleration() * f3;
        float f7 = this.ship.getEngineController().getEffectiveTurnAcceleration() * f3;
        float f8 = this.ship.getEngineController().getTurnDeceleration();
        float f9 = f5 / f8;
        float f10 = f5 * f9 - 0.5f * f8 * f9 * f9;
        float f11 = this.ship.getFacing() + Math.signum(f4) * f10;
        float f12 = Utils.super(f11, f2);
        float f13 = Utils.super(this.ship.getFacing(), f2);
        if (f12 > 1.0f) {
            float f14 = Utils.\u00d200000(this.ship.getFacing(), f2);
            if (Math.signum(f4) == Math.signum(f14) && f10 > f13) {
                f14 = -f14;
            }
            if (f14 < 0.0f) {
                this.ship.giveCommand(new Ship.Oo(Ship.oo.\u00d600000, null));
            } else if (f14 > 0.0f) {
                this.ship.giveCommand(new Ship.Oo(Ship.oo.OO0000, null));
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void render() {
    }
}

