/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.renderers;

import com.fs.graphics.Sprite;
import com.fs.starfarer.api.util.Misc;
import com.fs.util.DoNotObfuscate;
import java.util.Random;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class JitterRenderer
implements DoNotObfuscate {
    private long seed = Misc.genRandomSeed();
    private Random random = new Random(this.seed);
    private Vector2f jitterDirection = null;
    private float jitterLength = 0.0f;
    private boolean setSeedOnRender = true;
    private boolean circular;

    public static void renderWithJitter(Sprite sprite, float f2, float f3, float f4, int n) {
        int n2 = 0;
        while (n2 < n) {
            Vector2f vector2f = new Vector2f();
            vector2f.x = (float)Math.random() * f4 - f4 / 2.0f;
            vector2f.y = (float)Math.random() * f4 - f4 / 2.0f;
            sprite.renderAtCenter(f2 + vector2f.x, f3 + vector2f.y);
            ++n2;
        }
    }

    public void updateSeed() {
        this.seed = Misc.genRandomSeed();
    }

    public Random getRandom() {
        this.random.setSeed(this.seed);
        return this.random;
    }

    public void render(Sprite sprite, float f2, float f3, float f4, int n) {
        this.render(sprite, f2, f3, 0.0f, f4, n);
    }

    public void setJitterDirection(Vector2f vector2f) {
        this.jitterDirection = vector2f;
    }

    public void setJitterLength(float f2) {
        this.jitterLength = f2;
    }

    public boolean isSetSeedOnRender() {
        return this.setSeedOnRender;
    }

    public void setSetSeedOnRender(boolean bl) {
        this.setSeedOnRender = bl;
    }

    public void setUseCircularJitter(boolean bl) {
        this.circular = bl;
    }

    public void render(Sprite sprite, float f2, float f3, float f4, float f5, int n) {
        if (this.setSeedOnRender) {
            this.random.setSeed(this.seed);
        }
        int n2 = 0;
        while (n2 < n) {
            Vector2f vector2f;
            Vector2f vector2f2 = new Vector2f();
            float f6 = 1.0f;
            if (this.jitterDirection != null) {
                vector2f = new Vector2f((ReadableVector2f)this.jitterDirection);
                float f7 = this.random.nextFloat();
                vector2f.scale(f7 * f7 * this.jitterLength);
                vector2f2.set((ReadableVector2f)vector2f);
                f6 = 0.1f + f7 * 0.9f;
            }
            if (this.circular) {
                float f8 = f4 + (f5 - f4) * this.random.nextFloat();
                vector2f2 = Misc.getPointAtRadius((Vector2f)vector2f2, (float)(f8 * f6), (Random)this.random);
            } else {
                vector2f = new Vector2f((ReadableVector2f)vector2f2);
                if (f4 <= 0.0f) {
                    vector2f2.x = this.random.nextFloat() * f5 - f5 / 2.0f;
                    vector2f2.y = this.random.nextFloat() * f5 - f5 / 2.0f;
                } else {
                    vector2f2.x = this.random.nextFloat() * (f5 - f4) + f4;
                    vector2f2.y = this.random.nextFloat() * (f5 - f4) + f4;
                    if (vector2f2.x < f4) {
                        vector2f2.x = f4;
                    }
                    if (vector2f2.y < f4) {
                        vector2f2.y = f4;
                    }
                    vector2f2.x *= Math.signum(this.random.nextFloat() - 0.5f);
                    vector2f2.y *= Math.signum(this.random.nextFloat() - 0.5f);
                }
                vector2f2.scale(f6);
                Vector2f.add((Vector2f)vector2f2, (Vector2f)vector2f, (Vector2f)vector2f2);
            }
            sprite.renderAtCenter(f2 + vector2f2.x, f3 + vector2f2.y);
            ++n2;
        }
    }
}

