/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.enc;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;

public class StrandedGiveTJScript
implements EveryFrameScript {
    protected IntervalUtil interval = new IntervalUtil(5.0f, 10.0f);
    protected StarSystemAPI prev;
    protected float elapsed;

    @Override
    public void advance(float amount) {
        this.interval.advance(amount);
        if (this.interval.intervalElapsed()) {
            LocationAPI curr = Global.getSector().getCurrentLocation();
            if (!(curr instanceof StarSystemAPI)) {
                return;
            }
            StarSystemAPI system = (StarSystemAPI)curr;
            if (system.hasTag("do_not_show_stranded_dialog")) {
                return;
            }
            if (this.prev != system) {
                this.prev = system;
                this.elapsed = 0.0f;
            }
            for (SectorEntityToken s : system.getJumpPoints()) {
                JumpPointAPI jp = (JumpPointAPI)s;
                if (jp.getDestinations().isEmpty()) continue;
                return;
            }
            this.elapsed += this.interval.getIntervalDuration();
            CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
            if (!pf.hasAbility("fracture_jump") && this.elapsed > 60.0f && !Global.getSector().getCampaignUI().isShowingDialog() && !Global.getSector().getCampaignUI().isShowingMenu()) {
                Misc.showRuleDialog(pf, "StrandedInDeepSpace");
            }
        }
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }
}

